/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.data.BranchData;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.NodeData;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

public final class PhylogenyNode
implements Comparable<PhylogenyNode> {
    private static long NODE_COUNT = 0L;
    private BranchData _branch_data;
    private boolean _collapse;
    private ArrayList<PhylogenyNode> _descendants;
    private double _distance_parent = -1024.0;
    private long _id;
    private byte _indicator;
    private PhylogenyNode _link;
    private NodeData _node_data;
    private PhylogenyNode _parent;
    private int _sum_ext_nodes;
    private float _x;
    private float _x_secondary;
    private float _y;
    private float _y_secondary;

    public PhylogenyNode() {
        this.setId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public PhylogenyNode(String string) {
        this.setId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
        if (string != null) {
            this.getNodeData().setNodeName(string);
        }
    }

    private PhylogenyNode(String string, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION, boolean bl) throws NHXFormatException, PhyloXmlDataFormatException {
        NHXParser.parseNHX(string, this, tAXONOMY_EXTRACTION, bl, false, false, false);
        this.setId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    private PhylogenyNode(String string, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION, boolean bl, boolean bl2) throws NHXFormatException, PhyloXmlDataFormatException {
        NHXParser.parseNHX(string, this, tAXONOMY_EXTRACTION, bl, false, false, bl2);
        this.setId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public final void addAsChild(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        this.addChildNode(phylogenyNode2);
        phylogenyNode2.setParent(this);
    }

    public final int calculateDepth() {
        PhylogenyNode phylogenyNode = this;
        int n = 0;
        while (phylogenyNode._parent != null) {
            ++n;
            phylogenyNode = phylogenyNode._parent;
        }
        return n;
    }

    public final double calculateDistanceToRoot() {
        PhylogenyNode phylogenyNode = this;
        double d = 0.0;
        while (phylogenyNode._parent != null) {
            if (phylogenyNode._distance_parent > 0.0) {
                d += phylogenyNode._distance_parent;
            }
            phylogenyNode = phylogenyNode._parent;
        }
        return d;
    }

    @Override
    public final int compareTo(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        if (this.getName() == null || phylogenyNode2.getName() == null) {
            return 0;
        }
        return this.getName().compareTo(phylogenyNode2.getName());
    }

    public final PhylogenyNode copyNodeData() {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        PhylogenyNode.decreaseNodeCount();
        phylogenyNode._id = this._id;
        phylogenyNode._sum_ext_nodes = this._sum_ext_nodes;
        phylogenyNode._indicator = this._indicator;
        phylogenyNode._x = this._x;
        phylogenyNode._y = this._y;
        phylogenyNode._distance_parent = this._distance_parent;
        phylogenyNode._collapse = this._collapse;
        phylogenyNode._link = this._link;
        if (this._node_data != null) {
            phylogenyNode._node_data = (NodeData)this._node_data.copy();
        }
        if (this._branch_data != null) {
            phylogenyNode._branch_data = (BranchData)this._branch_data.copy();
        }
        return phylogenyNode;
    }

    public final PhylogenyNode copyNodeDataShallow() {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        PhylogenyNode.decreaseNodeCount();
        phylogenyNode._id = this._id;
        phylogenyNode._sum_ext_nodes = this._sum_ext_nodes;
        phylogenyNode._indicator = this._indicator;
        phylogenyNode._x = this._x;
        phylogenyNode._y = this._y;
        phylogenyNode._distance_parent = this._distance_parent;
        phylogenyNode._collapse = this._collapse;
        phylogenyNode._link = this._link;
        phylogenyNode._node_data = this._node_data;
        phylogenyNode._branch_data = this._branch_data;
        return phylogenyNode;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        PhylogenyNode phylogenyNode = (PhylogenyNode)object;
        if (!this.getName().equals(phylogenyNode.getName())) {
            return false;
        }
        NodeData nodeData = this.getNodeData();
        NodeData nodeData2 = phylogenyNode.getNodeData();
        if (nodeData.isHasSequence() && nodeData2.isHasSequence() && nodeData.isHasTaxonomy() && nodeData2.isHasTaxonomy()) {
            return nodeData.getTaxonomy().isEqual(nodeData2.getTaxonomy()) && nodeData.getSequence().isEqual(nodeData2.getSequence());
        }
        if (nodeData.isHasTaxonomy() && nodeData2.isHasTaxonomy()) {
            return nodeData.getTaxonomy().isEqual(nodeData2.getTaxonomy());
        }
        if (nodeData.isHasSequence() && nodeData2.isHasSequence()) {
            return nodeData.getSequence().isEqual(nodeData2.getSequence());
        }
        return this.getName().length() > 0;
    }

    public final List<PhylogenyNode> getAllExternalDescendants() {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (this.isExternal()) {
            arrayList.add(this);
            return arrayList;
        }
        PhylogenyNode phylogenyNode = this;
        while (!phylogenyNode.isExternal()) {
            phylogenyNode = phylogenyNode.getFirstChildNode();
        }
        PhylogenyNode phylogenyNode2 = this;
        while (!phylogenyNode2.isExternal()) {
            phylogenyNode2 = phylogenyNode2.getLastChildNode();
        }
        while (phylogenyNode != phylogenyNode2) {
            arrayList.add(phylogenyNode);
            phylogenyNode = phylogenyNode.getNextExternalNode();
        }
        arrayList.add(phylogenyNode2);
        return arrayList;
    }

    public final List<String> getAllExternalDescendantsNames() {
        List<PhylogenyNode> list = this.getAllExternalDescendants();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (PhylogenyNode phylogenyNode : list) {
            arrayList.add(phylogenyNode.getName());
        }
        return arrayList;
    }

    public final BranchData getBranchData() {
        if (this._branch_data == null) {
            this._branch_data = new BranchData();
        }
        return this._branch_data;
    }

    public final PhylogenyNode getChildNode(int n) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("attempt to get the child node of an external node.");
        }
        if (n >= this.getNumberOfDescendants() || n < 0) {
            throw new IllegalArgumentException("attempt to get child node " + n + " of a node with " + this.getNumberOfDescendants() + " child nodes");
        }
        return this.getDescendants().get(n);
    }

    public final PhylogenyNode getChildNode1() {
        return this.getChildNode(0);
    }

    public final PhylogenyNode getChildNode2() {
        return this.getChildNode(1);
    }

    public final int getChildNodeIndex() {
        return this.getChildNodeIndex(this.getParent());
    }

    public final int getChildNodeIndex(PhylogenyNode phylogenyNode) {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the child index for a root node.");
        }
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            if (phylogenyNode.getChildNode(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Unexpected exception: Could not determine the child index for node: " + this);
    }

    public final List<PhylogenyNode> getDescendants() {
        if (this._descendants == null) {
            this._descendants = new ArrayList();
        }
        return this._descendants;
    }

    public final double getDistanceToParent() {
        return this._distance_parent;
    }

    public final PhylogenyNode getFirstChildNode() {
        return this.getChildNode(0);
    }

    public final long getId() {
        return this._id;
    }

    public final byte getIndicator() {
        return this._indicator;
    }

    public final PhylogenyNode getLastChildNode() {
        return this.getChildNode(this.getNumberOfDescendants() - 1);
    }

    public final PhylogenyNode getLink() {
        return this._link;
    }

    public final String getName() {
        return this.getNodeData().getNodeName();
    }

    public final PhylogenyNode getNextExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("attempt to get next external node of an internal node");
        }
        if (this.isLastExternalNode()) {
            return null;
        }
        int n = this.getChildNodeIndex();
        PhylogenyNode phylogenyNode = this;
        PhylogenyNode phylogenyNode2 = this.getParent();
        while (!phylogenyNode2.isRoot() && (phylogenyNode2.getNumberOfDescendants() == 1 || phylogenyNode.isLastChildNode())) {
            n = phylogenyNode2.getChildNodeIndex();
            phylogenyNode = phylogenyNode2;
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        phylogenyNode2 = phylogenyNode2.getChildNode(n + 1);
        while (phylogenyNode2.isInternal()) {
            phylogenyNode2 = phylogenyNode2.getFirstChildNode();
        }
        return phylogenyNode2;
    }

    public final PhylogenyNode getNextExternalNodeWhileTakingIntoAccountCollapsedNodes() {
        if (this.isRoot()) {
            return null;
        }
        if (this.isInternal() && !this.isCollapse()) {
            throw new UnsupportedOperationException("attempt to get next external node of an uncollapsed internal node");
        }
        if (this.getParent().isCollapse()) {
            throw new UnsupportedOperationException("attempt to get next external node of node with a collapsed parent");
        }
        PhylogenyNode phylogenyNode = this;
        boolean bl = true;
        while (!phylogenyNode.isRoot()) {
            if (!phylogenyNode.isLastChildNode()) {
                bl = false;
                break;
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        if (bl) {
            return null;
        }
        int n = this.getChildNodeIndex();
        PhylogenyNode phylogenyNode2 = this;
        PhylogenyNode phylogenyNode3 = this.getParent();
        while (!phylogenyNode3.isRoot() && (phylogenyNode3.isCollapse() || phylogenyNode3.getNumberOfDescendants() == 1 || phylogenyNode2.isLastChildNode())) {
            n = phylogenyNode3.getChildNodeIndex();
            phylogenyNode2 = phylogenyNode3;
            phylogenyNode3 = phylogenyNode3.getParent();
        }
        if (n < phylogenyNode3.getNumberOfDescendants() - 1) {
            phylogenyNode3 = phylogenyNode3.getChildNode(n + 1);
        }
        while (phylogenyNode3.isInternal() && !phylogenyNode3.isCollapse()) {
            phylogenyNode3 = phylogenyNode3.getFirstChildNode();
        }
        return phylogenyNode3;
    }

    public final NodeData getNodeData() {
        if (this._node_data == null) {
            this._node_data = new NodeData();
        }
        return this._node_data;
    }

    public final boolean isHasNodeData() {
        return this._node_data != null && !this._node_data.isEmpty();
    }

    public final int getNumberOfDescendants() {
        if (this._descendants == null) {
            return 0;
        }
        return this._descendants.size();
    }

    public final int getNumberOfExternalNodes() {
        return this._sum_ext_nodes;
    }

    public final int getNumberOfParents() {
        return 1;
    }

    public final PhylogenyNode getParent() {
        return this._parent;
    }

    public final PhylogenyNode getPreviousExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for an internal node.");
        }
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for a root node.");
        }
        if (this.isFirstExternalNode()) {
            throw new UnsupportedOperationException("Attempt to get previous external node of the first external node.");
        }
        int n = this.getChildNodeIndex();
        PhylogenyNode phylogenyNode = this;
        PhylogenyNode phylogenyNode2 = this.getParent();
        while (!phylogenyNode2.isRoot() && (phylogenyNode2.getNumberOfDescendants() == 1 || phylogenyNode.isFirstChildNode())) {
            n = phylogenyNode2.getChildNodeIndex();
            phylogenyNode = phylogenyNode2;
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        phylogenyNode2 = phylogenyNode2.getChildNode(n - 1);
        while (phylogenyNode2.isInternal()) {
            phylogenyNode2 = phylogenyNode2.getLastChildNode();
        }
        return phylogenyNode2;
    }

    public final float getXcoord() {
        return this._x;
    }

    public final float getXSecondary() {
        return this._x_secondary;
    }

    public final float getYcoord() {
        return this._y;
    }

    public final float getYSecondary() {
        return this._y_secondary;
    }

    public final int hashCode() {
        NodeData nodeData = this.getNodeData();
        if (this.getName().length() < 1 && !nodeData.isHasSequence() && !nodeData.isHasTaxonomy()) {
            return super.hashCode();
        }
        int n = this.getName().hashCode();
        if (nodeData.isHasSequence()) {
            n ^= nodeData.getSequence().hashCode();
        }
        if (nodeData.isHasTaxonomy()) {
            n ^= nodeData.getTaxonomy().hashCode();
        }
        return n;
    }

    public final boolean isCollapse() {
        return this._collapse && this._parent != null;
    }

    public final boolean isDuplication() {
        return this.getNodeData().isHasEvent() && this.getNodeData().getEvent().isDuplication();
    }

    public boolean isEmpty() {
        return this._node_data == null || this._node_data.isEmpty();
    }

    public final boolean isExternal() {
        return this._descendants == null || this._descendants.size() == 0;
    }

    public final boolean isFirstChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the first child node of its _parent.");
        }
        return this.getChildNodeIndex() == 0;
    }

    public final boolean isFirstExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode phylogenyNode = this;
        while (!phylogenyNode.isRoot()) {
            if (!phylogenyNode.isFirstChildNode()) {
                return false;
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        return true;
    }

    public final boolean isHasAssignedEvent() {
        if (!this.getNodeData().isHasEvent()) {
            return false;
        }
        return !this.getNodeData().getEvent().isUnassigned();
    }

    public final boolean isInternal() {
        return !this.isExternal();
    }

    public final boolean isLastChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the last child node of its _parent.");
        }
        return this.getChildNodeIndex() == this.getParent().getNumberOfDescendants() - 1;
    }

    public final boolean isLastExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode phylogenyNode = this;
        while (!phylogenyNode.isRoot()) {
            if (!phylogenyNode.isLastChildNode()) {
                return false;
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        return true;
    }

    public final boolean isRoot() {
        return this._parent == null;
    }

    public final boolean isSpeciation() {
        return this.getNodeData().isHasEvent() && this.getNodeData().getEvent().isSpeciation();
    }

    public void preorderPrint() {
        System.out.println(this + "\n");
        if (this.isInternal()) {
            for (int i = 0; i < this.getNumberOfDescendants(); ++i) {
                this.getChildNode(i).preorderPrint();
            }
        }
    }

    public final void removeChildNode(int n) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("cannot get the child node for a external node.");
        }
        if (n >= this.getNumberOfDescendants() || n < 0) {
            throw new IllegalArgumentException("attempt to get child node " + n + " of a node with " + this.getNumberOfDescendants() + " child nodes.");
        }
        this.getDescendants().remove(n);
    }

    public final void removeChildNode(PhylogenyNode phylogenyNode) {
        this.removeChildNode(phylogenyNode.getChildNodeIndex());
    }

    public void removeConnections() {
        this._parent = null;
        this._link = null;
        this._descendants = null;
    }

    public final void setBranchData(BranchData branchData) {
        this._branch_data = branchData;
    }

    public final void setChild1(PhylogenyNode phylogenyNode) {
        this.setChildNode(0, phylogenyNode);
    }

    public final void setChild2(PhylogenyNode phylogenyNode) {
        this.setChildNode(1, phylogenyNode);
    }

    public final void setChildNode(int n, PhylogenyNode phylogenyNode) {
        phylogenyNode.setParent(this);
        if (this.getNumberOfDescendants() <= n) {
            this.addChildNode(phylogenyNode);
        } else {
            this.getDescendants().set(n, phylogenyNode);
        }
    }

    public final void setCollapse(boolean bl) {
        this._collapse = bl;
    }

    public final void setDistanceToParent(double d) {
        this._distance_parent = d;
    }

    public final void setIndicator(byte by) {
        this._indicator = by;
    }

    public final void setLink(PhylogenyNode phylogenyNode) {
        this._link = phylogenyNode;
    }

    public final void setName(String string) {
        this.getNodeData().setNodeName(string);
    }

    public final void setParent(PhylogenyNode phylogenyNode) {
        this._parent = phylogenyNode;
    }

    public final void setSumExtNodes(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("attempt to set sum of external nodes to less than one");
        }
        this._sum_ext_nodes = n;
    }

    public final void setXcoord(float f) {
        this._x = f;
    }

    public final void setXSecondary(float f) {
        this._x_secondary = f;
    }

    public final void setYcoord(float f) {
        this._y = f;
    }

    public final void setYSecondary(float f) {
        this._y_secondary = f;
    }

    public final void swapChildren() throws RuntimeException {
        if (this.isExternal()) {
            throw new RuntimeException("attempt to swap descendants of external node");
        }
        if (this.getNumberOfDescendants() != 2) {
            throw new RuntimeException("attempt to swap descendants of node with " + this.getNumberOfDescendants() + " descendants");
        }
        PhylogenyNode phylogenyNode = this.getChildNode(0);
        PhylogenyNode phylogenyNode2 = this.getChildNode(1);
        this.setChildNode(0, phylogenyNode2);
        this.setChildNode(1, phylogenyNode);
    }

    public final String toNewHampshire(boolean bl, NH_CONVERSION_SUPPORT_VALUE_STYLE nH_CONVERSION_SUPPORT_VALUE_STYLE) {
        String string = "";
        if (nH_CONVERSION_SUPPORT_VALUE_STYLE == NH_CONVERSION_SUPPORT_VALUE_STYLE.AS_INTERNAL_NODE_NAMES && !this.isExternal()) {
            if (this.getBranchData().isHasConfidences() && this.getBranchData().getConfidence(0).getValue() != -2.147483647E9) {
                string = Confidence.FORMATTER.format(ForesterUtil.round(this.getBranchData().getConfidence(0).getValue(), 9));
            }
        } else if (!ForesterUtil.isEmpty(this.getName())) {
            string = this.getName();
        } else if (this.getNodeData().isHasTaxonomy()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getTaxonomyCode())) {
                string = this.getNodeData().getTaxonomy().getTaxonomyCode();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getScientificName())) {
                string = this.getNodeData().getTaxonomy().getScientificName();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getCommonName())) {
                string = this.getNodeData().getTaxonomy().getCommonName();
            }
        } else if (this.getNodeData().isHasSequence()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getName())) {
                string = this.getNodeData().getSequence().getName();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getSymbol())) {
                string = this.getNodeData().getSequence().getSymbol();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getGeneName())) {
                string = this.getNodeData().getSequence().getGeneName();
            }
        }
        StringBuilder stringBuilder = ForesterUtil.santitizeStringForNH(string);
        if (bl && this.getDistanceToParent() != -1024.0) {
            stringBuilder.append(":");
            stringBuilder.append(this.getDistanceToParent());
        }
        if (nH_CONVERSION_SUPPORT_VALUE_STYLE == NH_CONVERSION_SUPPORT_VALUE_STYLE.IN_SQUARE_BRACKETS && !this.isExternal() && this.getBranchData().isHasConfidences() && this.getBranchData().getConfidence(0).getValue() != -2.147483647E9) {
            stringBuilder.append("[");
            stringBuilder.append(Confidence.FORMATTER.format(ForesterUtil.round(this.getBranchData().getConfidence(0).getValue(), 9)));
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public final String toNewHampshireX() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuffer stringBuffer = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getName())) {
            stringBuilder.append((CharSequence)ForesterUtil.santitizeStringForNH(this.getName()));
        }
        if (this.getDistanceToParent() != -1024.0) {
            stringBuilder.append(":");
            stringBuilder.append(this.getDistanceToParent());
        }
        if (this.getNodeDataDirectly() != null) {
            stringBuffer.append(this.getNodeDataDirectly().toNHX());
        }
        if (this.getBranchDataDirectly() != null) {
            stringBuffer.append(this.getBranchDataDirectly().toNHX());
        }
        if (stringBuffer.length() > 0) {
            stringBuilder.append("[&&NHX");
            stringBuilder.append(stringBuffer);
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!ForesterUtil.isEmpty(this.getName())) {
            stringBuilder.append(this.getName());
            stringBuilder.append(" ");
        }
        if (this.getNodeData().isHasTaxonomy()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getScientificName())) {
                stringBuilder.append(this.getNodeData().getTaxonomy().getScientificName());
                stringBuilder.append(" ");
            } else if (stringBuilder.length() <= 1 && !ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getTaxonomyCode())) {
                stringBuilder.append(this.getNodeData().getTaxonomy().getTaxonomyCode());
                stringBuilder.append(" ");
            } else if (this.getNodeData().getTaxonomy().getIdentifier() != null) {
                stringBuilder.append(this.getNodeData().getTaxonomy().getIdentifier().toString());
                stringBuilder.append(" ");
            }
        }
        if (this.getNodeData().isHasSequence()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getName())) {
                stringBuilder.append(this.getNodeData().getSequence().getName());
                stringBuilder.append(" ");
            }
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getSymbol())) {
                stringBuilder.append(this.getNodeData().getSequence().getSymbol());
                stringBuilder.append(" ");
            }
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getGeneName())) {
                stringBuilder.append(this.getNodeData().getSequence().getGeneName());
                stringBuilder.append(" ");
            }
            if (this.getNodeData().getSequence().getAccession() != null) {
                stringBuilder.append(this.getNodeData().getSequence().getAccession().toString());
                stringBuilder.append(" ");
            }
        }
        if (stringBuilder.length() <= 1) {
            stringBuilder.append("[");
            stringBuilder.append(this.getId());
            stringBuilder.append("]");
        }
        return stringBuilder.toString().trim();
    }

    protected final synchronized void setId(long l) {
        if (l < PhylogenyNode.getNodeCount()) {
            throw new IllegalArgumentException("attempt to set node id to a value less than total node count (thus violating the uniqueness of node ids)");
        }
        this._id = l;
    }

    final BranchData getBranchDataDirectly() {
        return this._branch_data;
    }

    final NodeData getNodeDataDirectly() {
        return this._node_data;
    }

    final void setChildNodeOnly(int n, PhylogenyNode phylogenyNode) {
        if (this.getNumberOfDescendants() <= n) {
            this.addChildNode(phylogenyNode);
        } else {
            this.getDescendants().set(n, phylogenyNode);
        }
    }

    final void setIndicatorsToZero() {
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(this);
        while (preorderTreeIterator.hasNext()) {
            preorderTreeIterator.next().setIndicator((byte)0);
        }
    }

    private final void addChildNode(PhylogenyNode phylogenyNode) {
        this.getDescendants().add(phylogenyNode);
    }

    public static PhylogenyNode createInstanceFromNhxString(String string) throws NHXFormatException, PhyloXmlDataFormatException {
        return new PhylogenyNode(string, NHXParser.TAXONOMY_EXTRACTION.NO, false);
    }

    public static PhylogenyNode createInstanceFromNhxString(String string, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) throws NHXFormatException, PhyloXmlDataFormatException {
        return new PhylogenyNode(string, tAXONOMY_EXTRACTION, false);
    }

    public static PhylogenyNode createInstanceFromNhxString(String string, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION, boolean bl) throws NHXFormatException, PhyloXmlDataFormatException {
        return new PhylogenyNode(string, tAXONOMY_EXTRACTION, bl);
    }

    public static PhylogenyNode createInstanceFromNhxString(String string, NHXParser.TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION, boolean bl, boolean bl2) throws NHXFormatException, PhyloXmlDataFormatException {
        return new PhylogenyNode(string, tAXONOMY_EXTRACTION, bl, bl2);
    }

    public static final synchronized long getNodeCount() {
        return NODE_COUNT;
    }

    static final synchronized void decreaseNodeCount() {
        --NODE_COUNT;
    }

    static final synchronized void setNodeCount(long l) {
        NODE_COUNT = l;
    }

    private static final synchronized void increaseNodeCount() {
        ++NODE_COUNT;
    }

    public static enum NH_CONVERSION_SUPPORT_VALUE_STYLE {
        AS_INTERNAL_NODE_NAMES,
        IN_SQUARE_BRACKETS,
        NONE;

    }
}

