/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.util.List;
import org.forester.msa.BasicMsa;
import org.forester.msa.Msa;
import org.forester.msa.MsaMethods;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;

public final class DeleteableMsa
extends BasicMsa {
    private int _length = 0;
    private int[] _mapped_col_positions = null;
    private int[] _mapped_row_positions = null;
    private int _seqs = 0;

    private DeleteableMsa(BasicMsa basicMsa) {
        super(basicMsa);
        int n;
        this._mapped_col_positions = new int[basicMsa.getLength()];
        this._mapped_row_positions = new int[basicMsa.getNumberOfSequences()];
        for (n = 0; n < this._mapped_col_positions.length; ++n) {
            this._mapped_col_positions[n] = n;
        }
        for (n = 0; n < this._mapped_row_positions.length; ++n) {
            this._mapped_row_positions[n] = n;
        }
        this._length = basicMsa.getLength();
        this._seqs = basicMsa.getNumberOfSequences();
    }

    public final double[] calcGappiness() {
        int n = this.getLength();
        double[] dArray = new double[n];
        int n2 = this.getNumberOfSequences();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
            }
        }
        return dArray;
    }

    public static int calcGapSumPerColumn(Msa msa, int n) {
        int n2 = 0;
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            if (!msa.isGapAt(i, n)) continue;
            ++n2;
        }
        return n2;
    }

    public short determineMaxIdLength() {
        short s = 0;
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            short s2 = (short)this.getIdentifier(i).length();
            if (s2 <= s) continue;
            s = s2;
        }
        return s;
    }

    public final void deleteGapColumns(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("max allowed gap ration is out of range: " + d);
        }
        for (int i = this.getLength() - 1; i >= 0; --i) {
            boolean bl;
            boolean bl2 = bl = (double)MsaMethods.calcGapSumPerColumn(this, i) / (double)this.getNumberOfSequences() > d;
            if (!bl) continue;
            this.deleteColumn(i);
        }
    }

    public final void deleteGapOnlyColumns() {
        for (int i = this.getLength() - 1; i >= 0; --i) {
            if (!this.isAllGap(i)) continue;
            this.deleteColumn(i);
        }
    }

    public final MolecularSequence deleteRow(String string, boolean bl) {
        int n = -1;
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            if (!this.getIdentifier(i).equals(string)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            throw new IllegalArgumentException("id [" + string + "] not found");
        }
        MolecularSequence molecularSequence = null;
        StringBuilder stringBuilder = null;
        if (bl) {
            molecularSequence = this.getSequence(n);
            char[] cArray = molecularSequence.getMolecularSequence();
            stringBuilder = new StringBuilder(cArray.length);
            for (char c : cArray) {
                if (c == '-') continue;
                stringBuilder.append(c);
            }
        }
        this.deleteRow(n);
        if (bl) {
            return new BasicSequence(new String(molecularSequence.getIdentifier()), stringBuilder.toString(), molecularSequence.getType());
        }
        return null;
    }

    @Override
    public final String getIdentifier(int n) {
        this.checkRow(n);
        return super.getIdentifier(this._mapped_row_positions[n]);
    }

    @Override
    public final int getLength() {
        return this._length;
    }

    @Override
    public final int getNumberOfSequences() {
        return this._seqs;
    }

    @Override
    public final char getResidueAt(int n, int n2) {
        this.checkRow(n);
        this.checkColumn(n2);
        return super.getResidueAt(this._mapped_row_positions[n], this._mapped_col_positions[n2]);
    }

    @Override
    public MolecularSequence getSequence(int n) {
        this.checkRow(n);
        return new BasicSequence(this.getIdentifier(n), this.getSequenceAsString(n).toString(), this.getType());
    }

    public final boolean isAllGap(int n) {
        int n2 = this._mapped_col_positions[n];
        for (int i = 0; i < this.getNumberOfSequences(); ++i) {
            if (super.getResidueAt(this._mapped_row_positions[i], n2) == '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setIdentifier(int n, String string) {
        this.checkRow(n);
        super.setIdentifier(this._mapped_row_positions[n], string);
    }

    @Override
    public final void setResidueAt(int n, int n2, char c) {
        this.checkRow(n);
        this.checkColumn(n2);
        super.setResidueAt(this._mapped_row_positions[n], this._mapped_col_positions[n2], c);
    }

    private final void checkColumn(int n) {
        if (n >= this._length || n < 0) {
            throw new IllegalArgumentException("column " + n + " is out of range");
        }
    }

    private final void checkRow(int n) {
        if (n >= this._seqs || n < 0) {
            throw new IllegalArgumentException("row " + n + " is out of range");
        }
    }

    private final void deleteColumn(int n) {
        this.checkColumn(n);
        for (int i = n; i < this._length - 1; ++i) {
            this._mapped_col_positions[i] = this._mapped_col_positions[i + 1];
        }
        --this._length;
    }

    private final void deleteRow(int n) {
        this.checkRow(n);
        for (int i = n; i < this._seqs - 1; ++i) {
            this._mapped_row_positions[i] = this._mapped_row_positions[i + 1];
        }
        --this._seqs;
    }

    public static final DeleteableMsa createInstance(List<MolecularSequence> list) {
        return new DeleteableMsa((BasicMsa)BasicMsa.createInstance(list));
    }

    public static final DeleteableMsa createInstance(Msa msa) {
        return new DeleteableMsa((BasicMsa)msa);
    }
}

