/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.forester.go.GoId;
import org.forester.go.GoNameSpace;
import org.forester.go.GoTerm;
import org.forester.go.GoUtils;
import org.forester.go.OBOparser;
import org.forester.go.PfamToGoParser;
import org.forester.io.parsers.HmmscanPerDomainTableParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.protein.BinaryDomainCombination;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.species.BasicSpecies;
import org.forester.species.Species;
import org.forester.surfacing.BasicDomainSimilarityCalculator;
import org.forester.surfacing.BasicGenomeWideCombinableDomains;
import org.forester.surfacing.CombinationsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.DomainCountsBasedPairwiseSimilarityCalculator;
import org.forester.surfacing.DomainLengthsTable;
import org.forester.surfacing.DomainParsimonyCalculator;
import org.forester.surfacing.DomainSimilarity;
import org.forester.surfacing.DomainSimilarityCalculator;
import org.forester.surfacing.GenomeWideCombinableDomains;
import org.forester.surfacing.MappingResults;
import org.forester.surfacing.MinimalDomainomeCalculator;
import org.forester.surfacing.PairwiseDomainSimilarityCalculator;
import org.forester.surfacing.PairwiseGenomeComparator;
import org.forester.surfacing.ProteinCountsBasedPairwiseDomainSimilarityCalculator;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class surfacing {
    private static final int MINIMAL_NUMBER_OF_SIMILARITIES_FOR_SPLITTING = 1000;
    public static final String DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS = "graph_analysis_out";
    public static final String DOMAIN_COMBINITONS_COUNTS_OUTPUT_OPTION = "dcc";
    public static final String DOMAIN_COMBINITONS_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_dc.dot";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC_OUTPUTFILE_SUFFIX_FOR_GRAPH_ANALYSIS = "_fitch_present_dc.dot";
    public static final String DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX = ".dcc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_DOMAINS = "_dollo_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_DOMAINS = "_fitch_gl_d";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_gl_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_DOMAINS = "_dollo_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_BINARY_COMBINATIONS = "_dollo_glc_dc";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_DOMAINS = "_fitch_glc_d";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_FITCH_BINARY_COMBINATIONS = "_fitch_glc_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_BC = "_fitch_gains_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_GAINS_HTML_BC = "_fitch_gains_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_BC = "_fitch_losses_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_LOSSES_HTML_BC = "_fitch_losses_dc.html";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_BC = "_fitch_present_dc";
    public static final String PARSIMONY_OUTPUT_FITCH_PRESENT_HTML_BC = "_fitch_present_dc.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_D = "_dollo_gains_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_HTML_D = "_dollo_gains_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_D = "_dollo_losses_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_HTML_D = "_dollo_losses_d.html";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_D = "_dollo_present_d";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_HTML_D = "_dollo_present_d.html";
    public static final String DOMAINS_PRESENT_NEXUS = "_dom.nex";
    public static final String BDC_PRESENT_NEXUS = "_dc.nex";
    public static final String PRG_NAME = "surfacing";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_d_dollo.xml";
    public static final String DOMAINS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_d_fitch.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_dc_dollo.xml";
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH = "_dc_fitch.xml";
    public static final String NEXUS_EXTERNAL_DOMAINS = "_dom.nex";
    public static final String NEXUS_EXTERNAL_DOMAIN_COMBINATIONS = "_dc.nex";
    public static final String NEXUS_SECONDARY_FEATURES = "_secondary_features.nex";
    public static final String PARSIMONY_OUTPUT_GL_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_gl_secondary_features";
    public static final String PARSIMONY_OUTPUT_GL_COUNTS_SUFFIX_DOLLO_SECONDARY_FEATURES = "_dollo_glc_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_GAINS_SECONDARY_FEATURES = "_dollo_gains_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_LOSSES_SECONDARY_FEATURES = "_dollo_losses_secondary_features";
    public static final String PARSIMONY_OUTPUT_DOLLO_PRESENT_SECONDARY_FEATURES = "_dollo_present_secondary_features";
    public static final String SECONDARY_FEATURES_PARSIMONY_TREE_OUTPUT_SUFFIX_DOLLO = "_secondary_features_dollo.xml";
    public static final String PARSIMONY_OUTPUT_DOLLO_ALL_GOID_D_ALL_NAMESPACES = "_dollo_goid_d";
    public static final String PARSIMONY_OUTPUT_FITCH_ALL_GOID_BC_ALL_NAMESPACES = "_fitch_goid_dc";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String OUTPUT_DIR_OPTION = "out_dir";
    private static final String SCORING_OPTION = "scoring";
    private static final DomainSimilarity.DomainSimilarityScoring SCORING_DEFAULT = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
    private static final String SCORING_DOMAIN_COUNT_BASED = "domains";
    private static final String SCORING_PROTEIN_COUNT_BASED = "proteins";
    private static final String SCORING_COMBINATION_BASED = "combinations";
    private static final String DETAILEDNESS_OPTION = "detail";
    private static final DomainSimilarityCalculator.Detailedness DETAILEDNESS_DEFAULT = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
    private static final String SPECIES_MATRIX_OPTION = "smatrix";
    private static final String DETAILEDNESS_BASIC = "basic";
    private static final String DETAILEDNESS_LIST_IDS = "list_ids";
    private static final String DETAILEDNESS_PUNCTILIOUS = "punctilious";
    private static final String DOMAIN_SIMILARITY_SORT_OPTION = "sort";
    private static final DomainSimilarity.DomainSimilaritySortField DOMAIN_SORT_FILD_DEFAULT = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
    private static final String DOMAIN_SIMILARITY_SORT_MIN = "min";
    private static final String DOMAIN_SIMILARITY_SORT_MAX = "max";
    private static final String DOMAIN_SIMILARITY_SORT_SD = "sd";
    private static final String DOMAIN_SIMILARITY_SORT_MEAN = "mean";
    private static final String DOMAIN_SIMILARITY_SORT_DIFF = "diff";
    private static final String DOMAIN_SIMILARITY_SORT_COUNTS_DIFF = "count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF = "abs_count_diff";
    private static final String DOMAIN_SIMILARITY_SORT_SPECIES_COUNT = "species";
    private static final String DOMAIN_SIMILARITY_SORT_ALPHA = "alpha";
    private static final String DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION = "species_first";
    private static final String DOMAIN_COUNT_SORT_OPTION = "dc_sort";
    private static final GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder DOMAINS_SORT_ORDER_DEFAULT = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
    private static final String DOMAIN_COUNT_SORT_ALPHA = "alpha";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT = "dom";
    private static final String DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT = "prot";
    private static final String DOMAIN_COUNT_SORT_COMBINATIONS_COUNT = "comb";
    private static final String CUTOFF_SCORE_FILE_OPTION = "cos";
    private static final String NOT_IGNORE_DUFS_OPTION = "dufs";
    private static final String MAX_FS_E_VALUE_OPTION = "fs_e";
    private static final String MAX_I_E_VALUE_OPTION = "ie";
    private static final String MIN_REL_ENV_LENGTH_RATIO_OPTION = "mrel";
    private static final String MAX_ALLOWED_OVERLAP_OPTION = "mo";
    private static final String NO_ENGULFING_OVERLAP_OPTION = "no_eo";
    private static final String IGNORE_COMBINATION_WITH_SAME_OPTION = "ignore_self_comb";
    private static final String PERFORM_DC_REGAIN_PROTEINS_STATS_OPTION = "dc_regain_stats";
    private static final String DA_ANALYSIS_OPTION = "da_analyis";
    private static final String USE_LAST_IN_FITCH_OPTION = "last";
    public static final String PAIRWISE_DOMAIN_COMPARISONS_PREFIX = "pwc_";
    private static final String PAIRWISE_DOMAIN_COMPARISONS_OPTION = "pwc";
    private static final String OUTPUT_FILE_OPTION = "o";
    private static final String PFAM_TO_GO_FILE_USE_OPTION = "p2g";
    private static final String GO_OBO_FILE_USE_OPTION = "obo";
    private static final String GO_NAMESPACE_LIMIT_OPTION = "go_namespace";
    private static final String GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION = "molecular_function";
    private static final String GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS = "biological_process";
    private static final String GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT = "cellular_component";
    private static final String SECONDARY_FEATURES_PARSIMONY_MAP_FILE = "secondary";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED = "simple_tab";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML = "simple_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML = "detailed_html";
    private static final String DOMAIN_SIMILARITY_PRINT_OPTION = "ds_output";
    private static final DomainSimilarity.PRINT_OPTION DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT = DomainSimilarity.PRINT_OPTION.HTML;
    private static final String IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION = "ignore_singlet_domains";
    private static final String IGNORE_VIRAL_IDS = "ignore_viral_ids";
    private static final boolean IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_DEFAULT = false;
    private static final String IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION = "ignore_species_specific_domains";
    private static final boolean IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION_DEFAULT = false;
    private static final String MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score.pwd";
    private static final String MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains.pwd";
    private static final String MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations.pwd";
    private static final String NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX = "_mean_score_NJ.xml";
    private static final String NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX = "_domains_NJ.xml";
    private static final String NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX = "_bin_combinations_NJ.xml";
    private static final String FILTER_POSITIVE_OPTION = "pos_filter";
    private static final String FILTER_NEGATIVE_OPTION = "neg_filter";
    private static final String FILTER_NEGATIVE_DOMAINS_OPTION = "neg_dom_filter";
    private static final String INPUT_GENOMES_FILE_OPTION = "genomes";
    private static final String INPUT_SPECIES_TREE_OPTION = "species_tree";
    private static final String SEQ_EXTRACT_OPTION = "prot_extract";
    private static final String PRG_VERSION = "2.603";
    private static final String PRG_DATE = "180510";
    private static final String E_MAIL = "phyloxml@gmail.com";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester/surfacing";
    private static final boolean IGNORE_DUFS_DEFAULT = true;
    private static final boolean IGNORE_COMBINATION_WITH_SAME_DEFAULLT = false;
    private static final double MAX_E_VALUE_DEFAULT = -1.0;
    public static final int MAX_ALLOWED_OVERLAP_DEFAULT = -1;
    private static final String RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION = "random_seed";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS = "consider_bdc_direction";
    private static final String CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY = "consider_bdc_adj";
    public static final String SEQ_EXTRACT_SUFFIX = ".prot";
    public static final String PLUS_MINUS_ANALYSIS_OPTION = "plus_minus";
    public static final String PLUS_MINUS_DOM_SUFFIX = "_plus_minus_dom.txt";
    public static final String PLUS_MINUS_DOM_SUFFIX_HTML = "_plus_minus_dom.html";
    public static final String PLUS_MINUS_DC_SUFFIX_HTML = "_plus_minus_dc.html";
    public static final int PLUS_MINUS_ANALYSIS_MIN_DIFF_DEFAULT = 0;
    public static final double PLUS_MINUS_ANALYSIS_FACTOR_DEFAULT = 1.0;
    public static final String PLUS_MINUS_ALL_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_all.txt";
    public static final String PLUS_MINUS_PASSING_GO_IDS_DOM_SUFFIX = "_plus_minus_go_ids_passing.txt";
    private static final String OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS = "all_prot";
    private static final String OUTPUT_LIST_OF_ALL_PROTEINS_PER_DOMAIN_E_VALUE_OPTION = "all_prot_e";
    public static final boolean VERBOSE = false;
    private static final String OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_gains_counts";
    private static final String OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX = "_fitch_dc_losses_counts";
    private static final String DOMAIN_LENGTHS_ANALYSIS_SUFFIX = "_domain_lengths_analysis";
    private static final String PERFORM_DOMAIN_LENGTH_ANALYSIS_OPTION = "dla";
    public static final String ALL_PFAMS_ENCOUNTERED_SUFFIX = "_all_encountered_pfams";
    public static final String ALL_PFAMS_ENCOUNTERED_WITH_GO_ANNOTATION_SUFFIX = "_all_encountered_pfams_with_go_annotation";
    public static final String ENCOUNTERED_PFAMS_SUMMARY_SUFFIX = "_encountered_pfams_summary";
    public static final String ALL_PFAMS_GAINED_AS_DOMAINS_SUFFIX = "_all_pfams_gained_as_domains";
    public static final String ALL_PFAMS_LOST_AS_DOMAINS_SUFFIX = "_all_pfams_lost_as_domains";
    public static final String ALL_PFAMS_GAINED_AS_DC_SUFFIX = "_all_pfams_gained_as_dc";
    public static final String ALL_PFAMS_LOST_AS_DC_SUFFIX = "_all_pfams_lost_as_dc";
    public static final String BASE_DIRECTORY_PER_NODE_DOMAIN_GAIN_LOSS_FILES = "PER_NODE_EVENTS";
    public static final String BASE_DIRECTORY_PER_SUBTREE_DOMAIN_GAIN_LOSS_FILES = "PER_SUBTREE_EVENTS";
    public static final String D_PROMISCUITY_FILE_SUFFIX = "_domain_promiscuities";
    private static final String LOG_FILE_SUFFIX = "_log.txt";
    private static final String DATA_FILE_SUFFIX = "_domain_combination_data.txt";
    private static final String DATA_FILE_DESC = "#SPECIES\tPRTEIN_ID\tN_TERM_DOMAIN\tC_TERM_DOMAIN\tN_TERM_DOMAIN_PER_DOMAIN_E_VALUE\tC_TERM_DOMAIN_PER_DOMAIN_E_VALUE\tN_TERM_DOMAIN_COUNTS_PER_PROTEIN\tC_TERM_DOMAIN_COUNTS_PER_PROTEIN";
    private static final String WRITE_TO_NEXUS_OPTION = "nexus";
    private static final String PERFORM_DC_FITCH = "dc_pars";
    private static final HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF INDIVIDUAL_SCORE_CUTOFF_DEFAULT = HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.FULL_SEQUENCE;
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_COUNTS_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_counts.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_OUTPUT_UNIQUE_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_unique.txt";
    public static final String LIMIT_SPEC_FOR_PROT_EX = null;
    public static final String BINARY_DOMAIN_COMBINATIONS_PARSIMONY_TREE_OUTPUT_SUFFIX_FITCH_MAPPED = "_dc_MAPPED_secondary_features_fitch.xml";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_COUNTS_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_counts_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_MAPPED_OUTPUT_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_MAPPED.txt";
    public static final String INDEPENDENT_DC_GAINS_FITCH_PARS_DC_FOR_GO_MAPPING_MAPPED_OUTPUT_UNIQUE_SUFFIX = "_indep_dc_gains_fitch_lists_for_go_mapping_unique_MAPPED.txt";
    private static final boolean CALC_SIMILARITY_SCORES = false;
    private static final String SEPARATOR_FOR_DA = "--";
    private static final String DOMAIN_SPECIES_IDS_MAP_NAME = "_DOMAIN_SPECIES_IDS_MAP.txt";
    public static final String DA_SPECIES_IDS_MAP_NAME = "_DA_SPECIES_IDS_MAP.txt";
    public static final String DA_NAME_MAP_NAME = "_DA_NAME_MAP.txt";
    private static final String WRITE_DA_IDS_NAMES_MAPS_OPTION = "write_DA_maps";
    private static final String INPUT_DA_NAME_FILE_OPTION = "input_DA_name_map";
    private static final String OBTAIN_NAMES_FOR_DAS_FROM_DB_OPTION = "obtain_DA_names_from_db";

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        void var89_124;
        Object object;
        Iterator<Domain> iterator;
        void var92_133;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        AbstractCollection abstractCollection;
        Object object10;
        Object object11;
        int n;
        Object object12;
        int n2;
        Object object13;
        Map[] mapArray;
        Object object14;
        File[] fileArray;
        Object object15;
        Object object16;
        Object object17;
        Object object18;
        int n3;
        Object object19;
        Object object20;
        Object object21;
        String string;
        Object object22;
        Object object23;
        Object object24;
        Object object25;
        long l = new Date().getTime();
        StringBuilder stringBuilder = new StringBuilder();
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        String string2 = ForesterUtil.LINE_SEPARATOR;
        stringBuilder.append("<table>" + string2);
        stringBuilder.append("<tr><td>Produced by:</td><td>surfacing</td></tr>" + string2);
        stringBuilder.append("<tr><td>Version:</td><td>2.603</td></tr>" + string2);
        stringBuilder.append("<tr><td>Release Date:</td><td>180510</td></tr>" + string2);
        stringBuilder.append("<tr><td>Contact:</td><td>phyloxml@gmail.com</td></tr>" + string2);
        stringBuilder.append("<tr><td>WWW:</td><td>https://sites.google.com/site/cmzmasek/home/software/forester/surfacing</td></tr>" + string2);
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
            surfacing.printHelp();
            System.exit(0);
        }
        if (stringArray.length < 1) {
            surfacing.printHelp();
            System.exit(-1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(NOT_IGNORE_DUFS_OPTION);
        arrayList.add(MAX_FS_E_VALUE_OPTION);
        arrayList.add(MAX_I_E_VALUE_OPTION);
        arrayList.add(MIN_REL_ENV_LENGTH_RATIO_OPTION);
        arrayList.add(DETAILEDNESS_OPTION);
        arrayList.add(OUTPUT_FILE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_SORT_OPTION);
        arrayList.add(SPECIES_MATRIX_OPTION);
        arrayList.add(SCORING_OPTION);
        arrayList.add(MAX_ALLOWED_OVERLAP_OPTION);
        arrayList.add(NO_ENGULFING_OVERLAP_OPTION);
        arrayList.add(DOMAIN_COUNT_SORT_OPTION);
        arrayList.add(CUTOFF_SCORE_FILE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION);
        arrayList.add(OUTPUT_DIR_OPTION);
        arrayList.add(IGNORE_COMBINATION_WITH_SAME_OPTION);
        arrayList.add(PFAM_TO_GO_FILE_USE_OPTION);
        arrayList.add(GO_OBO_FILE_USE_OPTION);
        arrayList.add(DOMAIN_SIMILARITY_PRINT_OPTION);
        arrayList.add(GO_NAMESPACE_LIMIT_OPTION);
        arrayList.add(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
        arrayList.add(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION);
        arrayList.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS);
        arrayList.add(INPUT_SPECIES_TREE_OPTION);
        arrayList.add(FILTER_POSITIVE_OPTION);
        arrayList.add(FILTER_NEGATIVE_OPTION);
        arrayList.add(INPUT_GENOMES_FILE_OPTION);
        arrayList.add(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
        arrayList.add(FILTER_NEGATIVE_DOMAINS_OPTION);
        arrayList.add(IGNORE_VIRAL_IDS);
        arrayList.add(SEQ_EXTRACT_OPTION);
        arrayList.add(OUTPUT_LIST_OF_ALL_PROTEINS_PER_DOMAIN_E_VALUE_OPTION);
        arrayList.add(SECONDARY_FEATURES_PARSIMONY_MAP_FILE);
        arrayList.add(PLUS_MINUS_ANALYSIS_OPTION);
        arrayList.add(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS);
        arrayList.add(DOMAIN_COMBINITONS_COUNTS_OUTPUT_OPTION);
        arrayList.add(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS);
        arrayList.add(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY);
        arrayList.add(WRITE_TO_NEXUS_OPTION);
        arrayList.add(PERFORM_DC_REGAIN_PROTEINS_STATS_OPTION);
        arrayList.add(DA_ANALYSIS_OPTION);
        arrayList.add(USE_LAST_IN_FITCH_OPTION);
        arrayList.add(PERFORM_DC_FITCH);
        arrayList.add(PERFORM_DOMAIN_LENGTH_ANALYSIS_OPTION);
        arrayList.add(WRITE_DA_IDS_NAMES_MAPS_OPTION);
        arrayList.add(INPUT_DA_NAME_FILE_OPTION);
        arrayList.add(OBTAIN_NAMES_FOR_DAS_FROM_DB_OPTION);
        boolean bl = true;
        boolean bl2 = false;
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        int n4 = -1;
        String string3 = commandLineArguments.validateAllowedOptionsAsString(arrayList);
        if (string3.length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string3);
        }
        boolean bl3 = false;
        if (commandLineArguments.isOptionSet(USE_LAST_IN_FITCH_OPTION)) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (commandLineArguments.isOptionSet(WRITE_TO_NEXUS_OPTION)) {
            bl4 = true;
        }
        boolean bl5 = false;
        if (commandLineArguments.isOptionSet(PERFORM_DC_FITCH)) {
            bl5 = true;
        }
        boolean bl6 = false;
        if (commandLineArguments.isOptionSet(PERFORM_DC_REGAIN_PROTEINS_STATS_OPTION)) {
            bl6 = true;
        }
        boolean bl7 = false;
        if (commandLineArguments.isOptionSet(DA_ANALYSIS_OPTION)) {
            bl7 = true;
        }
        boolean bl8 = false;
        if (commandLineArguments.isOptionSet(DOMAIN_COMBINITONS_OUTPUT_OPTION_FOR_GRAPH_ANALYSIS)) {
            bl8 = true;
        }
        boolean bl9 = false;
        if (commandLineArguments.isOptionSet(DOMAIN_COMBINITONS_COUNTS_OUTPUT_OPTION)) {
            bl9 = true;
        }
        if (commandLineArguments.isOptionSet(MAX_FS_E_VALUE_OPTION)) {
            try {
                d = commandLineArguments.getOptionValueAsDouble(MAX_FS_E_VALUE_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for E-value maximum");
            }
        }
        if (commandLineArguments.isOptionSet(MIN_REL_ENV_LENGTH_RATIO_OPTION)) {
            try {
                d3 = commandLineArguments.getOptionValueAsDouble(MIN_REL_ENV_LENGTH_RATIO_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for min rel env length ratio");
            }
        }
        if (commandLineArguments.isOptionSet(MAX_I_E_VALUE_OPTION)) {
            try {
                d2 = commandLineArguments.getOptionValueAsDouble(MAX_I_E_VALUE_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for E-value maximum");
            }
        }
        if (commandLineArguments.isOptionSet(MAX_ALLOWED_OVERLAP_OPTION)) {
            try {
                n4 = commandLineArguments.getOptionValueAsInt(MAX_ALLOWED_OVERLAP_OPTION);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, "no acceptable value for maximal allowed domain overlap");
            }
        }
        boolean bl10 = false;
        if (commandLineArguments.isOptionSet(NO_ENGULFING_OVERLAP_OPTION)) {
            bl10 = true;
        }
        boolean bl11 = false;
        if (commandLineArguments.isOptionSet(IGNORE_VIRAL_IDS)) {
            bl11 = true;
        }
        if (commandLineArguments.isOptionSet(NOT_IGNORE_DUFS_OPTION)) {
            bl = false;
        }
        if (commandLineArguments.isOptionSet(IGNORE_COMBINATION_WITH_SAME_OPTION)) {
            bl2 = true;
        }
        boolean bl12 = false;
        if (commandLineArguments.isOptionSet(PERFORM_DOMAIN_LENGTH_ANALYSIS_OPTION)) {
            bl12 = true;
        }
        boolean bl13 = false;
        if (commandLineArguments.isOptionSet(IGNORE_DOMAINS_WITHOUT_COMBINATIONS_IN_ALL_SPECIES_OPTION)) {
            bl13 = true;
        }
        boolean bl14 = false;
        if (commandLineArguments.isOptionSet(IGNORE_DOMAINS_SPECIFIC_TO_ONE_SPECIES_OPTION)) {
            bl14 = true;
        }
        if (!commandLineArguments.isOptionValueSet(INPUT_SPECIES_TREE_OPTION)) {
            ForesterUtil.fatalError(PRG_NAME, "no input species tree file given: species_tree=<file>");
        }
        File file = null;
        if (commandLineArguments.isOptionSet(OUTPUT_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(OUTPUT_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities output file: -o=<file>");
            }
            file = new File(commandLineArguments.getOptionValue(OUTPUT_FILE_OPTION));
            SurfacingUtil.checkForOutputFileWriteability(file);
        }
        File file2 = null;
        Map<String, Double> map = null;
        if (commandLineArguments.isOptionSet(CUTOFF_SCORE_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(CUTOFF_SCORE_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for individual domain score cutoffs file: -cos=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object25 = ForesterUtil.isReadableFile(file2 = new File(commandLineArguments.getOptionValue(CUTOFF_SCORE_FILE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read individual domain score cutoffs file: " + (String)object25);
            }
            try {
                object24 = BasicTableParser.parse(file2, ' ');
                map = ((BasicTable)object24).getColumnsAsMapDouble(0, 1);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, "cannot read from individual score cutoffs file: " + iOException);
            }
        }
        object25 = BinaryDomainCombination.DomainCombinationType.BASIC;
        if (commandLineArguments.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS)) {
            object25 = BinaryDomainCombination.DomainCombinationType.DIRECTED;
        }
        if (commandLineArguments.isOptionSet(CONSIDER_DOMAIN_COMBINATION_DIRECTEDNESS_AND_ADJACENCY)) {
            object25 = BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT;
        }
        object24 = null;
        if (commandLineArguments.isOptionSet(OUTPUT_DIR_OPTION)) {
            boolean bl15;
            if (!commandLineArguments.isOptionValueSet(OUTPUT_DIR_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for output directory: -out_dir=<dir>");
            }
            if (((File)(object24 = new File(commandLineArguments.getOptionValue(OUTPUT_DIR_OPTION)))).exists() && ((File)object24).listFiles().length > 0) {
                ForesterUtil.fatalError(PRG_NAME, "\"" + object24 + "\" aready exists and is not empty");
            }
            if (!(((File)object24).exists() || (bl15 = ((File)object24).mkdir()) && ((File)object24).exists())) {
                ForesterUtil.fatalError(PRG_NAME, "failed to create \"" + object24 + "\"");
            }
            if (!((File)object24).canWrite()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot write to \"" + object24 + "\"");
            }
        }
        File file3 = null;
        File file4 = null;
        File file5 = null;
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION) && commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION)) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative and positive protein filter");
        }
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION) && (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION) || commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION))) {
            ForesterUtil.fatalError(PRG_NAME, "attempt to use both negative or positive protein filter together wirh a negative domains filter");
        }
        if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_NEGATIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative filter: -neg_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object23 = ForesterUtil.isReadableFile(file4 = new File(commandLineArguments.getOptionValue(FILTER_NEGATIVE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file4 + "\": " + (String)object23);
            }
        } else if (commandLineArguments.isOptionSet(FILTER_POSITIVE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_POSITIVE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for positive filter: -pos_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object23 = ForesterUtil.isReadableFile(file3 = new File(commandLineArguments.getOptionValue(FILTER_POSITIVE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file3 + "\": " + (String)object23);
            }
        } else if (commandLineArguments.isOptionSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(FILTER_NEGATIVE_DOMAINS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for negative domains filter: -neg_dom_filter=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object23 = ForesterUtil.isReadableFile(file5 = new File(commandLineArguments.getOptionValue(FILTER_NEGATIVE_DOMAINS_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file5 + "\": " + (String)object23);
            }
        }
        object23 = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        SurfacingUtil.processPlusMinusAnalysisOption(commandLineArguments, (List<String>)object23, arrayList2, arrayList3, arrayList4);
        File file6 = null;
        if (commandLineArguments.isOptionSet(INPUT_GENOMES_FILE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(INPUT_GENOMES_FILE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input genomes file: -genomes=<file>");
            }
            if (!ForesterUtil.isEmpty((String)(object22 = ForesterUtil.isReadableFile(file6 = new File(commandLineArguments.getOptionValue(INPUT_GENOMES_FILE_OPTION)))))) {
                ForesterUtil.fatalError(PRG_NAME, "can not read from \"" + file6 + "\": " + (String)object22);
            }
        } else {
            ForesterUtil.fatalError(PRG_NAME, "no input genomes file given: genomes=<file>");
        }
        object22 = SCORING_DEFAULT;
        if (commandLineArguments.isOptionSet(SCORING_OPTION)) {
            String string4;
            if (!commandLineArguments.isOptionValueSet(SCORING_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for scoring method for domain combinations similarity calculation: -scoring=<domains|proteins|combinations>\"");
            }
            if ((string4 = commandLineArguments.getOptionValue(SCORING_OPTION)).equals(SCORING_DOMAIN_COUNT_BASED)) {
                object22 = DomainSimilarity.DomainSimilarityScoring.DOMAINS;
            } else if (string4.equals(SCORING_COMBINATION_BASED)) {
                object22 = DomainSimilarity.DomainSimilarityScoring.COMBINATIONS;
            } else if (string4.equals(SCORING_PROTEIN_COUNT_BASED)) {
                object22 = DomainSimilarity.DomainSimilarityScoring.PROTEINS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + string4 + "\" for scoring method for domain combinations similarity calculation: \"-" + SCORING_OPTION + "=<" + SCORING_DOMAIN_COUNT_BASED + "|" + SCORING_PROTEIN_COUNT_BASED + "|" + SCORING_COMBINATION_BASED + ">\"");
            }
        }
        boolean bl16 = false;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_SORT_BY_SPECIES_COUNT_FIRST_OPTION)) {
            bl16 = true;
        }
        boolean bl17 = false;
        if (commandLineArguments.isOptionSet(SPECIES_MATRIX_OPTION)) {
            bl17 = true;
        }
        boolean bl18 = false;
        double d4 = -1.0;
        if (commandLineArguments.isOptionSet(OUTPUT_LIST_OF_ALL_PROTEINS_OPTIONS)) {
            bl18 = true;
            if (commandLineArguments.isOptionSet(OUTPUT_LIST_OF_ALL_PROTEINS_PER_DOMAIN_E_VALUE_OPTION)) {
                try {
                    d4 = commandLineArguments.getOptionValueAsDouble(OUTPUT_LIST_OF_ALL_PROTEINS_PER_DOMAIN_E_VALUE_OPTION);
                }
                catch (Exception exception) {
                    ForesterUtil.fatalError(PRG_NAME, "no acceptable value for per domain E-value maximum");
                }
            }
        }
        DomainSimilarityCalculator.Detailedness detailedness = DETAILEDNESS_DEFAULT;
        if (commandLineArguments.isOptionSet(DETAILEDNESS_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DETAILEDNESS_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for -detail=<basic|list_ids|punctilious>\"");
            }
            if ((string = commandLineArguments.getOptionValue(DETAILEDNESS_OPTION).toLowerCase()).equals(DETAILEDNESS_BASIC)) {
                detailedness = DomainSimilarityCalculator.Detailedness.BASIC;
            } else if (string.equals(DETAILEDNESS_LIST_IDS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES;
            } else if (string.equals(DETAILEDNESS_PUNCTILIOUS)) {
                detailedness = DomainSimilarityCalculator.Detailedness.PUNCTILIOUS;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + string + "\" for detailedness: \"-" + DETAILEDNESS_OPTION + "=<" + DETAILEDNESS_BASIC + "|" + DETAILEDNESS_LIST_IDS + "|" + DETAILEDNESS_PUNCTILIOUS + ">\"");
            }
        }
        string = null;
        boolean bl19 = false;
        boolean bl20 = false;
        if (commandLineArguments.isOptionSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
            bl19 = true;
            if (!commandLineArguments.isOptionValueSet(PAIRWISE_DOMAIN_COMPARISONS_OPTION)) {
                bl20 = false;
            } else {
                bl20 = true;
                string = "_" + commandLineArguments.getOptionValue(PAIRWISE_DOMAIN_COMPARISONS_OPTION);
            }
        }
        String string5 = null;
        if (commandLineArguments.isOptionSet(SEQ_EXTRACT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(SEQ_EXTRACT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no domain ids given for sequences with given domains to be extracted : -prot_extract=<ordered domain sequences, domain ids separated by '~', sequences separated by '#'>");
            }
            string5 = commandLineArguments.getOptionValue(SEQ_EXTRACT_OPTION);
        }
        DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField = DOMAIN_SORT_FILD_DEFAULT;
        DomainSimilarity.DomainSimilaritySortField domainSimilaritySortField2 = DOMAIN_SORT_FILD_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_SIMILARITY_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for domain combinations similarities sorting: -sort=<alpha|max|min|mean|diff|abs_count_diff|count_diff|species|sd>\"");
            }
            if (((String)(object21 = commandLineArguments.getOptionValue(DOMAIN_SIMILARITY_SORT_OPTION).toLowerCase())).equals("alpha")) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object21).equals(DOMAIN_SIMILARITY_SORT_MAX)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object21).equals(DOMAIN_SIMILARITY_SORT_MIN)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MIN;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object21).equals(DOMAIN_SIMILARITY_SORT_MEAN)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MEAN;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MEAN;
            } else if (((String)object21).equals(DOMAIN_SIMILARITY_SORT_SPECIES_COUNT)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.SPECIES_COUNT;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object21).equals(DOMAIN_SIMILARITY_SORT_SD)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.SD;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.DOMAIN_ID;
            } else if (((String)object21).equals(DOMAIN_SIMILARITY_SORT_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MAX_DIFFERENCE;
            } else if (((String)object21).equals(DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
            } else if (((String)object21).equals(DOMAIN_SIMILARITY_SORT_COUNTS_DIFF)) {
                domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
                domainSimilaritySortField2 = DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object21 + "\" for domain combinations similarities sorting: \"-" + DOMAIN_SIMILARITY_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_SIMILARITY_SORT_MAX + "|" + DOMAIN_SIMILARITY_SORT_MIN + "|" + DOMAIN_SIMILARITY_SORT_MEAN + "|" + DOMAIN_SIMILARITY_SORT_DIFF + "|" + DOMAIN_SIMILARITY_SORT_ABS_COUNTS_DIFF + "|" + DOMAIN_SIMILARITY_SORT_COUNTS_DIFF + "||" + DOMAIN_SIMILARITY_SORT_SPECIES_COUNT + "|" + DOMAIN_SIMILARITY_SORT_SD + ">\"");
            }
        }
        object21 = DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_SIMILARITY_PRINT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for print option: -detailed_html|simple_html|simple_tab>\"");
            }
            if (((String)(object20 = commandLineArguments.getOptionValue(DOMAIN_SIMILARITY_PRINT_OPTION).toLowerCase())).equals(DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML)) {
                object21 = DomainSimilarity.PRINT_OPTION.HTML;
            } else if (((String)object20).equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML)) {
                ForesterUtil.fatalError(PRG_NAME, "simple HTML output not implemented yet :(");
            } else if (((String)object20).equals(DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED)) {
                object21 = DomainSimilarity.PRINT_OPTION.SIMPLE_TAB_DELIMITED;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object20 + "\" for print option: -" + DOMAIN_SIMILARITY_PRINT_OPTION_DETAILED_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_HTML + "|" + DOMAIN_SIMILARITY_PRINT_OPTION_SIMPLE_TAB_DELIMITED + ">\"");
            }
        }
        object20 = DOMAINS_SORT_ORDER_DEFAULT;
        if (commandLineArguments.isOptionSet(DOMAIN_COUNT_SORT_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(DOMAIN_COUNT_SORT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for sorting of domain counts: -dc_sort=<alpha|dom|prot|comb>\"");
            }
            if (((String)(object19 = commandLineArguments.getOptionValue(DOMAIN_COUNT_SORT_OPTION).toLowerCase())).equals("alpha")) {
                object20 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.ALPHABETICAL_KEY_ID;
            } else if (((String)object19).equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT)) {
                object20 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_COUNT;
            } else if (((String)object19).equals(DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT)) {
                object20 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.KEY_DOMAIN_PROTEINS_COUNT;
            } else if (((String)object19).equals(DOMAIN_COUNT_SORT_COMBINATIONS_COUNT)) {
                object20 = GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder.COMBINATIONS_COUNT;
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)object19 + "\" for sorting of domain counts: \"-" + DOMAIN_COUNT_SORT_OPTION + "=<" + "alpha" + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_COUNT + "|" + DOMAIN_COUNT_SORT_KEY_DOMAIN_PROTEINS_COUNT + "|" + DOMAIN_COUNT_SORT_COMBINATIONS_COUNT + ">\"");
            }
        }
        if ((n3 = ((String[][])(object19 = SurfacingUtil.processInputGenomesFile(file6))).length) < 2) {
            ForesterUtil.fatalError(PRG_NAME, "cannot analyze less than two files");
        }
        if (n3 < 3 && bl19) {
            ForesterUtil.fatalError(PRG_NAME, "cannot use : -pwc=<suffix> to turn on pairwise analyses with less than three input files");
        }
        SurfacingUtil.checkWriteabilityForPairwiseComparisons((DomainSimilarity.PRINT_OPTION)((Object)object21), (String[][])object19, string, (File)object24);
        for (int i = 0; i < n3; ++i) {
            object18 = new File((String)object19[i][1] + DOMAIN_COMBINITON_COUNTS_OUTPUTFILE_SUFFIX);
            if (object24 != null) {
                object18 = new File(object24 + ForesterUtil.FILE_SEPARATOR + object18);
            }
            SurfacingUtil.checkForOutputFileWriteability((File)object18);
        }
        File file7 = new File("pfam2go.txt");
        if (commandLineArguments.isOptionSet(PFAM_TO_GO_FILE_USE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(PFAM_TO_GO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for Pfam to GO mapping file: -p2g=<file>");
            }
            file7 = new File(commandLineArguments.getOptionValue(PFAM_TO_GO_FILE_USE_OPTION));
        }
        if (!ForesterUtil.isEmpty((String)(object18 = ForesterUtil.isReadableFile(file7)))) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read Pfam to GO mapping file: " + (String)object18);
        }
        Map<String, List<GoId>> map2 = null;
        int n5 = 0;
        try {
            object17 = new PfamToGoParser(file7);
            object16 = ((PfamToGoParser)object17).parse();
            map2 = SurfacingUtil.createDomainIdToGoIdMap(object16);
            if (((PfamToGoParser)object17).getMappingCount() < map2.size()) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getMappingCount() < domain_id_to_go_ids_map.size()");
            }
            n5 = ((PfamToGoParser)object17).getMappingCount();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read from Pfam to GO mapping file: " + iOException);
        }
        object17 = new File("go.obo");
        if (commandLineArguments.isOptionSet(GO_OBO_FILE_USE_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(GO_OBO_FILE_USE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO OBO file: -obo=<file>");
            }
            object17 = new File(commandLineArguments.getOptionValue(GO_OBO_FILE_USE_OPTION));
        }
        if (!ForesterUtil.isEmpty((String)(object16 = ForesterUtil.isReadableFile((File)object17)))) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read GO OBO file: " + (String)object16);
        }
        List<GoTerm> list = null;
        try {
            object15 = new OBOparser((File)object17, OBOparser.ReturnType.BASIC_GO_TERM);
            list = ((OBOparser)object15).parse();
            if (((OBOparser)object15).getGoTermCount() != list.size()) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "parser.getGoTermCount() != go_terms.size()");
            }
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "cannot read from GO OBO file: " + iOException);
        }
        object15 = null;
        if (map2 != null && map2.size() > 0 && list != null && list.size() > 0) {
            object15 = GoUtils.createGoIdToGoTermMap(list);
        }
        GoNameSpace goNameSpace = null;
        if (commandLineArguments.isOptionSet(GO_NAMESPACE_LIMIT_OPTION)) {
            if (object15 == null || object15.isEmpty()) {
                ForesterUtil.fatalError(PRG_NAME, "cannot use GO namespace limit (-go_namespace=<namespace>) without Pfam to GO mapping file (p2g=<file>) and GO OBO file (-obo=<file>)");
            }
            if (!commandLineArguments.isOptionValueSet(GO_NAMESPACE_LIMIT_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for GO namespace limit: \"-go_namespace=<molecular_function|biological_process|cellular_component>\"");
            }
            if ((fileArray = commandLineArguments.getOptionValue(GO_NAMESPACE_LIMIT_OPTION).toLowerCase()).equals(GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION)) {
                goNameSpace = GoNameSpace.createMolecularFunction();
            } else if (fileArray.equals(GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS)) {
                goNameSpace = GoNameSpace.createBiologicalProcess();
            } else if (fileArray.equals(GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT)) {
                goNameSpace = GoNameSpace.createCellularComponent();
            } else {
                ForesterUtil.fatalError(PRG_NAME, "unknown value \"" + (String)fileArray + "\" for GO namespace limit: \"-" + GO_NAMESPACE_LIMIT_OPTION + "=<" + GO_NAMESPACE_LIMIT_OPTION_MOLECULAR_FUNCTION + "|" + GO_NAMESPACE_LIMIT_OPTION_BIOLOGICAL_PROCESS + "|" + GO_NAMESPACE_LIMIT_OPTION_CELLULAR_COMPONENT + ">\"");
            }
        }
        if (domainSimilaritySortField == DomainSimilarity.DomainSimilaritySortField.MAX_COUNTS_DIFFERENCE && n3 > 2) {
            domainSimilaritySortField = DomainSimilarity.DomainSimilaritySortField.ABS_MAX_COUNTS_DIFFERENCE;
        }
        fileArray = null;
        Phylogeny[] phylogenyArray = null;
        if (commandLineArguments.isOptionSet(INPUT_SPECIES_TREE_OPTION)) {
            if (n3 < 3) {
                ForesterUtil.fatalError(PRG_NAME, "cannot infer gains and losses on input species trees (-species_tree without pairwise analyses (pwc=<suffix for pairwise comparison output files>)");
            }
            if (!commandLineArguments.isOptionValueSet(INPUT_SPECIES_TREE_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for input tree: -species_tree=<tree file in phyloXML format>");
            }
            if (((String)(object14 = commandLineArguments.getOptionValue(INPUT_SPECIES_TREE_OPTION))).indexOf("#") > 0) {
                String[] stringArray2 = ((String)object14).split("#");
                fileArray = new File[stringArray2.length];
                int n6 = 0;
                for (String string6 : stringArray2) {
                    fileArray[n6++] = new File(string6.trim());
                }
            } else {
                fileArray = new File[]{new File((String)object14)};
            }
            phylogenyArray = SurfacingUtil.obtainAndPreProcessIntrees(fileArray, n3, (String[][])object19);
        }
        object14 = SurfacingUtil.obtainFirstIntree((File)((Object)fileArray[0]));
        long l2 = 0L;
        boolean bl21 = false;
        if (commandLineArguments.isOptionSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
            if (!commandLineArguments.isOptionValueSet(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for random number seed: -random_seed=<seed>");
            }
            try {
                l2 = commandLineArguments.getOptionValueAsLong(RANDOM_SEED_FOR_FITCH_PARSIMONY_OPTION);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            }
            bl21 = true;
        }
        TreeSet<String> treeSet = null;
        if (file3 != null || file4 != null || file5 != null) {
            treeSet = new TreeSet<String>();
            if (file3 != null) {
                SurfacingUtil.processFilter(file3, treeSet);
            } else if (file4 != null) {
                SurfacingUtil.processFilter(file4, treeSet);
            } else if (file5 != null) {
                SurfacingUtil.processFilter(file5, treeSet);
            }
        }
        int n7 = commandLineArguments.isOptionSet(OBTAIN_NAMES_FOR_DAS_FROM_DB_OPTION) ? 1 : 0;
        boolean bl22 = commandLineArguments.isOptionSet(WRITE_DA_IDS_NAMES_MAPS_OPTION);
        File file8 = null;
        if (bl22) {
            if (commandLineArguments.isOptionSet(INPUT_DA_NAME_FILE_OPTION)) {
                if (!commandLineArguments.isOptionValueSet(INPUT_DA_NAME_FILE_OPTION)) {
                    ForesterUtil.fatalError(PRG_NAME, "no value for GO OBO file: -input_DA_name_map=<file>");
                }
                if (!ForesterUtil.isEmpty((String)(mapArray = ForesterUtil.isReadableFile(file8 = new File(commandLineArguments.getOptionValue(INPUT_DA_NAME_FILE_OPTION)))))) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read: " + file8);
                }
            }
            if (file8 == null && !n7) {
                ForesterUtil.fatalError(PRG_NAME, "need to obtain names for DAs either from file and/or database");
            }
        }
        mapArray = null;
        File[] fileArray2 = null;
        File file9 = new File(object24 + ForesterUtil.FILE_SEPARATOR + file + DOMAIN_LENGTHS_ANALYSIS_SUFFIX);
        if (bl12) {
            SurfacingUtil.checkForOutputFileWriteability(file9);
        }
        if (commandLineArguments.isOptionSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
            if (!commandLineArguments.isOptionValueSet(SECONDARY_FEATURES_PARSIMONY_MAP_FILE)) {
                ForesterUtil.fatalError(PRG_NAME, "no value for secondary features map file: -secondary=<file>");
            }
            object13 = commandLineArguments.getOptionValue(SECONDARY_FEATURES_PARSIMONY_MAP_FILE).split("#");
            fileArray2 = new File[((String[])object13).length];
            mapArray = new Map[((String[])object13).length];
            n2 = 0;
            object12 = object13;
            int n8 = ((String[])object12).length;
            for (n = 0; n < n8; ++n) {
                object11 = object12[n];
                fileArray2[n2] = new File((String)object11);
                object10 = ForesterUtil.isReadableFile(fileArray2[n2]);
                if (!ForesterUtil.isEmpty((String)object10)) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + (String)object10);
                }
                try {
                    mapArray[n2] = SurfacingUtil.createDomainIdToSecondaryFeaturesMap(fileArray2[n2]);
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, "cannot read secondary features map file: " + iOException.getMessage());
                }
                catch (Exception exception) {
                    ForesterUtil.fatalError(PRG_NAME, "problem with contents of features map file [" + fileArray2[n2] + "]: " + exception.getMessage());
                }
                ++n2;
            }
        }
        if (object24 == null) {
            ForesterUtil.fatalError(PRG_NAME, "no output directory indicated (-out_dir=<dir>)");
        }
        if (file == null) {
            ForesterUtil.fatalError(PRG_NAME, "no name for (main) output file indicated (-o=<file>)");
        }
        if (map2 == null || map2.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) Pfam to GO id mapping file provided ('pfam2go file') (-p2g=<file>)");
        }
        if (object15 == null || object15.isEmpty()) {
            ForesterUtil.fatalError(PRG_NAME, "no (acceptable) go id to term mapping file provided ('GO OBO file') (-obo=<file>)");
        }
        System.out.println("Output directory            : " + object24);
        System.out.println("Input genomes from          : " + file6);
        stringBuilder.append("<tr><td>Input genomes from:</td><td>" + file6 + "</td></tr>" + string2);
        if (file3 != null) {
            int n9 = treeSet.size();
            System.out.println("Positive protein filter     : " + file3 + " [" + n9 + " domain ids]");
            stringBuilder.append("<tr><td>Positive protein filter:</td><td>" + file3 + " [" + n9 + " domain ids]</td></tr>" + string2);
        }
        if (file4 != null) {
            int n10 = treeSet.size();
            System.out.println("Negative protein filter     : " + file4 + " [" + n10 + " domain ids]");
            stringBuilder.append("<tr><td>Negative protein filter:</td><td>" + file4 + " [" + n10 + " domain ids]</td></tr>" + string2);
        }
        if (file5 != null) {
            int n11 = treeSet.size();
            System.out.println("Negative domain filter      : " + file5 + " [" + n11 + " domain ids]");
            stringBuilder.append("<tr><td>Negative domain filter:</td><td>" + file5 + " [" + n11 + " domain ids]</td></tr>" + string2);
        }
        if (object23.size() > 0) {
            object13 = "";
            Object object26 = object23.iterator();
            while (object26.hasNext()) {
                object12 = (String)object26.next();
                object13 = (String)object13 + "+" + (String)object12 + " ";
            }
            object26 = "";
            for (String string7 : arrayList2) {
                object26 = (String)object26 + "*" + string7 + " ";
            }
            object12 = "";
            for (String string8 : arrayList3) {
                object12 = (String)object12 + "-" + string8 + " ";
            }
            System.out.println("Plus-minus analysis         : " + (String)object26 + "&& " + (String)object13 + "&& " + (String)object12);
            stringBuilder.append("<tr><td>Plus-minus analysis:</td><td>" + (String)object26 + "&& " + (String)object13 + "&& " + (String)object12 + "</td></tr>" + string2);
        }
        if (file2 != null) {
            System.out.println("Cutoff scores file          : " + file2);
            stringBuilder.append("<tr><td>Cutoff scores file:</td><td>" + file2 + "</td></tr>" + string2);
        }
        if (d2 >= 0.0) {
            System.out.println("iE-value maximum (incl)     : " + d2);
            stringBuilder.append("<tr><td>iE-value maximum (inclusive):</td><td>" + d2 + "</td></tr>" + string2);
        }
        if (d3 > 0.0) {
            System.out.println("Rel env length ratio min    : " + d3);
            stringBuilder.append("<tr><td>Relative hmm envelope length ratio min (inclusive):</td><td>" + d3 + "</td></tr>" + string2);
        }
        if (d >= 0.0) {
            System.out.println("FS E-value maximum (incl)   : " + d);
            stringBuilder.append("<tr><td>FS E-value maximum (inclusive):</td><td>" + d + "</td></tr>" + string2);
        }
        if (bl18) {
            System.out.println("Domain E-value max          : " + d4);
            stringBuilder.append("<tr><td>Protein lists: E-value maximum per domain (inclusive):</td><td>" + d4 + "</td></tr>" + string2);
        }
        System.out.println("Ignore DUFs                 : " + bl);
        if (bl11) {
            System.out.println("Ignore virus like ids       : " + bl11);
            stringBuilder.append("<tr><td>Ignore virus, phage, transposition related ids:</td><td>" + bl11 + "</td></tr>" + string2);
        }
        stringBuilder.append("<tr><td>Ignore DUFs:</td><td>" + bl + "</td></tr>" + string2);
        if (n4 != -1) {
            System.out.println("Max allowed domain overlap  : " + n4);
            stringBuilder.append("<tr><td>Max allowed domain overlap:</td><td>" + n4 + "</td></tr>" + string2);
        }
        if (bl10) {
            System.out.println("Ignore engulfed domains     : " + bl10);
            stringBuilder.append("<tr><td>Ignore (lower confidence) engulfed domains:</td><td>" + bl10 + "</td></tr>" + string2);
        }
        System.out.println("Ignore singlet domains      : " + bl13);
        stringBuilder.append("<tr><td>Ignore singlet domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + bl13 + "</td></tr>" + string2);
        System.out.println("Ignore species specific doms: " + bl14);
        stringBuilder.append("<tr><td>Ignore species specific domains for domain combination similarity analyses (not for parsimony analyses):</td><td>" + bl14 + "</td></tr>" + string2);
        System.out.println("Ignore combination with self: " + bl2);
        stringBuilder.append("<tr><td>Ignore combination with self for domain combination similarity analyses:</td><td>" + bl2 + "</td></tr>" + string2);
        System.out.println("Consider directedness       : " + (object25 != BinaryDomainCombination.DomainCombinationType.BASIC));
        stringBuilder.append("<tr><td>Consider directedness of binary domain combinations:</td><td>" + (object25 != BinaryDomainCombination.DomainCombinationType.BASIC) + "</td></tr>" + string2);
        if (object25 != BinaryDomainCombination.DomainCombinationType.BASIC) {
            System.out.println("Consider adjacency          : " + (object25 == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT));
            stringBuilder.append("<tr><td>Consider djacency of binary domain combinations:</td><td>" + (object25 == BinaryDomainCombination.DomainCombinationType.DIRECTED_ADJACTANT) + "</td></tr>" + string2);
        }
        System.out.println("Fitch parsimony of DCs      : " + bl5);
        stringBuilder.append("<tr><td>Fitch parsimony of DCs:</td><td>" + bl5 + "</td></tr>" + string2);
        if (bl5) {
            System.out.println("Use last in Fitch parsimony : " + bl3);
            stringBuilder.append("<tr><td>Use last in Fitch parsimony:</td><td>" + bl3 + "</td></tr>" + string2);
        }
        System.out.println("Write to Nexus files        : " + bl4);
        stringBuilder.append("<tr><td>Write to Nexus files:</td><td>" + bl4 + "</td></tr>" + string2);
        if (bl5) {
            System.out.println("DC regain prot stats        : " + bl6);
            stringBuilder.append("<tr><td>DC regain prot stats:</td><td>" + bl6 + "</td></tr>" + string2);
        }
        System.out.println("DA analysis                 : " + bl7);
        stringBuilder.append("<tr><td>DA analysis :</td><td>" + bl7 + "</td></tr>" + string2);
        System.out.print("Domain counts sort order    : ");
        stringBuilder.append("<tr><td>Domain counts sort order:</td><td>");
        switch (1.$SwitchMap$org$forester$surfacing$GenomeWideCombinableDomains$GenomeWideCombinableDomainsSortOrder[((Enum)object20).ordinal()]) {
            case 1: {
                System.out.println("alphabetical");
                stringBuilder.append("alphabetical</td></tr>" + string2);
                break;
            }
            case 2: {
                System.out.println("domain count");
                stringBuilder.append("domain count</td></tr>" + string2);
                break;
            }
            case 3: {
                System.out.println("domain proteins count");
                stringBuilder.append("domain proteins count</td></tr>" + string2);
                break;
            }
            case 4: {
                System.out.println("domain combinations count");
                stringBuilder.append("domain combinations count</td></tr>" + string2);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for dc sort order");
            }
        }
        if (map2 != null) {
            System.out.println("Pfam to GO mappings from    : " + file7 + " [" + n5 + " mappings]");
            stringBuilder.append("<tr><td>Pfam to GO mappings from:</td><td>" + file7 + " [" + n5 + " mappings]</td></tr>" + string2);
        }
        if (list != null) {
            System.out.println("GO terms from               : " + object17 + " [" + list.size() + " terms]");
            stringBuilder.append("<tr><td>GO terms from:</td><td>" + object17 + " [" + list.size() + " terms]</td></tr>" + string2);
        }
        if (goNameSpace != null) {
            System.out.println("Limit GO terms to           : " + goNameSpace.toString());
            stringBuilder.append("<tr><td>Limit GO terms to</td><td>" + goNameSpace + "</td></tr>" + string2);
        }
        if (bl19) {
            System.out.println("Suffix for PWC files        : " + string);
            stringBuilder.append("<tr><td>Suffix for PWC files</td><td>" + string + "</td></tr>" + string2);
        }
        if (object24 != null) {
            System.out.println("Output directory            : " + object24);
        }
        if (string5 != null) {
            System.out.println("Query domains (ordered)     : " + string5);
            stringBuilder.append("<tr><td></td><td>" + string5 + "</td></tr>" + string2);
        }
        System.out.println("Write similarities to       : " + file);
        System.out.print("  Scoring method            : ");
        stringBuilder.append("<tr><td>Scoring method:</td><td>");
        switch (1.$SwitchMap$org$forester$surfacing$DomainSimilarity$DomainSimilarityScoring[((Enum)object22).ordinal()]) {
            case 1: {
                System.out.println("domain combinations based");
                stringBuilder.append("domain combinations based</td></tr>" + string2);
                break;
            }
            case 2: {
                System.out.println("domain counts based");
                stringBuilder.append("domain counts based</td></tr>" + string2);
                break;
            }
            case 3: {
                System.out.println("domain proteins counts based");
                stringBuilder.append("domain proteins counts based</td></tr>" + string2);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        System.out.print("  Sort by                   : ");
        stringBuilder.append("<tr><td>Sort by:</td><td>");
        switch (domainSimilaritySortField) {
            case MIN: {
                System.out.print("score minimum");
                stringBuilder.append("score minimum");
                break;
            }
            case MAX: {
                System.out.print("score maximum");
                stringBuilder.append("score maximum");
                break;
            }
            case MEAN: {
                System.out.print("score mean");
                stringBuilder.append("score mean");
                break;
            }
            case SD: {
                System.out.print("score standard deviation");
                stringBuilder.append("score standard deviation");
                break;
            }
            case SPECIES_COUNT: {
                System.out.print("species number");
                stringBuilder.append("species number");
                break;
            }
            case DOMAIN_ID: {
                System.out.print("alphabetical domain identifier");
                stringBuilder.append("alphabetical domain identifier");
                break;
            }
            case MAX_DIFFERENCE: {
                System.out.print("(maximal) difference");
                stringBuilder.append("(maximal) difference");
                break;
            }
            case ABS_MAX_COUNTS_DIFFERENCE: {
                System.out.print("absolute (maximal) counts difference");
                stringBuilder.append("absolute (maximal) counts difference");
                break;
            }
            case MAX_COUNTS_DIFFERENCE: {
                System.out.print("(maximal) counts difference");
                stringBuilder.append("(maximal) counts  difference");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
            }
        }
        if (bl16) {
            System.out.println(" (sort by species count first)");
            stringBuilder.append(" (sort by species count first)");
        } else {
            System.out.println();
        }
        stringBuilder.append("</td></tr>" + string2);
        System.out.print("  Detailedness              : ");
        switch (detailedness) {
            case BASIC: {
                System.out.println(DETAILEDNESS_BASIC);
                break;
            }
            case LIST_COMBINING_DOMAIN_FOR_EACH_SPECIES: {
                System.out.println("list combining domains for each species");
                break;
            }
            case PUNCTILIOUS: {
                System.out.println(DETAILEDNESS_PUNCTILIOUS);
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for detailedness");
            }
        }
        System.out.print("  Print option              : ");
        switch (1.$SwitchMap$org$forester$surfacing$DomainSimilarity$PRINT_OPTION[((Enum)object21).ordinal()]) {
            case 1: {
                System.out.println("HTML");
                break;
            }
            case 2: {
                System.out.println("simple tab delimited");
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for print option");
            }
        }
        System.out.print("  Species matrix            : " + bl17);
        System.out.println();
        object13 = new File(object24 + ForesterUtil.FILE_SEPARATOR + file + DATA_FILE_SUFFIX);
        System.out.println("Domain comb data output     : " + object13);
        stringBuilder.append("<tr><td>Domain combination data output:</td><td> " + object13 + " </td></tr>");
        System.out.println();
        if (bl19) {
            System.out.println("Pairwise comparisons: ");
            stringBuilder.append("<tr><td>Pairwise comparisons:</td><td></td></tr>");
            System.out.print("  Sort by                   : ");
            stringBuilder.append("<tr><td>Sort by:</td><td>");
            switch (domainSimilaritySortField2) {
                case MEAN: {
                    System.out.print("score mean");
                    stringBuilder.append("score mean");
                    break;
                }
                case DOMAIN_ID: {
                    System.out.print("alphabetical domain identifier");
                    stringBuilder.append("alphabetical domain identifier");
                    break;
                }
                case MAX_DIFFERENCE: {
                    System.out.print("difference");
                    stringBuilder.append("difference");
                    break;
                }
                case ABS_MAX_COUNTS_DIFFERENCE: {
                    System.out.print("absolute counts difference");
                    stringBuilder.append("absolute counts difference");
                    break;
                }
                case MAX_COUNTS_DIFFERENCE: {
                    System.out.print("counts difference");
                    stringBuilder.append("counts difference");
                    break;
                }
                default: {
                    ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for similarities");
                }
            }
            System.out.println();
            stringBuilder.append("</td></tr>" + string2);
            if (phylogenyArray != null && phylogenyArray.length > 0) {
                for (File file10 : fileArray) {
                    stringBuilder.append("<tr><td>Intree for gain/loss parsimony analysis:</td><td>" + file10 + "</td></tr>" + string2);
                    System.out.println("  Intree for gain/loss pars.: " + file10);
                }
            }
            if (bl21) {
                stringBuilder.append("<tr><td>    Random number seed for Fitch parsimony analysis:</td><td>" + l2 + "</td></tr>" + string2);
                System.out.println("    Random number seed      : " + l2);
            }
            if (mapArray != null && mapArray.length > 0) {
                for (n2 = 0; n2 < fileArray2.length; ++n2) {
                    stringBuilder.append("<tr><td>Secondary features map file:</td><td>" + fileArray2[n2] + "</td></tr>" + string2);
                    System.out.println("Secondary features map file : " + fileArray2[n2] + " [mappings for " + mapArray[n2].size() + " domain ids]");
                }
            }
        }
        System.out.println();
        stringBuilder.append("<tr><td>Command line:</td><td>" + string2 + string2 + commandLineArguments.getCommandLineArgsAsString() + string2 + string2 + "</td></tr>" + string2);
        System.out.println("Command line                : " + commandLineArguments.getCommandLineArgsAsString());
        BufferedWriter[] bufferedWriterArray = null;
        ArrayList[] arrayListArray = null;
        if (string5 != null) {
            String[] stringArray3 = string5.split("#");
            arrayListArray = new ArrayList[stringArray3.length];
            bufferedWriterArray = new BufferedWriter[stringArray3.length];
            for (n = 0; n < stringArray3.length; ++n) {
                void object8;
                object11 = stringArray3[n];
                object10 = ((String)object11).split("~");
                abstractCollection = new ArrayList();
                for (String string4 : object10) {
                    abstractCollection.add((String)string4);
                }
                arrayListArray[n] = abstractCollection;
                object11 = ((String)object11).replace('~', '_');
                String string6 = (String)object11 + SEQ_EXTRACT_SUFFIX;
                if (object24 != null) {
                    String string7 = object24 + ForesterUtil.FILE_SEPARATOR + string6;
                }
                try {
                    bufferedWriterArray[n] = new BufferedWriter(new FileWriter((String)object8));
                    continue;
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, "Could not open [" + (String)object8 + "]: " + iOException.getLocalizedMessage());
                }
            }
        }
        TreeMap<Species, List<Protein>> treeMap = null;
        n = 0;
        n = 1;
        if (n != 0) {
            treeMap = new TreeMap<Species, List<Protein>>();
        }
        object11 = new ArrayList(n3);
        object10 = new TreeSet();
        abstractCollection = new TreeSet();
        Object var89_122 = null;
        ArrayList<BinaryDomainCombination> arrayList5 = null;
        if (phylogenyArray != null && phylogenyArray.length == 1) {
            ArrayList arrayList6 = new ArrayList();
            arrayList5 = new ArrayList<BinaryDomainCombination>();
        }
        File file10 = new File(object24 + ForesterUtil.FILE_SEPARATOR + file + D_PROMISCUITY_FILE_SUFFIX);
        Object var92_131 = null;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file10));
            bufferedWriter.write("Species:\t");
            bufferedWriter.write("Mean:\t");
            bufferedWriter.write("SD:\t");
            bufferedWriter.write("Median:\t");
            bufferedWriter.write("Min:\t");
            bufferedWriter.write("Max:\t");
            bufferedWriter.write("N:\t");
            bufferedWriter.write("Max Promiscuous Domains:" + ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        File file11 = new File(object24 + ForesterUtil.FILE_SEPARATOR + file + LOG_FILE_SUFFIX);
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file11));
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        BufferedWriter bufferedWriter2 = null;
        try {
            bufferedWriter2 = new BufferedWriter(new FileWriter((File)object13));
            bufferedWriter2.write(DATA_FILE_DESC);
            bufferedWriter2.write(ForesterUtil.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        BasicDescriptiveStatistics basicDescriptiveStatistics2 = new BasicDescriptiveStatistics();
        TreeMap<Integer, Integer> treeMap2 = new TreeMap<Integer, Integer>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        TreeSet<String> treeSet3 = new TreeSet<String>();
        TreeSet<String> treeSet4 = new TreeSet<String>();
        BufferedWriter bufferedWriter3 = null;
        try {
            bufferedWriter3 = new BufferedWriter(new FileWriter(object24 + ForesterUtil.FILE_SEPARATOR + file + "_domains_per_potein_stats.txt"));
            bufferedWriter3.write("Genome");
            bufferedWriter3.write("\t");
            bufferedWriter3.write("Mean");
            bufferedWriter3.write("\t");
            bufferedWriter3.write("SD");
            bufferedWriter3.write("\t");
            bufferedWriter3.write("Median");
            bufferedWriter3.write("\t");
            bufferedWriter3.write("N");
            bufferedWriter3.write("\t");
            bufferedWriter3.write("Min");
            bufferedWriter3.write("\t");
            bufferedWriter3.write("Max");
            bufferedWriter3.write("\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        HashMap<String, DescriptiveStatistics> hashMap = null;
        HashMap<String, DescriptiveStatistics> hashMap2 = null;
        HashMap<String, DescriptiveStatistics> hashMap3 = new HashMap<String, DescriptiveStatistics>();
        if (bl6) {
            hashMap = new HashMap<String, DescriptiveStatistics>();
            hashMap2 = new HashMap<String, DescriptiveStatistics>();
        }
        DomainLengthsTable domainLengthsTable = null;
        if (bl12) {
            domainLengthsTable = new DomainLengthsTable();
        }
        TreeMap<String, Set<String>> treeMap3 = new TreeMap<String, Set<String>>();
        TreeMap<String, Integer> treeMap4 = new TreeMap<String, Integer>();
        for (int i = 0; i < n3; ++i) {
            System.out.println();
            System.out.println(i + 1 + "/" + n3);
            SurfacingUtil.log(i + 1 + "/" + n3, bufferedWriter);
            System.out.println("Processing                                     : " + (String)object19[i][1] + " [" + (String)object19[i][0] + "]");
            SurfacingUtil.log("Genome                                         : " + (String)object19[i][1] + " [" + (String)object19[i][0] + "]", bufferedWriter);
            HmmscanPerDomainTableParser hmmscanPerDomainTableParser = null;
            HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF iNDIVIDUAL_SCORE_CUTOFF = HmmscanPerDomainTableParser.INDIVIDUAL_SCORE_CUTOFF.NONE;
            if (map != null) {
                iNDIVIDUAL_SCORE_CUTOFF = INDIVIDUAL_SCORE_CUTOFF_DEFAULT;
            }
            if (file3 != null || file4 != null || file5 != null) {
                object5 = HmmscanPerDomainTableParser.FilterType.NONE;
                if (file3 != null) {
                    object5 = HmmscanPerDomainTableParser.FilterType.POSITIVE_PROTEIN;
                } else if (file4 != null) {
                    object5 = HmmscanPerDomainTableParser.FilterType.NEGATIVE_PROTEIN;
                } else if (file5 != null) {
                    object5 = HmmscanPerDomainTableParser.FilterType.NEGATIVE_DOMAIN;
                }
                hmmscanPerDomainTableParser = new HmmscanPerDomainTableParser(new File((String)object19[i][0]), (String)object19[i][1], treeSet, (HmmscanPerDomainTableParser.FilterType)((Object)object5), iNDIVIDUAL_SCORE_CUTOFF, true);
            } else {
                hmmscanPerDomainTableParser = new HmmscanPerDomainTableParser(new File((String)object19[i][0]), (String)object19[i][1], iNDIVIDUAL_SCORE_CUTOFF, true);
            }
            if (d >= 0.0) {
                hmmscanPerDomainTableParser.setFsEValueMaximum(d);
            }
            if (d2 >= 0.0) {
                hmmscanPerDomainTableParser.setIEValueMaximum(d2);
            }
            if (d3 > 0.0) {
                hmmscanPerDomainTableParser.setRelEnvLengthRatioCutoff(d3);
            }
            hmmscanPerDomainTableParser.setIgnoreDufs(bl);
            hmmscanPerDomainTableParser.setIgnoreVirusLikeIds(bl11);
            hmmscanPerDomainTableParser.setIgnoreEngulfedDomains(bl10);
            if (n4 != -1) {
                hmmscanPerDomainTableParser.setMaxAllowedOverlap(n4);
            }
            hmmscanPerDomainTableParser.setReturnType(HmmscanPerDomainTableParser.ReturnType.UNORDERED_PROTEIN_DOMAIN_COLLECTION_PER_PROTEIN);
            if (map != null) {
                hmmscanPerDomainTableParser.setIndividualScoreCutoffs(map);
            }
            object5 = null;
            try {
                object5 = hmmscanPerDomainTableParser.parse();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            }
            catch (Exception exception) {
                ForesterUtil.unexpectedFatalError(PRG_NAME, exception.getMessage(), exception);
            }
            double d5 = (double)object5.size() / (double)hmmscanPerDomainTableParser.getProteinsEncountered();
            basicDescriptiveStatistics.addValue(d5);
            int n6 = -1;
            if (bl7) {
                Object object6 = object19[i][0];
                n6 = SurfacingUtil.storeDomainArchitectures((String)object6, treeMap3, (List<Protein>)object5, treeMap4);
            }
            System.out.println("Number of proteins encountered                 : " + hmmscanPerDomainTableParser.getProteinsEncountered());
            SurfacingUtil.log("Number of proteins encountered                 : " + hmmscanPerDomainTableParser.getProteinsEncountered(), bufferedWriter);
            System.out.println("Number of proteins stored                      : " + object5.size());
            SurfacingUtil.log("Number of proteins stored                      : " + object5.size(), bufferedWriter);
            System.out.println("Coverage                                       : " + ForesterUtil.roundToInt(100.0 * d5) + "%");
            SurfacingUtil.log("Coverage                                       : " + ForesterUtil.roundToInt(100.0 * d5) + "%", bufferedWriter);
            System.out.println("Domains encountered                            : " + hmmscanPerDomainTableParser.getDomainsEncountered());
            SurfacingUtil.log("Domains encountered                            : " + hmmscanPerDomainTableParser.getDomainsEncountered(), bufferedWriter);
            System.out.println("Domains stored                                 : " + hmmscanPerDomainTableParser.getDomainsStored());
            SurfacingUtil.log("Domains stored                                 : " + hmmscanPerDomainTableParser.getDomainsStored(), bufferedWriter);
            System.out.println("Distinct domains stored                        : " + hmmscanPerDomainTableParser.getDomainsStoredSet().size());
            SurfacingUtil.log("Distinct domains stored                        : " + hmmscanPerDomainTableParser.getDomainsStoredSet().size(), bufferedWriter);
            System.out.println("Domains ignored due to individual score cutoffs: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIndividualScoreCutoff());
            SurfacingUtil.log("Domains ignored due to individual score cutoffs: " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIndividualScoreCutoff(), bufferedWriter);
            System.out.println("Domains ignored due to FS E-value              : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToFsEval());
            SurfacingUtil.log("Domains ignored due to FS E-value              : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToFsEval(), bufferedWriter);
            System.out.println("Domains ignored due to iE-value                : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIEval());
            SurfacingUtil.log("Domains ignored due to iE-value                : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToIEval(), bufferedWriter);
            System.out.println("Domains ignored due to rel env length ratio    : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToRelEnvLengthRatioCutoff());
            SurfacingUtil.log("Domains ignored due to rel env length ratio    : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToRelEnvLengthRatioCutoff(), bufferedWriter);
            System.out.println("Domains ignored due to DUF designation         : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToDuf());
            SurfacingUtil.log("Domains ignored due to DUF designation         : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToDuf(), bufferedWriter);
            if (bl11) {
                System.out.println("Domains ignored due virus like ids             : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToVirusLikeIds());
                SurfacingUtil.log("Domains ignored due virus like ids             : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToVirusLikeIds(), bufferedWriter);
            }
            System.out.println("Domains ignored due negative domain filter     : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToNegativeDomainFilter());
            SurfacingUtil.log("Domains ignored due negative domain filter     : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToNegativeDomainFilter(), bufferedWriter);
            System.out.println("Domains ignored due to overlap                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToOverlap());
            SurfacingUtil.log("Domains ignored due to overlap                 : " + hmmscanPerDomainTableParser.getDomainsIgnoredDueToOverlap(), bufferedWriter);
            if (file4 != null) {
                System.out.println("Proteins ignored due to negative filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
                SurfacingUtil.log("Proteins ignored due to negative filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter(), bufferedWriter);
            }
            if (file3 != null) {
                System.out.println("Proteins ignored due to positive filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter());
                SurfacingUtil.log("Proteins ignored due to positive filter        : " + hmmscanPerDomainTableParser.getProteinsIgnoredDueToFilter(), bufferedWriter);
            }
            if (bl7) {
                System.out.println("Distinct domain architectures stored           : " + n6);
                SurfacingUtil.log("Distinct domain architectures stored           : " + n6, bufferedWriter);
            }
            System.out.println("Time for processing                            : " + hmmscanPerDomainTableParser.getTime() + "ms");
            SurfacingUtil.log("", bufferedWriter);
            try {
                int n8 = 0;
                object4 = object5.iterator();
                while (object4.hasNext()) {
                    object3 = (Protein)object4.next();
                    bufferedWriter2.write(SurfacingUtil.proteinToDomainCombinations((Protein)object3, n8 + "", "\t").toString());
                    ++n8;
                    for (Domain domain : object3.getProteinDomains()) {
                        object2 = domain.getDomainId().toString();
                        if (!hashMap3.containsKey(object2)) {
                            hashMap3.put((String)object2, new BasicDescriptiveStatistics());
                        }
                        ((DescriptiveStatistics)hashMap3.get(object2)).addValue(domain.getLength());
                    }
                }
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.toString());
            }
            SurfacingUtil.domainsPerProteinsStatistics((String)object19[i][1], (List<Protein>)object5, basicDescriptiveStatistics2, treeMap2, treeSet2, treeSet3, treeSet4, bufferedWriter3);
            if (bl12) {
                domainLengthsTable.addLengths((List<Protein>)object5);
            }
            if (!bl7) {
                object11.add(BasicGenomeWideCombinableDomains.createInstance((List<Protein>)object5, bl2, new BasicSpecies((String)object19[i][1]), map2, object25, hashMap, hashMap2));
                if (((GenomeWideCombinableDomains)object11.get(i)).getSize() > 0) {
                    if (bl9) {
                        SurfacingUtil.writeDomainCombinationsCountsFile((String[][])object19, (File)object24, (Writer)var92_133, (GenomeWideCombinableDomains)object11.get(i), i, (GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder)((Object)object20));
                    }
                    if (bl8) {
                        SurfacingUtil.writeBinaryDomainCombinationsFileForGraphAnalysis((String[][])object19, (File)object24, (GenomeWideCombinableDomains)object11.get(i), i, (GenomeWideCombinableDomains.GenomeWideCombinableDomainsSortOrder)((Object)object20));
                    }
                    SurfacingUtil.addAllDomainIdsToSet((GenomeWideCombinableDomains)object11.get(i), (SortedSet<String>)object10);
                    SurfacingUtil.addAllBinaryDomainCombinationToSet((GenomeWideCombinableDomains)object11.get(i), (SortedSet<BinaryDomainCombination>)((Object)abstractCollection));
                }
            }
            if (bufferedWriterArray != null) {
                for (int j = 0; j < arrayListArray.length; ++j) {
                    try {
                        SurfacingUtil.extractProteinNames((List<Protein>)object5, arrayListArray[j], bufferedWriterArray[j], "\t", LIMIT_SPEC_FOR_PROT_EX);
                        bufferedWriterArray[j].flush();
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            if (n != 0) {
                treeMap.put(new BasicSpecies((String)object19[i][1]), (List<Protein>)object5);
            }
            try {
                bufferedWriter.flush();
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
            System.gc();
        }
        ForesterUtil.programMessage(PRG_NAME, "Wrote domain promiscuities to: " + file10);
        try {
            MinimalDomainomeCalculator.calc(false, phylogenyArray[0], 0, treeMap, SEPARATOR_FOR_DA, -1.0, ((File)object24).toString() + "/" + file, true, false, false, null);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
        try {
            MinimalDomainomeCalculator.calc(true, phylogenyArray[0], 0, treeMap, SEPARATOR_FOR_DA, -1.0, ((File)object24).toString() + "/" + file, true, n7 != 0, bl22, file8);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
        if (bl7) {
            SurfacingUtil.performDomainArchitectureAnalysis(treeMap3, treeMap4, 10, new File(((File)object24).toString() + "/" + file + "_DA_counts.txt"), new File(((File)object24).toString() + "/" + file + "_unique_DAs.txt"));
            treeMap3.clear();
            treeMap4.clear();
            System.gc();
        }
        try {
            bufferedWriter3.write("ALL");
            bufferedWriter3.write("\t");
            bufferedWriter3.write(basicDescriptiveStatistics2.arithmeticMean() + "");
            bufferedWriter3.write("\t");
            bufferedWriter3.write(basicDescriptiveStatistics2.sampleStandardDeviation() + "");
            bufferedWriter3.write("\t");
            if (basicDescriptiveStatistics2.getN() <= 300) {
                bufferedWriter3.write(basicDescriptiveStatistics2.median() + "");
                bufferedWriter3.write("\t");
            }
            bufferedWriter3.write(basicDescriptiveStatistics2.getN() + "");
            bufferedWriter3.write("\t");
            bufferedWriter3.write(basicDescriptiveStatistics2.getMin() + "");
            bufferedWriter3.write("\t");
            bufferedWriter3.write(basicDescriptiveStatistics2.getMax() + "");
            bufferedWriter3.write("\n");
            bufferedWriter3.close();
            basicDescriptiveStatistics2 = null;
            SurfacingUtil.printOutPercentageOfMultidomainProteins(treeMap2, bufferedWriter);
            ForesterUtil.map2file(new File(object24 + ForesterUtil.FILE_SEPARATOR + file + "_all_genomes_domains_per_potein_histo.txt"), treeMap2, "\t", "\n");
            ForesterUtil.collection2file(new File(object24 + ForesterUtil.FILE_SEPARATOR + file + "_domains_always_single_.txt"), treeSet2, "\n");
            ForesterUtil.collection2file(new File(object24 + ForesterUtil.FILE_SEPARATOR + file + "_domains_single_or_combined.txt"), treeSet3, "\n");
            ForesterUtil.collection2file(new File(object24 + ForesterUtil.FILE_SEPARATOR + file + "_domains_always_combined.txt"), treeSet4, "\n");
            ForesterUtil.programMessage(PRG_NAME, "Average of proteins with a least one domain assigned: " + 100.0 * basicDescriptiveStatistics.arithmeticMean() + "% (+/-" + 100.0 * basicDescriptiveStatistics.sampleStandardDeviation() + "%)");
            ForesterUtil.programMessage(PRG_NAME, "Range of proteins with a least one domain assigned: " + 100.0 * basicDescriptiveStatistics.getMin() + "%-" + 100.0 * basicDescriptiveStatistics.getMax() + "%");
            SurfacingUtil.log("Average of prot with a least one dom assigned  : " + 100.0 * basicDescriptiveStatistics.arithmeticMean() + "% (+/-" + 100.0 * basicDescriptiveStatistics.sampleStandardDeviation() + "%)", bufferedWriter);
            SurfacingUtil.log("Range of prot with a least one dom assigned    : " + 100.0 * basicDescriptiveStatistics.getMin() + "%-" + 100.0 * basicDescriptiveStatistics.getMax() + "%", bufferedWriter);
            basicDescriptiveStatistics = null;
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
        if (bufferedWriterArray != null) {
            for (int i = 0; i < arrayListArray.length; ++i) {
                try {
                    bufferedWriterArray[i].close();
                    continue;
                }
                catch (IOException iOException) {
                    ForesterUtil.fatalError(PRG_NAME, iOException.toString());
                }
            }
        }
        try {
            var92_133.close();
            bufferedWriter2.close();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
        }
        if (bl12) {
            try {
                SurfacingUtil.executeDomainLengthAnalysis((String[][])object19, n3, domainLengthsTable, file9);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.toString());
            }
            System.out.println();
            ForesterUtil.programMessage(PRG_NAME, "Wrote domain length data to: " + file9);
            System.out.println();
        }
        domainLengthsTable = null;
        long l3 = new Date().getTime();
        object5 = null;
        BasicDomainSimilarityCalculator basicDomainSimilarityCalculator = new BasicDomainSimilarityCalculator(domainSimilaritySortField, bl16, n3 == 2, false, true);
        switch (1.$SwitchMap$org$forester$surfacing$DomainSimilarity$DomainSimilarityScoring[((Enum)object22).ordinal()]) {
            case 1: {
                object5 = new CombinationsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            case 2: {
                object5 = new DomainCountsBasedPairwiseSimilarityCalculator();
                break;
            }
            case 3: {
                object5 = new ProteinCountsBasedPairwiseDomainSimilarityCalculator();
                break;
            }
            default: {
                ForesterUtil.unexpectedFatalError(PRG_NAME, "unknown value for sorting for scoring");
            }
        }
        DomainSimilarityCalculator.GoAnnotationOutput goAnnotationOutput = DomainSimilarityCalculator.GoAnnotationOutput.NONE;
        if (map2 != null) {
            goAnnotationOutput = DomainSimilarityCalculator.GoAnnotationOutput.ALL;
        }
        SortedSet<DomainSimilarity> sortedSet = basicDomainSimilarityCalculator.calculateSimilarities((PairwiseDomainSimilarityCalculator)object5, (List<GenomeWideCombinableDomains>)object11, bl13, bl14);
        SurfacingUtil.decoratePrintableDomainSimilarities(sortedSet, detailedness);
        Map<String, Integer> map3 = SurfacingUtil.createTaxCodeToIdMap(phylogenyArray[0]);
        try {
            void var120_191;
            object4 = file.toString();
            object3 = null;
            iterator = null;
            if (sortedSet.size() > 1000) {
                if (((String)object4).endsWith(".html")) {
                    object4 = ((String)object4).substring(0, ((String)object4).length() - 5);
                }
                object3 = new HashMap<Character, Writer>();
                SurfacingUtil.createSplitWriters((File)object24, (String)object4, object3);
            } else if (!((String)object4).endsWith(".html")) {
                object4 = (String)object4 + ".html";
                iterator = new BufferedWriter(new FileWriter(object24 + ForesterUtil.FILE_SEPARATOR + (String)object4));
            }
            Object var120_189 = null;
            if (bl17) {
                ArrayList<BasicSpecies> arrayList7 = new ArrayList<BasicSpecies>();
                for (int i = 0; i < n3; ++i) {
                    arrayList7.add(new BasicSpecies((String)object19[i][1]));
                }
            }
            stringBuilder.append("<tr><td>Sum of all distinct binary combinations:</td><td>" + abstractCollection.size() + "</td></tr>" + string2);
            stringBuilder.append("<tr><td>Sum of all distinct domains:</td><td>" + object10.size() + "</td></tr>" + string2);
            stringBuilder.append("<tr><td>Analysis date/time:</td><td>" + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()) + "</td></tr>" + string2);
            stringBuilder.append("</table>" + string2);
            object2 = new BufferedWriter(new FileWriter(object24 + ForesterUtil.FILE_SEPARATOR + ((String)object4).replaceFirst(".html", ".tsv")));
            String string8 = ((String)object4).replaceFirst(".html", DOMAIN_SPECIES_IDS_MAP_NAME);
            object = new BufferedWriter(new FileWriter(object24 + ForesterUtil.FILE_SEPARATOR + string8));
            SurfacingUtil.writeDomainSimilaritiesToFile(stringBuilder, new StringBuilder(n3 + " genomes"), (Writer)object2, (Writer)((Object)iterator), (Writer)object, object3, sortedSet, n3 == 2, (List<Species>)var120_191, (DomainSimilarity.PRINT_OPTION)((Object)object21), (DomainSimilarity.DomainSimilarityScoring)((Object)object22), true, map3, (Phylogeny)object14, file3 != null ? treeSet : null);
            ((Writer)object2).close();
            ((Writer)object).flush();
            ((Writer)object).close();
            ForesterUtil.programMessage(PRG_NAME, "Wrote domain-species-ids map to       : " + string8);
            ForesterUtil.programMessage(PRG_NAME, "Wrote main output (includes domain similarities) to: \"" + (String)(object24 == null ? object4 : object24 + ForesterUtil.FILE_SEPARATOR + (String)object4) + "\"");
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, "Failed to write similarites to: \"" + file + "\" [" + iOException.getMessage() + "]");
        }
        System.out.println();
        object4 = new Species[n3];
        for (int i = 0; i < n3; ++i) {
            object4[i] = new BasicSpecies((String)object19[i][1]);
        }
        ArrayList<Object> arrayList8 = null;
        if (n3 > 2 && bl19) {
            void var120_197;
            iterator = new PairwiseGenomeComparator();
            ((PairwiseGenomeComparator)((Object)iterator)).performPairwiseComparisons(stringBuilder, bl16, detailedness, bl13, bl14, domainSimilaritySortField2, (DomainSimilarity.PRINT_OPTION)((Object)object21), (DomainSimilarity.DomainSimilarityScoring)((Object)object22), map2, (Map<GoId, GoTerm>)object15, goNameSpace, (Species[])object4, n3, (List<GenomeWideCombinableDomains>)object11, (PairwiseDomainSimilarityCalculator)object5, string, true, PAIRWISE_DOMAIN_COMPARISONS_PREFIX, PRG_NAME, (File)object24, bl20, map3, false, (Phylogeny)object14);
            String string9 = new String(file.toString());
            if (string9.indexOf(46) > 1) {
                String string10 = string9.substring(0, string9.indexOf(46));
            }
            if (object24 != null) {
                void var120_195;
                String string11 = object24 + ForesterUtil.FILE_SEPARATOR + (String)var120_195;
                file = new File(object24 + ForesterUtil.FILE_SEPARATOR + file);
            }
            SurfacingUtil.writeMatrixToFile(new File((String)var120_197 + MATRIX_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getDomainDistanceScoresMeans());
            SurfacingUtil.writeMatrixToFile(new File((String)var120_197 + MATRIX_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedBinaryCombinationsBasedDistances());
            SurfacingUtil.writeMatrixToFile(new File((String)var120_197 + MATRIX_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedDomainsBasedDistances());
            object2 = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File((String)var120_197 + NJ_TREE_MEAN_SCORE_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getDomainDistanceScoresMeans().get(0));
            Phylogeny phylogeny = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File((String)var120_197 + NJ_TREE_SHARED_BIN_COMBINATIONS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedBinaryCombinationsBasedDistances().get(0));
            object = SurfacingUtil.createNjTreeBasedOnMatrixToFile(new File((String)var120_197 + NJ_TREE_SHARED_DOMAINS_BASED_GENOME_DISTANCE_SUFFIX), ((PairwiseGenomeComparator)((Object)iterator)).getSharedDomainsBasedDistances().get(0));
            arrayList8 = new ArrayList<Object>();
            arrayList8.add(object2);
            arrayList8.add(phylogeny);
            arrayList8.add(object);
        }
        if (object24 != null && !bl19) {
            file = new File(object24 + ForesterUtil.FILE_SEPARATOR + file);
        }
        if (bl4) {
            SurfacingUtil.writePresentToNexus(file, file3, treeSet, (List<GenomeWideCombinableDomains>)object11);
        }
        if (phylogenyArray != null && phylogenyArray.length > 0 && n3 > 2) {
            iterator = SurfacingUtil.createParametersAsString(bl, d2, d, n4, bl10, file2, object25);
            String string12 = "_";
            if (bl21) {
                String string13 = string12 + l2 + "_";
            }
            int n9 = 0;
            for (Phylogeny phylogeny : phylogenyArray) {
                void var120_201;
                String string14 = ForesterUtil.removeSuffix(file.toString()) + (String)var120_201 + ForesterUtil.removeSuffix(fileArray[n9].toString());
                DomainParsimonyCalculator domainParsimonyCalculator = DomainParsimonyCalculator.createInstance(phylogeny, (List<GenomeWideCombinableDomains>)object11);
                SurfacingUtil.executeParsimonyAnalysis(l2, bl21, string14, domainParsimonyCalculator, phylogeny, map2, (Map<GoId, GoTerm>)object15, goNameSpace, ((StringBuilder)((Object)iterator)).toString(), mapArray, file3 == null ? null : treeSet, bl8, (List<BinaryDomainCombination>)var89_124, arrayList5, object25, hashMap, hashMap2, hashMap3, map3, bl4, bl3, bl5);
                if (mapArray != null && mapArray.length > 0) {
                    int n10 = 0;
                    for (Map map4 : mapArray) {
                        TreeMap<Species, MappingResults> treeMap5 = new TreeMap<Species, MappingResults>();
                        DomainParsimonyCalculator domainParsimonyCalculator2 = DomainParsimonyCalculator.createInstance(phylogeny, (List<GenomeWideCombinableDomains>)object11, map4);
                        SurfacingUtil.executeParsimonyAnalysisForSecondaryFeatures(string14 + "_" + fileArray2[n10++], domainParsimonyCalculator2, phylogeny, ((StringBuilder)((Object)iterator)).toString(), treeMap5, bl3);
                        if (n9 != 0) continue;
                        System.out.println();
                        System.out.println("Mapping to secondary features:");
                        for (Species species : treeMap5.keySet()) {
                            MappingResults mappingResults = (MappingResults)treeMap5.get(species);
                            int n11 = mappingResults.getSumOfFailures() + mappingResults.getSumOfSuccesses();
                            System.out.print(species + ":");
                            System.out.print(" mapped domains = " + mappingResults.getSumOfSuccesses());
                            System.out.print(", not mapped domains = " + mappingResults.getSumOfFailures());
                            if (n11 > 0) {
                                System.out.println(", mapped ratio = " + 100 * mappingResults.getSumOfSuccesses() / n11 + "%");
                                continue;
                            }
                            System.out.println(", mapped ratio = n/a (total domains = 0 )");
                        }
                    }
                }
                ++n9;
            }
        }
        if (object23.size() > 0) {
            SurfacingUtil.executePlusMinusAnalysis(file, (List<String>)object23, arrayList2, arrayList3, (List<GenomeWideCombinableDomains>)object11, treeMap, map2, (Map<GoId, GoTerm>)object15, arrayList4);
        }
        if (bl18) {
            SurfacingUtil.writeProteinListsForAllSpecies((File)object24, treeMap, (List<GenomeWideCombinableDomains>)object11, d4, file3 != null ? treeSet : null);
        }
        object11 = null;
        if (var89_124 != null) {
            try {
                SurfacingUtil.executeFitchGainsAnalysis(new File(file + OUTPUT_DOMAIN_COMBINATIONS_GAINED_MORE_THAN_ONCE_ANALYSIS_SUFFIX), (List<BinaryDomainCombination>)var89_124, object10.size(), (SortedSet<BinaryDomainCombination>)((Object)abstractCollection), true);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
        }
        if (arrayList5 != null) {
            try {
                SurfacingUtil.executeFitchGainsAnalysis(new File(file + OUTPUT_DOMAIN_COMBINATIONS_LOST_MORE_THAN_ONCE_ANALYSIS_SUFFIX), arrayList5, object10.size(), (SortedSet<BinaryDomainCombination>)((Object)abstractCollection), false);
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getLocalizedMessage());
            }
        }
        iterator = Runtime.getRuntime();
        long l4 = ((Runtime)((Object)iterator)).freeMemory() / 1000000L;
        long l5 = ((Runtime)((Object)iterator)).totalMemory() / 1000000L;
        ForesterUtil.programMessage(PRG_NAME, "Time for analysis : " + (new Date().getTime() - l3) + "ms");
        ForesterUtil.programMessage(PRG_NAME, "Total running time: " + (new Date().getTime() - l) + "ms ");
        ForesterUtil.programMessage(PRG_NAME, "Free memory       : " + l4 + "MB, total memory: " + l5 + "MB");
        ForesterUtil.programMessage(PRG_NAME, "If this application is useful to you, please cite:");
        ForesterUtil.programMessage(PRG_NAME, WWW);
        ForesterUtil.programMessage(PRG_NAME, "[next step for phylogenomic analysis pipeline (example, in \"DAS\" dir): % mse.rb .prot . FL_seqs DA_seqs path/to/genome_locations.txt]");
        ForesterUtil.programMessage(PRG_NAME, "OK");
        System.out.println();
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("% java -Xms256m -Xmx512m -cp forester.jar org.forester.applications.surfacing [options] <phylogen(y|ies) infile> [external node name 1] [name 2] ... [name n]");
        System.out.println();
        System.out.println(" Note: This software might need a significant amount of memory (heap space);");
        System.out.println("       hence use \"-Xms128m -Xmx512m\" (or more) to prevent a \"java.lang.OutOfMemoryError\".");
        System.out.println();
        System.out.println(" Options: ");
        System.out.println("detail: level of detail for similarities output file (default:" + (Object)((Object)DETAILEDNESS_DEFAULT) + ")");
        System.out.println("ignore_self_comb: to ignore combinations with self (default: not to ignore)");
        System.out.println("ignore_singlet_domains: to ignore domains without combinations in any species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("ignore_species_specific_domains: to ignore domains specific to one species (for similarity calc purposes, not for parsimony analyses) (default: not to ignore)");
        System.out.println("dufs: to _not_ ignore DUFs (domains with unknown function) (default: ignore DUFs)");
        System.out.println("ignore_viral_ids: to ignore domains with ids containing 'vir', 'retro', 'transpos', 'phage', or starting with 'rv' or 'gag_'");
        System.out.println("sort: sorting for similarities (default: " + (Object)((Object)DOMAIN_SORT_FILD_DEFAULT) + ")");
        System.out.println("o: name for (main) output file (mandatory)");
        System.out.println("ie: max (inclusive) iE-value");
        System.out.println("fs_e: max (inclusive) FS E-value");
        System.out.println("mrel: min (inclusive) relative envelope length ratio");
        System.out.println("mo: maximal allowed domain overlap");
        System.out.println("no_eo: to ignore engulfed lower confidence domains");
        System.out.println("smatrix: species matrix");
        System.out.println("scoring: scoring (default:" + (Object)((Object)SCORING_DEFAULT) + ")");
        System.out.println("dc_sort: sorting for domain counts (default:" + (Object)((Object)DOMAINS_SORT_ORDER_DEFAULT) + ")");
        System.out.println("ds_output: domain similarity print option (default:" + (Object)((Object)DOMAIN_SIMILARITY_PRINT_OPTION_DEFAULT) + ")");
        System.out.println("cos: cutoff score file");
        System.out.println("species_first: sort by species count first");
        System.out.println("out_dir: output directory");
        System.out.println("p2g: Pfam to GO mapping file");
        System.out.println("obo: GO terms file (OBO format)");
        System.out.println("go_namespace: limit GO term to one GO namespace");
        System.out.println("pwc[=<suffix for pairwise comparison output files>]: to perform pairwise comparison based analyses");
        System.out.println("species_tree: species tree, to perform (Dollo, Fitch) parismony analyses");
        System.out.println("species_tree=<treefiles in phyloXML format, separated by #>: to infer domain/binary domain combination gains/losses on given species trees");
        System.out.println("pos_filter=<file>: to filter out proteins not containing at least one domain listed in <file>");
        System.out.println("neg_filter=<file>: to filter out proteins containing at least one domain listed in <file>");
        System.out.println("neg_dom_filter=<file>: to filter out (ignore) domains listed in <file>");
        System.out.println("genomes=<file>: to read input files from <file>");
        System.out.println("random_seed=<seed>: seed for random number generator for Fitch Parsimony analysis (type: long, default: no randomization - given a choice, prefer absence");
        System.out.println("consider_bdc_direction: to consider directedness in binary combinations: e.g. A-B != B-A");
        System.out.println("consider_bdc_adj: to consider directedness and adjacency in binary combinations");
        System.out.println("prot_extract=<domain ids (Pfam names)>: to extract sequence names of sequences containing matching domains and/or domain-sequences (order N to C) (domain separator: '~', domain sequences speparator: '#', e.g. 'NACHT#BIR~CARD')");
        System.out.println("secondary=<file>: to perfom parsimony analysis on secondary features");
        System.out.println("plus_minus=<file>: to presence/absence genome analysis");
        System.out.println("dcc: to output binary domain counts (as individual files)");
        System.out.println("graph_analysis_out: to output binary domain combinations for (downstream) graph analysis");
        System.out.println("all_prot: to output all proteins per domain");
        System.out.println("all_prot_e: e value max per domain for output of all proteins per domain");
        System.out.println("last: to use last in Fitch parsimony");
        System.out.println("nexus: to output in Nexus format");
        System.out.println("dc_pars: to perform DC Fitch parsimony");
        System.out.println("dc_regain_stats: to perform DC regain protein statistics");
        System.out.println("da_analyis: to perform DA analysis");
        System.out.println("dla: to perform domain length analysis");
        System.out.println("write_DA_maps: to write DA-name-seq IDs mapping files");
        System.out.println("input_DA_name_map=<file>: file to obtain DA names from");
        System.out.println("obtain_DA_names_from_db: to obtain DA names from online database (UniProtKB)");
        System.out.println();
        System.out.println();
        System.out.println("Example 1: surfacing -p2g=pfam2go.txt -obo=go.obo -species_tree=tol_156.xml -no_eo -ie=0.01 -dufs -genomes=genomes_all.txt -pos_filter=tf_1.txt -out_dir=_tf1 -o=tf1");
        System.out.println();
        System.out.println("Example 2: surfacing -p2g=pfam2go.txt -obo=go.obo -species_tree=tol_156.xml -last -ignore_viral_ids -no_eo -ie=0.1 -dufs -genomes=genomes_all.txt -pos_filter=tf_1.txt -all_prot -all_prot_e=0.1 -out_dir=_tf1_e01_ape01 -o=tf1_e01_ape01");
        System.out.println();
        System.out.println("Example 3: surfacing -species_tree=master_tree.xml -no_eo -ie=1e-6 -mrel=0.5 -mo=10 -dufs -genomes=genomes.txt -out_dir=a605 -o=a605");
        System.out.println();
        System.out.println("Example 4: surfacing ");
        System.out.println();
        System.out.println("[next step for phylogenomic analysis pipeline (example, in \"DAS\" dir): % mse.rb .prot . FL_seqs DA_seqs path/to/genome_locations.txt]");
        System.out.println();
    }
}

