/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystemUtilities;
import com.approximatrix.charting.coordsystem.ticklocator.NumericTickLocator;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class RadarChartRenderer
extends AbstractChartRenderer {
    private static final int LABEL_BUFFER = 3;
    private static final float[] DOT1 = new float[]{1.0f};
    protected Stroke gridStroke = new BasicStroke(1.0f, 0, 0, 10.0f, DOT1, 0.0f);
    protected Color gridColor = Color.lightGray;
    protected int estimated_grid_steps = 10;
    private boolean drawGrid = true;

    public RadarChartRenderer(ChartDataModel model) {
        super(model);
    }

    public RadarChartRenderer(CoordSystem cs, ChartDataModel model) {
        super(cs, model);
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        Object rh = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartDataModel m = this.getChartDataModel();
        RowColorModel rcm = this.getRowColorModel();
        double height = this.getBounds().getHeight();
        double width = this.getBounds().getWidth();
        int lNumberOfRows = m.getDataSetNumber();
        int lNumberOfColumns = Integer.MAX_VALUE;
        int i = 0;
        while (i < lNumberOfRows) {
            lNumberOfColumns = Math.min(lNumberOfColumns, m.getDataSetLength(i));
            ++i;
        }
        double[] maxvalues = new double[lNumberOfColumns];
        double center_y = this.getBounds().getCenterY();
        double center_x = this.getBounds().getCenterX();
        double lRadius = Math.min(width * 0.9, height * 0.9) / 2.0;
        double[] ticks = null;
        double[] ym = this.getScaling();
        double lMaxValue = 0.0;
        if (ym != null && ym[0] > 0.0) {
            ticks = new NumericTickLocator(ym[0], 0.0, this.estimated_grid_steps, this.coord.getMaximumYTicks()).getTickMarkLocations();
            lMaxValue = 1.1 * ym[0];
        }
        int lRow = 0;
        while (lRow < lNumberOfRows && !this.getStopFlag()) {
            GeneralPath filledPolygon = new GeneralPath(0, lNumberOfColumns);
            int lCol = 0;
            while (lCol < lNumberOfColumns && !this.getStopFlag()) {
                double lValue = m.getValueAt(lRow, lCol).doubleValue();
                if (lMaxValue == 0.0) {
                    int row = 0;
                    while (row < lNumberOfRows) {
                        lMaxValue = Math.max(lMaxValue, m.getValueAt(row, lCol).doubleValue() * 1.1);
                        ++row;
                    }
                    maxvalues[lCol] = lMaxValue;
                }
                double lScaledValue = lValue / lMaxValue;
                double lLineValue = lRadius * lScaledValue;
                double lRotation = -1.0 * (Math.PI * 2 / (double)lNumberOfColumns) * (double)lCol + Math.PI;
                double lX = center_x + lLineValue * Math.sin(lRotation);
                double lY = center_y + lLineValue * Math.cos(lRotation);
                Line2D.Double lLine = new Line2D.Double(center_x, center_y, lX, lY);
                g.setColor(Color.black);
                g.draw(lLine);
                if (lCol == 0) {
                    filledPolygon.moveTo((float)lX, (float)lY);
                } else {
                    filledPolygon.lineTo((float)lX, (float)lY);
                }
                ++lCol;
            }
            filledPolygon.closePath();
            g.setPaint(rcm.getColor(lRow));
            g.draw(filledPolygon);
            ++lRow;
        }
        if (ticks != null && lMaxValue > 0.0 && this.isDrawGrid()) {
            Stroke shold = g.getStroke();
            Color chold = g.getColor();
            g.setStroke(this.gridStroke);
            g.setColor(this.gridColor);
            int lRow2 = 0;
            while (lRow2 < ticks.length && !this.getStopFlag()) {
                GeneralPath filledPolygon = new GeneralPath(0, lNumberOfColumns);
                if (!(ticks[lRow2] > lMaxValue) && ticks[lRow2] != 0.0) {
                    double lScaledValue = ticks[lRow2] / lMaxValue;
                    double lLineValue = lRadius * lScaledValue;
                    int lCol = 0;
                    while (lCol < lNumberOfColumns && !this.getStopFlag()) {
                        double rot = -1.0 * (Math.PI * 2 / (double)lNumberOfColumns) * (double)lCol + Math.PI;
                        double x = center_x + lLineValue * Math.sin(rot);
                        double y = center_y + lLineValue * Math.cos(rot);
                        if (lCol == 0) {
                            filledPolygon.moveTo((float)x, (float)y);
                            TextLayout label = new TextLayout(this.coord.getYDecimalFormat().format(ticks[lRow2]), this.coord.getTickFont(), new FontRenderContext(null, true, false));
                            g.setStroke(shold);
                            g.setColor(Color.black);
                            label.draw(g, (float)x + 3.0f, (float)y);
                            g.setStroke(this.gridStroke);
                            g.setColor(this.gridColor);
                        } else {
                            filledPolygon.lineTo((float)x, (float)y);
                        }
                        ++lCol;
                    }
                    filledPolygon.closePath();
                    g.draw(filledPolygon);
                }
                ++lRow2;
            }
            g.setStroke(shold);
            g.setColor(chold);
        }
        int lCol = 0;
        while (lCol < lNumberOfColumns && !this.getStopFlag()) {
            double lRotation = -1.0 * (Math.PI * 2 / (double)lNumberOfColumns) * (double)lCol + Math.PI;
            double lX = center_x + lRadius * Math.sin(lRotation);
            double lY = center_y + lRadius * Math.cos(lRotation);
            Line2D.Double lLine = new Line2D.Double(center_x, center_y, lX, lY);
            g.setColor(Color.black);
            g.draw(lLine);
            TextLayout lLabel = new TextLayout("" + this.model.getColumnValueAt(lCol), new Font("Courier", 1, 9), new FontRenderContext(null, true, false));
            g.setColor(Color.black);
            if (lRotation <= 1.5707963267948966 && lRotation >= -1.5707963267948966) {
                lY += lLabel.getBounds().getHeight();
            }
            if (lRotation <= 0.0) {
                lX -= lLabel.getBounds().getWidth();
            }
            lLabel.draw(g, (float)lX, (float)lY);
            ++lCol;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rh);
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }

    private double[] getScaling() {
        try {
            return CoordSystemUtilities.SafeMaxMin(this.model.getChartDataModelConstraints(0).getMaximumY().doubleValue(), this.model.getChartDataModelConstraints(0).getMinimumY().doubleValue());
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public void setDrawGrid(boolean value) {
        this.drawGrid = value;
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }
}

