/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.Chart;
import com.approximatrix.charting.Legend;
import com.approximatrix.charting.Title;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.AbstractRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractChart
extends AbstractRenderer
implements Chart {
    protected static final int MISSING_LEGEND_WIDTH = 30;
    protected static final int MISSING_TITLE_HEIGHT = 20;
    protected HashMap<Integer, AbstractChartRenderer> renderer = new HashMap();
    protected Rectangle bounds;
    protected Legend legend;
    protected CoordSystem coord;
    protected Title title;
    protected RowColorModel rcModel;
    protected ChartDataModel model;

    @Override
    public void addChartRenderer(AbstractChartRenderer render, int z) {
        this.renderer.put(new Integer(z), render);
        render.setRowColorModel(this.rcModel);
    }

    @Override
    public Map<Integer, AbstractChartRenderer> getChartRenderer() {
        return this.renderer;
    }

    @Override
    public AbstractChartRenderer getChartRenderer(int z) {
        return this.renderer.get(new Integer(z));
    }

    @Override
    public CoordSystem getCoordSystem() {
        return this.coord;
    }

    @Override
    public Legend getLegend() {
        return this.legend;
    }

    @Override
    public Title getTitle() {
        return this.title;
    }

    public RowColorModel getRowColorModel() {
        return this.rcModel;
    }

    public void setChartRenderer(Map render) {
        Iterator i = render.values().iterator();
        int z = 0;
        while (i.hasNext()) {
            this.addChartRenderer((AbstractChartRenderer)i.next(), z);
        }
    }

    @Override
    public void setCoordSystem(CoordSystem c) {
        this.coord = c;
    }

    @Override
    public void setLegend(Legend l) {
        this.legend = l;
    }

    @Override
    public void setTitle(Title t) {
        this.title = t;
    }

    public void setRowColorModel(RowColorModel rcm) throws NullPointerException {
        if (rcm == null) {
            throw new NullPointerException();
        }
        for (AbstractChartRenderer acr : this.getChartRenderer().values()) {
            if (acr == null || acr.getRowColorModel() != this.rcModel) continue;
            acr.setRowColorModel(rcm);
        }
        if (this.getLegend() != null && this.getLegend().getRowColorModel() == this.rcModel) {
            this.getLegend().setRowColorModel(rcm);
        }
        this.rcModel = rcm;
    }

    @Override
    public void setChartDataModel(ChartDataModel model) {
        this.model = model;
    }

    @Override
    public ChartDataModel getChartDataModel() {
        return this.model;
    }

    @Override
    public void setBounds(Rectangle r) {
        this.bounds = r;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void paintDefault(Graphics2D g) {
    }

    @Override
    public void render(Graphics2D g) {
    }
}

