/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS.attachData;

import FCSalyzer.FCS.attachData.ImportTable;
import FCSalyzer.GUI.attachParameterDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import staticStuff.Fileservice;

public class ImportPanel
implements ActionListener {
    private attachParameterDialog parentDialog;
    private ImportTable theSource;
    private JPanel theGui;
    private JScrollPane theLineScroller;
    private JTable theLines;
    private final String OPEN = "Open File";
    private final String OK = "Import";
    private final String HEADER = "Use first line as parameter name";
    private final String TAB = "TAB";
    private final String COMMA = ",";
    private final String SEMI = ";";
    private final String SPACE = "SPACE";
    private final String DECIMAL_COMMA = ",,";
    private final String DECIMAL_PERIOD = ".";
    private JButton OPEN_Button = new JButton("Open File");
    private JButton OK_Button = new JButton("Import");
    private JCheckBox headerCheckbox = new JCheckBox("Use first line as parameter name");
    private JRadioButton sepTab = new JRadioButton("TAB");
    private JRadioButton sepComma = new JRadioButton(",");
    private JRadioButton sepSemi = new JRadioButton(";");
    private JRadioButton sepSpace = new JRadioButton("SPACE");
    private JRadioButton decimalIndicatorPeriod = new JRadioButton(".");
    private JRadioButton decimalIndicatorComma = new JRadioButton(",");

    public ImportPanel(attachParameterDialog paramDialog) {
        this.parentDialog = paramDialog;
        this.theGui = new JPanel();
        this.theGui.setLayout(new BorderLayout());
        this.OPEN_Button.setActionCommand("Open File");
        this.OPEN_Button.addActionListener(this);
        this.OK_Button.setActionCommand("Import");
        this.OK_Button.addActionListener(this);
        JPanel buttonPane = new JPanel();
        buttonPane.add(this.OPEN_Button);
        buttonPane.add(this.OK_Button);
        this.theGui.add((Component)buttonPane, "South");
        JPanel optionPane = new JPanel();
        BoxLayout boxL = new BoxLayout(optionPane, 1);
        optionPane.setLayout(boxL);
        this.headerCheckbox.setAlignmentX(0.0f);
        this.headerCheckbox.setActionCommand("Use first line as parameter name");
        this.headerCheckbox.addActionListener(this);
        this.headerCheckbox.setMargin(new Insets(0, 0, 0, 0));
        optionPane.add(this.headerCheckbox);
        ButtonGroup separators = new ButtonGroup();
        this.sepTab.setActionCommand("TAB");
        this.sepComma.setActionCommand(",");
        this.sepSemi.setActionCommand(";");
        this.sepSpace.setActionCommand("SPACE");
        this.sepTab.setAlignmentX(0.0f);
        this.sepTab.setMargin(new Insets(0, 0, 0, 0));
        separators.add(this.sepTab);
        this.sepSpace.setAlignmentX(0.0f);
        this.sepSpace.setMargin(new Insets(0, 0, 0, 0));
        separators.add(this.sepSpace);
        this.sepComma.setAlignmentX(0.0f);
        this.sepComma.setMargin(new Insets(0, 0, 0, 0));
        separators.add(this.sepComma);
        this.sepSemi.setAlignmentX(0.0f);
        this.sepSemi.setMargin(new Insets(0, 0, 0, 0));
        separators.add(this.sepSemi);
        this.sepTab.setSelected(true);
        this.sepTab.addActionListener(this);
        this.sepComma.addActionListener(this);
        this.sepSemi.addActionListener(this);
        this.sepSpace.addActionListener(this);
        JPanel sepPanels = new JPanel();
        JLabel l = new JLabel("Parameter separator: ");
        l.setAlignmentX(0.0f);
        sepPanels.add(l);
        sepPanels.add(this.sepTab);
        sepPanels.add(this.sepSpace);
        sepPanels.add(this.sepComma);
        sepPanels.add(this.sepSemi);
        sepPanels.setAlignmentX(0.0f);
        sepPanels.setMaximumSize(sepPanels.getPreferredSize());
        optionPane.add(sepPanels);
        ButtonGroup commators = new ButtonGroup();
        commators.add(this.decimalIndicatorPeriod);
        commators.add(this.decimalIndicatorComma);
        this.decimalIndicatorPeriod.setSelected(true);
        this.decimalIndicatorPeriod.setMargin(new Insets(0, 0, 0, 0));
        this.decimalIndicatorComma.setMargin(new Insets(0, 0, 0, 0));
        JPanel decimalPanels = new JPanel();
        decimalPanels.add(new JLabel("Decimal point indicator: "));
        this.decimalIndicatorPeriod.setActionCommand(".");
        this.decimalIndicatorComma.setActionCommand(",,");
        this.decimalIndicatorPeriod.addActionListener(this);
        this.decimalIndicatorComma.addActionListener(this);
        decimalPanels.add(this.decimalIndicatorPeriod);
        decimalPanels.add(this.decimalIndicatorComma);
        decimalPanels.setAlignmentX(0.0f);
        decimalPanels.setMaximumSize(decimalPanels.getPreferredSize());
        optionPane.add(decimalPanels);
        this.theGui.add((Component)optionPane, "North");
        this.theSource = new ImportTable(this);
        this.theLines = new JTable(this.theSource);
        this.theSource.setRegulars(this.theLines.getDefaultEditor(String.class), this.theLines.getDefaultRenderer(String.class), this.theLines.getDefaultEditor(Boolean.class), this.theLines.getDefaultRenderer(Boolean.class));
        this.theLines.setDefaultEditor(String.class, this.theSource);
        this.theLines.setDefaultRenderer(String.class, this.theSource);
        this.theLines.setAutoResizeMode(0);
        this.theLineScroller = new JScrollPane(this.theLines);
        this.theGui.add((Component)this.theLineScroller, "Center");
        optionPane.add(this.theSource.theProgressBar);
    }

    public JPanel getGUI() {
        return this.theGui;
    }

    public void setHasHeader() {
        this.headerCheckbox.setSelected(true);
    }

    public void setRowsToImport(int rows) {
        this.theSource.setRowsToImport(rows);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File newFile;
        String actionCommand = e.getActionCommand();
        if (actionCommand == "Use first line as parameter name") {
            this.theSource.setHasHeader(this.headerCheckbox.isSelected());
        }
        if (actionCommand == "TAB") {
            this.theSource.setSeparator("\t");
        }
        if (actionCommand == "SPACE") {
            this.theSource.setSeparator(" ");
        }
        if (actionCommand == ",") {
            this.theSource.setSeparator(",");
        }
        if (actionCommand == ";") {
            this.theSource.setSeparator(";");
        }
        if (actionCommand == ",,") {
            this.theSource.setUseDecimalPeriod(false);
        }
        if (actionCommand == ".") {
            this.theSource.setUseDecimalPeriod(true);
        }
        if (actionCommand == "Open File" && (newFile = Fileservice.getFileForLoad(false)) != null && newFile.isFile()) {
            try {
                this.theSource.setFile(newFile);
            }
            catch (IOException fn) {
                JOptionPane.showMessageDialog(null, "Error when opening file.", "Error", 0);
            }
        }
        if (actionCommand == "Import") {
            File[] attachedFiles = null;
            try {
                attachedFiles = this.theSource.convert();
            }
            catch (IOException ip) {
                JOptionPane.showMessageDialog(null, "There was an error during file generation!", "File error!", 0);
            }
            if (attachedFiles != null) {
                this.parentDialog.attachFiles(attachedFiles, this.theSource.getDefinedTicks());
            }
        }
    }
}

