/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS.attachData;

import FCSalyzer.FCS.attachData.ImportParameter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Locale;

public class FCSWriter {
    private BufferedOutputStream out;
    private int paramsToExport;

    public FCSWriter(File paramWrite, ImportParameter[] theParameters, int eventCount, String sourceFileName) throws IOException {
        this.out = new BufferedOutputStream(new FileOutputStream(paramWrite));
        this.paramsToExport = theParameters.length;
        int totalDataSize = eventCount * 4 * this.paramsToExport;
        StringBuilder text = new StringBuilder();
        text.append("/$COM/");
        text.append("This dataset was created by Data2FCS from a comma (or other)-separated-values data file.");
        text.append("/$SRC/");
        text.append(sourceFileName);
        text.append("/$FIL/");
        text.append(paramWrite.getName());
        text.append("/$DATE/");
        Calendar c = Calendar.getInstance();
        int day = c.get(5);
        int year = c.get(1);
        String month = c.getDisplayName(2, 1, Locale.ENGLISH);
        String dayS = String.valueOf(day);
        if (dayS.length() == 1) {
            text.append("0");
        }
        text.append(dayS);
        text.append("-");
        text.append(month);
        text.append("-");
        text.append(year);
        text.append("/$CYT/Data2FCS");
        text.append("/$CYTSN/1.0");
        text.append("/$BYTEORD/4,3,2,1");
        text.append("/$DATATYPE/F");
        text.append("/$MODE/L");
        text.append("/$TOT/");
        text.append(eventCount);
        text.append("/$PAR/");
        text.append(this.paramsToExport);
        int currParam = 0;
        for (int i = 0; i < this.paramsToExport; ++i) {
            text.append("/$P");
            text.append(++currParam);
            text.append("B/32");
            text.append("/$P");
            text.append(currParam);
            text.append("E/0,0");
            text.append("/$P");
            text.append(currParam);
            text.append("N/Param #");
            text.append(currParam);
            if (theParameters[i].isCategory) {
                text.append("/$P");
                text.append(currParam);
                text.append("R/");
                text.append((theParameters[i].orderedCatValues.size() + 1) * 100);
            } else {
                text.append("/$P");
                text.append(currParam);
                text.append("R/");
                text.append(theParameters[i].range);
            }
            text.append("/$P");
            text.append(currParam);
            text.append("S/");
            text.append(theParameters[i].name.trim().replace("/", "//"));
            text.append("/$P");
            text.append(currParam);
            text.append("D/");
            if (theParameters[i].displayLog) {
                text.append("Logarithmic,");
                int range = theParameters[i].range;
                int logs = (int)Math.log10(range);
                text.append(++logs);
                text.append(",1");
            } else {
                text.append("Linear,0,");
                text.append(theParameters[i].range);
            }
            text.append("/P");
            text.append(currParam);
            text.append("DISPLAY/");
            if (theParameters[i].displayLog) {
                text.append("LOG");
            } else {
                text.append("LIN");
            }
            if (!theParameters[i].isCategory) continue;
            text.append("/P");
            text.append(currParam);
            text.append("Data2FCS_CATEGORIES/");
            for (int k = 0; k < theParameters[i].orderedCatValues.size(); ++k) {
                text.append((k + 1) * 100);
                text.append("=");
                text.append(theParameters[i].orderedCatValues.get(k).trim().replace("/", "//"));
                if (k == theParameters[i].orderedCatValues.size() - 1) continue;
                text.append("\n");
            }
        }
        text.append("/$BEGINANALYSIS/0/$ENDANALYSIS/0");
        text.append("/$BEGINSTEXT/0/$ENDSTEXT/0");
        text.append("/$NEXTDATA/0");
        String textTemp = text.toString();
        Charset utf8 = Charset.forName("utf-8");
        byte[] textBytes = textTemp.getBytes(utf8);
        int currLength = textBytes.length + 22 + 60;
        text.append("/$BEGINDATA/");
        int dataBegin = currLength += 20;
        text.append(currLength);
        text.append("/$ENDDATA/");
        text.append(currLength + totalDataSize);
        int dataEnd = currLength + totalDataSize;
        text.append("/");
        String beginning = "FCS3.1    ";
        String text_start = "      60";
        String data_start = "        ";
        String data_end = "        ";
        String analysis_start = "       0";
        String analysis_end = "       0";
        String header_padding = "  ";
        text.insert(0, header_padding);
        text.insert(0, analysis_end);
        text.insert(0, analysis_start);
        if (dataEnd < 100000000) {
            int k;
            String temp = String.valueOf(dataEnd);
            text.insert(0, temp);
            int l = 8 - temp.length();
            for (k = 0; k < l; ++k) {
                text.insert(0, " ");
            }
            temp = String.valueOf(dataBegin);
            text.insert(0, temp);
            l = 8 - temp.length();
            for (k = 0; k < l; ++k) {
                text.insert(0, " ");
            }
        } else {
            text.insert(0, data_end);
            text.insert(0, data_start);
        }
        int textEnd = text.length() + 8 + text_start.length() + beginning.length() - 1;
        String tempEnd = String.valueOf(textEnd);
        text.insert(0, tempEnd);
        int l = 8 - tempEnd.length();
        for (int k = 0; k < l; ++k) {
            text.insert(0, " ");
        }
        text.insert(0, text_start);
        text.insert(0, beginning);
        textTemp = text.toString();
        textBytes = textTemp.getBytes(utf8);
        this.out.write(textBytes);
        for (int i = textBytes.length; i < dataBegin; ++i) {
            this.out.write(32);
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void write(Float value) throws IOException {
        int toWrite = Float.floatToIntBits(value.floatValue());
        int four = toWrite >>> 24 & 0xFF;
        int three = toWrite >>> 16 & 0xFF;
        int two = toWrite >>> 8 & 0xFF;
        int one = toWrite >>> 0 & 0xFF;
        this.out.write(four);
        this.out.write(three);
        this.out.write(two);
        this.out.write(one);
    }
}

