/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FACS_objects;

import FCSalyzer.FACS_objects.FACS_annotation;
import FCSalyzer.FACS_objects.FACS_panel;
import FCSalyzer.FACS_objects.FACS_statistics;
import FCSalyzer.FCS.FCS_RegionGatesHolder;
import FCSalyzer.FCS.FCS_data;
import FCSalyzer.FCS.FCS_gate;
import FCSalyzer.FCS.FCS_marker;
import FCSalyzer.FCS.FCS_quadrant;
import FCSalyzer.FCS.FCS_region;
import FCSalyzer.FCS.attachData.definedTick;
import FCSalyzer.GUI.FACS_document;
import FCSalyzer.GUI.annotationDialog;
import FCSalyzer.GUI.colorGradient;
import FCSalyzer.GUI.markerDialog;
import FCSalyzer.GUI.statisticsDialog;
import FCSalyzer.Transform.Compensation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.customCursors;
import staticStuff.privateClipboard;
import staticStuff.staticMethods;

public class FACS_plot
extends FACS_panel
implements ListSelectionListener {
    public static final int EVENT_COUNT = -1;
    public static final int ONE_PARAM = -2;
    public static final int THREE_PARAM = -3;
    public static final int DENSITY_PARAM_NOT_SET = -1;
    public static final short DOT = 0;
    public static final short DENSITY = 1;
    public static final short HISTOGRAM = 2;
    private static final int HIGHER_MARKER_POINT = 1;
    private static final int LOWER_MARKER_POINT = 0;
    public static final double DISPLAY_RANGE = 4096.0;
    public static final double MAX_DISPLAY_VALUE = 4095.0;
    private static final int PAINT_EVENTS = 0;
    private static final int REUSE_EVENTS = 1;
    private static final int DO_NOT_PAINT_EVENTS = 2;
    private static final int DOCUMENT_STATISTICS_NEED_UPDATE = 0;
    private static final int PLOT_STATISTICS_NEED_UPDATE = 1;
    private static final int QUADRANT_STATISTICS_NEED_UPDATE = 2;
    private static final int MARKER_STATISTICS_NEED_UPDATE = 3;
    private static final int STATISTICS_DO_NOT_NEED_UPDATE = -1;
    private static final int HISTOGRAM_BINS = 256;
    public static final float[][] PATTERNS = new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {4.0f, 4.0f}, {10.0f, 10.0f}, {4.0f, 4.0f, 1.0f, 4.0f}};
    public static final float[] WIDTHS = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f};
    private final JList axisList = new JList();
    private static final int AXIS_POPUP_HEIGHT = 100;
    private static final int AXIS_POPUP_WIDTH = 150;
    private final JScrollPane axisScroller = new JScrollPane(this.axisList);
    private final ArrayList<FACS_panel> children = new ArrayList();
    private static final int COLOR_BLACK = Color.BLACK.getRGB();
    private FCS_marker drawingMarker;
    private Point drawingPoint;
    private FCS_region drawingRegion;
    private Rectangle eventArea = new Rectangle(-1, -1, 0, 0);
    private int[] gatesRGB;
    private boolean isPaintingForExport = false;
    private boolean isUpdatingLabels = false;
    private boolean listXaxis = true;
    private final ArrayList<FCS_marker> markers = new ArrayList();
    private Point mouseDragPoint;
    private Point mousePressedPoint;
    private Polygon mousePressedTranformedRegion;
    private ArrayList<overlaySettings> overlays = new ArrayList();
    private int paintLocalEvents = 0;
    private boolean performActions = true;
    private Rectangle plotArea = new Rectangle(-1, -1, 0, 0);
    private short plotType = 0;
    private FCS_quadrant quadrant;
    private boolean regionIsBeingDrawn = false;
    private final ArrayList<visibleRegion> regionsToDraw = new ArrayList();
    private int selectedMarkerPoint = -1;
    private int selectedName = -1;
    private int selectedNameXOffset = 0;
    private int selectedNameYOffset = 0;
    private int selectedRegionPoint = -1;
    private int statisticsStatus = -1;
    private FCS_RegionGatesHolder theRaG;
    private BufferedImage view;
    private int view_height;
    private int view_width;
    private Rectangle x_axis_Area = new Rectangle(-1, -1, 0, 0);
    private Rectangle y_axis_Area = new Rectangle(-1, -1, 0, 0);
    public static final String XML_NAME = "FACS_plot";
    private static final String XML_TYPE = "Type";
    private static final String XML_QUADRANT = "Quadrant";
    private static final String XML_QUADRANT_X = "X";
    private static final String XML_QUADRANT_Y = "Y";
    private static final String XML_MARKERS = "Markers";
    private static final String XML_MARKER = "Marker";
    private static final String XML_MARKER_NAME = "Name";
    private static final String XML_MARKER_LOWER = "Lower_Channel";
    private static final String XML_MARKER_UPPER = "Higher_Channel";
    private static final String XML_MARKER_Y = "Y";
    private static final String XML_VISIBLE_REGIONS = "Visible_Regions";
    private static final String XML_REGION = "Region";
    private static final String XML_REGION_INDEX = "Index";
    private static final String XML_REGION_X = "Name_x";
    private static final String XML_REGION_Y = "Name_y";
    private static final String XML_TYPE_DOT = "DOT";
    private static final String XML_TYPE_HISTOGRAM = "HISTOGRAM";
    private static final String XML_TYPE_DENSITY = "DENSITY";

    protected FACS_plot() {
        this.theRaG = null;
    }

    public FACS_plot(FACS_document paramDoc) {
        this.setFCS_Document(paramDoc);
        this.setLayout(null);
        this.setOpaque(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.axisScroller.setVisible(false);
        this.axisScroller.setHorizontalScrollBarPolicy(31);
        this.axisScroller.setBounds(0, 0, 150, 100);
        this.axisList.addListSelectionListener(this);
        paramDoc.addScrollBox(this.axisScroller);
        this.theRaG = paramDoc.getRegionsAndGates();
    }

    public static ArrayList<FACS_panel> fromXML(FACS_document paramDoc, Node storedData, String oldPath, String oldFileSeparator, String currentPath, ArrayList<Compensation> theCompensations, ArrayList<FCS_data> documentData, boolean vers0915) throws NumberFormatException {
        String nameCurrent;
        Node current;
        int i;
        ArrayList<FACS_panel> returns = new ArrayList<FACS_panel>();
        FACS_plot newPlot = new FACS_plot(paramDoc);
        returns.add(newPlot);
        ArrayList<overlaySettings> oS = newPlot.overlays;
        NodeList nL = storedData.getChildNodes();
        for (i = 0; i < nL.getLength(); ++i) {
            current = nL.item(i);
            nameCurrent = current.getNodeName();
            if (nameCurrent.equals("Bounds")) {
                NodeList nL_temp = current.getChildNodes();
                double x = 0.0;
                double y = 0.0;
                double width = 0.0;
                double height = 0.0;
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    Node curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    if (curr2Name.equals(XML_QUADRANT_X)) {
                        x = staticMethods.getNodeDouble(curr2, x);
                        continue;
                    }
                    if (curr2Name.equals("Y")) {
                        y = staticMethods.getNodeDouble(curr2, y);
                        continue;
                    }
                    if (curr2Name.equals("Width")) {
                        width = staticMethods.getNodeDouble(curr2, width);
                        continue;
                    }
                    if (!curr2Name.equals("Height")) continue;
                    height = staticMethods.getNodeDouble(curr2, height);
                }
                newPlot.setBounds((int)x, (int)y, (int)width, (int)height);
                continue;
            }
            if (nameCurrent.equals("Font")) {
                NodeList nL_temp = current.getChildNodes();
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    Node curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    Float fonts = null;
                    if (!curr2Name.equals("Size") || (fonts = staticMethods.getNodeFloat(curr2, fonts)) == null) continue;
                    newPlot.setFontSize(fonts);
                }
                continue;
            }
            if (nameCurrent.equals("ZOrder")) {
                Integer zo = staticMethods.getNodeInteger(current, null);
                if (zo == null) continue;
                newPlot.rememberZOrder(zo);
                continue;
            }
            if (nameCurrent.equals("Overlay")) {
                overlaySettings newOs = new overlaySettings(current, oldFileSeparator, oldPath, currentPath, theCompensations, documentData, paramDoc.getRegionsAndGates());
                oS.add(newOs);
                if (oS.size() != 1) continue;
                String[] data = new String[newOs.overlayData.getTotalParameterCount()];
                for (int k = 0; k < newOs.overlayData.getTotalParameterCount(); ++k) {
                    data[k] = newOs.overlayData.getParameterLabel(k);
                }
                newPlot.performActions = false;
                newPlot.axisList.setListData(data);
                newPlot.performActions = true;
                continue;
            }
            if (nameCurrent.equals("FACS_annotation")) {
                FACS_annotation newAnno = FACS_annotation.loadAnnotation(paramDoc, newPlot, current);
                newPlot.children.add(newAnno);
                returns.add(newAnno);
                continue;
            }
            if (nameCurrent.equals(XML_QUADRANT)) {
                FCS_quadrant quad;
                int qx = 0;
                int qy = 0;
                NodeList nL_temp = current.getChildNodes();
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    Node curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    if (curr2Name.equals(XML_QUADRANT_X)) {
                        qx = staticMethods.getNodeInteger(curr2, 0);
                        continue;
                    }
                    if (!curr2Name.equals("Y")) continue;
                    qy = staticMethods.getNodeInteger(curr2, 0);
                }
                if (vers0915) {
                    double temp = qx;
                    double r = newPlot.getData(0).getChannels(newPlot.getParamX(0));
                    double res = temp / r;
                    qx = (int)(res *= 4096.0);
                    temp = qy;
                    r = newPlot.getData(0).getChannels(newPlot.getParamY(0));
                    res = temp / r;
                    qy = (int)(res *= 4096.0);
                }
                newPlot.quadrant = quad = new FCS_quadrant(qx, qy);
                continue;
            }
            if (nameCurrent.equals(XML_MARKERS)) {
                NodeList nL_temp = current.getChildNodes();
                for (int j = 0; j < nL_temp.getLength(); ++j) {
                    Node curr2 = nL_temp.item(j);
                    String curr2Name = curr2.getNodeName();
                    if (!curr2Name.equals(XML_MARKER)) continue;
                    FCS_marker newMarker = new FCS_marker("");
                    NodeList nL_temp2 = curr2.getChildNodes();
                    for (int k = 0; k < nL_temp2.getLength(); ++k) {
                        double res;
                        double r;
                        double temp;
                        Node curr3 = nL_temp2.item(k);
                        String curr3Name = curr3.getNodeName();
                        if (curr3Name.equals(XML_MARKER_NAME)) {
                            newMarker.setName(staticMethods.getNodeText(curr3));
                            continue;
                        }
                        if (curr3Name.equals(XML_MARKER_LOWER)) {
                            int m = staticMethods.getNodeInteger(curr3, 0);
                            if (vers0915) {
                                temp = m;
                                r = newPlot.getData(0).getChannels(newPlot.getParamX(0));
                                res = temp / r;
                                m = (int)(res *= 4096.0);
                            }
                            newMarker.setLowerLimit(m);
                            continue;
                        }
                        if (curr3Name.equals(XML_MARKER_UPPER)) {
                            int m = staticMethods.getNodeInteger(curr3, 0);
                            if (vers0915) {
                                temp = m;
                                r = newPlot.getData(0).getChannels(newPlot.getParamX(0));
                                res = temp / r;
                                m = (int)(res *= 4096.0);
                            }
                            newMarker.setUpperLimit(m);
                            continue;
                        }
                        if (!curr3Name.equals("Y")) continue;
                        float y = staticMethods.getNodeFloat(curr3, Float.valueOf(0.5f)).floatValue();
                        if (y > 1.0f) {
                            y = 0.5f;
                        }
                        newMarker.setDisplayHeight(y);
                    }
                    newPlot.markers.add(newMarker);
                }
                continue;
            }
            if (nameCurrent.equals(XML_TYPE)) {
                String temp = staticMethods.getNodeText(current);
                if (temp.equals(XML_TYPE_DOT)) {
                    newPlot.plotType = 0;
                    continue;
                }
                if (temp.equals(XML_TYPE_DENSITY)) {
                    newPlot.plotType = 1;
                    continue;
                }
                if (!temp.equals(XML_TYPE_HISTOGRAM)) continue;
                newPlot.plotType = (short)2;
                continue;
            }
            if (!nameCurrent.equals(XML_VISIBLE_REGIONS)) continue;
            NodeList nL_temp = current.getChildNodes();
            for (int j = 0; j < nL_temp.getLength(); ++j) {
                Node curr2 = nL_temp.item(j);
                String curr2Name = curr2.getNodeName();
                if (!curr2Name.equals(XML_REGION)) continue;
                Integer index = null;
                Integer name_x = null;
                Integer name_y = null;
                NodeList nL_temp2 = curr2.getChildNodes();
                for (int k = 0; k < nL_temp2.getLength(); ++k) {
                    Node curr3 = nL_temp2.item(k);
                    String curr3Name = curr3.getNodeName();
                    if (curr3Name.equals(XML_REGION_INDEX)) {
                        index = staticMethods.getNodeInteger(curr3, index);
                        continue;
                    }
                    if (curr3Name.equals(XML_REGION_X)) {
                        name_x = staticMethods.getNodeInteger(curr3, name_x);
                        continue;
                    }
                    if (!curr3Name.equals(XML_REGION_Y)) continue;
                    name_y = staticMethods.getNodeInteger(curr3, name_y);
                }
                if (index == null || name_x == null || name_y == null) continue;
                FCS_region theRegion = paramDoc.getRegionsAndGates().getRegion(index);
                visibleRegion currentRegion = new visibleRegion(theRegion);
                newPlot.regionsToDraw.add(currentRegion);
                currentRegion.regionLocationInChannels = new Point(name_x, name_y);
            }
        }
        for (i = 0; i < nL.getLength(); ++i) {
            current = nL.item(i);
            nameCurrent = current.getNodeName();
            if (!nameCurrent.equals("FACS_statistics")) continue;
            FACS_statistics newStat = null;
            try {
                newStat = FACS_statistics.loadStatistics(paramDoc, newPlot, current);
            }
            catch (IOException io) {
                newStat = null;
                JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
            }
            if (newStat == null) continue;
            newStat.setQuadrant(newPlot.getQuadrant());
            try {
                newStat.refresh(true);
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
                newStat = null;
            }
            if (newStat == null) continue;
            newPlot.children.add(newStat);
            returns.add(newStat);
        }
        for (FACS_panel currPanel : returns) {
            if (!(currPanel instanceof FACS_plot)) continue;
            FACS_plot thePlot = (FACS_plot)currPanel;
            if (thePlot.plotType == 0) continue;
            for (overlaySettings currOv : thePlot.overlays) {
                if (currOv.colorType != 0) continue;
                currOv.colorType = 2;
            }
        }
        return returns;
    }

    public void addOverlay(FCS_data newData, int overlay_paramX, int overlay_paramY) {
        if (overlay_paramX >= newData.getTotalParameterCount()) {
            overlay_paramX = 0;
        }
        if (overlay_paramY >= newData.getTotalParameterCount()) {
            overlay_paramY = 0;
        }
        overlaySettings oS = new overlaySettings();
        oS.overlayData = newData;
        oS.paramX = overlay_paramX;
        oS.paramY = overlay_paramY;
        oS.rangeX = newData.getRange(overlay_paramX);
        oS.rangeY = newData.getRange(overlay_paramY);
        if (this.overlays.size() > 0) {
            oS.appliedGate = this.overlays.get(0).appliedGate;
        }
        this.overlays.add(oS);
        if (this.overlays.size() == 1) {
            String[] data = new String[newData.getTotalParameterCount()];
            for (int i = 0; i < newData.getTotalParameterCount(); ++i) {
                data[i] = newData.getParameterLabel(i);
            }
            this.performActions = false;
            this.axisList.setListData(data);
            this.performActions = true;
        }
        if (this.plotType == 2) {
            oS.colorType = 2;
        }
        if (this.plotType == 1 && this.theDocument.getColorGradientCount() > 0) {
            oS.colorType = 3;
        }
        this.view = null;
        this.repaint();
        this.updateStatistics(1);
        this.updateAnnotations();
    }

    public void addOverlay(FCS_data newData) {
        int overlay_paramX = 0;
        int overlay_paramY = 0;
        if (this.overlays.size() > 0) {
            overlay_paramX = this.overlays.get(0).paramX;
            overlay_paramY = this.overlays.get(0).paramY;
            if (overlay_paramX >= newData.getTotalParameterCount()) {
                overlay_paramX = 0;
            }
            if (overlay_paramY >= newData.getTotalParameterCount()) {
                overlay_paramY = 1;
            }
        }
        this.addOverlay(newData, overlay_paramX, overlay_paramY);
    }

    private void addPointToRegion(MouseEvent e) {
        if (!this.regionIsBeingDrawn) {
            this.drawingPoint = e.getPoint();
            this.drawingRegion = new FCS_region("R" + this.theRaG.getRegionsCount(), this.overlays.get(0).paramX, this.overlays.get(0).paramY, this.theRaG);
            this.drawingRegion.add(e.getPoint());
            this.regionIsBeingDrawn = true;
        } else {
            int first_x = this.drawingRegion.getShape().xpoints[0];
            int first_y = this.drawingRegion.getShape().ypoints[0];
            if (Math.abs(e.getX() - first_x) < 5 && Math.abs(e.getY() - first_y) < 5) {
                this.regionIsBeingDrawn = false;
                this.drawingRegion.setShape(this.transformToChannels(this.drawingRegion.getShape(), this.eventArea));
                this.statisticsStatus = 0;
                this.theRaG.add(this.drawingRegion);
                this.theDocument.adjustGateMenu();
                this.regionsToDraw.add(new visibleRegion(this.drawingRegion));
                this.drawingRegion.setSelected(false);
                this.theDocument.setApplicationObjectType(2);
            } else {
                this.drawingRegion.add(e.getPoint());
                if (e.getClickCount() > 1) {
                    this.regionIsBeingDrawn = false;
                    this.drawingRegion.setShape(this.transformToChannels(this.drawingRegion.getShape(), this.eventArea));
                    this.statisticsStatus = 0;
                    this.theRaG.add(this.drawingRegion);
                    this.theDocument.adjustGateMenu();
                    this.drawingRegion.setSelected(false);
                    this.regionsToDraw.add(new visibleRegion(this.drawingRegion));
                    this.theDocument.setApplicationObjectType(2);
                }
            }
        }
    }

    private FCS_quadrant calculateQuadrant(MouseEvent e) {
        int x = e.getPoint().x - this.eventArea.x;
        int y = e.getPoint().y - this.eventArea.y;
        x = (int)Math.round((double)x * this.overlays.get(0).factor_x);
        y = 4096 - (int)Math.round((double)y * this.overlays.get(0).factor_y);
        FCS_quadrant toReturn = new FCS_quadrant(x, y);
        if (this.quadrant != null) {
            toReturn.setSelected(this.quadrant.isSelected());
        }
        return toReturn;
    }

    public void copySelectedQuadrantMarkerRegion() {
        if (this.quadrant != null && this.quadrant.isSelected()) {
            privateClipboard.getInstance().setContent(this.quadrant.duplicate());
            this.quadrant.setSelected(false);
            this.repaint();
            return;
        }
        for (visibleRegion currVisRegion : this.regionsToDraw) {
            FCS_region currRegion = currVisRegion.region;
            if (!currRegion.isSelected()) continue;
            privateClipboard.getInstance().setContent(this.theRaG.indexOf(currVisRegion.region));
            currRegion.setSelected(false);
            this.repaint();
            return;
        }
        ArrayList temp = (ArrayList)this.markers.clone();
        for (FCS_marker currMarker : temp) {
            if (!currMarker.isSelected()) continue;
            privateClipboard.getInstance().setContent(currMarker.duplicate());
            currMarker.setSelected(false);
            this.repaint();
            return;
        }
    }

    public FACS_annotation createAnnotation() {
        String selection = annotationDialog.getInstance().getAnnotationKey(this.getKeywordsDescription(0), this.getKeywordsTEXT(0), this.getValuesTEXT(0));
        boolean isLegend = annotationDialog.getInstance().isLegend();
        return this.createAnnotation(selection, isLegend);
    }

    public FACS_annotation createAnnotation(String keyword, boolean showLegend) {
        if (keyword == null) {
            return null;
        }
        int x = this.getX();
        int y = this.getY();
        FACS_annotation newAnno = new FACS_annotation(this.theDocument, this, keyword, showLegend);
        Dimension size = newAnno.getPreferredSize();
        newAnno.setBounds(x, y -= (int)size.getHeight(), this.getWidth(), size.height);
        this.children.add(newAnno);
        return newAnno;
    }

    private void createGateRGB() {
        this.gatesRGB = new int[this.theRaG.getGatesCount()];
        int m = this.theRaG.getGatesCount();
        for (int i = 0; i < m; ++i) {
            this.gatesRGB[i] = this.theRaG.getGatesColor(i);
        }
    }

    public FACS_statistics createStatistics() {
        statisticsDialog currentInstance = statisticsDialog.getInstance();
        int stat = statisticsDialog.getInstance().editStats(null, 0);
        if (currentInstance.isOK()) {
            return this.createStatistics(stat);
        }
        return null;
    }

    public FACS_statistics createStatistics(int statistics) {
        int x = this.getX();
        int y = this.getY();
        JComponent newStat = null;
        try {
            newStat = new FACS_statistics(this.theDocument, this, statistics, this.quadrant, this.markers, this.theRaG, true);
        }
        catch (IOException io) {
            newStat = null;
            JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
        }
        if (newStat != null) {
            Dimension size = newStat.getPreferredSize();
            ((FACS_statistics)newStat).setBounds(x += this.getWidth(), y, size.width, size.height);
            this.children.add((FACS_panel)newStat);
        }
        return newStat;
    }

    private void createView_analyseViewAxes(createView_viewInfos infos) {
        overlaySettings testOverlay;
        int i;
        infos.baseOverlay = this.overlays.get(0);
        infos.xAxisR = infos.baseOverlay.rangeX;
        infos.yAxisR = this.plotType != 2 ? infos.baseOverlay.rangeY : (long)(infos.baseOverlay.getPeakChannelEventCount(infos.baseOverlay.paramX, infos.baseOverlay.appliedGate) + 1);
        int[] histogramRanges = new int[this.overlays.size()];
        int Xparam = infos.baseOverlay.paramX;
        int Yparam = infos.baseOverlay.paramY;
        float Xlogs = infos.baseOverlay.overlayData.getLogDecades(Xparam);
        float Ylogs = infos.baseOverlay.overlayData.getLogDecades(Yparam);
        long xRange = infos.baseOverlay.rangeX;
        long yRange = infos.yAxisR;
        for (i = 1; i < this.overlays.size(); ++i) {
            testOverlay = this.overlays.get(i);
            if (Xparam != testOverlay.paramX && infos.showXLabels) {
                infos.showXLabels = false;
            }
            if (xRange != testOverlay.rangeX && infos.showXticks) {
                infos.showXticks = false;
            }
            if (Xlogs != testOverlay.overlayData.getLogDecades(testOverlay.paramX) && infos.showXticks) {
                infos.showXticks = false;
            }
            if (Yparam != testOverlay.paramY && infos.showYLabels) {
                infos.showYLabels = false;
            }
            if (yRange != testOverlay.rangeY && infos.showYticks) {
                infos.showYticks = false;
            }
            if (Ylogs == testOverlay.overlayData.getLogDecades(testOverlay.paramY) || !infos.showYticks) continue;
            infos.showYticks = false;
        }
        if (this.isHistogram()) {
            infos.showYLabels = true;
            infos.showYticks = true;
            infos.maxRange = 0;
            for (i = 0; i < histogramRanges.length; ++i) {
                testOverlay = this.overlays.get(i);
                histogramRanges[i] = testOverlay.getPeakChannelEventCount(testOverlay.paramX, testOverlay.appliedGate);
                int currentRange = histogramRanges[i];
                if (currentRange == 0) {
                    int[] histogram = testOverlay.getHistogramEvents(testOverlay.paramX, testOverlay.appliedGate);
                    currentRange = histogram[0];
                    if (currentRange == 0) {
                        currentRange = histogram[histogram.length - 1];
                    } else if (histogram[histogram.length - 1] > 0 && histogram[histogram.length - 1] < currentRange) {
                        currentRange = histogram[histogram.length - 1];
                    }
                }
                if (testOverlay.scaleType == 1) {
                    histogramRanges[i] = -1;
                    if (currentRange <= infos.maxRange) continue;
                    infos.maxRange = currentRange;
                    continue;
                }
                if (testOverlay.scaleType == 2) {
                    histogramRanges[i] = testOverlay.manualScale;
                    continue;
                }
                histogramRanges[i] = currentRange;
                if (currentRange <= infos.maxRange) continue;
                infos.maxRange = currentRange;
            }
            for (i = 0; i < histogramRanges.length; ++i) {
                if (histogramRanges[i] != -1) continue;
                histogramRanges[i] = infos.maxRange;
            }
            int currentRange = histogramRanges[0];
            this.overlays.get(0).rangeY = histogramRanges[0];
            for (int i2 = 1; i2 < histogramRanges.length; ++i2) {
                this.overlays.get(i2).rangeY = histogramRanges[i2];
                if (histogramRanges[i2] == currentRange) continue;
                infos.showYticks = false;
                break;
            }
            infos.yAxisR = histogramRanges[0];
        }
    }

    private void createView_paintViewAxes(createView_viewInfos infos, Graphics2D g2) {
        int borderTop;
        Font standardFont = g2.getFont().deriveFont(this.getFontSize().floatValue());
        Font tickLabel = standardFont.deriveFont(this.getFontSize().floatValue() / 1.2f);
        Font superScriptFont = standardFont.deriveFont(this.getFontSize().floatValue() / 1.4f);
        g2.setFont(standardFont);
        FontMetrics fm = g2.getFontMetrics();
        String title = infos.baseOverlay.overlayData.getFileName();
        String labelX = infos.baseOverlay.overlayData.getParameterLabel(infos.baseOverlay.paramX);
        String labelY = this.plotType == 2 ? "Event count" : infos.baseOverlay.overlayData.getParameterLabel(infos.baseOverlay.paramY);
        Rectangle2D recTitle = fm.getStringBounds(title, g2);
        Rectangle2D recparamX = fm.getStringBounds(labelX, g2);
        Rectangle2D recparamY = fm.getStringBounds(labelY, g2);
        Rectangle2D recNumber = tickLabel.getStringBounds("0", g2.getFontRenderContext());
        int majorTickLength = 5;
        int minorTickLength = 3;
        int spacer = 4;
        int borderRight = borderTop = (int)recTitle.getHeight() + spacer;
        int borderLeft = (int)recparamY.getHeight() + spacer;
        borderLeft = this.plotType == 2 ? (borderLeft += (int)tickLabel.getStringBounds(String.valueOf(infos.yAxisR), g2.getFontRenderContext()).getWidth()) : (infos.baseOverlay.overlayData.getLogDecades(infos.baseOverlay.paramY) > 0.0f ? (borderLeft += (int)tickLabel.getStringBounds("100", g2.getFontRenderContext()).getWidth()) : (borderLeft += (int)tickLabel.getStringBounds(String.valueOf(infos.yAxisR), g2.getFontRenderContext()).getWidth()));
        int borderBottom = (int)recparamX.getHeight();
        int plotWidth = infos.width - borderLeft - borderRight;
        int plotHeight = infos.height - borderTop - (borderBottom += (int)(recNumber.getHeight() + (double)spacer));
        if (this.paintLocalEvents == 1) {
            borderLeft = this.plotArea.x - 1;
            borderTop = this.plotArea.y - 1;
            plotWidth = this.plotArea.width;
            plotHeight = this.plotArea.height;
        }
        infos.plotAreaWithTicks = new Rectangle(borderLeft + 1, borderTop + 1, plotWidth, plotHeight);
        infos.eventsWidth = plotWidth - 2 - majorTickLength;
        infos.eventsHeight = plotHeight - 2 - majorTickLength;
        this.eventArea = new Rectangle(borderLeft + majorTickLength + 1, borderTop + 1, infos.eventsWidth, infos.eventsHeight);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.overlays.size() == 1) {
            g2.drawString(infos.baseOverlay.overlayData.getFileName(), (int)(((double)infos.width - recTitle.getWidth()) / 2.0), (int)recTitle.getHeight());
        }
        if (infos.showXLabels) {
            g2.drawString(infos.baseOverlay.overlayData.getParameterLabel(infos.baseOverlay.paramX), (int)(((double)infos.eventsWidth - recparamX.getWidth()) / 2.0) + borderLeft + majorTickLength, infos.height - 5);
            this.x_axis_Area = new Rectangle((infos.eventsWidth - 150) / 2 + borderLeft + majorTickLength, infos.height - 5 - (int)recparamX.getHeight(), 150, infos.height);
        }
        if (infos.showYLabels) {
            AffineTransform tempT = g2.getTransform();
            g2.rotate(-1.5707963267948966);
            g2.drawString(labelY, -((int)((double)(borderTop + infos.eventsHeight / 2) + recparamY.getWidth() / 2.0)), (int)recparamX.getHeight());
            g2.setTransform(tempT);
            this.y_axis_Area = this.plotType == 2 ? new Rectangle() : new Rectangle(0, borderTop + infos.eventsHeight / 2 - 75, (int)recparamY.getHeight(), 150);
        }
        int[][] tickEventArea = null;
        if (infos.eventsWidth > 0 && infos.eventsHeight > 0) {
            Object yMinorTickPos;
            int[] yMajorTickPos;
            String[] yMajorTickLabels;
            int pos;
            long tickNumber;
            long minor;
            String log_string;
            long log_number;
            double currentTick;
            int i;
            Object xMinorTickPos;
            int[] xMajorTickPos;
            String[] xMajorTickLabels;
            tickEventArea = new int[infos.plotAreaWithTicks.width][infos.plotAreaWithTicks.height];
            int w = infos.eventsWidth + 2 + majorTickLength;
            for (int x = majorTickLength; x < w; ++x) {
                tickEventArea[x][0] = COLOR_BLACK;
                tickEventArea[x][infos.eventsHeight + 1] = COLOR_BLACK;
            }
            int h = infos.eventsHeight + 2;
            for (int y = 0; y < h; ++y) {
                tickEventArea[majorTickLength][y] = COLOR_BLACK;
                tickEventArea[majorTickLength + infos.eventsWidth + 1][y] = COLOR_BLACK;
            }
            double xScaleFactor = (double)infos.xAxisR / (double)infos.eventsWidth;
            double yScaleFactor = (double)infos.yAxisR / (double)infos.eventsHeight;
            if (this.isHistogram()) {
                yScaleFactor = (double)infos.yAxisR / (double)(infos.eventsHeight - 1);
            }
            boolean xDisplayLog = infos.baseOverlay.overlayData.displayAsLog(infos.baseOverlay.paramX);
            boolean yDisplayLog = infos.baseOverlay.overlayData.displayAsLog(infos.baseOverlay.paramY);
            definedTick[] defTicks = infos.baseOverlay.overlayData.getDefinedTicks(infos.baseOverlay.paramX);
            if (defTicks.length > 0) {
                xMajorTickLabels = new String[defTicks.length];
                xMajorTickPos = new int[defTicks.length];
                xMinorTickPos = new int[][]{};
                for (i = 0; i < defTicks.length; ++i) {
                    xMajorTickLabels[i] = defTicks[i].label;
                    double majorOnScale = defTicks[i].tick;
                    if (xDisplayLog) {
                        majorOnScale = infos.baseOverlay.overlayData.getTransform(infos.baseOverlay.paramX, defTicks[i].tick);
                    }
                    xMajorTickPos[i] = (int)(majorOnScale /= xScaleFactor);
                }
            } else if (xDisplayLog) {
                int i2;
                int logDecades;
                float scaleStart = infos.baseOverlay.overlayData.getOffset(infos.baseOverlay.paramX);
                if (scaleStart == 0.0f) {
                    scaleStart = 1.0f;
                }
                if ((logDecades = (int)infos.baseOverlay.overlayData.getLogDecades(infos.baseOverlay.paramX)) == 0) {
                    logDecades = (int)Math.log10(infos.xAxisR);
                }
                xMajorTickLabels = new String[logDecades + 1];
                xMajorTickPos = new int[logDecades + 1];
                xMinorTickPos = new int[logDecades + 2][8];
                for (i2 = 0; i2 <= logDecades; ++i2) {
                    currentTick = Math.pow(10.0, i2) * (double)scaleStart;
                    double majorOnScale = infos.baseOverlay.overlayData.getTransform(infos.baseOverlay.paramX, currentTick);
                    if ((majorOnScale /= xScaleFactor) >= (double)infos.eventsWidth) {
                        majorOnScale = infos.eventsWidth - 1;
                    }
                    xMajorTickPos[i2] = (int)majorOnScale;
                    double log = Math.log10(currentTick);
                    log_number = Math.round(log * 10.0);
                    log_string = String.valueOf(log_number);
                    log_string = log_string.substring(log_string.length() - 1).equals("0") ? log_string.substring(0, log_string.length() - 1) : log_string.substring(0, log_string.length() - 1) + "." + log_string.substring(log_string.length() - 1);
                    if (log_string.isEmpty()) {
                        log_string = "0";
                    }
                    xMajorTickLabels[i2] = log_string;
                }
                for (i2 = 0; i2 <= logDecades + 1; ++i2) {
                    currentTick = Math.pow(10.0, i2) * (double)scaleStart;
                    for (int j = 0; j < 8; ++j) {
                        double tickNumber2 = currentTick * (double)(j + 2);
                        double minorOnScale = infos.baseOverlay.overlayData.getTransform(infos.baseOverlay.paramX, tickNumber2);
                        if (!((minorOnScale /= xScaleFactor) < (double)infos.eventsWidth)) continue;
                        xMinorTickPos[i2][j] = (int)minorOnScale;
                    }
                }
            } else {
                int i3;
                int majorTicksToShow = 5;
                int minorTicksToShow = 5;
                long major = infos.xAxisR / (long)majorTicksToShow;
                major = (int)Math.floor(Math.log10(major));
                if ((major = (long)((int)Math.pow(10.0, major))) == 0L) {
                    major = 1L;
                }
                if ((major = infos.xAxisR / (long)majorTicksToShow / major * major) == 0L) {
                    major = 1L;
                }
                majorTicksToShow = (int)(infos.xAxisR / major);
                minor = major / (long)minorTicksToShow;
                xMajorTickLabels = new String[majorTicksToShow + 1];
                xMajorTickPos = new int[majorTicksToShow + 1];
                xMinorTickPos = new int[majorTicksToShow + 2][minorTicksToShow];
                for (i3 = 0; i3 < majorTicksToShow + 1; ++i3) {
                    long majorChannel = major * (long)i3;
                    tickNumber = majorChannel;
                    xMajorTickLabels[i3] = tickNumber < 10000L ? String.valueOf(tickNumber) : String.valueOf(tickNumber / 1000L) + "K";
                    xMajorTickPos[i3] = (int)((double)majorChannel / xScaleFactor);
                    if (xMajorTickPos[i3] < infos.eventsWidth) continue;
                    xMajorTickPos[i3] = infos.eventsWidth - 1;
                }
                for (i3 = 0; i3 < majorTicksToShow + 2; ++i3) {
                    for (int j = 1; j < minorTicksToShow; ++j) {
                        long minorChannel = major * (long)i3 + (long)j * minor;
                        pos = (int)((double)minorChannel / xScaleFactor);
                        if (pos >= infos.eventsWidth) continue;
                        xMinorTickPos[i3][j] = pos;
                    }
                }
            }
            if ((defTicks = infos.baseOverlay.overlayData.getDefinedTicks(infos.baseOverlay.paramY)).length > 0 && this.plotType != 2) {
                yMajorTickLabels = new String[defTicks.length];
                yMajorTickPos = new int[defTicks.length];
                yMinorTickPos = new int[][]{};
                for (i = 0; i < defTicks.length; ++i) {
                    yMajorTickLabels[i] = defTicks[i].label;
                    double majorOnScale = defTicks[i].tick;
                    if (yDisplayLog) {
                        majorOnScale = infos.baseOverlay.overlayData.getTransform(infos.baseOverlay.paramY, defTicks[i].tick);
                    }
                    yMajorTickPos[i] = (int)(majorOnScale /= yScaleFactor);
                }
            } else if (yDisplayLog && this.plotType != 2) {
                int i4;
                int logDecades;
                float scaleStart = infos.baseOverlay.overlayData.getOffset(infos.baseOverlay.paramY);
                if (scaleStart == 0.0f) {
                    scaleStart = 1.0f;
                }
                if ((logDecades = (int)infos.baseOverlay.overlayData.getLogDecades(infos.baseOverlay.paramY)) == 0) {
                    logDecades = (int)Math.log10(infos.yAxisR);
                }
                yMajorTickLabels = new String[logDecades + 1];
                yMajorTickPos = new int[logDecades + 1];
                yMinorTickPos = new int[logDecades + 2][8];
                for (i4 = 0; i4 <= logDecades; ++i4) {
                    currentTick = Math.pow(10.0, i4) * (double)scaleStart;
                    double majorOnScale = infos.baseOverlay.overlayData.getTransform(infos.baseOverlay.paramY, currentTick);
                    if ((majorOnScale /= yScaleFactor) >= (double)infos.eventsHeight) {
                        majorOnScale = infos.eventsHeight - 1;
                    }
                    yMajorTickPos[i4] = (int)majorOnScale;
                    double log = Math.log10(currentTick);
                    log_number = Math.round(log * 10.0);
                    log_string = String.valueOf(log_number);
                    log_string = log_string.substring(log_string.length() - 1).equals("0") ? log_string.substring(0, log_string.length() - 1) : log_string.substring(0, log_string.length() - 1) + "." + log_string.substring(log_string.length() - 1);
                    if (log_string.isEmpty()) {
                        log_string = "0";
                    }
                    yMajorTickLabels[i4] = log_string;
                }
                for (i4 = 0; i4 <= logDecades + 1; ++i4) {
                    currentTick = Math.pow(10.0, i4) * (double)scaleStart;
                    for (int j = 0; j < 8; ++j) {
                        double tickNumber3 = currentTick * (double)(j + 2);
                        double minorOnScale = infos.baseOverlay.overlayData.getTransform(infos.baseOverlay.paramY, tickNumber3);
                        if (!((minorOnScale /= yScaleFactor) < (double)infos.eventsHeight)) continue;
                        yMinorTickPos[i4][j] = (int)minorOnScale;
                    }
                }
            } else {
                int i5;
                int majorTicksToShow = 5;
                int minorTicksToShow = 5;
                long major = infos.yAxisR / (long)majorTicksToShow;
                major = (int)Math.floor(Math.log10(major));
                if ((major = (long)((int)Math.pow(10.0, major))) == 0L) {
                    major = 1L;
                }
                if ((major = infos.yAxisR / (long)majorTicksToShow / major * major) == 0L) {
                    major = 1L;
                }
                majorTicksToShow = (int)(infos.yAxisR / major);
                minor = major / (long)minorTicksToShow;
                yMajorTickLabels = new String[majorTicksToShow + 1];
                yMajorTickPos = new int[majorTicksToShow + 1];
                yMinorTickPos = new int[majorTicksToShow + 2][minorTicksToShow];
                for (i5 = 0; i5 < majorTicksToShow + 1; ++i5) {
                    long majorChannel = major * (long)i5;
                    tickNumber = majorChannel;
                    yMajorTickLabels[i5] = tickNumber < 10000L ? String.valueOf(tickNumber) : String.valueOf(tickNumber / 1000L) + "K";
                    yMajorTickPos[i5] = (int)((double)majorChannel / yScaleFactor);
                    if (yMajorTickPos[i5] < infos.eventsHeight) continue;
                    yMajorTickPos[i5] = infos.eventsHeight - 1;
                }
                for (i5 = 0; i5 < majorTicksToShow + 2; ++i5) {
                    for (int j = 1; j < minorTicksToShow; ++j) {
                        long minorChannel = major * (long)i5 + (long)j * minor;
                        pos = (int)((double)minorChannel / yScaleFactor);
                        if (pos >= infos.eventsHeight) continue;
                        yMinorTickPos[i5][j] = pos;
                    }
                }
            }
            if (infos.showXticks) {
                int y_base = borderTop + infos.eventsHeight + 1;
                String ten = "10";
                int tenPositionAdjust = (int)fm.getStringBounds(ten, g2).getWidth() - 4;
                for (int i6 = 0; i6 < xMajorTickPos.length; ++i6) {
                    for (int y = infos.plotAreaWithTicks.height - majorTickLength; y < infos.plotAreaWithTicks.height; ++y) {
                        tickEventArea[xMajorTickPos[i6] + majorTickLength + 1][y] = COLOR_BLACK;
                    }
                    int calc_x_label = xMajorTickPos[i6] + majorTickLength + 2 + borderLeft;
                    String tickString = xMajorTickLabels[i6];
                    g2.setFont(tickLabel);
                    if (xDisplayLog) {
                        g2.drawString(ten, calc_x_label - tenPositionAdjust, (int)((double)y_base + recNumber.getHeight() + 5.0));
                        g2.setFont(superScriptFont);
                        g2.drawString(tickString, calc_x_label + 2, (int)((double)y_base + recNumber.getHeight() + 5.0 - (double)(superScriptFont.getSize() / 2)));
                    } else {
                        g2.drawString(tickString, calc_x_label - fm.stringWidth(tickString) / 2, (int)((double)y_base + recNumber.getHeight() + 4.0));
                    }
                    if (i6 >= ((int[][])xMinorTickPos).length) continue;
                    for (int j = 0; j < xMinorTickPos[i6].length; ++j) {
                        int y;
                        int xpos;
                        if (xMinorTickPos[i6][j] <= 0 || (xpos = xMinorTickPos[i6][j] + majorTickLength + 1) >= tickEventArea.length) continue;
                        int l = y + minorTickLength;
                        for (y = infos.plotAreaWithTicks.height - majorTickLength; y < l; ++y) {
                            tickEventArea[xpos][y] = COLOR_BLACK;
                        }
                    }
                }
                int maxNegValue = infos.baseOverlay.overlayData.getApproximateNegativeRange(infos.baseOverlay.paramX);
                int divSteps = -(maxNegValue / 5);
                if (divSteps > 0) {
                    int calc_x_tick = 0;
                    for (int i7 = 0; i7 < 6; ++i7) {
                        int y;
                        double transformed_x_tick = infos.baseOverlay.overlayData.getTransform(infos.baseOverlay.paramX, -(i7 * divSteps));
                        calc_x_tick = (int)(transformed_x_tick / xScaleFactor) + majorTickLength + 1;
                        if (calc_x_tick >= tickEventArea.length) continue;
                        int l = y + minorTickLength;
                        for (y = infos.plotAreaWithTicks.height - majorTickLength; y < l; ++y) {
                            tickEventArea[calc_x_tick][y] = COLOR_BLACK;
                        }
                    }
                    int calc_x_label = calc_x_tick + borderLeft + 2;
                    String tickString = String.valueOf(-divSteps * 5);
                    g2.setFont(tickLabel);
                    g2.drawString(tickString, calc_x_label - fm.stringWidth(tickString) / 2, (int)((double)y_base + recNumber.getHeight() + 4.0));
                }
            }
            if (infos.showYticks) {
                String ten = "10";
                int tenSizeWidth = (int)fm.getStringBounds(ten, g2).getWidth() - 2;
                int tenSizeHeight = (int)fm.getStringBounds(ten, g2).getHeight();
                for (int i8 = 0; i8 < yMajorTickPos.length; ++i8) {
                    int calc_y_tick = infos.eventsHeight - 1 - yMajorTickPos[i8];
                    if (++calc_y_tick > -1) {
                        for (int x = 0; x < majorTickLength; ++x) {
                            tickEventArea[x][calc_y_tick] = COLOR_BLACK;
                        }
                        int calc_y_label = calc_y_tick + borderTop;
                        String tickString = yMajorTickLabels[i8];
                        g2.setFont(tickLabel);
                        if (yDisplayLog && !this.isHistogram()) {
                            g2.drawString(ten, borderLeft + majorTickLength - tenSizeWidth - tenSizeWidth / 2 - 6, calc_y_label + tenSizeHeight / 2 - 4);
                            g2.setFont(superScriptFont);
                            g2.drawString(tickString, borderLeft + majorTickLength - tenSizeWidth / 2 - 6, calc_y_label + tenSizeHeight / 2 - 4 - superScriptFont.getSize() / 2);
                        } else {
                            Rectangle2D tickRec = tickLabel.getStringBounds(tickString, g2.getFontRenderContext());
                            g2.drawString(tickString, (int)((double)(borderLeft + majorTickLength - 6) - tickRec.getWidth()), calc_y_label + 1 + (int)tickRec.getHeight() / 4);
                        }
                    }
                    if (i8 >= ((int[][])yMinorTickPos).length) continue;
                    for (int j = 0; j < yMinorTickPos[i8].length; ++j) {
                        if (yMinorTickPos[i8][j] <= 0) continue;
                        int calc_y_minor = infos.eventsHeight - 1 - yMinorTickPos[i8][j];
                        if (++calc_y_minor <= 0) continue;
                        for (int x = majorTickLength - minorTickLength; x < majorTickLength; ++x) {
                            tickEventArea[x][calc_y_minor] = COLOR_BLACK;
                        }
                    }
                }
                int maxNegValue = infos.baseOverlay.overlayData.getApproximateNegativeRange(infos.baseOverlay.paramY);
                int divSteps = -(maxNegValue / 5);
                if (divSteps > 0) {
                    int calc_y_tick = 0;
                    for (int i9 = 0; i9 < 6; ++i9) {
                        double transformed_y_tick = infos.baseOverlay.overlayData.getTransform(infos.baseOverlay.paramY, -(i9 * divSteps));
                        calc_y_tick = (int)(transformed_y_tick / yScaleFactor);
                        if ((calc_y_tick = infos.eventsHeight - calc_y_tick) <= 0) continue;
                        for (int x = 0; x < majorTickLength; ++x) {
                            tickEventArea[x][calc_y_tick] = COLOR_BLACK;
                        }
                    }
                    int calc_y_label = calc_y_tick + borderTop + 1;
                    String tickString = String.valueOf(-divSteps * 5);
                    g2.setFont(tickLabel);
                    Rectangle2D tickRec = tickLabel.getStringBounds(tickString, g2.getFontRenderContext());
                    g2.drawString(tickString, (int)((double)(borderLeft + majorTickLength - 6) - tickRec.getWidth()), calc_y_label + (int)tickRec.getHeight() / 4);
                }
            }
            int w2 = tickEventArea.length;
            int h2 = tickEventArea[0].length;
            int[] pixels = new int[w2 * h2];
            for (int x = 0; x < w2; ++x) {
                for (int y = 0; y < h2; ++y) {
                    pixels[y * w2 + x] = tickEventArea[x][y];
                }
            }
            BufferedImage toDraw = new BufferedImage(w2, h2, 7);
            toDraw.setRGB(0, 0, w2, h2, pixels, 0, w2);
            g2.drawImage((Image)toDraw, borderLeft, borderTop, this);
        }
    }

    private int[][] createView_calculateDot(overlaySettings currentOverlay, int[][] painted) {
        int paintWidth = painted.length;
        int paintHeight = painted[0].length;
        int step = currentOverlay.step;
        FCS_data currentData = currentOverlay.overlayData;
        FCS_gate theGate = currentOverlay.appliedGate;
        int currentGate = this.theRaG.indexOf(theGate);
        int currentParamX = currentOverlay.paramX;
        int currentParamY = currentOverlay.paramY;
        currentOverlay.factor_x = 4096.0 / (double)paintWidth;
        currentOverlay.factor_y = 4096.0 / (double)paintHeight;
        double currentFactorX = currentOverlay.factor_x;
        double currentFactorY = currentOverlay.factor_y;
        int totalEvents = currentData.getEventCount();
        int eventColor = Color.BLACK.getRGB();
        switch (currentOverlay.colorType) {
            case 0: {
                break;
            }
            case 1: {
                if (currentGate < 0) break;
                eventColor = this.gatesRGB[currentGate];
                break;
            }
            case 2: {
                eventColor = currentOverlay.outerColor;
            }
        }
        if (step == 1) {
            int cacheStep = 100;
            int cachings = totalEvents / cacheStep;
            int rest = totalEvents % cacheStep;
            for (int i = 0; i < cachings; ++i) {
                double[][] cacheEvents = currentData.getEvents(i * cacheStep, cacheStep)[0];
                for (int m = 0; m < cacheStep; ++m) {
                    double[] event = cacheEvents[m];
                    if (theGate != null && !theGate.contains(event)) continue;
                    int x = (int)(event[currentParamX] / currentFactorX);
                    int y = paintHeight - (int)(event[currentParamY] / currentFactorY) - 1;
                    painted[x][y] = currentOverlay.colorType == 0 ? this.theRaG.colorFirstGateContaining(event) : eventColor;
                }
            }
            double[][] cacheEvents = currentData.getEvents(cachings * cacheStep, rest)[0];
            for (int m = 0; m < rest; ++m) {
                double[] event = cacheEvents[m];
                if (theGate != null && !theGate.contains(event)) continue;
                int x = (int)(event[currentParamX] / currentFactorX);
                int y = paintHeight - (int)(event[currentParamY] / currentFactorY) - 1;
                painted[x][y] = currentOverlay.colorType == 0 ? this.theRaG.colorFirstGateContaining(event) : eventColor;
            }
        } else {
            for (int i = 0; i < totalEvents; i += step) {
                double[] event = currentData.getEvents(i, 1)[0][0];
                if (theGate != null && !theGate.contains(event)) continue;
                int x = (int)(event[currentParamX] / currentFactorX);
                int y = paintHeight - (int)(event[currentParamY] / currentFactorY) - 1;
                painted[x][y] = currentOverlay.colorType == 0 ? this.theRaG.colorFirstGateContaining(event) : eventColor;
            }
        }
        return painted;
    }

    private int[][] createView_calculateEventDensity(overlaySettings currentOverlay, int[][] painted, createView_viewInfos infos) {
        int paintWidth = painted.length;
        int paintHeight = painted[0].length;
        currentOverlay.factor_x = 4096.0 / (double)paintWidth;
        currentOverlay.factor_y = 4096.0 / (double)paintHeight;
        int x_size = 64;
        int y_size = 64;
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 128;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 256;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 512;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 1024;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 128;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 256;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 512;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 1024;
        }
        int[][] density_grid = new int[x_size][y_size];
        FCS_data currentData = currentOverlay.overlayData;
        int totalEvents = currentData.getEventCount();
        FCS_gate theGate = currentOverlay.appliedGate;
        int currentGate = this.theRaG.indexOf(theGate);
        int currentParamX = currentOverlay.paramX;
        int currentParamY = currentOverlay.paramY;
        double tempFactorX = 4096.0 / (double)x_size;
        double tempFactorY = 4096.0 / (double)y_size;
        int tempYadjust = y_size - 1;
        int[][] count_grid = new int[x_size][y_size];
        int cacheStep = 100;
        int cachings = totalEvents / cacheStep;
        int rest = totalEvents % cacheStep;
        for (int i = 0; i < cachings; ++i) {
            double[][] cacheEvents = currentData.getEvents(i * cacheStep, cacheStep)[0];
            for (int m = 0; m < cacheStep; ++m) {
                double[] event = cacheEvents[m];
                if (theGate != null && !theGate.contains(event)) continue;
                int x = (int)(event[currentParamX] / tempFactorX);
                int y = tempYadjust - (int)(event[currentParamY] / tempFactorY);
                int[] nArray = count_grid[x];
                int n = y;
                nArray[n] = nArray[n] + 1;
            }
        }
        double[][] cacheEvents = currentData.getEvents(cachings * cacheStep, rest)[0];
        for (int m = 0; m < rest; ++m) {
            double[] event = cacheEvents[m];
            if (theGate != null && !theGate.contains(event)) continue;
            int x = (int)(event[currentParamX] / tempFactorX);
            int y = tempYadjust - (int)(event[currentParamY] / tempFactorY);
            int[] nArray = count_grid[x];
            int n = y;
            nArray[n] = nArray[n] + 1;
        }
        int highestCount = 0;
        for (int x = 0; x < x_size; ++x) {
            for (int y = 0; y < y_size; ++y) {
                int count = count_grid[x][y];
                if (count <= highestCount) continue;
                highestCount = count;
            }
        }
        double logFactor = ((double)colorGradient.gradientSteps - 1.0) / Math.log(highestCount);
        Color theColor = Color.BLACK;
        int grad = -1;
        switch (currentOverlay.colorType) {
            case 0: {
                break;
            }
            case 1: {
                if (currentGate < 0) break;
                theColor = new Color(this.gatesRGB[currentGate]);
                break;
            }
            case 2: {
                theColor = new Color(currentOverlay.outerColor);
                break;
            }
            default: {
                grad = currentOverlay.colorType;
            }
        }
        int[] cGradient = colorGradient.createGradient(theColor, Color.WHITE, colorGradient.gradientSteps);
        if (grad != -1) {
            if ((grad -= 3) < 0) {
                grad = 0;
            }
            if (grad >= this.theDocument.getColorGradientCount()) {
                grad = this.theDocument.getColorGradientCount() - 1;
            }
            if (grad >= 0) {
                cGradient = this.theDocument.getGradient(grad);
            }
            currentOverlay.colorType = grad + 3;
        }
        for (int x = 0; x < x_size; ++x) {
            for (int y = 0; y < y_size; ++y) {
                if (count_grid[x][y] <= 0) continue;
                int log = (int)(Math.log(count_grid[x][y]) * logFactor);
                density_grid[x][y] = cGradient[log];
            }
        }
        float scaleFactorX = (float)x_size / (float)paintWidth;
        float scaleFactorY = (float)y_size / (float)paintHeight;
        for (int x = 0; x < x_size; ++x) {
            for (int y = 0; y < y_size; ++y) {
                int calc_x = (int)((float)x / scaleFactorX);
                int calc_y = (int)((float)y / scaleFactorY);
                int calc_next_x = (int)((float)(x + 1) / scaleFactorX);
                int calc_next_y = (int)((float)(y + 1) / scaleFactorY);
                if (calc_next_x > painted.length - 1) {
                    calc_next_x = painted.length - 1;
                }
                if (calc_next_y > painted[0].length - 1) {
                    calc_next_y = painted[0].length - 1;
                }
                if (calc_x >= calc_next_x) {
                    calc_next_x = calc_x + 1;
                }
                if (calc_y >= calc_next_y) {
                    calc_next_y = calc_y + 1;
                }
                for (int i = calc_x; i < calc_next_x; ++i) {
                    for (int j = calc_y; j < calc_next_y; ++j) {
                        if (density_grid[x][y] == 0) continue;
                        painted[i][j] = density_grid[x][y];
                    }
                }
            }
        }
        return painted;
    }

    private int[][] createView_calculateParamDensity(overlaySettings currentOverlay, int[][] painted, createView_viewInfos infos) {
        int paintWidth = painted.length;
        int paintHeight = painted[0].length;
        currentOverlay.factor_x = 4096.0 / (double)paintWidth;
        currentOverlay.factor_y = 4096.0 / (double)paintHeight;
        int x_size = 64;
        int y_size = 64;
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 128;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 256;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 512;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 1024;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 128;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 256;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 512;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 1024;
        }
        int[][] density_grid = new int[x_size][y_size];
        FCS_data currentData = currentOverlay.overlayData;
        int totalEvents = currentData.getEventCount();
        FCS_gate theGate = currentOverlay.appliedGate;
        int currentGate = this.theRaG.indexOf(theGate);
        int currentParamX = currentOverlay.paramX;
        int currentParamY = currentOverlay.paramY;
        double tempFactorX = 4096.0 / (double)x_size;
        double tempFactorY = 4096.0 / (double)y_size;
        int tempYadjust = y_size - 1;
        int[][] count_grid = new int[x_size][y_size];
        double[][] value_grid = new double[x_size][y_size];
        int param = currentOverlay.densityParam_1;
        int cacheStep = 100;
        int cachings = totalEvents / cacheStep;
        int rest = totalEvents % cacheStep;
        for (int i = 0; i < cachings; ++i) {
            double[][][] cacheEvents = currentData.getEvents(i * cacheStep, cacheStep);
            double[][] displayEvents = cacheEvents[0];
            double[][] calculEvents = cacheEvents[1];
            for (int m = 0; m < cacheStep; ++m) {
                double[] event = displayEvents[m];
                if (theGate != null && !theGate.contains(event)) continue;
                int x = (int)(event[currentParamX] / tempFactorX);
                int y = tempYadjust - (int)(event[currentParamY] / tempFactorY);
                int[] nArray = count_grid[x];
                int n = y;
                nArray[n] = nArray[n] + 1;
                value_grid[x][y] = value_grid[x][y] + calculEvents[m][param];
            }
        }
        double[][][] cacheEvents = currentData.getEvents(cachings * cacheStep, rest);
        double[][] displayEvents = cacheEvents[0];
        double[][] calculEvents = cacheEvents[1];
        for (int m = 0; m < rest; ++m) {
            double[] event = displayEvents[m];
            if (theGate != null && !theGate.contains(event)) continue;
            int x = (int)(event[currentParamX] / tempFactorX);
            int y = tempYadjust - (int)(event[currentParamY] / tempFactorY);
            int[] nArray = count_grid[x];
            int n = y;
            nArray[n] = nArray[n] + 1;
            value_grid[x][y] = value_grid[x][y] + calculEvents[m][param];
        }
        for (int x = 0; x < x_size; ++x) {
            for (int y = 0; y < y_size; ++y) {
                value_grid[x][y] = value_grid[x][y] / (double)count_grid[x][y];
            }
        }
        double highestValue = 0.0;
        double lowestValue = Double.MAX_VALUE;
        for (int x = 0; x < x_size; ++x) {
            for (int y = 0; y < y_size; ++y) {
                double value = value_grid[x][y];
                if (value > highestValue) {
                    highestValue = value;
                }
                if (!(value < lowestValue)) continue;
                lowestValue = value;
            }
        }
        if (lowestValue < 1.0) {
            double toAdd = 1.0 - lowestValue;
            for (int x = 0; x < x_size; ++x) {
                for (int y = 0; y < y_size; ++y) {
                    value_grid[x][y] = value_grid[x][y] + toAdd;
                }
            }
        }
        double logFactor = ((double)colorGradient.gradientSteps - 1.0) / Math.log(highestValue);
        Color theColor = Color.BLACK;
        int grad = -1;
        switch (currentOverlay.colorType) {
            case 0: {
                break;
            }
            case 1: {
                if (currentGate < 0) break;
                theColor = new Color(this.gatesRGB[currentGate]);
                break;
            }
            case 2: {
                theColor = new Color(currentOverlay.outerColor);
                break;
            }
            default: {
                grad = currentOverlay.colorType;
            }
        }
        int[] cGradient = colorGradient.createGradient(theColor, Color.WHITE, colorGradient.gradientSteps);
        if (grad != -1) {
            if ((grad -= 3) < 0) {
                grad = 0;
            }
            if (grad >= this.theDocument.getColorGradientCount()) {
                grad = this.theDocument.getColorGradientCount() - 1;
            }
            if (grad >= 0) {
                cGradient = this.theDocument.getGradient(grad);
            }
            currentOverlay.colorType = grad + 3;
        }
        for (int x = 0; x < x_size; ++x) {
            for (int y = 0; y < y_size; ++y) {
                if (count_grid[x][y] <= 0) continue;
                int log = (int)(Math.log(value_grid[x][y]) * logFactor);
                density_grid[x][y] = cGradient[log];
            }
        }
        float scaleFactorX = (float)x_size / (float)paintWidth;
        float scaleFactorY = (float)y_size / (float)paintHeight;
        for (int x = 0; x < x_size; ++x) {
            for (int y = 0; y < y_size; ++y) {
                int calc_x = (int)((float)x / scaleFactorX);
                int calc_y = (int)((float)y / scaleFactorY);
                int calc_next_x = (int)((float)(x + 1) / scaleFactorX);
                int calc_next_y = (int)((float)(y + 1) / scaleFactorY);
                if (calc_next_x > painted.length - 1) {
                    calc_next_x = painted.length - 1;
                }
                if (calc_next_y > painted[0].length - 1) {
                    calc_next_y = painted[0].length - 1;
                }
                if (calc_x >= calc_next_x) {
                    calc_next_x = calc_x + 1;
                }
                if (calc_y >= calc_next_y) {
                    calc_next_y = calc_y + 1;
                }
                for (int i = calc_x; i < calc_next_x; ++i) {
                    for (int j = calc_y; j < calc_next_y; ++j) {
                        if (density_grid[x][y] == 0) continue;
                        painted[i][j] = density_grid[x][y];
                    }
                }
            }
        }
        return painted;
    }

    private int[][] createView_calculateThreeParamDensity(overlaySettings currentOverlay, int[][] painted, createView_viewInfos infos) {
        int y;
        int paintWidth = painted.length;
        int paintHeight = painted[0].length;
        currentOverlay.factor_x = 4096.0 / (double)paintWidth;
        currentOverlay.factor_y = 4096.0 / (double)paintHeight;
        int x_size = 64;
        int y_size = 64;
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 128;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 256;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 512;
        }
        if (paintWidth > x_size && infos.xAxisR > (long)x_size) {
            x_size = 1024;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 128;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 256;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 512;
        }
        if (paintHeight > y_size && infos.yAxisR > (long)y_size) {
            y_size = 1024;
        }
        int[][] density_grid = new int[x_size][y_size];
        FCS_data currentData = currentOverlay.overlayData;
        int totalEvents = currentData.getEventCount();
        FCS_gate theGate = currentOverlay.appliedGate;
        int currentParamX = currentOverlay.paramX;
        int currentParamY = currentOverlay.paramY;
        double tempFactorX = 4096.0 / (double)x_size;
        double tempFactorY = 4096.0 / (double)y_size;
        int tempYadjust = y_size - 1;
        int[][] count_grid = new int[x_size][y_size];
        int param1 = currentOverlay.densityParam_1;
        int param2 = currentOverlay.densityParam_2;
        int param3 = currentOverlay.densityParam_3;
        double[][] value_grid_p1 = new double[x_size][y_size];
        double[][] value_grid_p2 = null;
        double[][] value_grid_p3 = null;
        if (param2 > -1) {
            value_grid_p2 = new double[x_size][y_size];
        }
        if (param3 > -1) {
            value_grid_p3 = new double[x_size][y_size];
        }
        int cacheStep = 100;
        int cachings = totalEvents / cacheStep;
        int rest = totalEvents % cacheStep;
        for (int i = 0; i < cachings; ++i) {
            double[][][] cacheEvents = currentData.getEvents(i * cacheStep, cacheStep);
            double[][] displayEvents = cacheEvents[0];
            double[][] calculEvents = cacheEvents[1];
            for (int m = 0; m < cacheStep; ++m) {
                double[] event = displayEvents[m];
                if (theGate != null && !theGate.contains(event)) continue;
                int x = (int)(event[currentParamX] / tempFactorX);
                int y2 = tempYadjust - (int)(event[currentParamY] / tempFactorY);
                int[] nArray = count_grid[x];
                int n = y2;
                nArray[n] = nArray[n] + 1;
                value_grid_p1[x][y2] = value_grid_p1[x][y2] + calculEvents[m][param1];
                if (value_grid_p2 != null) {
                    value_grid_p2[x][y2] = value_grid_p2[x][y2] + calculEvents[m][param2];
                }
                if (value_grid_p3 == null) continue;
                value_grid_p3[x][y2] = value_grid_p3[x][y2] + calculEvents[m][param3];
            }
        }
        double[][][] cacheEvents = currentData.getEvents(cachings * cacheStep, rest);
        double[][] displayEvents = cacheEvents[0];
        double[][] calculEvents = cacheEvents[1];
        for (int m = 0; m < rest; ++m) {
            double[] event = displayEvents[m];
            if (theGate != null && !theGate.contains(event)) continue;
            int x = (int)(event[currentParamX] / tempFactorX);
            int y3 = tempYadjust - (int)(event[currentParamY] / tempFactorY);
            int[] nArray = count_grid[x];
            int n = y3;
            nArray[n] = nArray[n] + 1;
            value_grid_p1[x][y3] = value_grid_p1[x][y3] + calculEvents[m][param1];
            if (value_grid_p2 != null) {
                value_grid_p2[x][y3] = value_grid_p2[x][y3] + calculEvents[m][param2];
            }
            if (value_grid_p3 == null) continue;
            value_grid_p3[x][y3] = value_grid_p3[x][y3] + calculEvents[m][param3];
        }
        for (int x = 0; x < x_size; ++x) {
            for (int y4 = 0; y4 < y_size; ++y4) {
                value_grid_p1[x][y4] = value_grid_p1[x][y4] / (double)count_grid[x][y4];
                if (value_grid_p2 != null) {
                    value_grid_p2[x][y4] = value_grid_p2[x][y4] / (double)count_grid[x][y4];
                }
                if (value_grid_p3 == null) continue;
                value_grid_p3[x][y4] = value_grid_p3[x][y4] / (double)count_grid[x][y4];
            }
        }
        double highestValue_p1 = 0.0;
        double lowestValue_p1 = Double.MAX_VALUE;
        double highestValue_p2 = 0.0;
        double lowestValue_p2 = Double.MAX_VALUE;
        double highestValue_p3 = 0.0;
        double lowestValue_p3 = Double.MAX_VALUE;
        for (int x = 0; x < x_size; ++x) {
            for (int y5 = 0; y5 < y_size; ++y5) {
                double value = value_grid_p1[x][y5];
                if (value > highestValue_p1) {
                    highestValue_p1 = value;
                }
                if (value < lowestValue_p1) {
                    lowestValue_p1 = value;
                }
                if (value_grid_p2 != null) {
                    value = value_grid_p2[x][y5];
                    if (value > highestValue_p2) {
                        highestValue_p2 = value;
                    }
                    if (value < lowestValue_p2) {
                        lowestValue_p2 = value;
                    }
                }
                if (value_grid_p3 == null) continue;
                value = value_grid_p3[x][y5];
                if (value > highestValue_p3) {
                    highestValue_p3 = value;
                }
                if (!(value < lowestValue_p3)) continue;
                lowestValue_p3 = value;
            }
        }
        if (lowestValue_p1 < 1.0) {
            double toAdd = 1.0 - lowestValue_p1;
            for (int x = 0; x < x_size; ++x) {
                for (y = 0; y < y_size; ++y) {
                    value_grid_p1[x][y] = value_grid_p1[x][y] + toAdd;
                }
            }
        }
        if (lowestValue_p2 < 1.0 && value_grid_p2 != null) {
            double toAdd = 1.0 - lowestValue_p2;
            for (int x = 0; x < x_size; ++x) {
                for (y = 0; y < y_size; ++y) {
                    value_grid_p2[x][y] = value_grid_p2[x][y] + toAdd;
                }
            }
        }
        if (lowestValue_p3 < 1.0 && value_grid_p3 != null) {
            double toAdd = 1.0 - lowestValue_p3;
            for (int x = 0; x < x_size; ++x) {
                for (y = 0; y < y_size; ++y) {
                    value_grid_p3[x][y] = value_grid_p3[x][y] + toAdd;
                }
            }
        }
        double logFactor_p1 = ((double)colorGradient.gradientSteps - 1.0) / Math.log(highestValue_p1);
        double logFactor_p2 = ((double)colorGradient.gradientSteps - 1.0) / Math.log(highestValue_p2);
        double logFactor_p3 = ((double)colorGradient.gradientSteps - 1.0) / Math.log(highestValue_p3);
        int[] cArray = new int[]{0, 27, 34, 41, 48, 55, 62, 69, 76, 83, 90, 97, 104, 111, 118, 125, 132, 139, 146, 153, 160, 167, 174, 181, 188, 195, 202, 209, 216, 223, 230, 237, 244};
        for (int x = 0; x < x_size; ++x) {
            for (int y6 = 0; y6 < y_size; ++y6) {
                if (count_grid[x][y6] <= 0) continue;
                int log1 = 0;
                int log2 = 0;
                int log3 = 0;
                if (value_grid_p1[x][y6] > 0.0) {
                    log1 = (int)(Math.log(value_grid_p1[x][y6]) * logFactor_p1) + 1;
                }
                if (value_grid_p2 != null && value_grid_p2[x][y6] > 0.0) {
                    log2 = (int)(Math.log(value_grid_p2[x][y6]) * logFactor_p2) + 1;
                }
                if (value_grid_p3 != null && value_grid_p3[x][y6] > 0.0) {
                    log3 = (int)(Math.log(value_grid_p3[x][y6]) * logFactor_p3) + 1;
                }
                density_grid[x][y6] = new Color(cArray[log1], cArray[log2], cArray[log3]).getRGB();
            }
        }
        float scaleFactorX = (float)x_size / (float)paintWidth;
        float scaleFactorY = (float)y_size / (float)paintHeight;
        for (int x = 0; x < x_size; ++x) {
            for (int y7 = 0; y7 < y_size; ++y7) {
                int calc_x = (int)((float)x / scaleFactorX);
                int calc_y = (int)((float)y7 / scaleFactorY);
                int calc_next_x = (int)((float)(x + 1) / scaleFactorX);
                int calc_next_y = (int)((float)(y7 + 1) / scaleFactorY);
                if (calc_next_x > painted.length - 1) {
                    calc_next_x = painted.length - 1;
                }
                if (calc_next_y > painted[0].length - 1) {
                    calc_next_y = painted[0].length - 1;
                }
                if (calc_x >= calc_next_x) {
                    calc_next_x = calc_x + 1;
                }
                if (calc_y >= calc_next_y) {
                    calc_next_y = calc_y + 1;
                }
                for (int i = calc_x; i < calc_next_x; ++i) {
                    for (int j = calc_y; j < calc_next_y; ++j) {
                        if (density_grid[x][y7] == 0) continue;
                        painted[i][j] = density_grid[x][y7];
                    }
                }
            }
        }
        return painted;
    }

    private void createView_drawHistogramm(BufferedImage histogramArea, overlaySettings currentOverlay, createView_viewInfos infos) {
        int i;
        Graphics2D gTemp = (Graphics2D)histogramArea.getGraphics();
        int paintWidth = histogramArea.getWidth();
        int paintHeight = histogramArea.getHeight();
        int currentParamX = currentOverlay.paramX;
        FCS_gate theGate = currentOverlay.appliedGate;
        int currentGate = this.theRaG.indexOf(theGate);
        currentOverlay.factor_x = 4096.0 / (double)paintWidth;
        currentOverlay.factor_y = 4096.0 / (double)paintHeight;
        double currentFactorY = currentOverlay.factor_y;
        int[] y_values = new int[paintWidth];
        Arrays.fill(y_values, -1);
        int[] histogram_events = currentOverlay.getHistogramEvents(currentParamX, theGate);
        int peakEvent = currentOverlay.getPeakChannelEventCount(currentParamX, theGate);
        if (currentOverlay.scaleType == 2) {
            peakEvent = currentOverlay.manualScale;
        }
        if (currentOverlay.scaleType == 1) {
            peakEvent = infos.maxRange;
        }
        double factorToRange = 4096.0 / (double)peakEvent;
        int bins = histogram_events.length;
        float factorX = (float)paintWidth / (float)bins;
        for (i = 0; i < bins; ++i) {
            int x = (int)((float)i * factorX);
            int y = (int)((double)histogram_events[i] * factorToRange / currentFactorY);
            if (y_values[x] >= y) continue;
            y_values[x] = y;
        }
        for (i = 0; i < y_values.length; ++i) {
            if (y_values[i] <= paintHeight * 3) continue;
            y_values[i] = paintHeight * 3;
        }
        Polygon histo = new Polygon();
        histo.addPoint(-10, paintHeight + 10);
        histo.addPoint(-10, paintHeight - 1 - y_values[0]);
        histo.addPoint(-1, paintHeight - 1 - y_values[0]);
        int lastY = 0;
        for (int i2 = 0; i2 < y_values.length; ++i2) {
            int y;
            if (y_values[i2] == -1) continue;
            lastY = y = paintHeight - 1 - y_values[i2];
            histo.addPoint(i2, y);
        }
        histo.addPoint(y_values.length + 10, lastY);
        histo.addPoint(y_values.length + 10, paintHeight + 10);
        if (currentOverlay.fillHistogram) {
            gTemp.setColor(new Color(currentOverlay.fillColor, true));
            gTemp.fillPolygon(histo);
        }
        gTemp.setStroke(currentOverlay.theStroke);
        int lineColor = Color.BLACK.getRGB();
        switch (currentOverlay.colorType) {
            case 0: {
                break;
            }
            case 1: {
                if (currentGate < 0) break;
                lineColor = this.gatesRGB[currentGate];
                break;
            }
            case 2: {
                lineColor = currentOverlay.outerColor;
            }
        }
        gTemp.setColor(new Color(lineColor, true));
        gTemp.drawPolygon(histo);
        gTemp.dispose();
    }

    private Rectangle createView(Graphics2D g2, int width, int height) throws IllegalStateException {
        createView_viewInfos infos = new createView_viewInfos();
        infos.width = width;
        infos.height = height;
        if (this.paintLocalEvents != 2) {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, width, height);
            g2.setColor(Color.black);
            this.createView_analyseViewAxes(infos);
            this.createView_paintViewAxes(infos, g2);
            if (infos.eventsWidth > 0 && infos.eventsHeight > 0) {
                if (this.paintLocalEvents == 0 || this.view == null) {
                    this.createGateRGB();
                    int[][] calc = new int[infos.eventsWidth][infos.eventsHeight];
                    if (this.plotType == 0) {
                        for (overlaySettings currentO : this.overlays) {
                            this.createView_calculateDot(currentO, calc);
                        }
                    }
                    if (this.plotType == 1) {
                        for (overlaySettings currentO : this.overlays) {
                            if (currentO.densityType == -2 && currentO.densityParam_1 != -1) {
                                this.createView_calculateParamDensity(currentO, calc, infos);
                                continue;
                            }
                            if (currentO.densityType == -3 && currentO.densityParam_1 != -1) {
                                this.createView_calculateThreeParamDensity(currentO, calc, infos);
                                continue;
                            }
                            this.createView_calculateEventDensity(currentO, calc, infos);
                        }
                    }
                    BufferedImage histogramArea = null;
                    if (this.plotType == 2) {
                        histogramArea = new BufferedImage(infos.eventsWidth, infos.eventsHeight, 3);
                        for (overlaySettings currentO : this.overlays) {
                            this.createView_drawHistogramm(histogramArea, currentO, infos);
                        }
                    }
                    if (calc != null) {
                        int w = calc.length;
                        int h = calc[0].length;
                        int[] pixels = new int[w * h];
                        for (int x = 0; x < w; ++x) {
                            for (int y = 0; y < h; ++y) {
                                pixels[y * w + x] = calc[x][y];
                            }
                        }
                        BufferedImage toDraw = new BufferedImage(w, h, 7);
                        toDraw.setRGB(0, 0, w, h, pixels, 0, w);
                        g2.drawImage((Image)toDraw, this.eventArea.x, this.eventArea.y, this);
                    }
                    if (histogramArea != null) {
                        g2.drawImage((Image)histogramArea, this.eventArea.x, this.eventArea.y, this);
                    }
                } else {
                    BufferedImage oldView = this.view.getSubimage(this.eventArea.x, this.eventArea.y, this.eventArea.width, this.eventArea.height);
                    g2.drawImage((Image)oldView, this.eventArea.x, this.eventArea.y, null);
                }
            }
            if (this.overlays.size() != 1) {
                if (!infos.showXLabels) {
                    this.x_axis_Area = new Rectangle(0, 0, 0, 0);
                }
                if (!infos.showYLabels) {
                    this.y_axis_Area = new Rectangle(0, 0, 0, 0);
                }
            }
        } else {
            g2.setColor(Color.lightGray);
            g2.fillRect(0, 0, width, height);
        }
        return infos.plotAreaWithTicks;
    }

    @Override
    public void delete() {
        ArrayList childrenCopy = (ArrayList)this.children.clone();
        for (Object o : childrenCopy) {
            if (!(o instanceof FACS_panel)) continue;
            FACS_panel currentChild = (FACS_panel)o;
            currentChild.delete();
            this.theDocument.removeComponent(currentChild);
        }
        for (int i = 0; i < this.overlays.size(); ++i) {
            this.overlays.get(i).clear();
        }
        this.overlays.clear();
        this.overlays = null;
        this.quadrant = null;
        this.theRaG = null;
        this.theDocument = null;
    }

    public void deleteSelectedQuadrantMarker() {
        if (this.quadrant != null && this.quadrant.isSelected()) {
            this.quadrant = null;
            this.updateStatistics(1);
            return;
        }
        ArrayList temp = (ArrayList)this.markers.clone();
        for (FCS_marker currMarker : temp) {
            if (!currMarker.isSelected()) continue;
            this.markers.remove(currMarker);
            this.updateStatistics(3);
        }
    }

    public void displayRegion(FCS_region currRegion, boolean displayRegion) {
        visibleRegion toggleVis = null;
        for (int i = 0; i < this.regionsToDraw.size(); ++i) {
            if (this.regionsToDraw.get(i).region != currRegion) continue;
            toggleVis = this.regionsToDraw.get(i);
        }
        if (displayRegion && toggleVis == null) {
            this.regionsToDraw.add(new visibleRegion(currRegion));
        }
        if (!displayRegion && toggleVis != null) {
            this.regionsToDraw.remove(toggleVis);
        }
        this.repaint();
    }

    private void drawMarkers(Graphics g, Rectangle currentEventArea, boolean colorSelection) {
        if (this.plotType == 2) {
            for (FCS_marker currMarker : this.markers) {
                if (currMarker.isSelected() && colorSelection) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                int start_x = (int)((double)currMarker.getLowerLimit() / this.overlays.get(0).factor_x);
                int end_x = (int)((double)currMarker.getUpperLimit() / this.overlays.get(0).factor_x);
                int calc_y = currentEventArea.height - 1 - (int)(currMarker.getDisplayHeight() * (float)currentEventArea.height);
                end_x += currentEventArea.x;
                calc_y += currentEventArea.y;
                boolean drawStartSquare = true;
                boolean drawEndSquare = true;
                if ((start_x += currentEventArea.x) < currentEventArea.x) {
                    start_x = currentEventArea.x;
                    drawStartSquare = false;
                }
                if (end_x < currentEventArea.x || start_x > currentEventArea.x + currentEventArea.width) break;
                if (end_x > currentEventArea.x + currentEventArea.width) {
                    end_x = currentEventArea.x + currentEventArea.width;
                    drawEndSquare = false;
                }
                if (calc_y < currentEventArea.y || calc_y > currentEventArea.y + currentEventArea.height) break;
                g.drawLine(start_x, calc_y, end_x, calc_y);
                if (drawStartSquare) {
                    g.drawLine(start_x, calc_y - 5, start_x, calc_y + 5);
                }
                if (drawEndSquare) {
                    g.drawLine(end_x, calc_y - 5, end_x, calc_y + 5);
                }
                if (currMarker.isSelected() && colorSelection) {
                    if (drawStartSquare) {
                        g.fillRect(start_x - 2, calc_y - 2, 5, 5);
                    }
                    if (drawEndSquare) {
                        g.fillRect(end_x - 2, calc_y - 2, 5, 5);
                    }
                }
                String name = currMarker.getName();
                Rectangle2D bounds = g.getFontMetrics().getStringBounds(name, g);
                int halfWidth = (int)Math.round(bounds.getWidth() / 2.0);
                int posy = calc_y - 5;
                int posx = start_x + (end_x - start_x) / 2 - halfWidth;
                g.drawString(name, posx, posy);
            }
            if (this.drawingMarker != null) {
                g.setColor(Color.red);
                int start_x = (int)((double)this.drawingMarker.getLowerLimit() / this.overlays.get(0).factor_x);
                int end_x = (int)((double)this.drawingMarker.getUpperLimit() / this.overlays.get(0).factor_x);
                int calc_y = currentEventArea.height - 1 - (int)(this.drawingMarker.getDisplayHeight() * (float)currentEventArea.height);
                g.drawLine(start_x += currentEventArea.x, currentEventArea.y, start_x, currentEventArea.y + currentEventArea.height);
                g.drawLine(end_x += currentEventArea.x, currentEventArea.y, end_x, currentEventArea.y + currentEventArea.height);
                if ((calc_y += currentEventArea.y) < currentEventArea.y) {
                    return;
                }
                if (calc_y > currentEventArea.y + currentEventArea.height) {
                    return;
                }
                g.drawLine(start_x, calc_y, end_x, calc_y);
            }
        }
    }

    private void drawQuadrant(Graphics g, Rectangle currentEventArea, boolean colorSelection) {
        if (this.quadrant != null && this.plotType != 2) {
            if (this.quadrant.isSelected() && colorSelection) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            int calc_x = (int)((double)this.quadrant.getX() / this.overlays.get(0).factor_x);
            int calc_y = currentEventArea.height - 1 - (int)((double)this.quadrant.getY() / this.overlays.get(0).factor_y);
            calc_y += currentEventArea.y;
            if ((calc_x += currentEventArea.x) > currentEventArea.x) {
                g.drawLine(calc_x, currentEventArea.y, calc_x, currentEventArea.height + currentEventArea.y);
            }
            if (calc_y > currentEventArea.y) {
                g.drawLine(currentEventArea.x, calc_y, currentEventArea.width + currentEventArea.x, calc_y);
            }
            if (this.quadrant.isSelected() && colorSelection) {
                g.fillRect(calc_x - 2, calc_y - 2, 5, 5);
            }
        }
    }

    private void drawRegions(Graphics g, Rectangle currentEventArea, boolean colorSelection) {
        if (this.plotType != 2) {
            for (int i = 0; i < this.regionsToDraw.size(); ++i) {
                int posy;
                int posx;
                visibleRegion currentVisibleRegion = this.regionsToDraw.get(i);
                FCS_region currentRegion = currentVisibleRegion.region;
                if (!currentRegion.areRegionParameters(this.overlays.get(0).paramX, this.overlays.get(0).paramY)) continue;
                if (currentRegion.isSelected() && colorSelection) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                Polygon currentShape = this.getTransformedShape(currentRegion.getShape());
                g.drawPolygon(currentShape);
                if (currentRegion.isSelected() && colorSelection) {
                    for (int j = 0; j < currentShape.npoints; ++j) {
                        int x = currentShape.xpoints[j];
                        int y = currentShape.ypoints[j];
                        g.fillRect(x - 2, y - 2, 5, 5);
                    }
                }
                String name = currentRegion.getName();
                Point nameLoc = currentVisibleRegion.regionLocationInChannels;
                Rectangle2D nameBounds = g.getFontMetrics().getStringBounds(name, g);
                if (nameLoc != null) {
                    posx = (int)(nameLoc.getX() / this.overlays.get(0).factor_x) + currentEventArea.x;
                    posy = currentEventArea.height - 1 - (int)(nameLoc.getY() / this.overlays.get(0).factor_y) + currentEventArea.y;
                } else {
                    int halfWidth = (int)Math.round(nameBounds.getWidth() / 2.0);
                    int halfHeight = (int)Math.round(nameBounds.getHeight() / 2.0);
                    Rectangle2D regionBounds = currentShape.getBounds2D();
                    posx = (int)Math.round(regionBounds.getX() + regionBounds.getWidth() / 2.0) - halfWidth;
                    posy = (int)Math.round(regionBounds.getY() + regionBounds.getHeight() / 2.0) + halfHeight;
                    int channel_x = posx - currentEventArea.x;
                    channel_x = (int)((double)channel_x * this.overlays.get(0).factor_x);
                    int channel_y = posy - currentEventArea.y;
                    channel_y = currentEventArea.height - channel_y;
                    channel_y = (int)((double)channel_y * this.overlays.get(0).factor_y);
                    currentVisibleRegion.regionLocationInChannels = new Point(channel_x, channel_y);
                }
                nameBounds = g.getFontMetrics().getStringBounds(name, g);
                Rectangle stringBounds = new Rectangle(posx, posy - (int)nameBounds.getHeight() + 1, (int)nameBounds.getWidth(), (int)nameBounds.getHeight());
                g.setColor(Color.lightGray);
                g.fillRect(stringBounds.x - 1, stringBounds.y + 2, stringBounds.width + 2, stringBounds.height);
                g.setColor(Color.black);
                g.drawString(name, posx, posy);
                currentVisibleRegion.regionNameSize = stringBounds;
            }
            if (this.regionIsBeingDrawn && colorSelection) {
                g.setColor(Color.red);
                int[] x = Arrays.copyOf(this.drawingRegion.getShape().xpoints, this.drawingRegion.getShape().npoints + 1);
                int[] y = Arrays.copyOf(this.drawingRegion.getShape().ypoints, this.drawingRegion.getShape().npoints + 1);
                x[this.drawingRegion.getShape().npoints] = this.drawingPoint.x;
                y[this.drawingRegion.getShape().npoints] = this.drawingPoint.y;
                g.drawPolyline(x, y, this.drawingRegion.getShape().npoints + 1);
            }
        }
    }

    @Override
    public synchronized FACS_plot duplicate() {
        FACS_plot returnPlot = new FACS_plot(this.getFCS_Document());
        for (int i = 0; i < this.overlays.size(); ++i) {
            returnPlot.overlays.add(this.overlays.get(i).createCopy());
        }
        returnPlot.duplicateFontSize(this.getFontSize());
        returnPlot.view = this.view;
        returnPlot.view_width = this.view_width;
        returnPlot.view_height = this.view_height;
        returnPlot.x_axis_Area = new Rectangle(this.x_axis_Area);
        returnPlot.y_axis_Area = new Rectangle(this.y_axis_Area);
        returnPlot.plotArea = new Rectangle(this.plotArea);
        returnPlot.eventArea = new Rectangle(this.eventArea);
        returnPlot.listXaxis = this.listXaxis;
        returnPlot.theRaG = this.theRaG;
        returnPlot.drawingRegion = this.drawingRegion;
        returnPlot.regionIsBeingDrawn = this.regionIsBeingDrawn;
        returnPlot.selectedRegionPoint = this.selectedRegionPoint;
        returnPlot.regionsToDraw.addAll(this.regionsToDraw);
        returnPlot.selectedName = this.selectedName;
        returnPlot.selectedNameXOffset = this.selectedNameXOffset;
        returnPlot.selectedNameYOffset = this.selectedNameYOffset;
        returnPlot.drawingPoint = this.drawingPoint;
        returnPlot.gatesRGB = this.gatesRGB;
        returnPlot.mousePressedPoint = this.mousePressedPoint;
        returnPlot.mousePressedTranformedRegion = this.mousePressedTranformedRegion;
        returnPlot.statisticsStatus = this.statisticsStatus;
        returnPlot.plotType = this.plotType;
        returnPlot.drawingMarker = this.drawingMarker;
        returnPlot.selectedMarkerPoint = this.selectedMarkerPoint;
        returnPlot.mouseDragPoint = this.mouseDragPoint;
        returnPlot.paintLocalEvents = this.paintLocalEvents;
        returnPlot.setOpaque(this.isOpaque());
        if (this.quadrant != null) {
            returnPlot.quadrant = this.quadrant.duplicate();
        }
        for (FCS_marker currMarker : this.markers) {
            returnPlot.markers.add(currMarker.duplicate());
        }
        ListModel lData = this.axisList.getModel();
        ArrayList lArray = new ArrayList();
        for (int i = 0; i < lData.getSize(); ++i) {
            lArray.add(lData.getElementAt(i));
        }
        returnPlot.axisList.setListData(lArray.toArray());
        returnPlot.setSelected(this.getRememberedSelection());
        returnPlot.rememberSelection();
        returnPlot.setSelected(this.isSelected());
        returnPlot.setBounds(this.getBounds());
        for (FACS_panel currentChild : this.children) {
            if (!currentChild.isSelected()) continue;
            FACS_panel newChild = currentChild.duplicate();
            if (newChild instanceof FACS_annotation) {
                ((FACS_annotation)newChild).setParentPlot(returnPlot, false);
            }
            if (newChild instanceof FACS_statistics) {
                try {
                    ((FACS_statistics)newChild).setParentPlot(returnPlot, false);
                }
                catch (IOException io) {
                    JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
                }
            }
            returnPlot.children.add(newChild);
        }
        return returnPlot;
    }

    private void duplicateFontSize(Float fontSize) {
        super.setFontSize(fontSize);
    }

    public void gateDeleted(FCS_gate delGate) {
        boolean change = false;
        for (overlaySettings currO : this.overlays) {
            if (currO.appliedGate != delGate) continue;
            currO.appliedGate = null;
            change = true;
        }
        if (change) {
            this.updateViewAndStatistics(true);
        }
    }

    public Collection<? extends FACS_panel> getChildren() {
        return new ArrayList<FACS_panel>(this.children);
    }

    public int getColorType(int overlay) {
        return this.overlays.get(overlay).colorType;
    }

    public FCS_data getData(int overlay) {
        return this.overlays.get((int)overlay).overlayData;
    }

    @Override
    public void setDragType(int newType) {
        super.setDragType(newType);
        if (this.getDragType() == -1) {
            if (this.paintLocalEvents == 2) {
                this.view = null;
            }
            this.paintLocalEvents = 0;
            this.repaint();
        } else if (this.getDragType() != 4) {
            this.paintLocalEvents = 2;
        }
    }

    public String getFileName(int overlay) {
        return this.overlays.get((int)overlay).overlayData.getDataFileName();
    }

    public ImageIcon getFillColor(int overlay) {
        return this.overlays.get(overlay).fillColorImageIcon;
    }

    @Override
    public void setFontSize(Float newSize) {
        this.view = null;
        super.setFontSize(newSize);
    }

    public FCS_gate getGate(int overlay) {
        return this.overlays.get(overlay).appliedGate;
    }

    public int getGateIndex(int overlay) {
        return this.theRaG.indexOf(this.overlays.get(overlay).appliedGate);
    }

    public String[] getGates() {
        return this.theRaG.getGateDescription();
    }

    public ArrayList<String> getKeywordsDescription(int overlay) {
        return this.overlays.get((int)overlay).overlayData.getKeywordsDescription();
    }

    public ArrayList<String> getKeywordsTEXT(int overlay) {
        return this.overlays.get((int)overlay).overlayData.getKeywordsTEXT();
    }

    public int getLineType(int overlay) {
        return this.overlays.get(overlay).strokePattern;
    }

    public int getLineWidth(int overlay) {
        return this.overlays.get(overlay).strokeWidth;
    }

    public int getManualScale(int overlay) {
        return this.overlays.get(overlay).manualScale;
    }

    public ArrayList<FCS_marker> getMarkers() {
        return new ArrayList<FCS_marker>(this.markers);
    }

    public int getOverlayCount() {
        return this.overlays.size();
    }

    public BufferedImage getOverlayLegendImage(int overlay) {
        overlaySettings currOv = this.overlays.get(overlay);
        int height = 12;
        int totalWidth = 40;
        int width = 32;
        BufferedImage toReturn = new BufferedImage(totalWidth, height, 1);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < totalWidth; ++j) {
                toReturn.setRGB(j, i, Color.WHITE.getRGB());
            }
        }
        if (currOv.colorType == 0) {
            Graphics2D g = (Graphics2D)toReturn.getGraphics();
            g.setFont(g.getFont().deriveFont(10.0f));
            g.setColor(Color.BLACK);
            g.drawString("-multi-", 1, 10);
            g.dispose();
        } else {
            int color = 0;
            if (currOv.colorType == 1) {
                FCS_gate theGate = currOv.appliedGate;
                if (theGate != null) {
                    color = theGate.getColor();
                }
            } else {
                color = currOv.outerColor;
            }
            if (this.plotType == 0) {
                for (int i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        toReturn.setRGB(j, i, color);
                    }
                }
            }
            if (this.plotType == 1) {
                if (currOv.densityType == -3 && currOv.densityParam_1 != -1) {
                    Graphics2D g = (Graphics2D)toReturn.getGraphics();
                    g.setFont(g.getFont().deriveFont(10.0f));
                    g.setColor(Color.BLACK);
                    g.drawString("-3par-", 1, 10);
                    g.dispose();
                } else {
                    Color theColor = Color.BLACK;
                    int grad = -1;
                    switch (currOv.colorType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            if (currOv.appliedGate == null) break;
                            theColor = new Color(this.gatesRGB[this.theRaG.indexOf(currOv.appliedGate)]);
                            break;
                        }
                        case 2: {
                            theColor = new Color(currOv.outerColor);
                            break;
                        }
                        default: {
                            grad = currOv.colorType;
                        }
                    }
                    int[] cGradient = colorGradient.createGradient(theColor, Color.WHITE, colorGradient.gradientSteps);
                    if (grad != -1) {
                        if ((grad -= 3) < 0) {
                            grad = 0;
                        }
                        if (grad >= this.theDocument.getColorGradientCount()) {
                            grad = this.theDocument.getColorGradientCount() - 1;
                        }
                        if (grad >= 0) {
                            cGradient = this.theDocument.getGradient(grad);
                        }
                    }
                    for (int i = 0; i < width; ++i) {
                        for (int j = 0; j < height; ++j) {
                            toReturn.setRGB(i, j, cGradient[i]);
                        }
                    }
                }
            }
            if (this.plotType == 2) {
                Graphics2D g = (Graphics2D)toReturn.getGraphics();
                g.setStroke(currOv.theStroke);
                g.setColor(new Color(color));
                g.drawRect(1, 1, width - 2, height - 2);
                if (currOv.fillHistogram) {
                    g.setStroke(new BasicStroke());
                    g.setColor(new Color(currOv.fillColor));
                    g.fillRect(2, 2, width - 3, height - 3);
                }
                g.dispose();
            }
        }
        return toReturn;
    }

    public void setPaintingForExport(boolean forExport) {
        this.isPaintingForExport = forExport;
    }

    public int getParamX(int overlay) {
        return this.overlays.get(overlay).paramX;
    }

    public String getParamXLabel(int overlay) {
        return this.overlays.get((int)overlay).overlayData.getParameterLabel(this.overlays.get(overlay).paramX);
    }

    public int getParamY(int overlay) {
        return this.overlays.get(overlay).paramY;
    }

    public String getParamYLabel(int overlay) {
        return this.overlays.get((int)overlay).overlayData.getParameterLabel(this.overlays.get(overlay).paramY);
    }

    public String[] getParameters(int overlay) {
        return this.overlays.get((int)overlay).overlayData.getParameterLabels();
    }

    public FCS_quadrant getQuadrant() {
        return this.quadrant;
    }

    public FCS_RegionGatesHolder getRaG() {
        return this.theRaG;
    }

    public String getRegionNamesToDraw() {
        StringBuilder toReturn = new StringBuilder();
        for (visibleRegion visR : this.regionsToDraw) {
            toReturn.append(visR.region.getName());
            toReturn.append("|");
        }
        if (toReturn.length() == 0) {
            return "";
        }
        return toReturn.substring(0, toReturn.length() - 1);
    }

    public ArrayList getRegionToDraw() {
        ArrayList<FCS_region> toReturn = new ArrayList<FCS_region>();
        for (visibleRegion currR : this.regionsToDraw) {
            toReturn.add(currR.region);
        }
        return toReturn;
    }

    public int getScaleType(int overlay) {
        return this.overlays.get(overlay).scaleType;
    }

    @Override
    public void setSelected(boolean newValue) {
        super.setSelected(newValue);
        if (!newValue) {
            if (this.quadrant != null) {
                this.quadrant.setSelected(false);
            }
            for (FCS_region currentRegion : this.theRaG.getRegions()) {
                currentRegion.setSelected(false);
            }
            for (FCS_marker currentMarker : this.markers) {
                currentMarker.setSelected(false);
            }
        }
    }

    public int getStep(int overlay) {
        return this.overlays.get(overlay).step;
    }

    private Polygon getTransformedShape(Polygon theShape) {
        Polygon returnShape = new Polygon();
        for (int i = 0; i < theShape.npoints; ++i) {
            int calc_x = (int)((double)theShape.xpoints[i] / this.overlays.get(0).factor_x) + this.eventArea.x;
            int calc_y = this.eventArea.height - 1 - (int)((double)theShape.ypoints[i] / this.overlays.get(0).factor_y) + this.eventArea.y;
            returnShape.addPoint(calc_x, calc_y);
        }
        return returnShape;
    }

    public void setType(short newType) {
        this.plotType = newType;
        if (this.plotType != 0) {
            for (overlaySettings currOv : this.overlays) {
                if (currOv.colorType != 0) continue;
                currOv.colorType = 2;
            }
        }
    }

    public ImageIcon getUserColor(int overlay) {
        return this.overlays.get(overlay).outerColorImageIcon;
    }

    public String getValueTEXT(int overlay, int index) {
        return this.overlays.get((int)overlay).overlayData.getValueTEXT(index);
    }

    public String getValueTEXT(int overlay, String annotationKeyword) {
        return this.overlays.get((int)overlay).overlayData.getValueTEXT(annotationKeyword);
    }

    public ArrayList<String> getValuesTEXT(int overlay) {
        return this.overlays.get((int)overlay).overlayData.getValuesTEXT();
    }

    public void setXParameter(int newX) {
        for (int current = 0; current < this.overlays.size(); ++current) {
            this.setXParameter(current, newX);
        }
    }

    public void setYParameter(int newY) {
        for (int current = 0; current < this.overlays.size(); ++current) {
            this.setYParameter(current, newY);
        }
    }

    public boolean isDensityPlot() {
        return this.plotType == 1;
    }

    public boolean isHistogram() {
        return this.plotType == 2;
    }

    public boolean isHistogramFilled(int overlay) {
        return this.overlays.get(overlay).fillHistogram;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int count;
        if (!(this.theDocument.drawQuadrant() || this.theDocument.drawRegion() || this.theDocument.drawMarker())) {
            int e_x = e.getX();
            int e_y = e.getY();
            e_x = (int)Math.round((double)(e_x - this.eventArea.x) * this.overlays.get(0).factor_x);
            e_y = (int)Math.round((double)(this.eventArea.height - (e_y - this.eventArea.y)) * this.overlays.get(0).factor_y);
            Point calculatedPoint = new Point(e_x, e_y);
            int pixel_width = 5;
            int distance_x = (int)Math.round((double)pixel_width * this.overlays.get(0).factor_x);
            int distance_y = (int)Math.round((double)pixel_width * this.overlays.get(0).factor_y);
            if (this.quadrant != null && this.quadrant.isNearFrame(calculatedPoint, distance_x, distance_y)) {
                this.theDocument.clearSelections();
                this.quadrant.setSelected(true);
                this.repaint();
                return;
            }
            if (this.plotType != 2) {
                for (FCS_region currentRegion : this.theRaG.getRegions()) {
                    currentRegion.setSelected(false);
                }
                for (int i = 0; i < this.regionsToDraw.size(); ++i) {
                    visibleRegion visRegion = this.regionsToDraw.get(i);
                    FCS_region currentRegion = visRegion.region;
                    if (!currentRegion.areRegionParameters(this.overlays.get(0).paramX, this.overlays.get(0).paramY) || !currentRegion.isNearFrame(calculatedPoint, distance_x, distance_y)) continue;
                    this.theDocument.clearSelections();
                    currentRegion.setSelected(true);
                    this.repaint();
                    return;
                }
            } else {
                for (FCS_marker currentMarker : this.markers) {
                    currentMarker.setSelected(false);
                }
                for (FCS_marker currentMarker : this.markers) {
                    calculatedPoint.y = this.eventArea.height - (e.getY() - this.eventArea.y);
                    distance_y = 10;
                    if (!currentMarker.isNearFrame(calculatedPoint, distance_x, distance_y, this.eventArea.height)) continue;
                    this.theDocument.clearSelections();
                    currentMarker.setSelected(true);
                    this.repaint();
                    return;
                }
            }
            this.repaint();
        }
        if (this.theDocument.drawQuadrant()) {
            return;
        }
        if (this.theDocument.drawMarker()) {
            return;
        }
        if (this.theDocument.drawRegion()) {
            return;
        }
        if (this.x_axis_Area.contains(e.getPoint())) {
            this.axisScroller.setBounds((int)this.x_axis_Area.getX() + this.getX(), this.getY() + (int)this.x_axis_Area.getY(), 150, 100);
            this.performActions = false;
            count = this.overlays.get((int)0).overlayData.getTotalParameterCount();
            String[] data = new String[count];
            for (int k = 0; k < count; ++k) {
                data[k] = this.overlays.get((int)0).overlayData.getParameterLabel(k);
            }
            this.axisList.setListData(data);
            this.axisList.setSelectedIndex(this.overlays.get(0).paramX);
            this.axisList.ensureIndexIsVisible(this.overlays.get(0).paramX);
            this.performActions = true;
            this.axisScroller.setVisible(true);
            this.getFCS_Document().putInFront(this.axisScroller);
            this.listXaxis = true;
            if (!this.isSelected()) {
                super.mouseClicked(e);
            }
            return;
        }
        if (this.y_axis_Area.contains(e.getPoint())) {
            this.axisScroller.setBounds(2 + this.getX(), (int)this.y_axis_Area.getY() + 75 - 10 + this.getY(), 150, 100);
            this.performActions = false;
            count = this.overlays.get((int)0).overlayData.getTotalParameterCount();
            String[] data = new String[count];
            for (int k = 0; k < count; ++k) {
                data[k] = this.overlays.get((int)0).overlayData.getParameterLabel(k);
            }
            this.axisList.setListData(data);
            this.axisList.setSelectedIndex(this.overlays.get(0).paramY);
            this.axisList.ensureIndexIsVisible(this.overlays.get(0).paramY);
            this.performActions = true;
            this.axisScroller.setVisible(true);
            this.getFCS_Document().putInFront(this.axisScroller);
            this.listXaxis = false;
            if (!this.isSelected()) {
                super.mouseClicked(e);
            }
            return;
        }
        this.axisScroller.setVisible(false);
        super.mouseClicked(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.plotType != 2) {
            if (this.theDocument.drawRegion()) {
                return;
            }
            if (this.theDocument.drawQuadrant()) {
                this.quadrant = this.calculateQuadrant(e);
                if (!this.quadrant.isSelected()) {
                    this.theDocument.clearSelections();
                    this.quadrant.setSelected(true);
                }
                this.statisticsStatus = 2;
                this.repaint();
                return;
            }
        } else if (this.theDocument.drawMarker()) {
            FCS_quadrant temp = this.calculateQuadrant(e);
            this.drawingMarker.setUpperLimit(temp.getX());
            float height = this.eventArea.height - (e.getPoint().y - this.eventArea.y);
            this.drawingMarker.setDisplayHeight(height /= (float)this.eventArea.height);
            this.repaint();
            return;
        }
        if (this.plotType != 2) {
            if (this.selectedName != -1) {
                Rectangle currRec = this.regionsToDraw.get(this.selectedName).regionNameSize;
                e.translatePoint(this.selectedNameXOffset, this.selectedNameYOffset);
                e.translatePoint(0, (int)currRec.getHeight());
                FCS_quadrant newQuadrant = this.calculateQuadrant(e);
                this.regionsToDraw.get(this.selectedName).regionLocationInChannels = new Point(newQuadrant.getX(), newQuadrant.getY());
                Rectangle newRec = new Rectangle(e.getPoint().x, e.getPoint().y - (int)currRec.getHeight() - 1, (int)currRec.getWidth(), (int)currRec.getHeight());
                this.regionsToDraw.get(this.selectedName).regionNameSize = newRec;
                this.repaint();
                return;
            }
            if (this.quadrant != null && this.quadrant.isSelected()) {
                this.quadrant = this.calculateQuadrant(e);
                this.statisticsStatus = 2;
                if (!this.quadrant.isSelected()) {
                    this.theDocument.clearSelections();
                    this.quadrant.setSelected(true);
                }
                this.repaint();
                return;
            }
            FCS_region selectedRegion = null;
            for (FCS_region currentRegion : this.theRaG.getRegions()) {
                if (currentRegion.isSelected()) {
                    selectedRegion = currentRegion;
                }
                if (selectedRegion == null) continue;
                break;
            }
            if (selectedRegion != null) {
                if (this.selectedRegionPoint != -1) {
                    Polygon originalShape = selectedRegion.getShape();
                    int newX = (int)Math.round((double)(e.getX() - this.eventArea.x) * this.overlays.get(0).factor_x);
                    int newY = (int)Math.round((double)(this.eventArea.height - (e.getY() - this.eventArea.y)) * this.overlays.get(0).factor_y);
                    originalShape.xpoints[this.selectedRegionPoint] = newX;
                    originalShape.ypoints[this.selectedRegionPoint] = newY;
                    selectedRegion.setShape(originalShape);
                } else {
                    int move_x = e.getX() - this.mousePressedPoint.x;
                    int move_y = e.getY() - this.mousePressedPoint.y;
                    Polygon originalShape = selectedRegion.getShape();
                    for (int i = 0; i < originalShape.npoints; ++i) {
                        originalShape.xpoints[i] = this.mousePressedTranformedRegion.xpoints[i] + move_x;
                        originalShape.ypoints[i] = this.mousePressedTranformedRegion.ypoints[i] + move_y;
                    }
                    selectedRegion.setShape(this.transformToChannels(originalShape, this.eventArea));
                }
                this.statisticsStatus = 0;
                this.repaint();
                return;
            }
        } else {
            FCS_marker selectedMarker = null;
            for (FCS_marker currentMarker : this.markers) {
                if (!currentMarker.isSelected()) continue;
                selectedMarker = currentMarker;
                break;
            }
            if (selectedMarker != null) {
                FCS_quadrant temp = this.calculateQuadrant(e);
                if (this.selectedMarkerPoint != -1) {
                    if (this.selectedMarkerPoint == 0) {
                        selectedMarker.setUpperLimit(selectedMarker.getUpperLimit());
                        selectedMarker.setLowerLimit(temp.getX());
                        float height = this.eventArea.height - (e.getPoint().y - this.eventArea.y);
                        selectedMarker.setDisplayHeight(height /= (float)this.eventArea.height);
                    } else {
                        selectedMarker.setLowerLimit(selectedMarker.getLowerLimit());
                        selectedMarker.setUpperLimit(temp.getX());
                        float height = this.eventArea.height - (e.getPoint().y - this.eventArea.y);
                        selectedMarker.setDisplayHeight(height /= (float)this.eventArea.height);
                    }
                } else {
                    float move_y;
                    int move_x;
                    if (this.mouseDragPoint == null) {
                        move_x = e.getX() - this.mousePressedPoint.x;
                        move_y = e.getY() - this.mousePressedPoint.y;
                    } else {
                        move_x = e.getX() - this.mouseDragPoint.x;
                        move_y = e.getY() - this.mouseDragPoint.y;
                    }
                    this.mouseDragPoint = e.getPoint();
                    move_x = (int)Math.round((double)move_x * this.overlays.get(0).factor_x);
                    int l = selectedMarker.getLowerLimit() + move_x;
                    int h = selectedMarker.getUpperLimit() + move_x;
                    selectedMarker.setLowerLimit(l);
                    selectedMarker.setUpperLimit(h);
                    float changedHeight = move_y / (float)this.eventArea.height;
                    changedHeight = -changedHeight + selectedMarker.getDisplayHeight();
                    selectedMarker.setDisplayHeight(changedHeight);
                }
                this.statisticsStatus = 3;
                this.repaint();
                return;
            }
        }
        super.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.axisScroller.setVisible(false);
        if (this.plotType != 2) {
            if (this.theDocument.drawRegion()) {
                this.setCursor(customCursors.getCursor(4));
                if (this.regionIsBeingDrawn) {
                    this.drawingPoint = e.getPoint();
                    this.repaint();
                }
                return;
            }
        } else if (this.theDocument.drawMarker()) {
            this.setCursor(customCursors.getCursor(6));
            return;
        }
        if (this.x_axis_Area.contains(e.getPoint()) || this.y_axis_Area.contains(e.getPoint())) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        if (this.eventArea.contains(e.getPoint()) && this.theDocument.drawQuadrant()) {
            this.setCursor(customCursors.getCursor(3));
            return;
        }
        for (visibleRegion currRegion : this.regionsToDraw) {
            if (!currRegion.regionNameSize.contains(e.getPoint())) continue;
            this.setCursor(Cursor.getPredefinedCursor(13));
            return;
        }
        if (this.eventArea.contains(e.getPoint())) {
            this.setCursor(customCursors.getCursor(2));
            return;
        }
        super.mouseMoved(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.plotType != 2) {
            if (this.theDocument.drawRegion()) {
                this.addPointToRegion(e);
                this.repaint();
                return;
            }
            if (this.theDocument.drawQuadrant()) {
                this.quadrant = this.calculateQuadrant(e);
                this.statisticsStatus = 3;
                if (!this.quadrant.isSelected()) {
                    this.theDocument.clearSelections();
                    this.quadrant.setSelected(true);
                }
                this.repaint();
                return;
            }
        } else if (this.theDocument.drawMarker()) {
            FCS_quadrant temp = this.calculateQuadrant(e);
            this.drawingMarker = new FCS_marker("M" + (this.markers.size() + 1));
            this.drawingMarker.setLowerLimit(temp.getX());
            this.drawingMarker.setUpperLimit(temp.getX());
            float height = this.eventArea.height - (e.getPoint().y - this.eventArea.y);
            this.drawingMarker.setDisplayHeight(height /= (float)this.eventArea.height);
            this.drawingMarker.setSelected(true);
            this.repaint();
            return;
        }
        if (this.plotType != 2) {
            FCS_region selectedRegion = null;
            this.selectedName = -1;
            for (int i = 0; i < this.regionsToDraw.size(); ++i) {
                if (!this.regionsToDraw.get(i).regionNameSize.contains(e.getPoint())) continue;
                this.selectedName = this.selectedName = i;
                this.selectedNameXOffset = ((visibleRegion)this.regionsToDraw.get((int)i)).regionNameSize.x - e.getPoint().x;
                this.selectedNameYOffset = ((visibleRegion)this.regionsToDraw.get((int)i)).regionNameSize.y - e.getPoint().y;
            }
            for (FCS_region currentRegion : this.theRaG.getRegions()) {
                if (currentRegion.isSelected()) {
                    selectedRegion = currentRegion;
                }
                if (selectedRegion == null) continue;
                break;
            }
            if (selectedRegion != null) {
                Polygon currentShape;
                this.mousePressedPoint = e.getPoint();
                this.mousePressedTranformedRegion = currentShape = this.getTransformedShape(selectedRegion.getShape());
                int e_x = e.getX();
                int e_y = e.getY();
                this.selectedRegionPoint = -1;
                for (int i = 0; i < currentShape.npoints; ++i) {
                    if (Math.abs(e_x - currentShape.xpoints[i]) < 5 && Math.abs(e_y - currentShape.ypoints[i]) < 5) {
                        this.selectedRegionPoint = i;
                    }
                    if (this.selectedRegionPoint == -1) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            FCS_marker selectedMarker = null;
            for (FCS_marker currentMarker : this.markers) {
                if (currentMarker.isSelected()) {
                    selectedMarker = currentMarker;
                }
                if (selectedMarker == null) continue;
                break;
            }
            if (selectedMarker != null) {
                this.mousePressedPoint = e.getPoint();
                FCS_quadrant temp = this.calculateQuadrant(e);
                int click_y = this.eventArea.height - (e.getY() - this.eventArea.y);
                int marker_y = (int)(selectedMarker.getDisplayHeight() * (float)this.eventArea.height);
                int lower_x = selectedMarker.getLowerLimit();
                int higher_x = selectedMarker.getUpperLimit();
                int range_x = (int)Math.round(5.0 * this.overlays.get(0).factor_x);
                int range_y = 5;
                this.selectedMarkerPoint = -1;
                if (Math.abs(temp.getX() - lower_x) < range_x && Math.abs(click_y - marker_y) < range_y) {
                    this.selectedMarkerPoint = 0;
                }
                if (Math.abs(temp.getX() - higher_x) < range_x && Math.abs(click_y - marker_y) < range_y) {
                    this.selectedMarkerPoint = 1;
                }
            }
        }
        super.mousePressed(e);
        if (this.getDragType() != -1 && this.getDragType() != 4) {
            this.paintLocalEvents = 2;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseDragPoint = null;
        if (this.plotType != 2) {
            if (this.theDocument.drawRegion()) {
                return;
            }
            if (this.theDocument.drawQuadrant()) {
                this.quadrant = this.calculateQuadrant(e);
                this.theDocument.setApplicationObjectType(2);
                this.quadrant.setSelected(false);
                this.updateStatistics(2);
                this.repaint();
                return;
            }
        } else if (this.theDocument.drawMarker()) {
            FCS_quadrant temp = this.calculateQuadrant(e);
            this.drawingMarker.setUpperLimit(temp.getX());
            float height = this.eventArea.height - (e.getPoint().y - this.eventArea.y);
            this.drawingMarker.setDisplayHeight(height /= (float)this.eventArea.height);
            this.drawingMarker.setSelected(false);
            this.theDocument.setApplicationObjectType(2);
            this.markers.add(this.drawingMarker);
            this.drawingMarker = null;
            this.updateStatistics(3);
            this.repaint();
            return;
        }
        this.paintLocalEvents = 0;
        if (this.getDragType() != 4 && this.getDragType() != -1) {
            this.view = null;
            this.repaint();
        }
        this.updateStatistics(this.statisticsStatus);
        super.mouseReleased(e);
    }

    public void moveOverlay(int indexOne, int indexTwo) {
        if (indexOne < 0 || indexTwo < 0) {
            return;
        }
        if (indexOne >= this.overlays.size() || indexTwo >= this.overlays.size()) {
            return;
        }
        if (indexOne == indexTwo) {
            return;
        }
        overlaySettings one = this.overlays.get(indexOne);
        this.overlays.set(indexOne, this.overlays.get(indexTwo));
        this.overlays.set(indexTwo, one);
        if (!this.regionsToDraw.isEmpty()) {
            FCS_region theRegion = this.regionsToDraw.get(0).region;
            if (this.overlays.get(0).paramX != theRegion.getParamX() || this.overlays.get(0).paramY != theRegion.getParamY()) {
                this.regionsToDraw.clear();
            }
        }
        this.view = null;
        this.repaint();
        this.updateStatistics(1);
        this.updateAnnotations();
    }

    @Override
    public void paint(Graphics g) {
        int height = this.getBounds().height;
        int width = this.getBounds().width;
        if ((this.view == null || width != this.view_width || height != this.view_height || this.isUpdatingLabels) && this.paintLocalEvents != 2 && height > 0 && width > 0) {
            this.view_width = width;
            this.view_height = height;
            BufferedImage temp = new BufferedImage(width, height, 1);
            Graphics2D g2 = (Graphics2D)temp.getGraphics();
            try {
                this.plotArea = this.createView(g2, width, height);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            g2.dispose();
            this.view = temp;
        }
        if (!this.isPaintingForPrint() && !this.isPaintingForExport && this.paintLocalEvents != 2) {
            g.drawImage(this.view, 0, 0, this);
        } else {
            if (this.paintLocalEvents != 2) {
                this.paintLocalEvents = 1;
            }
            this.createView((Graphics2D)g, width, height);
        }
        if (this.paintLocalEvents != 2) {
            this.drawQuadrant(g, this.eventArea, true);
            this.drawMarkers(g, this.eventArea, true);
            this.drawRegions(g, this.eventArea, true);
        }
        if (this.isPaintingForExport) {
            return;
        }
        this.drawBorder(g, !this.isPaintingForPrint());
        super.paint(g);
        this.isUpdatingLabels = false;
    }

    public void paste(Object content) {
        if (content instanceof FCS_marker) {
            this.markers.add(((FCS_marker)content).duplicate());
            this.updateStatistics(3);
            this.repaint();
        } else if (content instanceof FCS_quadrant) {
            this.quadrant = ((FCS_quadrant)content).duplicate();
            this.updateStatistics(2);
            this.repaint();
        } else if (content instanceof Integer) {
            int regIndex = (Integer)content;
            visibleRegion newReg = new visibleRegion(this.theRaG.getRegion(regIndex));
            this.regionsToDraw.add(newReg);
            Rectangle enclosing = this.theRaG.getRegion((Integer)content).getShape().getBounds();
            Point p = new Point();
            p.x = enclosing.x + enclosing.width / 2;
            p.y = enclosing.y + enclosing.height / 2;
            newReg.regionLocationInChannels = p;
            this.repaint();
        }
    }

    public void regionNamesChanged() {
        this.updateStatistics(-1);
        this.updateAnnotations();
        this.repaint();
    }

    public void removeChild(FACS_panel toRemove) {
        this.children.remove(toRemove);
    }

    @Override
    public void removeListeners() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.axisList.removeListSelectionListener(this);
    }

    public void removeOverlay(int index) {
        if (this.overlays.size() == 1) {
            return;
        }
        if (index == 0 && (this.overlays.get(0).paramX != this.overlays.get(1).paramX || this.overlays.get(0).paramY != this.overlays.get(1).paramY)) {
            this.regionsToDraw.clear();
        }
        this.overlays.remove(index);
        this.view = null;
        this.repaint();
        this.updateStatistics(1);
        this.updateAnnotations();
    }

    public void setColorType(int overlay, Integer newType) {
        if (this.overlays.get(overlay).colorType != newType) {
            this.overlays.get(overlay).colorType = newType;
            this.view = null;
            this.repaint();
            this.updateAnnotations();
        }
    }

    public synchronized void setData(int overlay, FCS_data paramData, int paramParamX, int paramParamY) {
        overlaySettings oS = this.overlays.get(overlay);
        boolean newData = false;
        if (oS.overlayData != paramData) {
            oS.overlayData = paramData;
            int newParamCount = paramData.getTotalParameterCount();
            if (oS.paramX >= newParamCount) {
                oS.paramX = 0;
            }
            if (oS.paramY >= newParamCount) {
                oS.paramY = 0;
            }
            oS.rangeX = paramData.getRange(oS.paramX);
            oS.rangeY = paramData.getRange(oS.paramY);
            newData = true;
            String[] data = new String[paramData.getTotalParameterCount()];
            for (int i = 0; i < paramData.getTotalParameterCount(); ++i) {
                data[i] = paramData.getParameterLabel(i);
            }
            this.performActions = false;
            if (overlay == 0) {
                this.axisList.setListData(data);
            }
            this.performActions = true;
        }
        if (oS.paramX != paramParamX) {
            oS.paramX = paramParamX;
            if (oS.paramX >= paramData.getTotalParameterCount()) {
                oS.paramX = 0;
            }
            oS.rangeX = paramData.getRange(oS.paramX);
            newData = true;
        }
        if (oS.paramY != paramParamY) {
            oS.paramY = paramParamY;
            if (oS.paramY >= paramData.getTotalParameterCount()) {
                oS.paramY = 0;
            }
            oS.rangeY = paramData.getRange(oS.paramY);
            newData = true;
        }
        if (newData) {
            this.view = null;
            if (this.plotType == 2) {
                oS.generateHistograms(oS.appliedGate);
            }
            this.repaint();
        }
        if (this.quadrant != null) {
            this.quadrant = new FCS_quadrant(this.quadrant.getX(), this.quadrant.getY());
        }
        this.updateAnnotations();
        this.updateStatistics(1);
    }

    public void setData(int overlay, FCS_data paramData) {
        this.setData(overlay, paramData, this.overlays.get(overlay).paramX, this.overlays.get(overlay).paramY);
    }

    public void setFillColor(int overlay, Integer newColor) {
        this.overlays.get(overlay).fillColor = newColor;
        this.overlays.get(overlay).generateColorImages();
        this.view = null;
        this.repaint();
        this.updateAnnotations();
    }

    public void setGate(int overlay, int selectedIndex) {
        FCS_gate newGate = this.theRaG.getGate(selectedIndex);
        if (this.overlays.get(overlay).appliedGate != newGate) {
            this.overlays.get(overlay).appliedGate = newGate;
            if (this.plotType == 2) {
                this.overlays.get(overlay).generateHistograms(this.theRaG.getGate(selectedIndex));
            }
            this.updateViewAndStatistics(true);
        }
    }

    public void setHistogramFilled(int overlay, Boolean paintFilled) {
        this.overlays.get(overlay).fillHistogram = paintFilled;
        this.view = null;
        this.repaint();
        this.updateAnnotations();
    }

    public void setLinePattern(int overlay, int newPattern) {
        overlaySettings oS = this.overlays.get(overlay);
        oS.strokePattern = newPattern;
        oS.theStroke = new BasicStroke(oS.strokeWidth, 0, 0, 1.0f, FACS_plot.PATTERNS[newPattern], 0.0f);
        this.view = null;
        this.repaint();
        this.updateAnnotations();
    }

    public void setLineWidth(int overlay, int newWidth) {
        overlaySettings oS = this.overlays.get(overlay);
        oS.strokeWidth = newWidth;
        oS.theStroke = new BasicStroke(FACS_plot.WIDTHS[newWidth], 0, 0, 1.0f, FACS_plot.PATTERNS[oS.strokePattern], 0.0f);
        this.view = null;
        this.repaint();
        this.updateAnnotations();
    }

    public void setManualScale(int overlay, Integer newScale) {
        this.overlays.get(overlay).manualScale = newScale;
        this.view = null;
        this.repaint();
    }

    public void setScaleType(int overlay, Integer newType) {
        this.overlays.get(overlay).scaleType = newType;
        this.view = null;
        this.repaint();
    }

    public void setStepToShow(int overlay, int newStep) {
        overlaySettings currentOv = this.overlays.get(overlay);
        if (newStep != currentOv.step) {
            if (newStep < 1) {
                currentOv.step = 1;
            } else {
                currentOv.step = newStep;
            }
            this.view = null;
            this.repaint();
        }
    }

    public void setUserColor(int overlay, Integer newColor) {
        if (this.overlays.get(overlay).outerColor != newColor) {
            this.overlays.get(overlay).outerColor = newColor;
            this.overlays.get(overlay).generateColorImages();
            this.view = null;
            this.repaint();
            this.updateAnnotations();
        }
    }

    public void setXParameter(int overlay, int newX) {
        this.setData(overlay, this.overlays.get((int)overlay).overlayData, newX, this.overlays.get(overlay).paramY);
    }

    public void setYParameter(int overlay, int newY) {
        if (!this.isHistogram()) {
            this.setData(overlay, this.overlays.get((int)overlay).overlayData, this.overlays.get(overlay).paramX, newY);
        }
    }

    public void showMarkerDialog() {
        if (this.plotType == 2) {
            markerDialog newDial = new markerDialog(this.markers);
            newDial.showDialog();
            this.updateStatistics(3);
            this.repaint();
        }
    }

    public void toXML(Node parent, List<Compensation> documentComps, ArrayList<FCS_data> usedData) {
        Node plot = staticMethods.addNode(parent, XML_NAME, null);
        String type = "";
        switch (this.plotType) {
            case 0: {
                type = XML_TYPE_DOT;
                break;
            }
            case 2: {
                type = XML_TYPE_HISTOGRAM;
                break;
            }
            case 1: {
                type = XML_TYPE_DENSITY;
            }
        }
        staticMethods.addNode(plot, XML_TYPE, type);
        Node bounds = staticMethods.addNode(plot, "Bounds", null);
        Rectangle r = this.getBounds();
        staticMethods.addNode(bounds, XML_QUADRANT_X, r.getX());
        staticMethods.addNode(bounds, "Y", r.getY());
        staticMethods.addNode(bounds, "Width", r.getWidth());
        staticMethods.addNode(bounds, "Height", r.getHeight());
        staticMethods.addNode(plot, "ZOrder", this.theDocument.getComponentZOrder(this));
        Node font = staticMethods.addNode(plot, "Font", null);
        staticMethods.addNode(font, "Size", this.getFont().getSize());
        for (overlaySettings currOs : this.overlays) {
            currOs.toXML(plot, usedData, this.theRaG);
        }
        if (this.quadrant != null) {
            Node qu = staticMethods.addNode(plot, XML_QUADRANT, null);
            staticMethods.addNode(qu, XML_QUADRANT_X, this.quadrant.getX());
            staticMethods.addNode(qu, "Y", this.quadrant.getY());
        }
        if (this.markers.size() > 0) {
            Node mark = staticMethods.addNode(plot, XML_MARKERS, null);
            for (FCS_marker currMarker : this.markers) {
                Node m = staticMethods.addNode(mark, XML_MARKER, null);
                staticMethods.addNode(m, XML_MARKER_NAME, currMarker.getName());
                staticMethods.addNode(m, XML_MARKER_LOWER, currMarker.getLowerLimit());
                staticMethods.addNode(m, XML_MARKER_UPPER, currMarker.getUpperLimit());
                staticMethods.addNode(m, "Y", Float.valueOf(currMarker.getDisplayHeight()));
            }
        }
        if (!this.regionsToDraw.isEmpty()) {
            Node reg = staticMethods.addNode(plot, XML_VISIBLE_REGIONS, null);
            for (int i = 0; i < this.regionsToDraw.size(); ++i) {
                Node currR = staticMethods.addNode(reg, XML_REGION, null);
                staticMethods.addNode(currR, XML_REGION_INDEX, this.theRaG.indexOf(this.regionsToDraw.get(i).region));
                staticMethods.addNode(currR, XML_REGION_X, ((visibleRegion)this.regionsToDraw.get((int)i)).regionLocationInChannels.x);
                staticMethods.addNode(currR, XML_REGION_Y, ((visibleRegion)this.regionsToDraw.get((int)i)).regionLocationInChannels.y);
            }
        }
        for (FACS_panel currentPanel : this.children) {
            if (currentPanel instanceof FACS_annotation) {
                ((FACS_annotation)currentPanel).toXML(plot);
                continue;
            }
            ((FACS_statistics)currentPanel).toXML(plot);
        }
    }

    public void toggleRegionVisibility(int overlay, Integer regionToToggle) {
        if (regionToToggle < 0) {
            return;
        }
        FCS_region toToggle = this.theRaG.getRegion(regionToToggle);
        int index = -1;
        for (int i = 0; i < this.regionsToDraw.size(); ++i) {
            if (this.regionsToDraw.get(i).region != toToggle) continue;
            index = i;
        }
        if (index < 0) {
            this.regionsToDraw.add(new visibleRegion(toToggle));
        } else {
            this.regionsToDraw.remove(index);
        }
        this.repaint();
    }

    private Polygon transformToChannels(Polygon theShape, Rectangle currentEventArea) {
        Polygon newShape = new Polygon();
        for (int i = 0; i < theShape.npoints; ++i) {
            int x = (int)Math.round((double)(theShape.xpoints[i] - currentEventArea.x) * this.overlays.get(0).factor_x);
            int y = (int)Math.round((double)(currentEventArea.height - (theShape.ypoints[i] - currentEventArea.y)) * this.overlays.get(0).factor_y);
            newShape.addPoint(x, y);
        }
        return newShape;
    }

    private void updateAnnotations() {
        for (FACS_panel currentChild : this.children) {
            if (!(currentChild instanceof FACS_annotation)) continue;
            ((FACS_annotation)currentChild).refresh();
        }
    }

    private void updateStatistics(int type) {
        this.statisticsStatus = -1;
        switch (type) {
            case 0: {
                this.theDocument.refreshView(true);
                return;
            }
            case 2: {
                ArrayList<FACS_statistics> toRemove = new ArrayList<FACS_statistics>();
                for (FACS_panel currentChild : this.children) {
                    if (!(currentChild instanceof FACS_statistics)) continue;
                    FACS_statistics curr = (FACS_statistics)currentChild;
                    curr.setQuadrant(this.quadrant);
                    try {
                        curr.refresh(true);
                    }
                    catch (IOException io) {
                        toRemove.add(curr);
                        JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
                    }
                }
                for (FACS_statistics curr : toRemove) {
                    this.children.remove(curr);
                    this.theDocument.removeComponent(curr);
                }
                return;
            }
            case 1: {
                ArrayList<FACS_statistics> toRemove = new ArrayList<FACS_statistics>();
                for (FACS_panel currentChild : this.children) {
                    if (!(currentChild instanceof FACS_statistics)) continue;
                    FACS_statistics curr = (FACS_statistics)currentChild;
                    curr.setQuadrant(this.quadrant);
                    try {
                        curr.refresh(true);
                    }
                    catch (IOException io) {
                        toRemove.add(curr);
                        JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
                    }
                }
                for (FACS_statistics curr : toRemove) {
                    this.children.remove(curr);
                    this.theDocument.removeComponent(curr);
                }
                return;
            }
            case 3: {
                ArrayList<FACS_statistics> toRemove = new ArrayList<FACS_statistics>();
                for (FACS_panel currentChild : this.children) {
                    if (!(currentChild instanceof FACS_statistics)) continue;
                    FACS_statistics curr = (FACS_statistics)currentChild;
                    curr.setMarkers(this.markers);
                    try {
                        curr.refresh(true);
                    }
                    catch (IOException io) {
                        toRemove.add(curr);
                        JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
                    }
                }
                for (FACS_statistics curr : toRemove) {
                    this.children.remove(curr);
                    this.theDocument.removeComponent(curr);
                }
                return;
            }
        }
        for (FACS_panel currentChild : this.children) {
            if (!(currentChild instanceof FACS_statistics)) continue;
            FACS_statistics curr = (FACS_statistics)currentChild;
            curr.setMarkers(this.markers);
            try {
                curr.refresh(false);
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
            }
        }
    }

    public void updateViewAndStatistics(boolean updateEvents) {
        if (updateEvents) {
            int i;
            this.paintLocalEvents = 0;
            FCS_data plotData = this.overlays.get((int)0).overlayData;
            String[] data = new String[plotData.getTotalParameterCount()];
            for (i = 0; i < plotData.getTotalParameterCount(); ++i) {
                data[i] = plotData.getParameterLabel(i);
            }
            this.performActions = false;
            this.axisList.setListData(data);
            this.performActions = true;
            for (i = 0; i < this.overlays.size(); ++i) {
                overlaySettings currentO = this.overlays.get(i);
                if (currentO.paramX >= currentO.overlayData.getTotalParameterCount()) {
                    currentO.paramX = currentO.overlayData.getTotalParameterCount() - 1;
                    currentO.rangeX = currentO.overlayData.getRange(currentO.paramX);
                }
                if (currentO.paramY < currentO.overlayData.getTotalParameterCount()) continue;
                currentO.paramY = currentO.overlayData.getTotalParameterCount() - 1;
                currentO.rangeY = currentO.overlayData.getRange(currentO.paramY);
            }
            this.view = null;
            for (i = 0; i < this.overlays.size(); ++i) {
                if (this.plotType != 2) continue;
                this.overlays.get(i).generateHistograms(this.overlays.get(i).appliedGate);
            }
            ArrayList<visibleRegion> toRemove = new ArrayList<visibleRegion>();
            for (visibleRegion currReg : this.regionsToDraw) {
                if (this.theRaG.indexOf(currReg.region) != -1) continue;
                toRemove.add(currReg);
            }
            this.regionsToDraw.removeAll(toRemove);
            this.updateStatistics(1);
        } else {
            this.isUpdatingLabels = true;
            this.paintLocalEvents = 1;
            FCS_data plotData = this.overlays.get((int)0).overlayData;
            String[] data = new String[plotData.getTotalParameterCount()];
            for (int i = 0; i < plotData.getTotalParameterCount(); ++i) {
                data[i] = plotData.getParameterLabel(i);
            }
            this.performActions = false;
            this.axisList.setListData(data);
            this.performActions = true;
            this.updateStatistics(-1);
        }
        this.updateAnnotations();
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.performActions) {
            if (this.listXaxis) {
                this.theDocument.setXParameter(this.axisList.getSelectedIndex());
                this.axisScroller.setVisible(false);
            } else {
                this.theDocument.setYParameter(this.axisList.getSelectedIndex());
                this.axisScroller.setVisible(false);
            }
        }
    }

    public void writeEvents(int overlay, BufferedWriter out, boolean rawdata) throws IOException {
        double[][][] cacheEvents;
        overlaySettings currentOverlay = this.overlays.get(overlay);
        FCS_data currentData = currentOverlay.overlayData;
        FCS_gate theGate = currentOverlay.appliedGate;
        int totalEvents = currentData.getEventCount();
        int currentEvent = -1;
        int parameterCount = currentData.getTotalParameterCount();
        StringBuilder toWrite = new StringBuilder();
        toWrite.append("Event#");
        for (int i = 0; i < parameterCount; ++i) {
            toWrite.append(",");
            toWrite.append(currentData.getParameterLabel(i));
        }
        toWrite.append("\n");
        out.write(toWrite.toString());
        int cacheStep = 100;
        int cachings = totalEvents / cacheStep;
        int rest = totalEvents % cacheStep;
        double[][] rawEvents = null;
        for (int i = 0; i < cachings; ++i) {
            toWrite = new StringBuilder();
            cacheEvents = currentData.getEvents(i * cacheStep, cacheStep);
            if (rawdata) {
                rawEvents = currentData.getRawEvents(i * cacheStep, cacheStep);
            }
            for (int m = 0; m < cacheStep; ++m) {
                ++currentEvent;
                double[] event = cacheEvents[0][m];
                if (theGate != null && !theGate.contains(event)) continue;
                double[] writeEvent = rawdata ? rawEvents[m] : cacheEvents[1][m];
                toWrite.append(currentEvent);
                for (int j = 0; j < parameterCount; ++j) {
                    toWrite.append(",");
                    toWrite.append(writeEvent[j]);
                }
                toWrite.append("\n");
            }
            out.write(toWrite.toString());
        }
        toWrite = new StringBuilder();
        cacheEvents = currentData.getEvents(cachings * cacheStep, rest);
        if (rawdata) {
            rawEvents = currentData.getRawEvents(cachings * cacheStep, rest);
        }
        for (int m = 0; m < rest; ++m) {
            ++currentEvent;
            double[] event = cacheEvents[0][m];
            if (theGate != null && !theGate.contains(event)) continue;
            double[] writeEvent = rawdata ? rawEvents[m] : cacheEvents[1][m];
            toWrite.append(currentEvent);
            for (int j = 0; j < parameterCount; ++j) {
                toWrite.append(",");
                toWrite.append(writeEvent[j]);
            }
            toWrite.append("\n");
        }
        out.write(toWrite.toString());
    }

    public int getDensityParam(int densityParam, int overlay) {
        if (densityParam == 1) {
            return this.overlays.get(overlay).densityParam_1;
        }
        if (densityParam == 2) {
            return this.overlays.get(overlay).densityParam_2;
        }
        if (densityParam == 3) {
            return this.overlays.get(overlay).densityParam_3;
        }
        return -1;
    }

    public void setDensityParam(int densityParam, int overlay, int newCalcParam) {
        if (newCalcParam < 0) {
            newCalcParam = -1;
        }
        switch (densityParam) {
            case 1: {
                if (this.overlays.get(overlay).densityParam_1 != newCalcParam) {
                    this.overlays.get(overlay).densityParam_1 = newCalcParam;
                    if (this.overlays.get(overlay).densityType == -2 || this.overlays.get(overlay).densityType == -3) {
                        this.view = null;
                        this.repaint();
                        this.updateAnnotations();
                    }
                    return;
                }
            }
            case 2: {
                if (this.overlays.get(overlay).densityParam_2 != newCalcParam) {
                    this.overlays.get(overlay).densityParam_2 = newCalcParam;
                    if (this.overlays.get(overlay).densityType == -3) {
                        this.view = null;
                        this.repaint();
                        this.updateAnnotations();
                    }
                    return;
                }
            }
            case 3: {
                if (this.overlays.get(overlay).densityParam_3 == newCalcParam) break;
                this.overlays.get(overlay).densityParam_3 = newCalcParam;
                if (this.overlays.get(overlay).densityType == -3) {
                    this.view = null;
                    this.repaint();
                    this.updateAnnotations();
                }
                return;
            }
        }
    }

    public int getDensityType(int overlay) {
        return this.overlays.get(overlay).densityType;
    }

    public void setDensityType(int overlay, int newType) {
        if ((newType == -1 || newType == -2 || newType == -3) && this.overlays.get(overlay).densityType != newType) {
            this.overlays.get(overlay).densityType = newType;
            this.view = null;
            this.repaint();
            this.updateAnnotations();
        }
    }

    private static class visibleRegion {
        private FCS_region region;
        private Rectangle regionNameSize;
        private Point regionLocationInChannels;

        private visibleRegion(FCS_region region) {
            this.region = region;
            this.regionNameSize = new Rectangle(-1, -1, 0, 0);
            this.regionLocationInChannels = null;
        }
    }

    private static class overlaySettings {
        FCS_data overlayData;
        int[][] histogram_events;
        private int step = 1;
        private double factor_x;
        private double factor_y;
        private int paramX;
        private int paramY;
        private long rangeX;
        private long rangeY;
        private FCS_gate appliedGate = null;
        public static final int MULTI_COLOR = 0;
        public static final int GATE_COLOR = 1;
        public static final int USER_COLOR = 2;
        private int colorType = 0;
        public static final int LOCAL_MAXIMUM = 0;
        public static final int GLOBAL_MAXIMUM = 1;
        public static final int USER_SCALE = 2;
        private int scaleType = 0;
        private int manualScale = 100;
        private int outerColor = Color.black.getRGB();
        private final int imageSize = 12;
        private final BufferedImage outerColorImage = new BufferedImage(12, 12, 1);
        private ImageIcon outerColorImageIcon = new ImageIcon(this.outerColorImage);
        private int fillColor = Color.black.getRGB();
        private boolean fillHistogram = false;
        private final BufferedImage fillColorImage = new BufferedImage(12, 12, 2);
        private ImageIcon fillColorImageIcon = new ImageIcon(this.fillColorImage);
        private int strokePattern = 0;
        private int strokeWidth = 0;
        private Stroke theStroke = new BasicStroke(WIDTHS[this.strokeWidth], 0, 0, 1.0f, PATTERNS[this.strokePattern], 0.0f);
        private int densityType = -1;
        private int densityParam_1 = -1;
        private int densityParam_2 = -1;
        private int densityParam_3 = -1;
        public static final String XML_NAME = "Overlay";
        private static final String XML_APPLIED_GATE = "AppliedGate";
        private static final String XML_PARAM_X = "Parameter_X";
        private static final String XML_PARAM_Y = "Parameter_Y";
        private static final String XML_STEP = "Step";
        private static final String XML_SCALE_TYPE = "ScaleType";
        private static final String XML_MANUAL_SCALE = "ManualScale";
        private static final String XML_COLOR_TYPE = "ColorType";
        private static final String XML_OUTER_COLOR = "OuterColor";
        private static final String XML_FILL_COLOR = "FillColor";
        private static final String XML_FILL_HISTOGRAM = "FillHistogram";
        private static final String XML_STROKE_WIDTH = "LineWidth";
        private static final String XML_STROKE_PATTERN = "LinePattern";
        private static final String XML_DATAFILE_INDEX = "DatafileIndex";
        private static final String XML_DENSITY_TYPE = "DensityType";
        private static final String XML_DENSITY_PARAM_1 = "DensityParam_1";
        private static final String XML_DENSITY_PARAM_2 = "DensityParam_2";
        private static final String XML_DENSITY_PARAM_3 = "DensityParam_3";

        private overlaySettings() {
            this.generateColorImages();
        }

        private void generateColorImages() {
            int j;
            int i;
            for (i = 0; i < 12; ++i) {
                for (j = 0; j < 12; ++j) {
                    this.outerColorImage.setRGB(i, j, this.outerColor);
                }
            }
            this.outerColorImageIcon.setImage(this.outerColorImage);
            this.fillColorImageIcon.setImage(this.fillColorImage);
            for (i = 0; i < 12; ++i) {
                for (j = 0; j < 12; ++j) {
                    this.fillColorImage.setRGB(i, j, this.fillColor);
                }
            }
            this.fillColorImageIcon.setImage(this.fillColorImage);
        }

        private void clear() {
            this.overlayData = null;
        }

        private overlaySettings createCopy() {
            overlaySettings toReturn = new overlaySettings();
            toReturn.densityParam_2 = this.densityParam_2;
            toReturn.densityParam_3 = this.densityParam_3;
            toReturn.appliedGate = this.appliedGate;
            toReturn.colorType = this.colorType;
            toReturn.densityType = this.densityType;
            toReturn.factor_x = this.factor_x;
            toReturn.factor_y = this.factor_y;
            toReturn.fillColor = this.fillColor;
            toReturn.fillHistogram = this.fillHistogram;
            toReturn.densityParam_1 = this.densityParam_1;
            if (this.histogram_events != null) {
                toReturn.histogram_events = (int[][])this.histogram_events.clone();
            }
            toReturn.manualScale = this.manualScale;
            toReturn.outerColor = this.outerColor;
            toReturn.overlayData = this.overlayData;
            toReturn.paramX = this.paramX;
            toReturn.paramY = this.paramY;
            toReturn.rangeX = this.rangeX;
            toReturn.rangeY = this.rangeY;
            toReturn.scaleType = this.scaleType;
            toReturn.step = this.step;
            toReturn.strokePattern = this.strokePattern;
            toReturn.strokeWidth = this.strokeWidth;
            toReturn.theStroke = this.theStroke;
            toReturn.generateColorImages();
            return toReturn;
        }

        private void toXML(Node parent, ArrayList<FCS_data> usedData, FCS_RegionGatesHolder theRaG) {
            Node ov = staticMethods.addNode(parent, XML_NAME, null);
            staticMethods.addNode(ov, XML_APPLIED_GATE, theRaG.indexOf(this.appliedGate));
            staticMethods.addNode(ov, XML_PARAM_X, this.paramX);
            staticMethods.addNode(ov, XML_PARAM_Y, this.paramY);
            staticMethods.addNode(ov, XML_STEP, this.step);
            staticMethods.addNode(ov, XML_SCALE_TYPE, this.scaleType);
            staticMethods.addNode(ov, XML_MANUAL_SCALE, this.manualScale);
            staticMethods.addNode(ov, XML_COLOR_TYPE, this.colorType);
            staticMethods.addNode(ov, XML_OUTER_COLOR, this.outerColor);
            staticMethods.addNode(ov, XML_FILL_COLOR, this.fillColor);
            staticMethods.addNode(ov, XML_FILL_HISTOGRAM, this.fillHistogram);
            staticMethods.addNode(ov, XML_STROKE_WIDTH, this.strokeWidth);
            staticMethods.addNode(ov, XML_STROKE_PATTERN, this.strokePattern);
            staticMethods.addNode(ov, XML_DATAFILE_INDEX, usedData.indexOf(this.overlayData));
            staticMethods.addNode(ov, XML_DENSITY_TYPE, this.densityType);
            staticMethods.addNode(ov, XML_DENSITY_PARAM_1, this.densityParam_1);
            staticMethods.addNode(ov, XML_DENSITY_PARAM_2, this.densityParam_2);
            staticMethods.addNode(ov, XML_DENSITY_PARAM_3, this.densityParam_3);
        }

        public overlaySettings(Node storedData, String oldFileSeparator, String oldPath, String currentPath, ArrayList<Compensation> documentCompensation, ArrayList<FCS_data> documentData, FCS_RegionGatesHolder theRaG) {
            NodeList nL = storedData.getChildNodes();
            for (int i = 0; i < nL.getLength(); ++i) {
                Node current = nL.item(i);
                String nameCurrent = current.getNodeName();
                if (nameCurrent.equals(XML_APPLIED_GATE)) {
                    this.appliedGate = theRaG.getGate(staticMethods.getNodeInteger(current, -1));
                    continue;
                }
                if (nameCurrent.equals(XML_PARAM_X)) {
                    this.paramX = staticMethods.getNodeInteger(current, this.paramX);
                    continue;
                }
                if (nameCurrent.equals(XML_PARAM_Y)) {
                    this.paramY = staticMethods.getNodeInteger(current, this.paramY);
                    continue;
                }
                if (nameCurrent.equals(XML_STEP)) {
                    this.step = staticMethods.getNodeInteger(current, this.step);
                    continue;
                }
                if (nameCurrent.equals(XML_SCALE_TYPE)) {
                    this.scaleType = staticMethods.getNodeInteger(current, this.scaleType);
                    continue;
                }
                if (nameCurrent.equals(XML_MANUAL_SCALE)) {
                    this.manualScale = staticMethods.getNodeInteger(current, this.manualScale);
                    continue;
                }
                if (nameCurrent.equals(XML_COLOR_TYPE)) {
                    this.colorType = staticMethods.getNodeInteger(current, this.colorType);
                    continue;
                }
                if (nameCurrent.equals(XML_OUTER_COLOR)) {
                    this.outerColor = staticMethods.getNodeInteger(current, this.outerColor);
                    continue;
                }
                if (nameCurrent.equals(XML_FILL_COLOR)) {
                    this.fillColor = staticMethods.getNodeInteger(current, this.fillColor);
                    continue;
                }
                if (nameCurrent.equals(XML_FILL_HISTOGRAM)) {
                    this.fillHistogram = staticMethods.getNodeBoolean(current);
                    continue;
                }
                if (nameCurrent.equals(XML_STROKE_WIDTH)) {
                    this.strokeWidth = staticMethods.getNodeInteger(current, this.strokeWidth);
                    continue;
                }
                if (nameCurrent.equals(XML_STROKE_PATTERN)) {
                    this.strokePattern = staticMethods.getNodeInteger(current, this.strokePattern);
                    continue;
                }
                if (nameCurrent.equals(XML_DENSITY_TYPE)) {
                    this.densityType = staticMethods.getNodeInteger(current, this.densityType);
                    continue;
                }
                if (nameCurrent.equals(XML_DENSITY_PARAM_1)) {
                    this.densityParam_1 = staticMethods.getNodeInteger(current, this.densityParam_1);
                    continue;
                }
                if (nameCurrent.equals(XML_DENSITY_PARAM_2)) {
                    this.densityParam_2 = staticMethods.getNodeInteger(current, this.densityParam_2);
                    continue;
                }
                if (nameCurrent.equals(XML_DENSITY_PARAM_3)) {
                    this.densityParam_3 = staticMethods.getNodeInteger(current, this.densityParam_3);
                    continue;
                }
                if (!nameCurrent.equals(XML_DATAFILE_INDEX)) continue;
                int index = staticMethods.getNodeInteger(current, 0);
                this.overlayData = documentData.get(index);
            }
            this.generateColorImages();
            this.theStroke = new BasicStroke(WIDTHS[this.strokeWidth], 0, 0, 1.0f, PATTERNS[this.strokePattern], 0.0f);
            this.rangeX = this.overlayData.getRange(this.paramX);
            this.rangeY = this.overlayData.getRange(this.paramY);
        }

        private int getPeakChannelEventCount(int paramHisto, FCS_gate theGate) {
            int peak = 0;
            int[] histogramEvent = this.getHistogramEvents(paramHisto, theGate);
            int m = histogramEvent.length - 1;
            for (int i = 1; i < m; ++i) {
                if (histogramEvent[i] <= peak) continue;
                peak = histogramEvent[i];
            }
            return peak;
        }

        private int[] getHistogramEvents(int paramHisto, FCS_gate theGate) {
            if (this.histogram_events == null) {
                this.generateHistograms(theGate);
            }
            return this.histogram_events[paramHisto];
        }

        private void generateHistograms(FCS_gate theGate) {
            int parCount = this.overlayData.getTotalParameterCount();
            int eventCount = this.overlayData.getEventCount();
            this.histogram_events = new int[parCount][];
            int cacheStep = 100;
            int cachings = eventCount / cacheStep;
            int rest = eventCount % cacheStep;
            double[] parameterRanges = new double[parCount];
            float[] binFactor = new float[parCount];
            for (int i = 0; i < parCount; ++i) {
                parameterRanges[i] = 4096.0;
                int binCount = 256;
                this.histogram_events[i] = new int[binCount];
                binFactor[i] = (float)(parameterRanges[i] / (double)binCount);
            }
            int maxBin = this.histogram_events[0].length - 1;
            for (int i = 0; i < cachings; ++i) {
                double[][] cacheEvents = this.overlayData.getEvents(i * cacheStep, cacheStep)[0];
                for (int m = 0; m < cacheStep; ++m) {
                    double[] event = cacheEvents[m];
                    if (theGate != null && !theGate.contains(event)) continue;
                    for (int currPar = 0; currPar < parCount; ++currPar) {
                        double currChannel = event[currPar];
                        int bin = (int)Math.floor(currChannel / (double)binFactor[currPar]);
                        if (bin > maxBin) {
                            bin = maxBin;
                        }
                        int[] nArray = this.histogram_events[currPar];
                        int n = bin;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
            double[][] cacheEvents = this.overlayData.getEvents(cachings * cacheStep, rest)[0];
            for (int m = 0; m < rest; ++m) {
                double[] event = cacheEvents[m];
                if (theGate != null && !theGate.contains(event)) continue;
                for (int currPar = 0; currPar < parCount; ++currPar) {
                    double currChannel = event[currPar];
                    int bin = (int)Math.floor((float)(currChannel / (double)binFactor[currPar]));
                    int[] nArray = this.histogram_events[currPar];
                    int n = bin;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
    }

    private class createView_viewInfos {
        int width;
        int height;
        long xAxisR;
        long yAxisR;
        int maxRange;
        int eventsWidth;
        int eventsHeight;
        boolean showYLabels = true;
        boolean showXLabels = true;
        boolean showYticks = true;
        boolean showXticks = true;
        overlaySettings baseOverlay;
        Rectangle plotAreaWithTicks;

        private createView_viewInfos() {
        }
    }
}

