/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FCS.FCS_RegionGatesHolder;
import FCSalyzer.FCS.FCS_region;
import FCSalyzer.GUI.regionGateDialog;
import java.awt.Polygon;
import java.util.ArrayList;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class regionTableModel
implements TableModel {
    private FCS_RegionGatesHolder theRaG;
    private ArrayList<FCS_region> theRegions;
    private regionGateDialog theDialog;
    private static String[] columns = new String[]{"Region Name", "X Parameter", "Y Parameter", "Points"};

    private regionTableModel() {
    }

    public regionTableModel(FCS_RegionGatesHolder paramRaG, regionGateDialog paramDialog) {
        this.theRaG = paramRaG;
        this.theRegions = this.theRaG.getRegions();
        this.theDialog = paramDialog;
    }

    @Override
    public int getRowCount() {
        return this.theRegions.size();
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.theRegions.get(rowIndex).getName();
            }
            case 1: {
                return this.theRegions.get(rowIndex).getParamX();
            }
            case 2: {
                return this.theRegions.get(rowIndex).getParamY();
            }
            case 3: {
                Polygon theShape = this.theRegions.get(rowIndex).getShape();
                StringBuilder temp = new StringBuilder();
                for (int i = 0; i < theShape.npoints; ++i) {
                    temp.append("(");
                    temp.append(theShape.xpoints[i]);
                    temp.append(",");
                    temp.append(theShape.ypoints[i]);
                    temp.append(") ");
                }
                return temp.toString();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.theRegions.get(rowIndex).setName(aValue.toString());
            this.theDialog.updateGateTable();
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

