/*
 * Decompiled with CFR 0.152.
 */
package fcs2data;

import fcs2data.FCS_datafile;
import fcs2data.buttonListener;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class FCS2Data {
    private static buttonListener theListener = new buttonListener();
    private static final String version = "FCS2Data 1.0";

    public static void main(String[] args) {
        JFileChooser theChooser = new JFileChooser();
        theChooser.setDialogTitle("Select (multiple) FCS file(s) to convert:");
        theChooser.setDialogType(0);
        theChooser.setFileSelectionMode(0);
        theChooser.setMultiSelectionEnabled(true);
        theChooser.showOpenDialog(null);
        File[] selectedFiles = theChooser.getSelectedFiles();
        if (selectedFiles != null && selectedFiles.length != 0) {
            String path = selectedFiles[0].getParent();
            JLabel info1 = new JLabel("Enter a value to use the option");
            JLabel info2 = new JLabel("Leave blank to skip the option");
            JTextField allFilesOutput = new JTextField();
            JLabel allLabel = new JLabel("Suffix for single event data files: ");
            JTextField summaryMeanOutput = new JTextField();
            JLabel meanLabel = new JLabel("Filename for list of mean values: ");
            JTextField summaryMedianOutput = new JTextField();
            JLabel medianLabel = new JLabel("Filename for list of median values: ");
            JDialog optionDialog = new JDialog();
            optionDialog.setLayout(new GridLayout(0, 2));
            optionDialog.add(info1);
            optionDialog.add(new JLabel());
            optionDialog.add(info2);
            optionDialog.add(new JLabel());
            optionDialog.add(allLabel);
            optionDialog.add(allFilesOutput);
            optionDialog.add(meanLabel);
            optionDialog.add(summaryMeanOutput);
            optionDialog.add(medianLabel);
            optionDialog.add(summaryMedianOutput);
            optionDialog.setTitle("Define Output Files");
            optionDialog.setSize(600, 200);
            JButton OK_Button = new JButton("OK");
            OK_Button.setActionCommand("OK");
            OK_Button.addActionListener(theListener);
            JButton Cancel_Button = new JButton("Cancel");
            Cancel_Button.setActionCommand("Cancel");
            Cancel_Button.addActionListener(theListener);
            optionDialog.add(OK_Button);
            optionDialog.add(Cancel_Button);
            theListener.setDialog(optionDialog);
            optionDialog.setModal(true);
            optionDialog.setVisible(true);
            if (theListener.getStatus()) {
                boolean createMedianSummary;
                boolean createSingleFiles = !allFilesOutput.getText().trim().isEmpty();
                boolean createMeanSummary = !summaryMeanOutput.getText().trim().isEmpty();
                boolean bl = createMedianSummary = !summaryMedianOutput.getText().trim().isEmpty();
                if (createSingleFiles || createMeanSummary || createMedianSummary) {
                    File meanFile = null;
                    if (createMeanSummary) {
                        meanFile = FCS2Data.tryFile(path, summaryMeanOutput.getText().trim());
                    }
                    if (meanFile == null) {
                        createMeanSummary = false;
                    }
                    FileWriter meanWriter = null;
                    try {
                        if (meanFile != null) {
                            meanWriter = new FileWriter(meanFile);
                        }
                    }
                    catch (IOException n) {
                        JOptionPane.showMessageDialog(null, summaryMeanOutput.getText().trim() + " could not be created.");
                    }
                    File medianFile = null;
                    if (createMedianSummary) {
                        medianFile = FCS2Data.tryFile(path, summaryMedianOutput.getText().trim());
                    }
                    if (medianFile == null) {
                        createMedianSummary = false;
                    }
                    FileWriter medianWriter = null;
                    try {
                        if (medianFile != null) {
                            medianWriter = new FileWriter(medianFile);
                        }
                    }
                    catch (IOException n) {
                        JOptionPane.showMessageDialog(null, summaryMedianOutput.getText().trim() + " could not be created.");
                    }
                    boolean headersWritten = false;
                    int fileCount = 0;
                    JDialog theProgress = new JDialog();
                    theProgress.setSize(600, 100);
                    theProgress.setTitle("Progress:");
                    JProgressBar theBar = new JProgressBar(0, selectedFiles.length);
                    theProgress.add(theBar);
                    theBar.setStringPainted(true);
                    theBar.setString("0");
                    theProgress.setLocation(100, 100);
                    theProgress.setVisible(true);
                    for (File selectedFile : selectedFiles) {
                        FCS_datafile fcsFile;
                        FileWriter singleWriter;
                        block106: {
                            if (++fileCount % 50 == 0) {
                                theBar.setValue(fileCount);
                                theBar.paintImmediately(0, 0, 600, 100);
                                theBar.setString(String.valueOf(fileCount));
                            }
                            File singleFile = null;
                            String name = selectedFile.getName() + allFilesOutput.getText().trim();
                            if (createSingleFiles) {
                                singleFile = FCS2Data.tryFile(path, name);
                            }
                            singleWriter = null;
                            try {
                                if (singleFile != null) {
                                    singleWriter = new FileWriter(singleFile);
                                }
                            }
                            catch (IOException n) {
                                JOptionPane.showMessageDialog(null, name + " could not be created.");
                            }
                            fcsFile = null;
                            try {
                                fcsFile = FCS_datafile.getFCS_data(selectedFile);
                            }
                            catch (IOException ex) {
                                fcsFile = null;
                                JOptionPane.showMessageDialog(null, selectedFile.getName() + " could not be opened.");
                            }
                            catch (DataFormatException ex) {
                                fcsFile = null;
                                JOptionPane.showMessageDialog(null, selectedFile.getName() + " could not be opened as an FCS file.");
                            }
                            catch (BufferUnderflowException bf) {
                                fcsFile = null;
                                if (meanWriter != null) {
                                    try {
                                        meanWriter.write(selectedFile.getName());
                                        meanWriter.write("\n");
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (medianWriter == null) break block106;
                                try {
                                    medianWriter.write(selectedFile.getName());
                                    medianWriter.write("\n");
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (fcsFile != null) {
                            int paramCount = fcsFile.getParameterCount();
                            if (!headersWritten) {
                                if (meanWriter != null) {
                                    try {
                                        meanWriter.write("file name");
                                        meanWriter.write("\t");
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (medianWriter != null) {
                                    try {
                                        medianWriter.write("file name");
                                        medianWriter.write("\t");
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                for (int param = 0; param < paramCount; ++param) {
                                    if (meanWriter != null) {
                                        try {
                                            meanWriter.write(fcsFile.getParameterLabel(param));
                                            meanWriter.write("\t");
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    if (medianWriter == null) continue;
                                    try {
                                        medianWriter.write(fcsFile.getParameterLabel(param));
                                        medianWriter.write("\t");
                                        continue;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (meanWriter != null) {
                                    try {
                                        meanWriter.write("\n");
                                    }
                                    catch (IOException param) {
                                        // empty catch block
                                    }
                                }
                                if (medianWriter != null) {
                                    try {
                                        medianWriter.write("\n");
                                    }
                                    catch (IOException param) {
                                        // empty catch block
                                    }
                                }
                                headersWritten = true;
                            }
                            if (singleWriter != null) {
                                for (int param = 0; param < paramCount; ++param) {
                                    if (singleWriter == null) continue;
                                    try {
                                        singleWriter.write(fcsFile.getParameterLabel(param));
                                        singleWriter.write("\t");
                                        continue;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    singleWriter.write("\n");
                                }
                                catch (IOException param) {
                                    // empty catch block
                                }
                            }
                            int totalEvents = fcsFile.getEventCount();
                            double[] meanValues = null;
                            if (createMeanSummary) {
                                meanValues = new double[paramCount];
                            }
                            double[] medianValues = null;
                            double[][] valuesForMedian = null;
                            if (createMedianSummary) {
                                try {
                                    valuesForMedian = new double[paramCount][totalEvents];
                                    medianValues = new double[paramCount];
                                }
                                catch (OutOfMemoryError o) {
                                    valuesForMedian = null;
                                    medianValues = null;
                                    JOptionPane.showMessageDialog(null, "Not enough memory to calculate the medians of " + selectedFile.getName());
                                }
                            }
                            int currentEvent = 0;
                            int cacheStep = 100;
                            int cachings = totalEvents / cacheStep;
                            int rest = totalEvents % cacheStep;
                            for (int i = 0; i < cachings; ++i) {
                                float[][] cacheEvents = fcsFile.getEvents(i * cacheStep, cacheStep);
                                for (int m = 0; m < cacheStep; ++m) {
                                    for (int param = 0; param < paramCount; ++param) {
                                        if (meanValues != null) {
                                            meanValues[param] = meanValues[param] + (double)cacheEvents[m][param];
                                        }
                                        if (valuesForMedian != null) {
                                            valuesForMedian[param][currentEvent] = cacheEvents[m][param];
                                        }
                                        if (singleWriter == null) continue;
                                        try {
                                            singleWriter.write(String.valueOf(cacheEvents[m][param]));
                                            singleWriter.write("\t");
                                            continue;
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    if (singleWriter != null) {
                                        try {
                                            singleWriter.write("\n");
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                    ++currentEvent;
                                }
                            }
                            float[][] cacheEvents = fcsFile.getEvents(cachings * cacheStep, rest);
                            for (int m = 0; m < rest; ++m) {
                                for (int param = 0; param < paramCount; ++param) {
                                    if (meanValues != null) {
                                        meanValues[param] = meanValues[param] + (double)cacheEvents[m][param];
                                    }
                                    if (valuesForMedian != null) {
                                        valuesForMedian[param][currentEvent] = cacheEvents[m][param];
                                    }
                                    if (singleWriter == null) continue;
                                    try {
                                        singleWriter.write(String.valueOf(cacheEvents[m][param]));
                                        singleWriter.write("\t");
                                        continue;
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (singleWriter != null) {
                                    try {
                                        singleWriter.write("\n");
                                    }
                                    catch (IOException param) {
                                        // empty catch block
                                    }
                                }
                                ++currentEvent;
                            }
                            for (int param = 0; param < paramCount; ++param) {
                                if (meanValues != null) {
                                    meanValues[param] = meanValues[param] / (double)totalEvents;
                                }
                                if (medianValues == null) continue;
                                Arrays.sort(valuesForMedian[param]);
                                if (totalEvents % 2 == 1) {
                                    medianValues[param] = valuesForMedian[param][totalEvents / 2];
                                    continue;
                                }
                                double val1 = valuesForMedian[param][totalEvents / 2 - 1];
                                double val2 = valuesForMedian[param][totalEvents / 2];
                                medianValues[param] = (val1 + val2) / 2.0;
                            }
                            if (meanWriter != null) {
                                try {
                                    meanWriter.write(fcsFile.getDataFileName());
                                    meanWriter.write("\t");
                                }
                                catch (IOException param) {
                                    // empty catch block
                                }
                            }
                            if (medianWriter != null && medianValues != null) {
                                try {
                                    medianWriter.write(fcsFile.getDataFileName());
                                    medianWriter.write("\t");
                                }
                                catch (IOException param) {
                                    // empty catch block
                                }
                            }
                            for (int param = 0; param < paramCount; ++param) {
                                if (meanWriter != null) {
                                    try {
                                        meanWriter.write(String.valueOf(meanValues[param]));
                                        meanWriter.write("\t");
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (medianWriter == null || medianValues == null) continue;
                                try {
                                    medianWriter.write(String.valueOf(medianValues[param]));
                                    medianWriter.write("\t");
                                    continue;
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (meanWriter != null) {
                                try {
                                    meanWriter.write("\n");
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (medianWriter != null && medianValues != null) {
                                try {
                                    medianWriter.write("\n");
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            fcsFile.close();
                        }
                        if (singleWriter == null) continue;
                        try {
                            singleWriter.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    theProgress.setVisible(false);
                    if (meanWriter != null) {
                        try {
                            meanWriter.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (medianWriter != null) {
                        try {
                            medianWriter.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        System.exit(0);
    }

    private static File tryFile(String path, String name) {
        File returnFile = null;
        returnFile = new File(path, name);
        if (returnFile == null) {
            JOptionPane.showMessageDialog(null, "'" + name + "' denotes an invalid name. File will not be created.");
            return null;
        }
        if (returnFile.isDirectory()) {
            JOptionPane.showMessageDialog(null, "'" + name + "' denotes an already existing directory. File will not be created.");
            return null;
        }
        if (returnFile.exists()) {
            if (JOptionPane.showConfirmDialog(null, "'" + name + "' already exists!\nOverwrite file?", "File exists!", 0) != 0) {
                return null;
            }
            return returnFile;
        }
        boolean success = false;
        try {
            success = returnFile.createNewFile();
        }
        catch (IOException n) {
            success = false;
        }
        if (!success) {
            JOptionPane.showMessageDialog(null, "'" + name + "' could not be created.");
            return null;
        }
        return returnFile;
    }
}

