/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Util;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.Relevance;
import net.sf.jabref.specialfields.SpecialFieldsUtils;
import net.sf.jabref.undo.NamedCompound;

public class ManageKeywordsAction
extends MnemonicAwareAction {
    private JabRefFrame frame;
    private JDialog diag = null;
    private JTextField keyword;
    private DefaultListModel keywordListModel;
    private JList keywordList;
    private JScrollPane kPane;
    private JRadioButton intersectKeywords;
    private JRadioButton mergeKeywords;
    private JButton ok;
    private JButton cancel;
    private JButton add;
    private JButton remove;
    private boolean cancelled;
    private TreeSet<String> sortedKeywordsOfAllEntriesBeforeUpdateByUser = new TreeSet();

    public ManageKeywordsAction(JabRefFrame frame) {
        this.putValue("Name", "Manage keywords");
        this.frame = frame;
    }

    private void createDialog() {
        this.keyword = new JTextField();
        this.keywordListModel = new DefaultListModel();
        this.keywordList = new JList(this.keywordListModel);
        this.keywordList.setVisibleRowCount(8);
        this.kPane = new JScrollPane(this.keywordList);
        this.diag = new JDialog(this.frame, Globals.lang("Manage keywords"), true);
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.add = new JButton(Globals.lang("Add"));
        this.remove = new JButton(Globals.lang("Remove"));
        this.keywordList.setVisibleRowCount(10);
        this.intersectKeywords = new JRadioButton("Display keywords appearing in ALL entries");
        this.mergeKeywords = new JRadioButton("Display keywords appearing in ANY entry");
        ButtonGroup group = new ButtonGroup();
        group.add(this.intersectKeywords);
        group.add(this.mergeKeywords);
        ActionListener stateChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ManageKeywordsAction.this.fillKeyWordList();
            }
        };
        this.intersectKeywords.addActionListener(stateChanged);
        this.mergeKeywords.addActionListener(stateChanged);
        this.intersectKeywords.setSelected(true);
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("fill:200dlu, 4dlu, left:pref, 4dlu, left:pref", ""));
        builder.appendSeparator(Globals.lang("Keywords of selected entries"));
        builder.append((Component)this.intersectKeywords, 5);
        builder.nextLine();
        builder.append((Component)this.mergeKeywords, 5);
        builder.nextLine();
        builder.append((Component)this.kPane, 3);
        builder.add(this.remove);
        builder.nextLine();
        builder.append((Component)this.keyword, 3);
        builder.append(this.add);
        builder.nextLine();
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageKeywordsAction.this.cancelled = false;
                ManageKeywordsAction.this.diag.dispose();
            }
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageKeywordsAction.this.cancelled = true;
                ManageKeywordsAction.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        final ActionListener addActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String text = ManageKeywordsAction.this.keyword.getText().trim();
                if (text.equals("")) {
                    return;
                }
                if (ManageKeywordsAction.this.keywordListModel.isEmpty()) {
                    ManageKeywordsAction.this.keywordListModel.addElement(text);
                } else {
                    int idx;
                    String element = (String)ManageKeywordsAction.this.keywordListModel.getElementAt(idx);
                    for (idx = 0; idx < ManageKeywordsAction.this.keywordListModel.size() && element.compareTo(text) < 0; ++idx) {
                    }
                    if (idx == ManageKeywordsAction.this.keywordListModel.size()) {
                        ManageKeywordsAction.this.keywordListModel.addElement(text);
                    } else if (element.compareTo(text) != 0) {
                        ManageKeywordsAction.this.keywordListModel.add(idx, text);
                    }
                }
                ManageKeywordsAction.this.keyword.setText(null);
                ManageKeywordsAction.this.keyword.requestFocusInWindow();
            }
        };
        this.add.addActionListener(addActionListener);
        final ActionListener removeActionListenter = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object[] values = ManageKeywordsAction.this.keywordList.getSelectedValues();
                ArrayList<String> selectedValuesList = new ArrayList<String>();
                for (int i = 0; i < values.length; ++i) {
                    selectedValuesList.add((String)values[i]);
                }
                for (String val : selectedValuesList) {
                    ManageKeywordsAction.this.keywordListModel.removeElement(val);
                }
            }
        };
        this.remove.addActionListener(removeActionListenter);
        this.keywordList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyCode() == 127) {
                    removeActionListenter.actionPerformed(null);
                }
            }
        });
        AbstractAutoCompleter autoComp = JabRef.jrf.basePanel().getAutoCompleter("keywords");
        AutoCompleteListener acl = new AutoCompleteListener(autoComp);
        this.keyword.addKeyListener(acl);
        this.keyword.addFocusListener(acl);
        this.keyword.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    addActionListener.actionPerformed(null);
                }
            }
        });
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", cancelAction);
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BasePanel bp = this.frame.basePanel();
        if (bp == null) {
            return;
        }
        if (bp.getSelectedEntries().length == 0) {
            return;
        }
        if (this.diag == null) {
            this.createDialog();
        }
        this.cancelled = true;
        this.fillKeyWordList();
        this.diag.pack();
        Util.placeDialog(this.diag, this.frame);
        this.diag.setVisible(true);
        if (this.cancelled) {
            return;
        }
        HashSet<String> keywordsToAdd = new HashSet<String>();
        HashSet<String> userSelectedKeywords = new HashSet<String>();
        Enumeration keywords = this.keywordListModel.elements();
        while (keywords.hasMoreElements()) {
            String keyword = (String)keywords.nextElement();
            userSelectedKeywords.add(keyword);
            if (this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.contains(keyword)) continue;
            keywordsToAdd.add(keyword);
        }
        HashSet<String> keywordsToRemove = new HashSet<String>();
        for (String keyword : this.sortedKeywordsOfAllEntriesBeforeUpdateByUser) {
            if (userSelectedKeywords.contains(keyword)) continue;
            keywordsToRemove.add(keyword);
        }
        if (keywordsToAdd.isEmpty() && keywordsToRemove.isEmpty()) {
            return;
        }
        if (SpecialFieldsUtils.keywordSyncEnabled() && !keywordsToAdd.isEmpty()) {
            HashSet clone = (HashSet)keywordsToAdd.clone();
            clone.retainAll(Priority.getInstance().getKeyWords());
            if (!clone.isEmpty()) {
                keywordsToRemove.addAll(Priority.getInstance().getKeyWords());
            }
            clone = (HashSet)keywordsToAdd.clone();
            clone.retainAll(Quality.getInstance().getKeyWords());
            if (!clone.isEmpty()) {
                keywordsToRemove.addAll(Quality.getInstance().getKeyWords());
            }
            clone = (HashSet)keywordsToAdd.clone();
            clone.retainAll(Rank.getInstance().getKeyWords());
            if (!clone.isEmpty()) {
                keywordsToRemove.addAll(Rank.getInstance().getKeyWords());
            }
            clone = (HashSet)keywordsToAdd.clone();
            clone.retainAll(Relevance.getInstance().getKeyWords());
            if (!clone.isEmpty()) {
                keywordsToRemove.addAll(Relevance.getInstance().getKeyWords());
            }
        }
        BibtexEntry[] entries = bp.getSelectedEntries();
        NamedCompound ce = new NamedCompound(Globals.lang("Update keywords"));
        for (BibtexEntry entry : entries) {
            ArrayList<String> separatedKeywords = Util.getSeparatedKeywords(entry);
            TreeSet<String> keywords2 = new TreeSet<String>();
            keywords2.addAll(separatedKeywords);
            keywords2.removeAll(keywordsToRemove);
            keywords2.addAll(keywordsToAdd);
            separatedKeywords.clear();
            separatedKeywords.addAll(keywords2);
            Util.putKeywords(entry, separatedKeywords, ce);
            if (!SpecialFieldsUtils.keywordSyncEnabled()) continue;
            SpecialFieldsUtils.syncSpecialFieldsFromKeywords(entry, ce);
        }
        ce.end();
        bp.undoManager.addEdit(ce);
        bp.markBaseChanged();
    }

    private void fillKeyWordList() {
        BasePanel bp = this.frame.basePanel();
        BibtexEntry[] entries = bp.getSelectedEntries();
        this.keywordListModel.clear();
        this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.clear();
        if (this.mergeKeywords.isSelected()) {
            for (BibtexEntry entry : entries) {
                ArrayList<String> separatedKeywords = Util.getSeparatedKeywords(entry);
                this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.addAll(separatedKeywords);
            }
        } else {
            assert (this.intersectKeywords.isSelected());
            BibtexEntry firstEntry = entries[0];
            ArrayList<String> separatedKeywords = Util.getSeparatedKeywords(firstEntry);
            this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.addAll(separatedKeywords);
            for (int i = 1; i < entries.length; ++i) {
                BibtexEntry entry;
                entry = entries[i];
                separatedKeywords = Util.getSeparatedKeywords(entry);
                this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.retainAll(separatedKeywords);
            }
        }
        for (String s : this.sortedKeywordsOfAllEntriesBeforeUpdateByUser) {
            this.keywordListModel.addElement(s);
        }
    }
}

