/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.io.FileFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.FindUnlinkedFilesDialog;
import net.sf.jabref.imports.UnlinkedPDFFileFilter;

public class UnlinkedFilesCrawler {
    public final FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            if (pathname == null) {
                return false;
            }
            return pathname.isDirectory();
        }
    };
    private final BibtexDatabase database;

    public UnlinkedFilesCrawler(BibtexDatabase database) {
        this.database = database;
    }

    public FindUnlinkedFilesDialog.CheckableTreeNode searchDirectory(File directory, FileFilter aFileFilter) {
        UnlinkedPDFFileFilter ff = new UnlinkedPDFFileFilter(aFileFilter, this.database);
        return this.searchDirectory(directory, ff, new int[]{1}, null);
    }

    public FindUnlinkedFilesDialog.CheckableTreeNode searchDirectory(File directory, UnlinkedPDFFileFilter ff, int[] state, ChangeListener changeListener) {
        int i;
        if (state == null || state.length < 1 || state[0] != 1) {
            return null;
        }
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles(ff);
        FindUnlinkedFilesDialog.CheckableTreeNode root = new FindUnlinkedFilesDialog.CheckableTreeNode(null);
        int filesCount = 0;
        File[] subDirectories = directory.listFiles(this.directoryFilter);
        for (i = 0; i < subDirectories.length; ++i) {
            FindUnlinkedFilesDialog.CheckableTreeNode subRoot = this.searchDirectory(subDirectories[i], ff, state, changeListener);
            if (subRoot == null || subRoot.getChildCount() <= 0) continue;
            filesCount += ((FindUnlinkedFilesDialog.FileNodeWrapper)subRoot.getUserObject()).fileCount;
            root.add(subRoot);
        }
        root.setUserObject(new FindUnlinkedFilesDialog.FileNodeWrapper(directory, files.length + filesCount));
        for (i = 0; i < files.length; ++i) {
            root.add(new FindUnlinkedFilesDialog.CheckableTreeNode(new FindUnlinkedFilesDialog.FileNodeWrapper(files[i])));
            if (changeListener == null) continue;
            changeListener.stateChanged(new ChangeEvent(this));
        }
        return root;
    }
}

