/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRef;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;

public class DatabaseFileLookup {
    private static final String KEY_FILE_FIELD = "file";
    private static Logger logger = Logger.getLogger(DatabaseFileLookup.class.getName());
    private final HashMap<File, Boolean> fileToFound = new HashMap();
    private final Collection<BibtexEntry> entries;
    private final String[] possibleFilePaths;

    public DatabaseFileLookup(BibtexDatabase aDatabase) {
        if (aDatabase == null) {
            throw new IllegalArgumentException("Passing a 'null' BibtexDatabase.");
        }
        this.entries = aDatabase.getEntries();
        this.possibleFilePaths = JabRef.jrf.basePanel().metaData().getFileDirectory(KEY_FILE_FIELD);
    }

    public boolean lookupDatabase(File aFile) {
        if (this.fileToFound.containsKey(aFile)) {
            return this.fileToFound.get(aFile);
        }
        Boolean res = false;
        for (BibtexEntry entry : this.entries) {
            if (!this.lookupEntry(aFile, entry)) continue;
            res = true;
            break;
        }
        this.fileToFound.put(aFile, res);
        return res;
    }

    public boolean lookupEntry(File aFile, BibtexEntry anEntry) {
        FileListEntry flEntry;
        String link;
        if (aFile == null || anEntry == null) {
            return false;
        }
        FileListTableModel model = new FileListTableModel();
        String fileField = anEntry.getField(KEY_FILE_FIELD);
        model.setContent(fileField);
        for (int i = 0; i < model.getRowCount() && (link = (flEntry = model.getEntry(i)).getLink()) != null; ++i) {
            File expandedFilename = Util.expandFilename(link, this.possibleFilePaths);
            if (expandedFilename == null || !expandedFilename.equals(aFile)) continue;
            return true;
        }
        return false;
    }
}

