/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibTeXMLHandler;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BibteXMLImporter
extends ImportFormat {
    private static Logger logger = Logger.getLogger(BibteXMLImporter.class.toString());

    @Override
    public String getFormatName() {
        return "BibTeXML";
    }

    @Override
    public String getCLIId() {
        return "bibtexml";
    }

    @Override
    public boolean isRecognizedFormat(InputStream stream) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(stream));
        Pattern pat1 = Pattern.compile("<bibtex:file .*");
        while ((str = in.readLine()) != null) {
            if (!pat1.matcher(str).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream stream, OutputPrinter status) throws IOException {
        ArrayList<BibtexEntry> bibItems = new ArrayList<BibtexEntry>();
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        try {
            SAXParser parser = parserFactory.newSAXParser();
            BibTeXMLHandler handler = new BibTeXMLHandler();
            parser.parse(stream, (DefaultHandler)handler);
            bibItems = handler.getItems();
        }
        catch (ParserConfigurationException e1) {
            logger.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
            status.showMessage(e1.getLocalizedMessage());
        }
        catch (SAXException e2) {
            logger.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
            status.showMessage(e2.getLocalizedMessage());
        }
        catch (IOException e3) {
            logger.log(Level.SEVERE, e3.getLocalizedMessage(), e3);
            status.showMessage(e3.getLocalizedMessage());
        }
        return bibItems;
    }
}

