/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.io.File;
import java.io.IOException;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.export.layout.ParamLayoutFormatter;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;

public class FileLink
implements ParamLayoutFormatter {
    String fileType = null;

    @Override
    public String format(String field) {
        String link;
        block7: {
            FileListTableModel tableModel;
            block6: {
                tableModel = new FileListTableModel();
                if (field == null) {
                    return "";
                }
                tableModel.setContent(field);
                link = null;
                if (this.fileType != null) break block6;
                if (tableModel.getRowCount() <= 0) break block7;
                link = tableModel.getEntry(0).getLink();
                break block7;
            }
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                FileListEntry flEntry = tableModel.getEntry(i);
                if (!flEntry.getType().getName().toLowerCase().equals(this.fileType)) continue;
                link = flEntry.getLink();
                break;
            }
        }
        if (link == null) {
            return "";
        }
        String[] dirs = Globals.prefs.fileDirForDatabase != null ? Globals.prefs.fileDirForDatabase : new String[]{Globals.prefs.get("fileDirectory")};
        File f = Util.expandFilename(link, dirs);
        if (f != null) {
            try {
                return f.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
                return f.getPath();
            }
        }
        return link;
    }

    @Override
    public void setArgument(String arg) {
        this.fileType = arg;
    }
}

