/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableStringChange;

public class StringNameChange
extends Change {
    BibtexString string;
    String mem;
    String tmp;
    String disk;
    String content;
    private BibtexString tmpString;

    public StringNameChange(BibtexString string, BibtexString tmpString, String mem, String tmp, String disk, String content) {
        this.tmpString = tmpString;
        this.name = Globals.lang("Renamed string") + ": '" + tmp + "'";
        this.string = string;
        this.content = content;
        this.mem = mem;
        this.tmp = tmp;
        this.disk = disk;
    }

    @Override
    public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
        BibtexString bs;
        String newId;
        if (panel.database().hasStringLabel(this.disk)) {
            Globals.logger("Cannot rename string '" + this.mem + "' to '" + this.disk + "' because the name " + "is already in use.");
        }
        if (this.string != null) {
            this.string.setName(this.disk);
            undoEdit.addEdit(new UndoableStringChange(panel, this.string, true, this.mem, this.disk));
        } else {
            newId = Util.createNeutralId();
            bs = new BibtexString(newId, this.disk, this.content);
            try {
                panel.database().addString(bs);
                undoEdit.addEdit(new UndoableInsertString(panel, panel.database(), bs));
            }
            catch (KeyCollisionException ex) {
                Globals.logger("Error: could not add string '" + bs.getName() + "': " + ex.getMessage());
            }
        }
        if (this.tmpString != null) {
            this.tmpString.setName(this.disk);
        } else {
            newId = Util.createNeutralId();
            bs = new BibtexString(newId, this.disk, this.content);
            secondary.addString(bs);
        }
        return true;
    }

    @Override
    JComponent description() {
        return new JLabel(this.disk + " : " + this.content);
    }
}

