/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.help.HelpDialog;

public class NameFormatterTab
extends JPanel
implements PrefsTab {
    public static final String NAME_FORMATTER_VALUE = "nameFormatterFormats";
    public static final String NAME_FORMATER_KEY = "nameFormatterNames";
    private boolean tableChanged = false;
    private JTable table;
    private int rowCount = -1;
    private Vector<TableRow> tableRows = new Vector(10);

    public static Map<String, String> getNameFormatters() {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] names = Globals.prefs.getStringArray(NAME_FORMATER_KEY);
        String[] formats = Globals.prefs.getStringArray(NAME_FORMATTER_VALUE);
        if (names == null) {
            names = new String[]{};
        }
        if (formats == null) {
            formats = new String[]{};
        }
        for (int i = 0; i < names.length; ++i) {
            if (i < formats.length) {
                result.put(names[i], formats[i]);
                continue;
            }
            result.put(names[i], "1@*@{ff }{vv }{ll}{, jj}@@*@1@{ff }{vv }{ll}{, jj}@*@, {ff }{vv }{ll}{, jj}");
        }
        return result;
    }

    public NameFormatterTab(HelpDialog helpDialog) {
        this.setLayout(new BorderLayout());
        AbstractTableModel tm = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return NameFormatterTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row >= NameFormatterTab.this.tableRows.size()) {
                    return "";
                }
                TableRow tr = (TableRow)NameFormatterTab.this.tableRows.elementAt(row);
                if (tr == null) {
                    return "";
                }
                switch (column) {
                    case 0: {
                        return tr.name;
                    }
                    case 1: {
                        return tr.format;
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int col) {
                return col == 0 ? Globals.lang("Formatter Name") : Globals.lang("Format String");
            }

            public Class<String> getColumnClass(int column) {
                if (column == 0) {
                    return String.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                NameFormatterTab.this.tableChanged = true;
                while (row >= NameFormatterTab.this.tableRows.size()) {
                    NameFormatterTab.this.tableRows.add(new TableRow());
                }
                TableRow rowContent = (TableRow)NameFormatterTab.this.tableRows.elementAt(row);
                if (col == 0) {
                    rowContent.name = value.toString();
                } else {
                    rowContent.format = value.toString();
                }
            }
        };
        this.table = new JTable(tm);
        TableColumnModel cm = this.table.getColumnModel();
        cm.getColumn(0).setPreferredWidth(140);
        cm.getColumn(1).setPreferredWidth(400);
        FormLayout layout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        JPanel pan = new JPanel();
        JPanel tabPanel = new JPanel();
        tabPanel.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.table, 20, 31);
        this.table.setPreferredScrollableViewportSize(new Dimension(250, 200));
        sp.setMinimumSize(new Dimension(250, 300));
        sp.setPreferredSize(new Dimension(600, 300));
        tabPanel.add((Component)sp, "Center");
        JToolBar tlb = new JToolBar(1);
        tlb.setFloatable(false);
        tlb.setBorder(null);
        tlb.add(new AddRowAction());
        tlb.add(new DeleteRowAction());
        tlb.add(new HelpAction(helpDialog, "CustomExports.html#NameFormatter", "Help on Name Formatting", GUIGlobals.getIconUrl("helpSmall")));
        tabPanel.add((Component)tlb, "East");
        builder.appendSeparator(Globals.lang("Special Name Formatters"));
        builder.nextLine();
        builder.append(pan);
        builder.append(tabPanel);
        builder.nextLine();
        pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.tableRows.clear();
        String[] names = Globals.prefs.getStringArray(NAME_FORMATER_KEY);
        String[] formats = Globals.prefs.getStringArray(NAME_FORMATTER_VALUE);
        if (names == null) {
            names = new String[]{};
        }
        if (formats == null) {
            formats = new String[]{};
        }
        for (int i = 0; i < names.length; ++i) {
            if (i < formats.length) {
                this.tableRows.add(new TableRow(names[i], formats[i]));
                continue;
            }
            this.tableRows.add(new TableRow(names[i]));
        }
        this.rowCount = this.tableRows.size() + 5;
    }

    @Override
    public void storeSettings() {
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            int row = this.table.getEditingRow();
            this.table.getCellEditor(row, col).stopCellEditing();
        }
        if (this.tableChanged) {
            int i = 0;
            while (i < this.tableRows.size()) {
                if (this.tableRows.elementAt((int)i).name.equals("")) {
                    this.tableRows.removeElementAt(i);
                    continue;
                }
                ++i;
            }
            String[] names = new String[this.tableRows.size()];
            String[] formats = new String[this.tableRows.size()];
            for (i = 0; i < this.tableRows.size(); ++i) {
                TableRow tr = this.tableRows.elementAt(i);
                names[i] = tr.name;
                formats[i] = tr.format;
            }
            Globals.prefs.putStringArray(NAME_FORMATER_KEY, names);
            Globals.prefs.putStringArray(NAME_FORMATTER_VALUE, formats);
        }
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Name formatter");
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = NameFormatterTab.this.table.getSelectedRows();
            if (rows.length == 0) {
                NameFormatterTab.this.rowCount++;
                NameFormatterTab.this.table.revalidate();
                NameFormatterTab.this.table.repaint();
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] + i - 1 >= NameFormatterTab.this.tableRows.size()) continue;
                NameFormatterTab.this.tableRows.add(Math.max(0, rows[i] + i - 1), new TableRow());
            }
            NameFormatterTab.this.rowCount += rows.length;
            if (rows.length > 1) {
                NameFormatterTab.this.table.clearSelection();
            }
            NameFormatterTab.this.table.revalidate();
            NameFormatterTab.this.table.repaint();
            NameFormatterTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NameFormatterTab.this.tableChanged = true;
            int[] selectedRows = NameFormatterTab.this.table.getSelectedRows();
            int numberDeleted = 0;
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                if (selectedRows[i] >= NameFormatterTab.this.tableRows.size()) continue;
                NameFormatterTab.this.tableRows.remove(selectedRows[i]);
                ++numberDeleted;
            }
            NameFormatterTab.this.rowCount -= numberDeleted;
            if (selectedRows.length > 1) {
                NameFormatterTab.this.table.clearSelection();
            }
            NameFormatterTab.this.table.revalidate();
            NameFormatterTab.this.table.repaint();
        }
    }

    class TableRow {
        String name;
        String format;

        public TableRow() {
            this("");
        }

        public TableRow(String name) {
            this(name, "1@*@{ff }{vv }{ll}{, jj}@@*@1@{ff }{vv }{ll}{, jj}@*@, {ff }{vv }{ll}{, jj}");
        }

        public TableRow(String name, String format) {
            this.name = name;
            this.format = format;
        }
    }
}

