/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import net.sf.profiler4j.agent.ThreadInfo;
import net.sf.profiler4j.console.client.ClassInfo;
import net.sf.profiler4j.console.client.ClientException;
import net.sf.profiler4j.console.client.MemoryInfo;
import net.sf.profiler4j.console.client.ProgressCallback;
import net.sf.profiler4j.console.client.RuntimeInfo;
import net.sf.profiler4j.console.client.Snapshot;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Client {
    private static final Log log = LogFactory.getLog(Client.class);
    private Socket s;
    private ObjectOutputStream out;
    private ObjectInputStream in;

    public synchronized void connect(String host, int port) throws ClientException {
        try {
            if (this.isConnected()) {
                throw new ClientException("Client already connected");
            }
            this.s = new Socket(host, port);
            this.out = new ObjectOutputStream(new BufferedOutputStream(this.s.getOutputStream()));
            this.in = new ObjectInputStream(new BufferedInputStream(this.s.getInputStream()));
            String serverVersion = this.in.readUTF();
            if (!serverVersion.equals("(SC integrated)")) {
                this.s.close();
                this.s = null;
                this.out = null;
                this.in = null;
                throw new ClientException("Version of remote agent is incompatible: console is '(SC integrated)' but agent is '" + serverVersion + "'");
            }
            log.info((Object)("Client connected to " + host + ":" + port));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized boolean isConnected() {
        return this.s != null && this.s.isConnected() && !this.s.isInputShutdown();
    }

    public synchronized void disconnect() throws ClientException {
        this.assertConnected();
        try {
            this.sendAndWaitAck(4);
            this.close();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void reset() throws ClientException {
        this.assertConnected();
        try {
            this.sendAndWaitAck(3);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized RuntimeInfo getRuntimeInfo() throws ClientException {
        this.assertConnected();
        try {
            this.sendAndWaitAck(7);
            return RuntimeInfo.read(this.in);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public synchronized MemoryInfo getMemoryInfo() throws ClientException {
        this.assertConnected();
        try {
            this.sendAndWaitAck(8);
            return MemoryInfo.read(this.in);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public synchronized boolean[] setThreadMonitoring(boolean threadMonitoring, boolean cpuTimeMonitoring) throws ClientException {
        this.assertConnected();
        try {
            this.out.writeInt(10);
            this.out.writeUnshared(new boolean[]{threadMonitoring, cpuTimeMonitoring});
            this.out.flush();
            return (boolean[])this.in.readUnshared();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public synchronized ThreadInfo[] getThreadInfo(long[] ids, int maxDepth) throws ClientException {
        this.assertConnected();
        try {
            this.sendAndWaitAck(9);
            this.out.writeUnshared(ids);
            this.out.writeInt(maxDepth);
            this.out.flush();
            return (ThreadInfo[])this.in.readUnshared();
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public synchronized Snapshot getSnapshot() throws ClientException {
        this.assertConnected();
        try {
            this.sendAndWaitAck(2);
            return Snapshot.read(this.in);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    public void runGc() throws ClientException {
        this.assertConnected();
        try {
            this.sendAndWaitAck(1);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void restoreClasses(ProgressCallback callback) throws ClientException {
        this.applyRules("*(*):reject", "", callback);
    }

    public void applyRules(String rules, String defaultRuleOptions, ProgressCallback callback) throws ClientException {
        this.assertConnected();
        try {
            int i;
            this.sendAndWaitAck(5);
            this.out.writeUTF(defaultRuleOptions);
            this.out.writeUTF(rules);
            this.out.flush();
            int batchSize = this.in.readInt();
            if (callback != null && batchSize > 0) {
                callback.operationStarted(batchSize);
            }
            while ((i = this.in.readInt()) != -1) {
                callback.update(i);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized ClassInfo[] listLoadedClasses() throws ClientException {
        this.assertConnected();
        try {
            this.sendAndWaitAck(6);
            int n = this.in.readInt();
            ClassInfo[] names = new ClassInfo[n];
            for (int i = 0; i < n; ++i) {
                names[i] = new ClassInfo(this.in.readUTF(), this.in.readBoolean());
            }
            return names;
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void assertConnected() throws ClientException {
        if (!this.isConnected()) {
            log.error((Object)"ClientConnected assertion failed");
            throw new ClientException("Client not connected");
        }
    }

    private void sendAndWaitAck(int cmdId) throws ClientException {
        try {
            this.out.writeInt(cmdId);
            this.out.flush();
            this.expectOk();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void expectOk() throws ClientException {
        try {
            int status = this.in.readInt();
            if (status != 0) {
                throw new ClientException("Command Error: code=" + status);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception e) throws ClientException {
        this.close(e);
        if (e instanceof ClientException) {
            throw (ClientException)e;
        }
        if (e instanceof IOException) {
            throw new ClientException("I/O Error", e);
        }
        throw new ClientException("Unexpeced Client Error", e);
    }

    private void close() {
        this.close(null);
    }

    private void close(Throwable t) {
        if (this.s != null) {
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.s = null;
            this.in = null;
            this.out = null;
            if (t != null) {
                log.error((Object)"Client being disconnected due to error", t);
            } else {
                log.info((Object)"Client being disconnected normally");
            }
        }
    }
}

