/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sf.profiler4j.console.TreeBuilder;

public class MethodRenderer
extends DefaultTreeCellRenderer {
    private static final String IMAGE_BASE = "/net/sf/profiler4j/console/images/";
    private Font rootFont = new Font("Tahoma", 1, 11);
    private Color rootColor = Color.decode("#000000");
    private Icon rootIcon = MethodRenderer.loadIcon("medal_gold_1.png");
    private Font level1Font = new Font("Tahoma", 1, 11);
    private Color level1Color = Color.decode("#FF0000");
    private Icon level1Icon = MethodRenderer.loadIcon("tag_red.png");
    private Font level2Font = new Font("Tahoma", 0, 11);
    private Color level2Color = Color.decode("#DD2222");
    private Icon level2Icon = MethodRenderer.loadIcon("tag_yellow.png");
    private Font level3Font = new Font("Tahoma", 0, 11);
    private Color level3Color = Color.decode("#006600");
    private Icon level3Icon = MethodRenderer.loadIcon("tag_green.png");
    private Font selfFont = new Font("Tahoma", 0, 11);
    private Color selfColor = Color.decode("#000000");
    private Icon selfIcon = MethodRenderer.loadIcon("time.png");
    private Icon realRootIcon = MethodRenderer.loadIcon("clock.png");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        TreeBuilder.NodeInfo info = (TreeBuilder.NodeInfo)node.getUserObject();
        if (info != null) {
            boolean root;
            boolean child = info.getType() == TreeBuilder.Type.CHILD;
            boolean self = info.getType() == TreeBuilder.Type.SELF;
            boolean bl = root = info.getType() == TreeBuilder.Type.ROOT;
            if (root) {
                this.setForeground(this.rootColor);
                this.setFont(this.rootFont);
                this.setIcon(this.rootIcon);
            } else if (child) {
                if (info.getPercentFromRoot() >= 30.0) {
                    this.setForeground(this.level1Color);
                    this.setFont(this.level1Font);
                    this.setIcon(this.level1Icon);
                } else if (info.getPercentFromRoot() >= 15.0) {
                    this.setForeground(this.level2Color);
                    this.setFont(this.level2Font);
                    this.setIcon(this.level2Icon);
                } else {
                    this.setForeground(this.level3Color);
                    this.setFont(this.level3Font);
                    this.setIcon(this.level3Icon);
                }
            } else {
                if (!self) throw new IllegalArgumentException();
                this.setForeground(this.selfColor);
                this.setFont(this.selfFont);
                this.setIcon(this.selfIcon);
            }
        } else {
            this.setIcon(this.realRootIcon);
        }
        if (sel) {
            this.setForeground(Color.WHITE);
        }
        this.setOpaque(false);
        return this;
    }

    private static ImageIcon loadIcon(String name) {
        return new ImageIcon(MethodRenderer.class.getResource(IMAGE_BASE + name));
    }
}

