/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo;

import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.geo.Namespaces;
import java.text.NumberFormat;

@ExtensionDescription.Default(nsAlias="geo", nsUri="http://www.w3.org/2003/01/geo/wgs84_pos#", localName="lat")
public class GeoLat
extends ValueConstruct {
    public static final double MAX_LAT = 90.0;
    public static final double MIN_LAT = -90.0;
    public static final int COORDINATE_PRECISION = 6;
    private static final NumberFormat NUM_FORMAT = NumberFormat.getInstance();
    private Double lat = null;

    public GeoLat() {
        this((Double)null);
    }

    public GeoLat(Double lat) throws IllegalArgumentException {
        super(Namespaces.W3C_GEO_NAMESPACE, "lat", null, null);
        this.setRequired(true);
        if (lat != null) {
            this.setLatitude(lat);
            this.setImmutable(true);
        }
    }

    public Double getLatitude() {
        return this.lat;
    }

    public void setLatitude(Double latitude) {
        this.lat = latitude;
        String value = null;
        if (latitude != null) {
            if (latitude.compareTo(-90.0) < 0 || latitude.compareTo(90.0) > 0) {
                throw new IllegalArgumentException("Latitude must be between -90 and 90 degrees.");
            }
            value = NUM_FORMAT.format(latitude);
        }
        super.setValue(value);
    }

    public void setValue(String value) {
        Double d = null;
        if (value != null) {
            try {
                d = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("'value' must be a double.");
            }
        }
        this.setLatitude(d);
    }

    static {
        NUM_FORMAT.setMaximumFractionDigits(6);
        NUM_FORMAT.setMinimumFractionDigits(6);
    }
}

