/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import javax.media.Buffer;
import javax.media.Track;
import javax.media.TrackListener;
import net.sf.fmj.media.BasicSourceModule;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.MyOutputConnector;
import net.sf.fmj.media.PlaybackEngine;
import net.sf.fmj.media.rtp.util.RTPTimeBase;
import net.sf.fmj.media.util.LoopThread;

class SourceThread
extends LoopThread
implements TrackListener {
    BasicSourceModule bsm;
    int index = 0;
    protected MyOutputConnector oc;
    protected boolean readBlocked = false;
    protected boolean checkLatency = false;
    protected boolean resetted = false;
    long sequenceNum = 0L;
    static int remapTimeFlag = 4480;
    protected long lastRelativeTime = -1L;
    long currentTime = 0L;
    long counter = 0L;

    public SourceThread(BasicSourceModule bsm, MyOutputConnector oc, int i) {
        this.bsm = bsm;
        this.oc = oc;
        this.index = i;
        this.setName(this.getName() + ": " + oc.track);
        oc.track.setTrackListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean process() {
        Buffer buffer;
        block28: {
            this.readBlocked = false;
            buffer = this.oc.getEmptyBuffer();
            buffer.setOffset(0);
            buffer.setLength(0);
            buffer.setFlags(0);
            buffer.setSequenceNumber(this.sequenceNum++);
            if (this.resetted) {
                Object object = this.bsm.resetSync;
                synchronized (object) {
                    if (this.resetted) {
                        buffer.setFlags(512);
                        this.resetted = false;
                        this.pause();
                        if (this.bsm.checkAllPaused()) {
                            this.bsm.parser.stop();
                            this.bsm.parser.reset();
                        }
                        this.oc.writeReport();
                        return true;
                    }
                }
            }
            try {
                this.oc.track.readFrame(buffer);
            }
            catch (Throwable e) {
                Log.dumpStack(e);
                if (this.bsm.moduleListener == null) break block28;
                this.bsm.moduleListener.internalErrorOccurred(this.bsm);
            }
        }
        if (PlaybackEngine.TRACE_ON && !this.bsm.verifyBuffer(buffer)) {
            System.err.println("verify buffer failed: " + this.oc.track);
            Thread.dumpStack();
            if (this.bsm.moduleListener != null) {
                this.bsm.moduleListener.internalErrorOccurred(this.bsm);
            }
        }
        if (buffer.getTimeStamp() != -1L && (buffer.getFlags() & remapTimeFlag) != 0) {
            boolean success = true;
            if ((buffer.getFlags() & 0x80) != 0) {
                success = this.remapSystemTime(buffer);
            } else if ((buffer.getFlags() & 0x100) != 0) {
                success = this.remapRelativeTime(buffer);
            } else if ((buffer.getFlags() & 0x1000) != 0) {
                success = this.remapRTPTime(buffer);
            }
            if (!success) {
                buffer.setDiscard(true);
                this.oc.writeReport();
                return true;
            }
        }
        if (this.checkLatency) {
            buffer.setFlags(buffer.getFlags() | 0x400);
            if (this.bsm.moduleListener != null) {
                this.bsm.moduleListener.markedDataArrived(this.bsm, buffer);
            }
            this.checkLatency = false;
        } else {
            buffer.setFlags(buffer.getFlags() & 0xFFFFFBFF);
        }
        if (this.readBlocked && this.bsm.moduleListener != null) {
            this.bsm.moduleListener.dataBlocked(this.bsm, false);
        }
        if (buffer.isEOM()) {
            Object object = this.bsm.resetSync;
            synchronized (object) {
                if (!this.resetted) {
                    this.pause();
                    if (this.bsm.checkAllPaused()) {
                        this.bsm.parser.stop();
                    }
                }
            }
        } else {
            this.bsm.bitsRead += (long)buffer.getLength();
        }
        this.oc.writeReport();
        return true;
    }

    public void readHasBlocked(Track t) {
        this.readBlocked = true;
        if (this.bsm.moduleListener != null) {
            this.bsm.moduleListener.dataBlocked(this.bsm, true);
        }
    }

    private boolean remapRelativeTime(Buffer buffer) {
        buffer.setFlags(buffer.getFlags() & 0xFFFFFEFF | 0x60);
        return true;
    }

    private boolean remapRTPTime(Buffer buffer) {
        long dur;
        if (buffer.getTimeStamp() <= 0L) {
            buffer.setTimeStamp(-1L);
            return true;
        }
        if (this.bsm.cname == null) {
            this.bsm.cname = this.bsm.engine.getCNAME();
            if (this.bsm.cname == null) {
                buffer.setTimeStamp(-1L);
                return true;
            }
        }
        if (this.bsm.rtpOffsetInvalid) {
            if (this.bsm.rtpMapperUpdatable == null) {
                this.bsm.rtpMapperUpdatable = RTPTimeBase.getMapperUpdatable(this.bsm.cname);
                if (this.bsm.rtpMapperUpdatable == null) {
                    this.bsm.rtpOffsetInvalid = false;
                }
            }
            if (this.bsm.rtpMapperUpdatable != null) {
                this.bsm.rtpMapperUpdatable.setOrigin(this.bsm.currentRTPTime);
                this.bsm.rtpMapperUpdatable.setOffset(buffer.getTimeStamp());
                this.bsm.rtpOffsetInvalid = false;
            }
        }
        if (this.bsm.rtpMapper == null) {
            this.bsm.rtpMapper = RTPTimeBase.getMapper(this.bsm.cname);
        }
        if (this.bsm.rtpMapper.getOffset() != this.bsm.oldOffset) {
            this.bsm.oldOffset = this.bsm.rtpMapper.getOffset();
        }
        if ((dur = buffer.getTimeStamp() - this.bsm.rtpMapper.getOffset()) < 0L) {
            if (this.bsm.rtpMapperUpdatable != null) {
                this.bsm.rtpOffsetInvalid = true;
            } else {
                dur = 0L;
            }
        }
        this.bsm.currentRTPTime = this.bsm.rtpMapper.getOrigin() + dur;
        buffer.setTimeStamp(this.bsm.currentRTPTime);
        return true;
    }

    private boolean remapSystemTime(Buffer buffer) {
        if (!this.bsm.started) {
            return false;
        }
        long ts = buffer.getTimeStamp() - this.bsm.lastSystemTime;
        if (ts < 0L) {
            return false;
        }
        this.bsm.currentSystemTime = this.bsm.originSystemTime + ts;
        buffer.setTimeStamp(this.bsm.currentSystemTime);
        buffer.setFlags(buffer.getFlags() & 0xFFFFFF7F | 0x60);
        return true;
    }

    public synchronized void start() {
        super.start();
        this.lastRelativeTime = -1L;
    }
}

