/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.BigInteger;
import java.net.BindException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.CandidateType;
import org.ice4j.ice.CheckList;
import org.ice4j.ice.CheckListState;
import org.ice4j.ice.Component;
import org.ice4j.ice.ConnectivityCheckClient;
import org.ice4j.ice.ConnectivityCheckServer;
import org.ice4j.ice.DefaultNominator;
import org.ice4j.ice.FoundationsRegistry;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NominationStrategy;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.CandidateHarvesterSet;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.ice.harvest.TrickleCallback;
import org.ice4j.stack.StunStack;
import org.ice4j.stack.TransactionID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    private static final int CONSENT_FRESHNESS_MAX_RETRANSMISSIONS = 30;
    private static final int CONSENT_FRESHNESS_WAIT_INTERVAL = 500;
    public static final int DEFAULT_MAX_CHECK_LIST_SIZE = 100;
    public static final int DEFAULT_TERMINATION_DELAY = 3000;
    private static final PropertyChangeListener[] NO_STATE_CHANGE_LISTENERS = new PropertyChangeListener[0];
    private static final Logger logger = Logger.getLogger(Agent.class.getName());
    public static final String PROPERTY_ICE_PROCESSING_STATE = "IceProcessingState";
    private final Map<String, IceMediaStream> mediaStreams = new LinkedHashMap<String, IceMediaStream>();
    private final HostCandidateHarvester hostCandidateHarvester = new HostCandidateHarvester();
    private final CandidateHarvesterSet harvesters = new CandidateHarvesterSet();
    private final FoundationsRegistry foundationsRegistry = new FoundationsRegistry();
    private final DefaultNominator nominator;
    private long taValue = -1L;
    private final List<CandidatePair> preDiscoveredPairsQueue = new LinkedList<CandidatePair>();
    private final Object startLock = new Object();
    private final String ufrag;
    private final String password;
    private final long tieBreaker;
    private boolean isControlling = true;
    private final ConnectivityCheckClient connCheckClient;
    private final ConnectivityCheckServer connCheckServer;
    private IceProcessingState state = IceProcessingState.WAITING;
    private final List<PropertyChangeListener> stateListeners = new LinkedList<PropertyChangeListener>();
    private StunStack stunStack;
    private TerminationThread terminationThread;
    private Thread stunKeepAliveThread;
    private int generation = 0;
    private boolean trickle = false;
    private boolean shutdown = false;
    private boolean harvestingStarted = false;
    private boolean performConsentFreshness = false;

    public Agent() {
        SecureRandom random = new SecureRandom();
        this.connCheckServer = new ConnectivityCheckServer(this);
        this.connCheckClient = new ConnectivityCheckClient(this);
        System.setProperty("org.ice4j.ALWAYS_SIGN", "true");
        if (StackProperties.getString("org.ice4j.SOFTWARE") == null) {
            System.setProperty("org.ice4j.SOFTWARE", "ice4j.org");
        }
        this.ufrag = this.ensureIceAttributeLength(new BigInteger(24, random).toString(32) + BigInteger.valueOf(System.currentTimeMillis()).toString(32), 4, 256);
        this.password = this.ensureIceAttributeLength(new BigInteger(128, random).toString(32), 22, 256);
        this.tieBreaker = Math.abs(random.nextLong());
        this.nominator = new DefaultNominator(this);
    }

    public IceMediaStream createMediaStream(String mediaStreamName) {
        logger.fine("Create media stream for " + mediaStreamName);
        IceMediaStream mediaStream = new IceMediaStream(this, mediaStreamName);
        this.mediaStreams.put(mediaStreamName, mediaStream);
        this.setState(IceProcessingState.WAITING);
        return mediaStream;
    }

    public Component createComponent(IceMediaStream stream, Transport transport, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException, BindException {
        if (transport != Transport.UDP) {
            throw new IllegalArgumentException("This implementation does not currently support transport: " + (Object)((Object)transport));
        }
        Component component = stream.createComponent();
        this.gatherCandidates(component, preferredPort, minPort, maxPort);
        for (Candidate candidate : component.getLocalCandidates()) {
            logger.info("\t" + candidate.getTransportAddress() + " (" + (Object)((Object)candidate.getType()) + ")");
        }
        this.connCheckServer.start();
        return component;
    }

    private void gatherCandidates(Component component, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException {
        logger.info("Gather candidates for component " + component.toShortString());
        this.hostCandidateHarvester.harvest(component, preferredPort, minPort, maxPort, Transport.UDP);
        logger.fine("host candidate count: " + component.getLocalCandidateCount());
        if (!this.isTrickling()) {
            this.harvestingStarted = true;
            this.harvesters.harvest(component);
        }
        logger.fine("Candidate count in first harvest: " + component.getLocalCandidateCount());
        component.selectDefaultCandidate();
    }

    public void startCandidateTrickle(TrickleCallback trickleCallback) throws IllegalStateException {
        if (!this.isTrickling()) {
            throw new IllegalStateException("Trying to start trickling without enabling it on the agent!");
        }
        if (this.harvestingStarted) {
            logger.warning("Hmmm ... why are you harvesting twice? You shouldn't be!");
        }
        LinkedList<Component> components = new LinkedList<Component>();
        for (IceMediaStream stream : this.getStreams()) {
            components.addAll(stream.getComponents());
        }
        this.harvesters.harvest(components, trickleCallback);
        trickleCallback.onIceCandidates(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnectivityEstablishment() {
        Object object = this.startLock;
        synchronized (object) {
            logger.info("Start ICE connectivity establishment");
            this.shutdown = false;
            this.pruneNonMatchedStreams();
            try {
                this.initCheckLists();
            }
            catch (ArithmeticException e) {
                this.setState(IceProcessingState.FAILED);
                return;
            }
            this.setState(IceProcessingState.RUNNING);
            if (this.preDiscoveredPairsQueue.size() > 0) {
                logger.info("Trigger checks for pairs that were received before running state");
                Iterator<CandidatePair> it = this.preDiscoveredPairsQueue.iterator();
                while (it.hasNext()) {
                    this.triggerCheck(it.next());
                }
                this.preDiscoveredPairsQueue.clear();
            }
            this.connCheckClient.startChecks();
        }
    }

    private void pruneNonMatchedStreams() {
        boolean prune = false;
        block0: for (IceMediaStream stream : this.getStreams()) {
            for (Component component : stream.getComponents()) {
                if (component.getRemoteCandidateCount() > 0) {
                    prune = true;
                }
                if (!prune) continue;
                continue block0;
            }
        }
        if (prune) {
            for (IceMediaStream stream : this.getStreams()) {
                for (Component component : stream.getComponents()) {
                    if (component.getRemoteCandidateCount() != 0) continue;
                    stream.removeComponent(component);
                }
                if (stream.getComponentCount() != 0) continue;
                this.removeStream(stream);
            }
        }
    }

    public boolean isStarted() {
        return this.state != IceProcessingState.WAITING && this.state != IceProcessingState.COMPLETED && this.state != IceProcessingState.TERMINATED;
    }

    public boolean isOver() {
        return this.state == IceProcessingState.COMPLETED || this.state == IceProcessingState.TERMINATED || this.state == IceProcessingState.FAILED;
    }

    public IceProcessingState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            if (!this.stateListeners.contains(l)) {
                this.stateListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateChangeListener(PropertyChangeListener l) {
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChange(IceProcessingState oldState, IceProcessingState newState) {
        PropertyChangeListener[] stateListenersCopy;
        List<PropertyChangeListener> list = this.stateListeners;
        synchronized (list) {
            stateListenersCopy = this.stateListeners.toArray(NO_STATE_CHANGE_LISTENERS);
        }
        if (stateListenersCopy.length != 0) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, PROPERTY_ICE_PROCESSING_STATE, (Object)oldState, (Object)newState);
            for (PropertyChangeListener l : stateListenersCopy) {
                l.propertyChange(evt);
            }
        }
    }

    private void setState(IceProcessingState newState) {
        IceProcessingState oldState = this.state;
        this.state = newState;
        this.fireStateChange(oldState, newState);
    }

    protected void initCheckLists() {
        List<IceMediaStream> streams = this.getStreamsWithPendingConnectivityEstablishment();
        int streamCount = streams.size();
        int maxCheckListSize = Integer.getInteger("org.ice4j.MAX_CHECK_LIST_SIZE", 100);
        int maxPerStreamSize = streamCount == 0 ? 0 : maxCheckListSize / streamCount;
        for (IceMediaStream stream : streams) {
            logger.info("Init checklist for stream " + stream.getName());
            stream.setMaxCheckListSize(maxPerStreamSize);
            stream.initCheckList();
        }
        if (streamCount > 0) {
            streams.get(0).getCheckList().computeInitialCheckListPairStates();
        }
    }

    public void addCandidateHarvester(CandidateHarvester harvester) {
        this.harvesters.add(harvester);
    }

    public CandidateHarvesterSet getHarvesters() {
        return this.harvesters;
    }

    public String getLocalUfrag() {
        return this.ufrag;
    }

    public String getLocalPassword() {
        return this.password;
    }

    public String generateLocalUserName(String media) {
        String ret;
        IceMediaStream stream = this.getStream(media);
        if (stream == null) {
            ret = null;
            logger.warning("Agent contains no IceMediaStream with name " + media + "!");
        } else {
            String remoteUfrag = stream.getRemoteUfrag();
            if (remoteUfrag == null) {
                ret = null;
                logger.warning("Remote ufrag of IceMediaStream with name " + media + " is null!");
            } else {
                ret = remoteUfrag + ":" + this.getLocalUfrag();
            }
        }
        return ret;
    }

    public String generateRemoteUserName(String media) {
        IceMediaStream stream = this.getStream(media);
        return stream == null ? null : this.getLocalUfrag() + ":" + stream.getRemoteUfrag();
    }

    public String generateLocalUserName(RemoteCandidate remoteCandidate, LocalCandidate localCandidate) {
        return this.generateUserName(remoteCandidate, localCandidate);
    }

    public String generateRemoteUserName(RemoteCandidate remoteCandidate, LocalCandidate localCandidate) {
        return this.generateUserName(localCandidate, remoteCandidate);
    }

    private String generateUserName(Candidate<?> candidate1, Candidate<?> candidate2) {
        candidate1.getUfrag();
        candidate2.getUfrag();
        return null;
    }

    public final FoundationsRegistry getFoundationsRegistry() {
        return this.foundationsRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceMediaStream getStream(String name) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return this.mediaStreams.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStreamNames() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return new LinkedList<String>(this.mediaStreams.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IceMediaStream> getStreams() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return new LinkedList<IceMediaStream>(this.mediaStreams.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStreamCount() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            return this.mediaStreams.size();
        }
    }

    List<IceMediaStream> getStreamsWithPendingConnectivityEstablishment() {
        List<IceMediaStream> streams = this.getStreams();
        Iterator<IceMediaStream> streamIter = streams.iterator();
        while (streamIter.hasNext()) {
            IceMediaStream stream = streamIter.next();
            CheckList checkList = stream.getCheckList();
            CheckListState checkListState = checkList.getState();
            if (!CheckListState.COMPLETED.equals((Object)checkListState) && !CheckListState.FAILED.equals((Object)checkListState)) continue;
            streamIter.remove();
        }
        return streams;
    }

    public synchronized StunStack getStunStack() {
        if (this.stunStack == null) {
            this.stunStack = new StunStack();
        }
        return this.stunStack;
    }

    public void setStunStack(StunStack stunStack) {
        this.stunStack = stunStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getActiveCheckListCount() {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            int i = 0;
            Collection<IceMediaStream> streams = this.mediaStreams.values();
            for (IceMediaStream stream : streams) {
                if (!stream.getCheckList().isActive()) continue;
                ++i;
            }
            return i;
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder("ICE Agent (stream-count=");
        buff.append(this.getStreamCount());
        buff.append(" ice-pwd:").append(this.getLocalPassword());
        buff.append(" ice-ufrag:").append(this.getLocalUfrag());
        buff.append(" tie-breaker:").append(this.getTieBreaker());
        buff.append("):\n");
        for (IceMediaStream stream : this.getStreams()) {
            buff.append(stream).append("\n");
        }
        return buff.toString();
    }

    public long getTieBreaker() {
        return this.tieBreaker;
    }

    public void setControlling(boolean isControlling) {
        this.isControlling = isControlling;
        for (IceMediaStream stream : this.getStreams()) {
            CheckList list = stream.getCheckList();
            if (list == null) continue;
            list.recomputePairPriorities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStream(IceMediaStream stream) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            this.mediaStreams.remove(stream.getName());
        }
        stream.free();
    }

    public boolean isControlling() {
        return this.isControlling;
    }

    public LocalCandidate findLocalCandidate(TransportAddress localAddress) {
        for (IceMediaStream stream : this.mediaStreams.values()) {
            LocalCandidate cnd = stream.findLocalCandidate(localAddress);
            if (cnd == null) continue;
            return cnd;
        }
        return null;
    }

    public LocalCandidate findLocalCandidate(TransportAddress localAddress, String ufrag) {
        for (IceMediaStream stream : this.mediaStreams.values()) {
            for (Component c : stream.getComponents()) {
                for (LocalCandidate cnd : c.getLocalCandidates()) {
                    if (cnd == null || cnd.getUfrag() == null || !cnd.getUfrag().equals(ufrag)) continue;
                    return cnd;
                }
            }
        }
        return null;
    }

    public RemoteCandidate findRemoteCandidate(TransportAddress remoteAddress) {
        for (IceMediaStream stream : this.mediaStreams.values()) {
            RemoteCandidate cnd = stream.findRemoteCandidate(remoteAddress);
            if (cnd == null) continue;
            return cnd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidatePair findCandidatePair(TransportAddress localAddress, TransportAddress remoteAddress) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            for (IceMediaStream stream : this.mediaStreams.values()) {
                CandidatePair pair = stream.findCandidatePair(localAddress, remoteAddress);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CandidatePair findCandidatePair(String localUFrag, String remoteUFrag) {
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            for (IceMediaStream stream : this.mediaStreams.values()) {
                CandidatePair pair = stream.findCandidatePair(localUFrag, remoteUFrag);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incomingCheckReceived(TransportAddress remoteAddress, TransportAddress localAddress, long priority, String remoteUFrag, String localUFrag, boolean useCandidate) {
        if (this.isOver()) {
            return;
        }
        String ufrag = null;
        LocalCandidate localCandidate = null;
        localCandidate = this.findLocalCandidate(localAddress);
        if (localCandidate == null) {
            logger.info("No localAddress for this incoming checks: " + localAddress);
            return;
        }
        Component parentComponent = localCandidate.getParentComponent();
        RemoteCandidate remoteCandidate = null;
        remoteCandidate = new RemoteCandidate(remoteAddress, parentComponent, CandidateType.PEER_REFLEXIVE_CANDIDATE, this.foundationsRegistry.obtainFoundationForPeerReflexiveCandidate(), priority, null, ufrag);
        CandidatePair triggeredPair = new CandidatePair(localCandidate, remoteCandidate);
        logger.fine("set use-candidate " + useCandidate + " for pair " + triggeredPair.toShortString());
        if (useCandidate) {
            triggeredPair.setUseCandidateReceived();
        }
        Object object = this.startLock;
        synchronized (object) {
            if (this.isStarted()) {
                if (triggeredPair.getParentComponent().getSelectedPair() == null) {
                    logger.info("Received check from " + triggeredPair.toShortString() + " triggered a check");
                }
                this.triggerCheck(triggeredPair);
            } else {
                logger.fine("Receive STUN checks before our ICE has started");
                this.preDiscoveredPairsQueue.add(triggeredPair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerCheck(CandidatePair triggerPair) {
        CandidatePair knownPair = this.findCandidatePair(triggerPair.getLocalCandidate().getTransportAddress(), triggerPair.getRemoteCandidate().getTransportAddress());
        IceMediaStream parentStream = triggerPair.getLocalCandidate().getParentComponent().getParentStream();
        if (knownPair != null) {
            boolean useCand = triggerPair.useCandidateReceived();
            if (useCand) {
                knownPair.setUseCandidateReceived();
            }
            triggerPair = knownPair;
            if (!this.isControlling()) {
                logger.fine("set useCandidateReceived for " + triggerPair.toShortString());
                CandidatePair candidatePair = triggerPair;
                synchronized (candidatePair) {
                    triggerPair.setUseCandidateReceived();
                }
            }
            if (knownPair.getState() == CandidatePairState.SUCCEEDED) {
                if (!this.isControlling() && useCand) {
                    logger.fine("update nominated flag");
                    this.nominationConfirmed(triggerPair);
                    this.checkListStatesUpdated();
                }
                return;
            }
            if (knownPair.getState() == CandidatePairState.IN_PROGRESS) {
                TransactionID checkTransaction = knownPair.getConnectivityCheckTransaction();
                this.getStunStack().cancelTransaction(checkTransaction);
            }
        } else {
            if (triggerPair.getParentComponent().getSelectedPair() == null) {
                logger.info("Add peer CandidatePair with new reflexive address to checkList");
            }
            triggerPair.setUseCandidateReceived();
            parentStream.addToCheckList(triggerPair);
        }
        CheckList checkList = parentStream.getCheckList();
        boolean wasFrozen = checkList.isFrozen();
        checkList.scheduleTriggeredCheck(triggerPair);
        if (wasFrozen && !checkList.isFrozen()) {
            this.connCheckClient.startChecks(checkList);
        }
    }

    protected void validatePair(CandidatePair validPair) {
        Component parentComponent = validPair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        parentStream.addToValidList(validPair);
    }

    public synchronized void nominate(CandidatePair pair) throws IllegalStateException {
        if (!this.isControlling()) {
            throw new IllegalStateException("Only controlling agents can nominate pairs");
        }
        Component parentComponent = pair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        if (!pair.isNominated() && !parentStream.validListContainsNomineeForComponent(parentComponent)) {
            logger.info("verify if nominated pair answer again");
            pair.nominate();
            pair.getParentComponent().getParentStream().getCheckList().scheduleTriggeredCheck(pair);
        }
    }

    public void setNominationStrategy(NominationStrategy strategy) {
        this.nominator.setStrategy(strategy);
    }

    protected void nominationConfirmed(CandidatePair nominatedPair) {
        nominatedPair.nominate();
        Component parentComponent = nominatedPair.getParentComponent();
        IceMediaStream parentStream = parentComponent.getParentStream();
        CheckList checkList = parentStream.getCheckList();
        if (checkList.getState() == CheckListState.RUNNING) {
            checkList.handleNominationConfirmed(nominatedPair);
        }
        if (parentStream.allComponentsHaveSelected() && checkList.getState() == CheckListState.RUNNING) {
            checkList.setState(CheckListState.COMPLETED);
        }
    }

    protected void checkListStatesUpdated() {
        boolean allListsEnded = true;
        boolean atLeastOneListSucceeded = false;
        if (this.getState() == IceProcessingState.COMPLETED) {
            return;
        }
        List<IceMediaStream> streams = this.getStreams();
        for (IceMediaStream stream : streams) {
            CheckListState checkListState = stream.getCheckList().getState();
            if (checkListState == CheckListState.RUNNING) {
                allListsEnded = false;
                break;
            }
            if (checkListState != CheckListState.COMPLETED) continue;
            logger.info("CheckList of stream " + stream.getName() + " is COMPLETED");
            atLeastOneListSucceeded = true;
        }
        if (!allListsEnded) {
            return;
        }
        if (!atLeastOneListSucceeded) {
            logger.info("ICE state is FAILED");
            this.terminate(IceProcessingState.FAILED);
            return;
        }
        if (this.getState() != IceProcessingState.RUNNING) {
            return;
        }
        logger.info("ICE state is COMPLETED");
        this.setState(IceProcessingState.COMPLETED);
        if (this.stunKeepAliveThread == null && !StackProperties.getBoolean("org.ice4j.NO_KEEP_ALIVES", false)) {
            this.scheduleStunKeepAlive();
        }
        this.scheduleTermination();
        this.logCandTypes();
    }

    private void logCandTypes() {
        List<IceMediaStream> strms = this.getStreams();
        for (IceMediaStream stream : strms) {
            for (Component component : stream.getComponents()) {
                CandidatePair selectedPair = component.getSelectedPair();
                StringBuffer buf = new StringBuffer("Harvester used for selected pair for ");
                buf.append(component.toShortString());
                buf.append(": ");
                if (selectedPair == null) {
                    buf.append("none (conn checks failed)");
                    logger.info(buf.toString());
                    continue;
                }
                LocalCandidate localCnd = selectedPair.getLocalCandidate();
                TransportAddress serverAddr = localCnd.getStunServerAddress();
                buf.append((Object)localCnd.getType());
                if (serverAddr != null) {
                    buf.append(" (STUN server = ");
                    buf.append(serverAddr);
                    buf.append(")");
                } else {
                    TransportAddress relayAddr = localCnd.getRelayServerAddress();
                    if (relayAddr != null) {
                        buf.append(" (relay = ");
                        buf.append(relayAddr);
                        buf.append(")");
                    }
                }
                logger.info(buf.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int countHostCandidates() {
        int num = 0;
        Map<String, IceMediaStream> map = this.mediaStreams;
        synchronized (map) {
            Collection<IceMediaStream> streamsCol = this.mediaStreams.values();
            for (IceMediaStream stream : streamsCol) {
                num += stream.countHostCandidates();
            }
        }
        return num;
    }

    public void setTa(long taValue) {
        this.taValue = taValue;
    }

    protected long calculateTa() {
        if (this.taValue != -1L) {
            return this.taValue;
        }
        return 20L;
    }

    protected long calculateStunHarvestRTO() {
        return Math.max(100L, this.calculateTa() * 2L * (long)this.countHostCandidates());
    }

    protected long calculateStunConnCheckRTO() {
        return 100L;
    }

    private void scheduleTermination() {
        if (this.terminationThread == null) {
            this.terminationThread = new TerminationThread();
            this.terminationThread.start();
        }
    }

    private void scheduleStunKeepAlive() {
        if (this.stunKeepAliveThread == null) {
            this.stunKeepAliveThread = new Thread(){

                public void run() {
                    Agent.this.runInStunKeepAliveThread();
                }
            };
            this.stunKeepAliveThread.setDaemon(true);
            this.stunKeepAliveThread.setName("StunKeepAliveThread");
            this.stunKeepAliveThread.start();
        }
    }

    private void terminate(IceProcessingState terminationState) {
        if (!IceProcessingState.FAILED.equals((Object)terminationState) && !IceProcessingState.TERMINATED.equals((Object)terminationState)) {
            throw new IllegalArgumentException("terminationState");
        }
        this.connCheckClient.stop();
        this.setState(terminationState);
    }

    private String ensureIceAttributeLength(String s, int min, int max) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (min < 0) {
            throw new IllegalArgumentException("min " + min);
        }
        if (max < min) {
            throw new IllegalArgumentException("max " + max);
        }
        int length = s.length();
        int numberOfIceCharsToAdd = min - length;
        if (numberOfIceCharsToAdd > 0) {
            StringBuilder sb = new StringBuilder(min);
            while (numberOfIceCharsToAdd > 0) {
                sb.append('0');
                --numberOfIceCharsToAdd;
            }
            sb.append(s);
            s = sb.toString();
        } else if (max < length) {
            s = s.substring(0, max);
        }
        return s;
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }

    public void free() {
        logger.info("Free ICE agent");
        this.shutdown = true;
        if (this.stunKeepAliveThread != null) {
            this.stunKeepAliveThread.interrupt();
        }
        this.connCheckServer.stop();
        IceProcessingState state = this.getState();
        if (!IceProcessingState.FAILED.equals((Object)state) && !IceProcessingState.TERMINATED.equals((Object)state)) {
            this.terminate(IceProcessingState.TERMINATED);
        }
        boolean interrupted = false;
        logger.info("remove streams");
        for (IceMediaStream stream : this.getStreams()) {
            try {
                this.removeStream(stream);
                logger.info("remove stream " + stream.getName());
            }
            catch (Throwable t) {
                logger.info("remove stream " + stream.getName() + " failed: " + t);
                if (t instanceof InterruptedException) {
                    interrupted = true;
                    continue;
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.getStunStack().shutDown();
        logger.info("ICE agent freed");
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    private void runInStunKeepAliveThread() {
        while (this.runInStunKeepAliveThreadCondition()) {
            for (IceMediaStream stream : this.getStreams()) {
                for (Component component : stream.getComponents()) {
                    CandidatePair pair = component.getSelectedPair();
                    if (pair == null) continue;
                    if (this.performConsentFreshness) {
                        this.connCheckClient.startCheckForPair(pair, 500, 500, 30);
                        continue;
                    }
                    this.connCheckClient.sendBindingIndicationForPair(pair);
                }
            }
            if (!this.runInStunKeepAliveThreadCondition()) break;
            try {
                Thread.sleep(15000L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info(Thread.currentThread().getName() + " ends.");
    }

    private boolean runInStunKeepAliveThreadCondition() {
        IceProcessingState state = this.state;
        return (IceProcessingState.COMPLETED.equals((Object)state) || IceProcessingState.TERMINATED.equals((Object)state)) && !this.shutdown;
    }

    private CandidatePair getSelectedPair(String streamName) {
        Component component;
        IceMediaStream stream = this.getStream(streamName);
        if (stream != null && (component = stream.getComponent(1)) != null) {
            return component.getSelectedPair();
        }
        return null;
    }

    public LocalCandidate getSelectedLocalCandidate(String streamName) {
        CandidatePair candidatePair = this.getSelectedPair(streamName);
        return candidatePair == null ? null : candidatePair.getLocalCandidate();
    }

    public RemoteCandidate getSelectedRemoteCandidate(String streamName) {
        CandidatePair candidatePair = this.getSelectedPair(streamName);
        return candidatePair == null ? null : candidatePair.getRemoteCandidate();
    }

    public boolean isTrickling() {
        return this.trickle;
    }

    public void setTrickling(boolean trickle) {
        this.trickle = trickle;
    }

    public long getHarvestingTime(String harvesterName) {
        long harvestingTime = 0L;
        for (CandidateHarvester harvester : this.harvesters) {
            if (!harvester.getClass().getName().endsWith(harvesterName) || (harvestingTime = harvester.getHarvestStatistics().getHarvestDuration()) == 0L) continue;
            return harvestingTime;
        }
        return 0L;
    }

    public int getHarvestCount(String harvesterName) {
        for (CandidateHarvester harvester : this.harvesters) {
            int harvestCount;
            if (!harvester.getClass().getName().endsWith(harvesterName) || (harvestCount = harvester.getHarvestStatistics().getHarvestCount()) == 0) continue;
            return harvestCount;
        }
        return 0;
    }

    public long getTotalHarvestingTime() {
        long harvestDuration = 0L;
        for (CandidateHarvester harvester : this.harvesters) {
            harvestDuration += harvester.getHarvestStatistics().getHarvestDuration();
        }
        return harvestDuration;
    }

    public int getHarvestCount() {
        int harvestCount = 0;
        for (CandidateHarvester harvester : this.harvesters) {
            harvestCount += harvester.getHarvestStatistics().getHarvestCount();
        }
        return harvestCount;
    }

    public boolean getPerformConsentFreshness() {
        return this.performConsentFreshness;
    }

    public void setPerformConsentFreshness(boolean performConsentFreshness) {
        this.performConsentFreshness = performConsentFreshness;
    }

    private class TerminationThread
    extends Thread {
        private TerminationThread() {
            super("TerminationThread");
        }

        public synchronized void run() {
            long terminationDelay = Integer.getInteger("org.ice4j.TERMINATION_DELAY", 3000).intValue();
            if (terminationDelay >= 0L) {
                try {
                    this.wait(terminationDelay);
                }
                catch (InterruptedException ie) {
                    logger.log(Level.FINEST, "Interrupted while waiting. Will speed up termination", ie);
                }
            }
            logger.info("ICE state is TERMINATED");
            Agent.this.terminate(IceProcessingState.TERMINATED);
            Agent.this.terminationThread = null;
        }
    }
}

