/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.net.InetAddress;
import net.kano.joscar.MiscTools;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractOutgoingConnectionController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;

public class OutgoingConnectionController
extends AbstractOutgoingConnectionController {
    private final ConnectionType type;

    public OutgoingConnectionController(ConnectionType type) throws IllegalArgumentException {
        this.setConnector(new MyOutgoingConnector());
        if (type != ConnectionType.INTERNET && type != ConnectionType.LAN) {
            throw new IllegalArgumentException("invalid type for " + MiscTools.getClassName((Object)this) + ": " + (Object)((Object)type));
        }
        this.type = type;
    }

    public MyOutgoingConnector getConnector() {
        return (MyOutgoingConnector)super.getConnector();
    }

    protected void handleResolvingState() {
    }

    public ConnectionType getTimeoutType() {
        return this.type;
    }

    protected void handleConnectingState() {
        InetAddress ipAddress = this.getConnector().getIpAddress();
        int outPort = this.getRvConnectionInfo().getPort();
        ConnectionType type = this.type;
        EventPost eventPost = this.getRvConnection().getEventPost();
        eventPost.fireEvent(new ConnectingEvent(type, ipAddress, outPort));
    }

    private RvConnectionInfo getRvConnectionInfo() {
        return this.getRvSessionInfo().getConnectionInfo();
    }

    public String toString() {
        return MiscTools.getClassName((Object)this) + ": " + (Object)((Object)this.type);
    }

    public class MyOutgoingConnector
    extends AbstractOutgoingConnectionController.DefaultOutgoingConnector {
        public int getConnectionPort() {
            return OutgoingConnectionController.this.getRvConnectionInfo().getPort();
        }

        public InetAddress getIpAddress() {
            InetAddress ip;
            RvConnectionInfo connectionInfo = OutgoingConnectionController.this.getRvConnectionInfo();
            if (OutgoingConnectionController.this.type == ConnectionType.INTERNET) {
                ip = connectionInfo.getExternalIP();
            } else if (OutgoingConnectionController.this.type == ConnectionType.LAN) {
                ip = connectionInfo.getInternalIP();
            } else {
                throw new IllegalStateException("invalid OutgoingConnectionType " + (Object)((Object)OutgoingConnectionController.this.type));
            }
            return ip;
        }

        public void checkConnectionInfo() throws Exception {
            if (this.getIpAddress() == null) {
                throw new IllegalStateException(MiscTools.getClassName((Object)this) + " (" + (Object)((Object)OutgoingConnectionController.this.type) + ") has invalid connection info: " + OutgoingConnectionController.this.getRvConnectionInfo());
            }
        }
    }
}

