/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.config.dom.Transports;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-transport")
@PerLookup
@I18n(value="create.transport")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class CreateTransport
implements AdminCommand {
    private static final ResourceBundle rb = HttpServiceStatsProviderBootstrap.rb;
    @LogMessageInfo(message="{0} transport already exists. Cannot add duplicate transport.", level="INFO")
    protected static final String CREATE_TRANSPORT_FAIL_DUPLICATE = "AS-WEB-ADMIN-00022";
    @LogMessageInfo(message="Failed to create transport {0}.", level="INFO")
    protected static final String CREATE_TRANSPORT_FAIL = "AS-WEB-ADMIN-00023";
    @Param(name="transportname", primary=true)
    String transportName;
    @Param(name="acceptorthreads", alias="acceptorThreads", optional=true, defaultValue="-1")
    String acceptorThreads;
    @Param(name="buffersizebytes", alias="bufferSizeBytes", optional=true, defaultValue="8192")
    String bufferSizeBytes;
    @Param(name="bytebuffertype", alias="byteBufferType", optional=true, defaultValue="HEAP")
    String byteBufferType;
    @Param(name="classname", optional=true, defaultValue="org.glassfish.grizzly.TCPSelectorHandler")
    String className;
    @Param(name="displayconfiguration", alias="displayConfiguration", optional=true, defaultValue="false")
    Boolean displayConfiguration;
    @Param(name="enablesnoop", alias="enableSnoop", optional=true, defaultValue="false")
    Boolean enableSnoop;
    @Param(name="idlekeytimeoutseconds", alias="idleKeyTimeoutSeconds", optional=true, defaultValue="30")
    String idleKeyTimeoutSeconds;
    @Param(name="maxconnectionscount", alias="maxConnectionsCount", optional=true, defaultValue="4096")
    String maxConnectionsCount;
    @Param(name="readtimeoutmillis", alias="readTimeoutMillis", optional=true, defaultValue="30000")
    String readTimeoutMillis;
    @Param(name="writetimeoutmillis", alias="writeTimeoutMillis", optional=true, defaultValue="30000")
    String writeTimeoutMillis;
    @Param(name="selectionkeyhandler", alias="selectionKeyHandler", optional=true)
    String selectionKeyHandler;
    @Param(name="selectorpolltimeoutmillis", alias="selectorPollTimeoutMillis", optional=true, defaultValue="1000")
    String selectorPollTimeoutMillis;
    @Param(name="tcpnodelay", alias="tcpNoDelay", optional=true, defaultValue="false")
    Boolean tcpNoDelay;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        Transports transports = networkConfig.getTransports();
        for (Transport transport : transports.getTransport()) {
            if (this.transportName == null || !this.transportName.equalsIgnoreCase(transport.getName())) continue;
            report.setMessage(MessageFormat.format(rb.getString(CREATE_TRANSPORT_FAIL_DUPLICATE), this.transportName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Transports>(){

                public Object run(Transports param) throws PropertyVetoException, TransactionFailure {
                    boolean docrootAdded = false;
                    boolean accessLogAdded = false;
                    Transport newTransport = (Transport)param.createChild(Transport.class);
                    newTransport.setName(CreateTransport.this.transportName);
                    newTransport.setAcceptorThreads(CreateTransport.this.acceptorThreads);
                    newTransport.setBufferSizeBytes(CreateTransport.this.bufferSizeBytes);
                    newTransport.setByteBufferType(CreateTransport.this.byteBufferType);
                    newTransport.setClassname(CreateTransport.this.className);
                    newTransport.setDisplayConfiguration(CreateTransport.this.displayConfiguration.toString());
                    newTransport.setEnableSnoop(CreateTransport.this.enableSnoop.toString());
                    newTransport.setIdleKeyTimeoutSeconds(CreateTransport.this.idleKeyTimeoutSeconds);
                    newTransport.setMaxConnectionsCount(CreateTransport.this.maxConnectionsCount);
                    newTransport.setName(CreateTransport.this.transportName);
                    newTransport.setReadTimeoutMillis(CreateTransport.this.readTimeoutMillis);
                    newTransport.setSelectionKeyHandler(CreateTransport.this.selectionKeyHandler);
                    newTransport.setSelectorPollTimeoutMillis(CreateTransport.this.selectorPollTimeoutMillis);
                    newTransport.setWriteTimeoutMillis(CreateTransport.this.writeTimeoutMillis);
                    newTransport.setTcpNoDelay(CreateTransport.this.tcpNoDelay.toString());
                    param.getTransport().add(newTransport);
                    return newTransport;
                }
            }, (ConfigBeanProxy)transports);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString(CREATE_TRANSPORT_FAIL), this.transportName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

