/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgiweb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import org.glassfish.osgijavaeebase.JarHelper;
import org.glassfish.osgiweb.WARManifestProcessor;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class WebBundleURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final Logger logger = Logger.getLogger(WebBundleURLStreamHandlerService.class.getPackage().getName());

    public URLConnection openConnection(final URL u) throws IOException {
        assert ("webbundle".equals(u.getProtocol()));
        final URL embeddedURL = new URL(u.getPath());
        final URLConnection con = embeddedURL.openConnection();
        return new URLConnection(embeddedURL){
            private Manifest m;

            @Override
            public void connect() throws IOException {
                con.connect();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                this.connect();
                this.m = WARManifestProcessor.processManifest(embeddedURL, u.getQuery());
                final PipedOutputStream pos = new PipedOutputStream();
                PipedInputStream pis = new PipedInputStream(pos);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            WebBundleURLStreamHandlerService.this.writeWithoutSignedFiles(con, pos, m);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }.start();
                return pis;
            }
        };
    }

    protected void setURL(URL u, String proto, String host, int port, String auth, String user, String path, String query, String ref) {
        logger.logp(Level.INFO, "WebBundleURLStreamHandlerService", "setURL() called with", "u = [{0}], proto = [{1}], host = [{2}], port = [{3}], auth = [{4}], user = [{5}], path = [{6}], query = [{7}], ref = [{7}]", new Object[]{u, proto, host, port, auth, user, path, query, ref});
        if (query == null || query.isEmpty()) {
            throw new IllegalArgumentException("The query component can't be null. It must at least contain Web-ContextPath parameter.");
        }
        int sep = query.indexOf("?");
        if (sep != -1) {
            String query1 = query.substring(0, sep);
            String query2 = query.substring(sep + 1);
            path = path.concat("?").concat(query1);
            query = query2;
        }
        logger.logp(Level.INFO, "WebBundleURLStreamHandlerService", "setURL ", "new path = [{0}], new query = [{1}]", new Object[]{path, query});
        Map<String, String> queryParameters = WARManifestProcessor.readQueryParams(query);
        boolean containsContextPathKey = false;
        for (String key : queryParameters.keySet()) {
            if (!"Web-ContextPath".equalsIgnoreCase(key)) continue;
            containsContextPathKey = true;
            break;
        }
        if (!containsContextPathKey) {
            throw new IllegalArgumentException("Query [" + query + "] does not contain Web-ContextPath parameter.");
        }
        super.setURL(u, proto, host, port, auth, user, path, query, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWithoutSignedFiles(URLConnection con, PipedOutputStream os, Manifest m) throws IOException {
        JarInputStream jis = null;
        ZipOutputStream jos = null;
        try {
            jis = new JarInputStream(con.getInputStream());
            jos = new JarOutputStream((OutputStream)os, m);
            this.writeWithoutSignedFiles(jis, (JarOutputStream)jos);
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException e) {}
            }
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void writeWithoutSignedFiles(final JarInputStream jis, final JarOutputStream jos) throws IOException {
        JarHelper.accept((JarInputStream)jis, (JarHelper.Visitor)new JarHelper.Visitor(){
            ByteBuffer buffer = ByteBuffer.allocate(1024);

            public void visit(JarEntry je) {
                try {
                    String name = je.getName();
                    if (name.startsWith("META-INF/") && !name.substring("META-INF/".length()).contains("/") && (name.endsWith(".SF") || name.endsWith(".RSA") || name.endsWith(".DSA") || name.startsWith("SIG-"))) {
                        logger.logp(Level.INFO, "WebBundleURLStreamHandlerService", "visit", "Skipping writing of singature file {0}", new Object[]{name});
                        return;
                    }
                    logger.logp(Level.FINE, "WebBundleURLStreamHandlerService", "visit", "Writing jar entry = {0}", new Object[]{je});
                    jos.putNextEntry(je);
                    JarHelper.copy((InputStream)jis, (OutputStream)jos, (ByteBuffer)this.buffer);
                    jos.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

