/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.security.acl.Group;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.JAASCallbackHandler;
import org.apache.catalina.realm.RealmBase;
import org.glassfish.logging.annotation.LogMessageInfo;

public class JAASRealm
extends RealmBase {
    @LogMessageInfo(message="Setting JAAS app name {0}", level="INFO")
    public static final String SETTING_JAAS_INFO = "AS-WEB-CORE-00306";
    @LogMessageInfo(message="Login exception authenticating username {0}", level="FINE")
    public static final String LOGIN_EXCEPTION_AUTHENTICATING_USERNAME = "AS-WEB-CORE-00307";
    @LogMessageInfo(message="Username {0} NOT authenticated due to failed login", level="FINE")
    public static final String USERNAME_NOT_AUTHENTICATED_FAILED_LOGIN = "AS-WEB-CORE-00308";
    @LogMessageInfo(message="Username {0} NOT authenticated due to expired account", level="FINE")
    public static final String USERNAME_NOT_AUTHENTICATED_EXPIRED_ACCOUNT = "AS-WEB-CORE-00309";
    @LogMessageInfo(message="Username {0} NOT authenticated due to expired credential", level="FINE")
    public static final String USERNAME_NOT_AUTHENTICATED_EXPIRED_CREDENTIAL = "AS-WEB-CORE-00310";
    @LogMessageInfo(message="error ", level="SEVERE", cause="Could not authenticate by using the current username", action="Verify the username and credential")
    public static final String AUTHENTICATION_ERROR = "AS-WEB-CORE-00311";
    protected String appName = null;
    protected static final String info = "org.apache.catalina.realm.JAASRealm/1.0";
    protected static final String name = "JAASRealm";
    protected ArrayList<String> roleClasses = new ArrayList();
    protected ArrayList<String> userClasses = new ArrayList();
    protected String roleClassNames = null;
    protected String userClassNames = null;

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        String name = container.getName();
        if (this.appName == null) {
            this.appName = name;
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, SETTING_JAAS_INFO, this.appName);
            }
        }
    }

    public String getRoleClassNames() {
        return this.roleClassNames;
    }

    public void setRoleClassNames(String roleClassNames) {
        int comma;
        this.roleClassNames = roleClassNames;
        this.roleClasses.clear();
        String temp = this.roleClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.roleClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.roleClasses.add(temp);
        }
    }

    public String getUserClassNames() {
        return this.userClassNames;
    }

    public void setUserClassNames(String userClassNames) {
        int comma;
        this.userClassNames = userClassNames;
        this.userClasses.clear();
        String temp = this.userClassNames;
        if (temp == null) {
            return;
        }
        while ((comma = temp.indexOf(44)) >= 0) {
            this.userClasses.add(temp.substring(0, comma).trim());
            temp = temp.substring(comma + 1);
        }
        temp = temp.trim();
        if (temp.length() > 0) {
            this.userClasses.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Principal authenticate(String username, char[] credentials) {
        try {
            Principal principal;
            LoginContext loginContext = null;
            if (this.appName == null) {
                this.appName = "Tomcat";
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Authenticating " + this.appName + " " + username);
            }
            ClassLoader ocl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                loginContext = new LoginContext(this.appName, new JAASCallbackHandler(this, username, credentials));
            }
            catch (Throwable e) {
                String msg;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Error initializing JAAS: " + e.toString());
                    msg = MessageFormat.format(rb.getString(LOGIN_EXCEPTION_AUTHENTICATING_USERNAME), username);
                    log.log(Level.FINE, msg, e);
                }
                msg = null;
                return msg;
            }
            finally {
                Thread.currentThread().setContextClassLoader(ocl);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Login context created " + username);
            }
            Subject subject = null;
            try {
                loginContext.login();
                subject = loginContext.getSubject();
                if (subject == null) {
                    if (!log.isLoggable(Level.FINE)) return null;
                    log.log(Level.FINE, USERNAME_NOT_AUTHENTICATED_FAILED_LOGIN, username);
                    return null;
                }
            }
            catch (AccountExpiredException e) {
                if (!log.isLoggable(Level.FINE)) return null;
                log.log(Level.FINE, USERNAME_NOT_AUTHENTICATED_EXPIRED_ACCOUNT, username);
                return null;
            }
            catch (CredentialExpiredException e) {
                if (!log.isLoggable(Level.FINE)) return null;
                log.log(Level.FINE, USERNAME_NOT_AUTHENTICATED_EXPIRED_CREDENTIAL, username);
                return null;
            }
            catch (FailedLoginException e) {
                if (!log.isLoggable(Level.FINE)) return null;
                log.log(Level.FINE, USERNAME_NOT_AUTHENTICATED_FAILED_LOGIN, username);
                return null;
            }
            catch (LoginException e) {
                String msg = MessageFormat.format(rb.getString(LOGIN_EXCEPTION_AUTHENTICATING_USERNAME), username);
                log.log(Level.FINE, msg, e);
                return null;
            }
            catch (Throwable e) {
                log.log(Level.FINE, "Unexpected error", e);
                return null;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Getting principal " + subject);
            }
            if ((principal = this.createPrincipal(username, subject)) == null) {
                if (!log.isLoggable(Level.FINE)) return null;
                log.log(Level.FINE, "Failed to authenticate username " + username);
                return null;
            }
            if (!log.isLoggable(Level.FINE)) return principal;
            log.log(Level.FINE, "Successful to authenticate username " + username);
            return principal;
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, AUTHENTICATION_ERROR, t);
            return null;
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    protected char[] getPassword(String username) {
        return null;
    }

    @Override
    protected Principal getPrincipal(String username) {
        return null;
    }

    protected Principal createPrincipal(String username, Subject subject) {
        ArrayList<String> roles = new ArrayList<String>();
        for (Principal principal : subject.getPrincipals()) {
            if (principal instanceof GenericPrincipal) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Found old GenericPrincipal " + principal);
                }
                return principal;
            }
            String principalClass = principal.getClass().getName();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Principal: " + principalClass + " " + principal);
            }
            if (this.userClasses.contains(principalClass)) {
                username = principal.getName();
            }
            if (this.roleClasses.contains(principalClass)) {
                roles.add(principal.getName());
            }
            if (!(principal instanceof Group) || !"Roles".equals(principal.getName())) continue;
            Group grp = (Group)principal;
            Enumeration en = grp.members();
            while (en.hasMoreElements()) {
                Principal roleP = (Principal)en.nextElement();
                roles.add(roleP.getName());
            }
        }
        if (username != null) {
            return new GenericPrincipal(this, username, null, roles);
        }
        return null;
    }

    @Override
    public void start() throws LifecycleException {
        super.start();
    }

    @Override
    public void stop() throws LifecycleException {
        super.stop();
    }
}

