/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.common;

import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;

public class JIException
extends Exception {
    private static final long serialVersionUID = 8648697261032503931L;
    private String message = null;
    private int errorCode = -1;

    public JIException(int errorCode, String message) {
        this(errorCode, message, null);
    }

    public JIException(int errorCode) {
        this(errorCode, (Throwable)null);
    }

    public JIException(int errorCode, Throwable cause) {
        this(errorCode, null, cause);
    }

    public JIException(JIRuntimeException exception) {
        this(exception.getHResult(), null, exception);
    }

    public JIException(int errorCode, String message, Throwable cause) {
        super.initCause(cause);
        this.errorCode = errorCode;
        this.message = message;
    }

    public String getMessage() {
        return this.message == null ? (this.message = this.initMessageFromBundle()) : this.message;
    }

    private String initMessageFromBundle() {
        this.message = JISystem.getLocalizedMessage(this.errorCode);
        return this.message;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

