/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.WorkbenchJob;
import org.rssowl.ui.internal.ContextMenuCreator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.views.explorer.BookMarkFilter;
import org.rssowl.ui.internal.views.explorer.Messages;

class BookMarkSearchbar
extends Composite {
    private static final int FILTER_DELAY = 300;
    private static final String BAR_ACTION_ID = "org.rssowl.ui.internal.views.explorer.BarAction";
    private Composite fFilterComposite;
    private ToolBarManager fFilterToolBar;
    private Object[] fExpandedElements;
    private Text fFilterText;
    private String fInitialText = "";
    private BookMarkFilter fPatternFilter;
    private Job fRefreshJob;
    private Object[] fSelectedElements;
    private TreeViewer fViewer;
    private IViewSite fViewSite;

    BookMarkSearchbar(IViewSite viewSite, Composite parent, TreeViewer viewer, BookMarkFilter patternFilter) {
        super(parent, 0);
        this.fViewSite = viewSite;
        this.fViewer = viewer;
        this.fPatternFilter = patternFilter;
        this.createControl(parent);
        this.createRefreshJob();
        this.setFont(parent.getFont());
    }

    private void createClearText(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800100);
        this.fFilterToolBar = new ToolBarManager(toolBar);
        this.fFilterToolBar.getControl().setBackground(parent.getBackground());
        this.fFilterToolBar.getControl().setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        ((GridData)toolBar.getLayoutData()).exclude = true;
        toolBar.setVisible(false);
        Action clearTextAction = new Action("", 1){

            public void run() {
                BookMarkSearchbar.this.setFilterText("");
            }
        };
        clearTextAction.setToolTipText(Messages.BookMarkSearchbar_CLEAR);
        clearTextAction.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/clear.gif"));
        this.fFilterToolBar.add((IAction)clearTextAction);
    }

    private void createControl(Composite parent) {
        int prefContainerHeight;
        int prefToolbarHeight;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.fFilterComposite = new Composite((Composite)this, 0);
        GridLayout filterLayout = new GridLayout(OwlUI.needsCancelControl() ? 3 : 2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        filterLayout.horizontalSpacing = 3;
        this.fFilterComposite.setLayout((Layout)filterLayout);
        this.fFilterComposite.setFont(parent.getFont());
        this.fFilterComposite.setBackground(parent.getBackground());
        this.createFilterControls(this.fFilterComposite);
        this.fFilterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fFilterComposite.setBackground(parent.getBackground());
        if (this.fFilterToolBar != null && (prefToolbarHeight = this.fFilterToolBar.getControl().computeSize((int)-1, (int)-1).y) >= (prefContainerHeight = this.fFilterComposite.computeSize((int)-1, (int)-1).y)) {
            ((GridData)this.fFilterComposite.getLayoutData()).heightHint = prefToolbarHeight;
        }
    }

    private Composite createFilterControls(Composite parent) {
        this.createFilterTarget(parent);
        this.createFilterText(parent);
        if (OwlUI.needsCancelControl()) {
            this.createClearText(parent);
        }
        if (this.fFilterToolBar != null) {
            this.fFilterToolBar.update(false);
            this.fFilterToolBar.getControl().setVisible(false);
        }
        return parent;
    }

    private void createFilterTarget(Composite parent) {
        final ToolBarManager filterTargetManager = new ToolBarManager(0x800000);
        Action filterTargetAction = new Action("", 4){

            public void run() {
                OwlUI.positionDropDownMenu(this, filterTargetManager);
            }

            public String getId() {
                return BookMarkSearchbar.BAR_ACTION_ID;
            }
        };
        filterTargetAction.setMenuCreator((IMenuCreator)new ContextMenuCreator(){

            public Menu createMenu(Control parent) {
                Menu menu = new Menu(parent);
                final MenuItem searchName = new MenuItem(menu, 16);
                searchName.setText(Messages.BookMarkSearchbar_NAME);
                searchName.setSelection(BookMarkFilter.SearchTarget.NAME == BookMarkSearchbar.this.fPatternFilter.getSearchTarget());
                searchName.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchName.getSelection() && BookMarkSearchbar.this.fPatternFilter.getSearchTarget() != BookMarkFilter.SearchTarget.NAME) {
                            BookMarkSearchbar.this.doSearch(BookMarkFilter.SearchTarget.NAME);
                        }
                    }
                });
                final MenuItem searchLink = new MenuItem(menu, 16);
                searchLink.setText(Messages.BookMarkSearchbar_LINK);
                searchLink.setSelection(BookMarkFilter.SearchTarget.LINK == BookMarkSearchbar.this.fPatternFilter.getSearchTarget());
                searchLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (searchLink.getSelection() && BookMarkSearchbar.this.fPatternFilter.getSearchTarget() != BookMarkFilter.SearchTarget.LINK) {
                            BookMarkSearchbar.this.doSearch(BookMarkFilter.SearchTarget.LINK);
                        }
                    }
                });
                return menu;
            }
        });
        filterTargetAction.setImageDescriptor(OwlUI.getImageDescriptor("icons/etool16/find.gif"));
        filterTargetManager.add((IAction)filterTargetAction);
        filterTargetManager.createControl(parent);
        filterTargetManager.getControl().setLayoutData((Object)new GridData(1, 0x1000000, false, true));
    }

    private void doSearch(BookMarkFilter.SearchTarget target) {
        this.fPatternFilter.setSearchTarget(target);
        this.fFilterText.setFocus();
        if (this.fPatternFilter.getSearchTarget() == BookMarkFilter.SearchTarget.NAME) {
            this.fFilterText.setMessage(Messages.BookMarkSearchbar_NAME);
        } else {
            this.fFilterText.setMessage(Messages.BookMarkSearchbar_LINK);
        }
        if (this.fFilterText.getText().length() > 0) {
            this.textChanged();
        }
    }

    private void createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 2436);
        this.fFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (this.fPatternFilter.getSearchTarget() == BookMarkFilter.SearchTarget.NAME) {
            this.fFilterText.setMessage(Messages.BookMarkSearchbar_NAME);
        } else {
            this.fFilterText.setMessage(Messages.BookMarkSearchbar_LINK);
        }
        Controller.getDefault().getContextService().registerInputField((Control)this.fFilterText);
        this.fFilterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = BookMarkSearchbar.this.fFilterText.getText();
                e.result = filterTextString.length() == 0 ? BookMarkSearchbar.this.fInitialText : filterTextString;
            }
        });
        this.fFilterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JobRunner.runInUIThread(0, true, (Widget)BookMarkSearchbar.this.fFilterText, new Runnable(){

                    public void run() {
                        if (BookMarkSearchbar.this.fInitialText.equals(BookMarkSearchbar.this.fFilterText.getText().trim())) {
                            BookMarkSearchbar.this.fFilterText.selectAll();
                        }
                    }
                });
                BookMarkSearchbar.this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(true);
                BookMarkSearchbar.this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(true);
                BookMarkSearchbar.this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
                BookMarkSearchbar.this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.CUT.getId()).setEnabled(false);
                BookMarkSearchbar.this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()).setEnabled(false);
                BookMarkSearchbar.this.fViewSite.getActionBars().getGlobalActionHandler(ActionFactory.PASTE.getId()).setEnabled(false);
            }
        });
        this.fFilterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                if (e.character == '\u001b') {
                    BookMarkSearchbar.this.setFilterText("");
                    BookMarkSearchbar.this.fViewer.getTree().setFocus();
                    return;
                }
                boolean bl = hasItems = BookMarkSearchbar.this.fViewer.getTree().getItemCount() > 0;
                if (hasItems && (e.keyCode == 0x1000002 || e.keyCode == 0x1000001)) {
                    BookMarkSearchbar.this.fViewer.getTree().setFocus();
                } else if (e.character == '\r') {
                    return;
                }
            }
        });
        this.fFilterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (BookMarkSearchbar.this.fViewer.getTree().getItemCount() > 0) {
                        TreeItem item;
                        boolean textChanged;
                        boolean hasFocus = BookMarkSearchbar.this.fViewer.getTree().setFocus();
                        boolean bl = textChanged = !BookMarkSearchbar.this.fInitialText.equals(BookMarkSearchbar.this.fFilterText.getText().trim());
                        if (hasFocus && textChanged && BookMarkSearchbar.this.fFilterText.getText().trim().length() > 0 && (item = BookMarkSearchbar.this.getFirstMatchingItem(BookMarkSearchbar.this.fViewer.getTree().getItems())) != null) {
                            BookMarkSearchbar.this.fViewer.getTree().setSelection(new TreeItem[]{item});
                            ISelection sel = BookMarkSearchbar.this.fViewer.getSelection();
                            BookMarkSearchbar.this.fViewer.setSelection(sel, true);
                        }
                    }
                }
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BookMarkSearchbar.this.textChanged();
            }
        });
    }

    private void createRefreshJob() {
        this.fRefreshJob = new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                String text;
                if (BookMarkSearchbar.this.fViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String string = text = BookMarkSearchbar.this.fFilterText != null ? BookMarkSearchbar.this.fFilterText.getText() : null;
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = BookMarkSearchbar.this.fInitialText != null && BookMarkSearchbar.this.fInitialText.equals(text);
                if (initial) {
                    BookMarkSearchbar.this.fPatternFilter.setPattern(null);
                } else {
                    BookMarkSearchbar.this.fPatternFilter.setPattern(text);
                }
                try {
                    IStructuredSelection sel;
                    BookMarkSearchbar.this.fViewer.getControl().getParent().setRedraw(false);
                    if (BookMarkSearchbar.this.fExpandedElements == null) {
                        BookMarkSearchbar.this.fExpandedElements = BookMarkSearchbar.this.fViewer.getExpandedElements();
                    }
                    if (!(sel = (IStructuredSelection)BookMarkSearchbar.this.fViewer.getSelection()).isEmpty()) {
                        BookMarkSearchbar.this.fSelectedElements = sel.toArray();
                    }
                    BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            BookMarkSearchbar.this.fViewer.refresh(false);
                        }
                    });
                    if (text.length() == 0) {
                        BookMarkSearchbar.this.fViewer.collapseAll();
                        Object[] objectArray = BookMarkSearchbar.this.fExpandedElements;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object element = objectArray[n2];
                            BookMarkSearchbar.this.fViewer.setExpandedState(element, true);
                            ++n2;
                        }
                        if (BookMarkSearchbar.this.fSelectedElements != null) {
                            BookMarkSearchbar.this.fViewer.setSelection((ISelection)new StructuredSelection(BookMarkSearchbar.this.fSelectedElements), true);
                        }
                        BookMarkSearchbar.this.fExpandedElements = null;
                        BookMarkSearchbar.this.fSelectedElements = null;
                    }
                    if (text.length() > 0 && !initial) {
                        Object[] elements;
                        IStructuredContentProvider provider = (IStructuredContentProvider)BookMarkSearchbar.this.fViewer.getContentProvider();
                        Object[] objectArray = elements = provider.getElements(BookMarkSearchbar.this.fViewer.getInput());
                        int n = elements.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object element = objectArray[n3];
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            BookMarkSearchbar.this.fViewer.expandToLevel(element, -1);
                            ++n3;
                        }
                        TreeItem[] items = BookMarkSearchbar.this.fViewer.getTree().getItems();
                        if (items.length > 0) {
                            BookMarkSearchbar.this.fViewer.getTree().showItem(items[0]);
                        }
                        BookMarkSearchbar.this.setToolBarVisible(true);
                    } else {
                        BookMarkSearchbar.this.setToolBarVisible(false);
                    }
                }
                finally {
                    BookMarkSearchbar.this.fViewer.getControl().getParent().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        this.fRefreshJob.setSystem(true);
        this.fViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BookMarkSearchbar.this.fRefreshJob.cancel();
            }
        });
    }

    Text getControl() {
        return this.fFilterText;
    }

    TreeItem getFirstMatchingItem(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        if (items.length != 0) {
            TreeItem element = treeItemArray[0];
            if (this.fPatternFilter.isLeafMatch((Viewer)this.fViewer, element.getData()) && this.fPatternFilter.isElementSelectable(element.getData())) {
                return element;
            }
            return this.getFirstMatchingItem(element.getItems());
        }
        return null;
    }

    void setFilterText(String string) {
        if (this.fFilterText != null) {
            this.fFilterText.setText(string);
            this.fFilterText.selectAll();
        }
    }

    void textChanged() {
        this.fRefreshJob.cancel();
        this.fRefreshJob.schedule((long)(this.fFilterText.getText().length() != 0 ? 300 : 0));
    }

    void setToolBarVisible(boolean visible) {
        if (this.fFilterToolBar != null && ((GridData)this.fFilterToolBar.getControl().getLayoutData()).exclude == visible) {
            ((GridData)this.fFilterToolBar.getControl().getLayoutData()).exclude = !visible;
            this.fFilterToolBar.getControl().setVisible(visible);
            this.fFilterComposite.layout();
        }
    }
}

