/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.search;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.NewNewsBinAction;
import org.rssowl.ui.internal.search.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;
import org.rssowl.ui.internal.views.explorer.BookMarkLabelProvider;
import org.rssowl.ui.internal.views.explorer.BookMarkSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationControl
extends Composite {
    private Mode fMode = Mode.SEARCH_LOCATION;
    private Link fConditionLabel;
    private List<IFolderChild> fSelection;
    private boolean fModified;

    public LocationControl(Composite parent, int style) {
        this(parent, style, Mode.SEARCH_LOCATION);
    }

    public LocationControl(Composite parent, int style, Mode mode) {
        super(parent, style);
        this.fMode = mode;
        this.initComponents();
    }

    public Long[][] getSelection() {
        return this.fSelection != null ? ModelUtils.toPrimitive(this.fSelection) : null;
    }

    public void select(Long[][] selection) {
        this.fSelection = CoreUtils.toEntities((Long[][])selection);
        this.fConditionLabel.setText(this.getLabel(this.fSelection));
    }

    public boolean isModified() {
        return this.fModified;
    }

    private void initComponents() {
        this.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 1));
        this.fConditionLabel = new Link((Composite)this, 0);
        this.fConditionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fConditionLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFolderChild selectedChild = null;
                if (e.text != null && e.text.length() > 0) {
                    selectedChild = (IFolderChild)LocationControl.this.fSelection.get(Integer.valueOf(e.text));
                }
                LocationControl.this.onChangeCondition(selectedChild);
            }
        });
        this.fConditionLabel.setText(this.getLabel(this.fSelection));
    }

    private void onChangeCondition(IFolderChild selectedChild) {
        FolderChildChooserDialog dialog = new FolderChildChooserDialog(this.getShell(), selectedChild, this.fSelection);
        if (dialog.open() == 0) {
            List<IFolderChild> checkedElements = dialog.getCheckedElements();
            this.fSelection = checkedElements;
            this.fConditionLabel.setText(this.getLabel(this.fSelection));
            this.notifyListeners(24, new Event());
            this.getShell().layout(true, true);
        }
    }

    protected String getDefaultLabel() {
        if (this.fMode == Mode.SELECT_BIN) {
            return Messages.LocationControl_CHOOSE_BINS_LABEL;
        }
        return Messages.LocationControl_CHOOSE_LOCATION_LABEL;
    }

    private String getLabel(List<IFolderChild> entities) {
        if (entities == null || entities.size() == 0) {
            return "<a href=\"\">" + this.getDefaultLabel() + "</a>";
        }
        StringBuilder strB = new StringBuilder();
        int i = 0;
        while (i < entities.size()) {
            strB.append("<a href=\"" + i + "\">").append(entities.get(i).getName()).append("</a>").append(", ");
            ++i;
        }
        if (strB.length() > 0) {
            strB.delete(strB.length() - 2, strB.length());
        }
        return strB.toString();
    }

    public ISearchCondition toScopeCondition() {
        ISearchCondition condition = null;
        Long[][] selection = this.getSelection();
        if (selection != null) {
            IModelFactory factory = Owl.getModelFactory();
            ISearchField field = factory.createSearchField(19, INews.class.getName());
            condition = factory.createSearchCondition(field, SearchSpecifier.SCOPE, (Object)selection);
        }
        return condition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FolderChildChooserDialog
    extends Dialog {
        private CheckboxTreeViewer fViewer;
        private List<IFolderChild> fCheckedElements;
        private IFolderChild fSelectedElement;
        private Set<IFolderChild> fCheckedElementsCache;
        private FilteredTree fFilteredTree;
        private Button fSelectAll;

        FolderChildChooserDialog(Shell parentShell, IFolderChild selectedElement, List<IFolderChild> checkedElements) {
            super(parentShell);
            this.fCheckedElementsCache = new HashSet<IFolderChild>();
            this.fSelectedElement = selectedElement;
            this.fCheckedElements = checkedElements;
        }

        List<IFolderChild> getCheckedElements() {
            return this.fCheckedElements;
        }

        protected void okPressed() {
            Object[] checkedObjects = this.fCheckedElementsCache.toArray();
            StructuredSelection selection = new StructuredSelection(checkedObjects);
            List<IFolderChild> entities = ModelUtils.getFoldersBookMarksBins((IStructuredSelection)selection);
            CoreUtils.normalize(entities);
            this.fCheckedElements = entities;
            LocationControl.this.fModified = true;
            super.okPressed();
        }

        protected Control createDialogArea(Composite parent) {
            int viewerHeight;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 10, 10));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 1, true, false));
            switch (LocationControl.this.fMode) {
                case SEARCH_LOCATION: {
                    label.setText(Messages.LocationControl_CHOOSE_LOCATION_MSG);
                    break;
                }
                case SELECT_BIN: {
                    label.setText(Messages.LocationControl_CHOOSE_BINS_MSG);
                }
            }
            final PatternFilter filter = new PatternFilter(){

                protected boolean isLeafMatch(Viewer viewer, Object element) {
                    if (LocationControl.this.fMode == Mode.SELECT_BIN && !(element instanceof INewsBin)) {
                        return false;
                    }
                    String labelText = ((IFolderChild)element).getName();
                    if (labelText == null) {
                        return false;
                    }
                    return this.wordMatches(labelText);
                }
            };
            this.fFilteredTree = new FilteredTree(composite, 2048, filter){

                protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                    FolderChildChooserDialog.this.fViewer = new CheckboxTreeViewer(parent, 2048){

                        public void refresh(boolean updateLabels) {
                            super.refresh(updateLabels);
                            this.expandToLevel(LocationControl.this.fMode == Mode.SELECT_BIN ? -1 : 2);
                            for (IFolderChild child : FolderChildChooserDialog.this.fCheckedElementsCache) {
                                FolderChildChooserDialog.this.setParentsExpanded(child);
                                FolderChildChooserDialog.this.fViewer.setChecked((Object)child, true);
                                FolderChildChooserDialog.this.setChildsChecked(child, true, true, false);
                            }
                        }
                    };
                    FolderChildChooserDialog.this.fViewer.setAutoExpandLevel(LocationControl.this.fMode == Mode.SELECT_BIN ? -1 : 2);
                    FolderChildChooserDialog.this.fViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
                    FolderChildChooserDialog.this.fViewer.getTree().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
                    return FolderChildChooserDialog.this.fViewer;
                }

                protected void updateToolbar(boolean visible) {
                    if (this.filterToolBar != null) {
                        this.filterToolBar.getControl().setEnabled(visible);
                    }
                }

                protected Composite createFilterControls(Composite parent) {
                    Composite filterControls = super.createFilterControls(parent);
                    if (this.filterToolBar != null) {
                        this.filterToolBar.getControl().setVisible(true);
                        this.filterToolBar.getControl().setEnabled(false);
                    }
                    return filterControls;
                }
            };
            this.fFilteredTree.setInitialText("");
            if (LocationControl.this.fMode == Mode.SEARCH_LOCATION) {
                this.fFilteredTree.getFilterControl().setMessage(Messages.LocationControl_FILTER_LOCATIONS);
                OwlUI.makeAccessible((Control)this.fFilteredTree.getFilterControl(), Messages.LocationControl_FILTER_LOCATIONS);
            } else {
                this.fFilteredTree.getFilterControl().setMessage(Messages.LocationControl_FILTER_BINS);
                OwlUI.makeAccessible((Control)this.fFilteredTree.getFilterControl(), Messages.LocationControl_FILTER_BINS);
            }
            this.fFilteredTree.getViewer().getControl().setFocus();
            this.fFilteredTree.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character > ' ') {
                        String character = String.valueOf(e.character);
                        Text text = FolderChildChooserDialog.this.fFilteredTree.getFilterControl();
                        text.setFocus();
                        text.setText(character);
                        text.setSelection(1);
                        filter.setPattern(character);
                        e.doit = false;
                    }
                }
            });
            this.fFilteredTree.getFilterControl().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    boolean isFiltered = StringUtils.isSet((String)FolderChildChooserDialog.this.fFilteredTree.getFilterControl().getText());
                    if (FolderChildChooserDialog.this.fSelectAll != null) {
                        FolderChildChooserDialog.this.fSelectAll.setEnabled(!isFiltered);
                    }
                    if (isFiltered) {
                        OwlUI.setAllChecked(FolderChildChooserDialog.this.fViewer.getTree(), false);
                        FolderChildChooserDialog.this.cacheAll(false);
                    }
                }
            });
            ((GridData)composite.getLayoutData()).heightHint = viewerHeight = this.fViewer.getTree().getItemHeight() * 20 + 12;
            if (Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.BE_SORT_BY_NAME)) {
                BookMarkSorter sorter = new BookMarkSorter();
                sorter.setType(BookMarkSorter.Type.SORT_BY_NAME);
                this.fViewer.setComparator((ViewerComparator)sorter);
            }
            this.fViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getElements(Object inputElement) {
                    Set rootFolders = CoreUtils.loadRootFolders();
                    return rootFolders.toArray();
                }

                public Object[] getChildren(Object parentElement) {
                    if (parentElement instanceof IFolder) {
                        IFolder folder = (IFolder)parentElement;
                        return folder.getChildren().toArray();
                    }
                    return new Object[0];
                }

                public Object getParent(Object element) {
                    if (element instanceof IFolder) {
                        IFolder folder = (IFolder)element;
                        return folder.getParent();
                    }
                    return null;
                }

                public boolean hasChildren(Object element) {
                    if (element instanceof IFolder) {
                        IFolder folder = (IFolder)element;
                        return !folder.isEmpty();
                    }
                    return false;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.fViewer.setLabelProvider((IBaseLabelProvider)new BookMarkLabelProvider(false, true){

                public void update(ViewerCell cell) {
                    Object element;
                    super.update(cell);
                    if (LocationControl.this.fMode == Mode.SELECT_BIN && (element = cell.getElement()) instanceof IFolder && !OwlUI.isHighContrast()) {
                        cell.setForeground(FolderChildChooserDialog.this.fViewer.getControl().getDisplay().getSystemColor(15));
                    }
                }
            });
            this.fViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    switch (LocationControl.this.fMode) {
                        case SEARCH_LOCATION: {
                            return !(element instanceof ISearchMark);
                        }
                        case SELECT_BIN: {
                            if (element instanceof IFolder) {
                                return this.containsBin(((IFolder)element).getChildren());
                            }
                            return !(element instanceof ISearchMark) && !(element instanceof IBookMark);
                        }
                    }
                    return true;
                }

                private boolean containsBin(List<IFolderChild> children) {
                    for (IFolderChild child : children) {
                        if (child instanceof INewsBin) {
                            return true;
                        }
                        if (!(child instanceof IFolder) || !this.containsBin(((IFolder)child).getChildren())) continue;
                        return true;
                    }
                    return false;
                }
            });
            this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    IFolder folder;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    IFolder iFolder = folder = selection.getFirstElement() instanceof IFolder ? (IFolder)selection.getFirstElement() : null;
                    if (folder != null && !folder.isEmpty()) {
                        boolean expandedState = !FolderChildChooserDialog.this.fViewer.getExpandedState((Object)folder);
                        FolderChildChooserDialog.this.fViewer.setExpandedState((Object)folder, expandedState);
                        if (expandedState && FolderChildChooserDialog.this.fViewer.getChecked((Object)folder)) {
                            FolderChildChooserDialog.this.setChildsChecked((IFolderChild)folder, true, true, false);
                        }
                    }
                }
            });
            this.fViewer.setInput(new Object());
            if (this.fCheckedElements != null) {
                for (IFolderChild child : this.fCheckedElements) {
                    this.setParentsExpanded(child);
                    this.cache(child, true);
                    this.fViewer.setChecked((Object)child, true);
                    this.setChildsChecked(child, true, true, true);
                }
            }
            this.fViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail == 32) {
                        TreeItem item = (TreeItem)e.item;
                        if (LocationControl.this.fMode == Mode.SELECT_BIN && item.getData() instanceof IFolder) {
                            e.detail = 0;
                            e.doit = false;
                            item.setChecked(false);
                        } else {
                            IFolderChild folderChild = (IFolderChild)item.getData();
                            FolderChildChooserDialog.this.setChildsChecked(folderChild, item.getChecked(), false, true);
                            FolderChildChooserDialog.this.cache(folderChild, item.getChecked());
                            if (!item.getChecked()) {
                                FolderChildChooserDialog.this.setParentsChecked(folderChild, false, true);
                            }
                        }
                    }
                }
            });
            this.fViewer.addTreeListener(new ITreeViewerListener(){

                public void treeExpanded(TreeExpansionEvent event) {
                    boolean isChecked = FolderChildChooserDialog.this.fViewer.getChecked(event.getElement());
                    if (isChecked) {
                        FolderChildChooserDialog.this.setChildsChecked((IFolderChild)event.getElement(), isChecked, false, false);
                    }
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                }
            });
            if (this.fSelectedElement != null) {
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fSelectedElement));
                this.fViewer.getTree().showSelection();
            }
            Composite buttonContainer = new Composite(composite, 0);
            buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
            buttonContainer.setLayoutData((Object)new GridData(4, 1, true, false));
            if (LocationControl.this.fMode == Mode.SEARCH_LOCATION) {
                this.fSelectAll = new Button(buttonContainer, 8);
                this.fSelectAll.setText(Messages.LocationControl_SELECT_ALL);
                Dialog.applyDialogFont((Control)this.fSelectAll);
                this.setButtonLayoutData(this.fSelectAll);
                this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        OwlUI.setAllChecked(FolderChildChooserDialog.this.fViewer.getTree(), true);
                        FolderChildChooserDialog.this.cacheAll(true);
                    }
                });
                Button deselectAll = new Button(buttonContainer, 8);
                deselectAll.setText(Messages.LocationControl_DESELECT_ALL);
                Dialog.applyDialogFont((Control)deselectAll);
                this.setButtonLayoutData(deselectAll);
                deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        OwlUI.setAllChecked(FolderChildChooserDialog.this.fViewer.getTree(), false);
                        FolderChildChooserDialog.this.cacheAll(false);
                    }
                });
            } else {
                Button createBin = new Button(buttonContainer, 8);
                createBin.setText(Messages.LocationControl_NEW_NEWSBIN);
                Dialog.applyDialogFont((Control)createBin);
                this.setButtonLayoutData(createBin);
                createBin.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FolderChildChooserDialog.this.onCreateNewsBin();
                    }
                });
            }
            FolderChildChooserDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void onCreateNewsBin() {
            Object element;
            IFolderChild selectedFolderChild = null;
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
            if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof IFolderChild) {
                selectedFolderChild = (IFolderChild)element;
            }
            IFolder folder = (IFolder)(selectedFolderChild instanceof IFolder ? selectedFolderChild : null);
            IMark position = null;
            if (folder == null && selectedFolderChild != null && selectedFolderChild instanceof IMark) {
                folder = selectedFolderChild.getParent();
                position = (IMark)selectedFolderChild;
            }
            NewNewsBinAction action = new NewNewsBinAction(this.getShell(), folder, position);
            action.run(null);
            INewsBin newsbin = action.getNewsbin();
            if (newsbin != null) {
                this.fFilteredTree.getPatternFilter().setPattern("");
                this.fFilteredTree.getFilterControl().setText("");
                this.fViewer.refresh();
                this.fViewer.expandAll();
                this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newsbin), true);
                this.fViewer.setChecked((Object)newsbin, true);
                this.fCheckedElementsCache.add((IFolderChild)newsbin);
            }
        }

        protected Control createButtonBar(Composite parent) {
            Label sep = new Label(parent, 258);
            sep.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
            return super.createButtonBar(parent);
        }

        private void cache(IFolderChild child, boolean checked) {
            if (checked) {
                this.fCheckedElementsCache.add(child);
            } else {
                this.fCheckedElementsCache.remove(child);
            }
        }

        private void cacheAll(boolean checked) {
            Tree tree = this.fViewer.getTree();
            this.cacheAll(tree.getItems(), checked);
        }

        private void cacheAll(TreeItem[] items, boolean checked) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() != null) {
                    this.cache((IFolderChild)item.getData(), checked);
                    this.cacheAll(item.getItems(), checked);
                }
                ++n2;
            }
        }

        private void setChildsChecked(IFolderChild folderChild, boolean checked, boolean onlyExpanded, boolean cache) {
            if (folderChild instanceof IFolder && (!onlyExpanded || this.fViewer.getExpandedState((Object)folderChild))) {
                List children = ((IFolder)folderChild).getChildren();
                for (IFolderChild child : children) {
                    if (cache) {
                        this.cache(child, checked);
                    }
                    this.fViewer.setChecked((Object)child, checked);
                    this.setChildsChecked(child, checked, onlyExpanded, cache);
                }
            }
        }

        private void setParentsChecked(IFolderChild folderChild, boolean checked, boolean cache) {
            IFolder parent = folderChild.getParent();
            if (parent != null) {
                if (cache) {
                    this.cache((IFolderChild)parent, checked);
                }
                this.fViewer.setChecked((Object)parent, checked);
                this.setParentsChecked((IFolderChild)parent, checked, cache);
            }
        }

        private void setParentsExpanded(IFolderChild folderChild) {
            IFolder parent = folderChild.getParent();
            if (parent != null) {
                this.fViewer.setExpandedState((Object)parent, true);
                this.setParentsExpanded((IFolderChild)parent);
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            switch (LocationControl.this.fMode) {
                case SEARCH_LOCATION: {
                    newShell.setText(Messages.LocationControl_CHOOSE_LOCATION);
                    break;
                }
                case SELECT_BIN: {
                    newShell.setText(Messages.LocationControl_CHOOSE_BINS);
                }
            }
        }

        protected void initializeBounds() {
            super.initializeBounds();
            Point bestSize = this.getShell().computeSize(this.convertHorizontalDLUsToPixels(300), -1);
            this.getShell().setSize(bestSize);
            LayoutUtils.positionShell(this.getShell());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SEARCH_LOCATION,
        SELECT_BIN;

    }
}

