/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.editors.feed;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsBinReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.reference.SearchMarkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.ExpandingReader;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.FolderNewsMark;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.editors.feed.Messages;
import org.rssowl.ui.internal.editors.feed.NewsBrowserViewer;
import org.rssowl.ui.internal.editors.feed.NewsContentProvider;
import org.rssowl.ui.internal.util.CBrowser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsBrowserLabelProvider
extends LabelProvider {
    private DateFormat fDateFormat = OwlUI.getLongDateFormat();
    private DateFormat fTimeFormat = OwlUI.getShortTimeFormat();
    private final Set<String> fImageTags = new HashSet<String>(Arrays.asList("img", "map", "area"));
    private final Set<String> fMediaTags = new HashSet<String>(Arrays.asList("applet", "embed", "frame", "frameset", "iframe", "object"));
    private final Set<String> fImageAndMediaTags;
    private static final String IE_MOTW = "<!-- saved from url=(0014)about:internet -->";
    private String fNewsFontFamily;
    private String fNormalFontCSS;
    private String fVerySmallFontCSS;
    private String fSmallFontCSS;
    private String fBiggerFontCSS;
    private String fBiggestFontCSS;
    private String fStickyBGColorCSS;
    private String fNewsListBGColorCSS;
    private String fLinkFGColorCSS;
    private boolean fIsNewsListBGColorDefined;
    private IPropertyChangeListener fPropertyChangeListener;
    private final NewsBrowserViewer fViewer;
    private final boolean fIsIE;
    private boolean fStripImagesFromNews;
    private boolean fStripMediaFromNews;
    private boolean fForceShowFeedInformation;
    private boolean fManageLinks;
    private boolean fShowFooter;
    private boolean fHeadlinesOnly;
    private boolean fForceNoGrouping;
    private boolean fForceNoPaging;
    private final long fTodayInMillies;
    private final Map<String, String> fMapFeedLinkToName = new HashMap<String, String>();

    public NewsBrowserLabelProvider(CBrowser browser) {
        this(null, browser.isIE());
    }

    public NewsBrowserLabelProvider(NewsBrowserViewer viewer) {
        this(viewer, viewer.getBrowser().isIE());
    }

    private NewsBrowserLabelProvider(NewsBrowserViewer viewer, boolean isIE) {
        this.fViewer = viewer;
        this.fIsIE = isIE;
        this.fManageLinks = OwlUI.useExternalBrowser() || Owl.getPreferenceService().getGlobalScope().getBoolean(DefaultPreferences.OPEN_LINKS_IN_NEW_TAB);
        this.fShowFooter = true;
        this.fTodayInMillies = DateUtils.getToday().getTimeInMillis();
        this.fImageAndMediaTags = new HashSet<String>();
        this.fImageAndMediaTags.addAll(this.fImageTags);
        this.fImageAndMediaTags.addAll(this.fMediaTags);
        this.createFonts();
        this.createColors();
        this.registerListeners();
    }

    public void setStripMediaFromNews(boolean stripImagesFromNews, boolean stripMediaFromNews) {
        this.fStripImagesFromNews = stripImagesFromNews;
        this.fStripMediaFromNews = stripMediaFromNews;
    }

    String stripMediaTagsIfNecessary(String str) {
        if (this.fStripImagesFromNews && this.fStripMediaFromNews) {
            return StringUtils.filterTags((String)str, this.fImageAndMediaTags, (boolean)false);
        }
        if (this.fStripImagesFromNews) {
            return StringUtils.filterTags((String)str, this.fImageTags, (boolean)false);
        }
        if (this.fStripMediaFromNews) {
            return StringUtils.filterTags((String)str, this.fMediaTags, (boolean)false);
        }
        return str;
    }

    String highlightSearchTermsIfNecessary(String str) {
        Collection<String> wordsToHighlight;
        if (this.fViewer != null && !(wordsToHighlight = this.fViewer.getHighlightedWords()).isEmpty()) {
            StringBuilder highlightedResult = new StringBuilder(str.length());
            RGB searchRGB = OwlUI.getThemeRGB("org.rssowl.ui.SearchHighlightBGColor", new RGB(255, 255, 0));
            String preHighlight = "<span style=\"background-color:rgb(" + OwlUI.toString(searchRGB) + ");\">";
            String postHighlight = "</span>";
            ExpandingReader resultHighlightReader = new ExpandingReader((Reader)new StringReader(str), wordsToHighlight, preHighlight, postHighlight, true);
            int len = 0;
            char[] buf = new char[1000];
            try {
                while ((len = resultHighlightReader.read(buf)) != -1) {
                    highlightedResult.append(buf, 0, len);
                }
                return highlightedResult.toString();
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        return str;
    }

    public void setForceShowFeedInformation(boolean forceShowFeedInformation) {
        this.fForceShowFeedInformation = forceShowFeedInformation;
    }

    public void setShowFooter(boolean showFooter) {
        this.fShowFooter = showFooter;
    }

    public void setHeadlinesOnly(boolean headlinesOnly) {
        this.fHeadlinesOnly = headlinesOnly;
    }

    boolean isHeadlinesOnly() {
        return this.fHeadlinesOnly;
    }

    public void dispose() {
        super.dispose();
        this.unregisterListeners();
        this.fMapFeedLinkToName.clear();
    }

    private void registerListeners() {
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("org.rssowl.ui.NewsTextFont".equals(property)) {
                    NewsBrowserLabelProvider.this.createFonts();
                } else if ("org.rssowl.ui.StickyBGColor".equals(property) || "org.rssowl.ui.LinkFGColor".equals(property) || "org.rssowl.ui.NewsListBackgroundColor".equals(property)) {
                    NewsBrowserLabelProvider.this.createColors();
                }
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private void unregisterListeners() {
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    private void createFonts() {
        int fontHeight = 10;
        Font newsFont = OwlUI.getThemeFont("org.rssowl.ui.NewsTextFont", 0);
        FontData[] fontData = newsFont.getFontData();
        if (fontData.length > 0) {
            this.fNewsFontFamily = fontData[0].getName();
            fontHeight = fontData[0].getHeight();
        }
        int normal = fontHeight;
        int verysmall = normal - 2;
        int small = normal - 1;
        int bigger = normal + 1;
        int biggest = bigger + 2;
        String fontUnit = "pt";
        this.fNormalFontCSS = "font-size: " + normal + fontUnit + ";";
        this.fVerySmallFontCSS = "font-size: " + verysmall + fontUnit + ";";
        this.fSmallFontCSS = "font-size: " + small + fontUnit + ";";
        this.fBiggerFontCSS = "font-size: " + bigger + fontUnit + ";";
        this.fBiggestFontCSS = "font-size: " + biggest + fontUnit + ";";
    }

    private void createColors() {
        RGB stickyRgb = OwlUI.getThemeRGB("org.rssowl.ui.StickyBGColor", new RGB(255, 255, 180));
        this.fStickyBGColorCSS = "background-color: rgb(" + stickyRgb.red + "," + stickyRgb.green + "," + stickyRgb.blue + ");";
        RGB linkRgb = OwlUI.getThemeRGB("org.rssowl.ui.LinkFGColor", new RGB(0, 0, 153));
        this.fLinkFGColorCSS = "color: rgb(" + linkRgb.red + "," + linkRgb.green + "," + linkRgb.blue + ");";
        RGB newsListRgb = OwlUI.getThemeRGB("org.rssowl.ui.NewsListBackgroundColor", new RGB(255, 255, 255));
        this.fNewsListBGColorCSS = "background-color: rgb(" + newsListRgb.red + "," + newsListRgb.green + "," + newsListRgb.blue + ");";
        this.fIsNewsListBGColorDefined = !newsListRgb.equals((Object)new RGB(255, 255, 255));
    }

    public String getText(Object element) {
        return this.getText(element, true, true, -1);
    }

    public String getText(Object element, boolean withInternalLinks, boolean withManagedLinks, int index) {
        if (element instanceof EntityGroup) {
            return this.getLabel((EntityGroup)element, withInternalLinks);
        }
        if (element instanceof INews) {
            return this.getLabel((INews)element, withInternalLinks, withManagedLinks, false, index);
        }
        if (element instanceof NewsBrowserViewer.PageLatch) {
            return this.getLabel((NewsBrowserViewer.PageLatch)element);
        }
        return "";
    }

    private boolean isSingleNewsDisplayed() {
        Object input = this.fViewer != null ? this.fViewer.getInput() : null;
        return input instanceof INews;
    }

    private boolean isEntityGroupDisplayed() {
        Object input = this.fViewer != null ? this.fViewer.getInput() : null;
        return input instanceof EntityGroup;
    }

    private boolean isGroupingEnabled() {
        IContentProvider cp;
        if (this.isEntityGroupDisplayed()) {
            return false;
        }
        if (this.fForceNoGrouping) {
            return false;
        }
        if (this.fViewer != null && (cp = this.fViewer.getContentProvider()) instanceof NewsContentProvider) {
            return ((NewsContentProvider)cp).isGroupingEnabled();
        }
        return false;
    }

    private boolean showFeedInformation() {
        Object input;
        if (this.fForceShowFeedInformation) {
            return true;
        }
        Object object = input = this.fViewer != null ? this.fViewer.getInput() : null;
        return input instanceof FolderNewsMark.FolderNewsMarkReference || input instanceof SearchMarkReference || input instanceof NewsBinReference;
    }

    public void writeCSS(Writer writer) throws IOException {
        this.writeCSS(writer, this.isSingleNewsDisplayed(), true);
    }

    public void writeCSS(Writer writer, boolean forSingleNews, boolean withInternalLinks) throws IOException {
        boolean isGroupingEnabled = this.isGroupingEnabled();
        writer.write("<style type=\"text/css\">\n");
        this.writeCommonCSS(writer, forSingleNews, withInternalLinks);
        if (this.fHeadlinesOnly) {
            this.writeCommonHeadlinesCSS(writer);
        } else {
            this.writeCommonNewspaperCSS(writer);
        }
        if (forSingleNews) {
            this.writesingleNewsCSS(writer);
        } else if (isGroupingEnabled && this.fHeadlinesOnly) {
            this.writeHeadlinesGroupedCSS(writer);
        } else if (isGroupingEnabled && !this.fHeadlinesOnly) {
            this.writeNewspaperGroupedCSS(writer);
        } else if (!isGroupingEnabled && this.fHeadlinesOnly) {
            this.writeHeadlinesUngroupedCSS(writer);
        } else if (!isGroupingEnabled && !this.fHeadlinesOnly) {
            this.writeNewspaperUngroupedCSS(writer);
        }
        writer.write("</style>\n");
    }

    private void writeCommonCSS(Writer writer, boolean forSingleNews, boolean withInternalLinks) throws IOException {
        writer.append("body { overflow: auto; margin: 0; font-family: ").append(this.fNewsFontFamily).append(",Verdanna,sans-serif; }\n");
        writer.append("a { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; }\n");
        writer.append("a:hover { ").append(this.fLinkFGColorCSS).append(" text-decoration: underline; }\n");
        writer.append("a:visited { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; }\n");
        writer.append("img { border: none; }\n");
        writer.append("div.hidden { display: none; }\n");
        writer.append("div.group { color: #678; ").append(this.fBiggestFontCSS).append(" font-weight: bold; margin: 10px 0px 5px 5px; padding-bottom: 3px; border-bottom: 1px solid #678; }\n");
        writer.append("div.group a { color: #678; ").append(this.fBiggestFontCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.group a:hover { color: #678; ").append(this.fBiggestFontCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.group a:visited { color: #678; ").append(this.fBiggestFontCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("span.groupNote { margin-left: 5px; ").append(this.fNormalFontCSS).append(" font-style: normal; }\n");
        writer.append("div.content { \n");
        writer.append("  padding: 15px 10px 15px 10px; border-top: dotted 1px silver; \n");
        writer.append("  background-color: #fff; clear: both; ").append(this.fNormalFontCSS).append(" font-style: normal; \n");
        writer.append("}\n");
        writer.write("div.content p { margin-top: 0 !important; padding-top: 0 !important; margin-left: 0 !important; padding-left: 0 !important; }\n");
        if (!withInternalLinks) {
            writer.append("div.title { float: left; ").append(this.fBiggerFontCSS).append(" }\n");
        }
        writer.append("div.title span.unread { font-weight: bold; }\n");
        writer.append("div.author { text-align: right; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("a.author { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.append("a.author:hover { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.append("a.author:active { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.append("a.author:visited { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.write("a.comments { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.write("a.comments:hover { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.write("a.comments:active { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.write("a.comments:visited { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.append("table.subline { margin: 0; padding: 0; }\n");
        writer.append("tr.subline { margin: 0; padding: 0; }\n");
        writer.append("td.firstactionsubline { text-align: left; width: 20px; margin: 0; padding: 0; color: rgb(80, 80, 80); ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("td.firstactionsubline a { width: 20px; }\n");
        writer.append("td.otheractionsubline { text-align: center; width: 22px; margin: 0; padding: 0; color: rgb(80, 80, 80); ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("td.otheractionsubline a { width: 22px; }\n");
        writer.append("td.subline { margin: 0; padding: 0; color: rgb(80, 80, 80); padding-right: 5px; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("td.sublineseparator { margin: 0; padding: 0; color: rgb(140, 140, 140); padding-right: 5px; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("td.actionsublineseparator { margin: 0; padding: 0; color: rgb(140, 140, 140); padding-left: 4px; padding-right: 5px; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("div.date { float: left; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("div.footerline { clear: both; ").append(this.fVerySmallFontCSS).append(" padding-left: 3px; }\n");
        writer.append("div.footerline a { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.append("div.footerline a:visited { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.append("div.footerline a:hover { color: rgb(80,80,80); text-decoration: none; }\n");
        writer.append("table.footerline { margin: 0; padding: 0; }\n");
        writer.append("tr.footerline { margin: 0; padding: 0; }\n");
        writer.append("td.footerline { margin: 0; padding: 0; padding-right: 5px; ").append(this.fVerySmallFontCSS).append(" }\n");
        writer.append("td.footerlineseparator { margin: 0; padding: 0; color: rgb(140, 140, 140); padding-right: 5px; ").append(this.fVerySmallFontCSS).append(" }\n");
        if (!forSingleNews) {
            writer.write("div.clearingFooter { clear: both; }\n");
        }
        writer.write("span.quote_lvl1 { color: #660066; }\n");
        writer.write("span.quote_lvl2 { color: #007777; }\n");
        writer.write("span.quote_lvl3 { color: #3377ff; }\n");
        writer.write("span.quote_lvl4 { color: #669966; }\n");
        writer.append("div.pageLatch { padding: 5px; text-align: center; ").append(this.fNormalFontCSS).append(" }\n");
        writer.append("div.pageLatch a { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.pageLatch a:hover { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.pageLatch a:active { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.pageLatch a:visited { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
    }

    private void writeCommonHeadlinesCSS(Writer writer) throws IOException {
        writer.append("div.title {  ").append(this.fNormalFontCSS).append(" }\n");
        writer.append("div.title a { color: black; text-decoration: none; font-style: normal; }\n");
        writer.append("div.title a.unread { font-weight: bold; text-decoration: none; font-style: normal; }\n");
        writer.append("div.title a:hover { color: black; text-decoration: none; font-style: normal; }\n");
        writer.append("div.title a:visited { color: black; text-decoration: none; font-style: normal; }\n");
        writer.append("div.titleExpanded { width: 90%; float: left; ").append(this.fBiggerFontCSS).append(" }\n");
        writer.append("div.titleExpanded a { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.titleExpanded a.unread { font-weight: bold; text-decoration: none; font-style: normal; }\n");
        writer.append("div.titleExpanded a:hover { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.titleExpanded a:visited { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.titleCollapsed { ").append(this.fNormalFontCSS).append(" }\n");
        writer.append("div.titleCollapsed a { color: rgb(80, 80, 80); text-decoration: none; font-style: normal; }\n");
        writer.append("div.titleCollapsed a.unread { color: rgb(80, 80, 80); font-weight: bold; text-decoration: none; font-style: normal; }\n");
        writer.append("div.titleCollapsed a:hover { color: rgb(80, 80, 80); text-decoration: none; font-style: normal; }\n");
        writer.append("div.titleCollapsed a:visited { color: rgb(80, 80, 80); text-decoration: none; font-style: normal; }\n");
        writer.append("a.subtitle { font-style: italic !important; text-decoration: none; padding-left: 10px; color: rgb(80, 80, 80); ").append(this.fVerySmallFontCSS).append(" }");
        writer.append("a.subtitle:hover { font-style: italic !important; text-decoration: none; padding-left: 10px; color: rgb(80, 80, 80); ").append(this.fVerySmallFontCSS).append(" }");
        writer.append("a.subtitle:visited { font-style: italic !important; text-decoration: none; padding-left: 10px; color: rgb(80, 80, 80); ").append(this.fVerySmallFontCSS).append(" }");
        writer.append("div.delete { padding-top: 5px; text-align: right; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("div.subline { margin: 8px 0px 0px 0px; padding: 0; clear: left; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("      div.footer { padding: 3px 5px 5px 5px; line-height: 20px; border-top: dotted 1px silver; clear: both; }\n");
        writer.append("div.footerSticky { padding: 3px 5px 5px 5px; line-height: 20px; border-top: dotted 1px silver; clear: both; ").append(this.fStickyBGColorCSS).append(" }\n");
    }

    private void writeCommonNewspaperCSS(Writer writer) throws IOException {
        writer.append("div.title { width: 90%; float: left; padding-bottom: 6px; ").append(this.fBiggerFontCSS).append(" }\n");
        writer.append("div.title a { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.title a.unread { font-weight: bold; text-decoration: none; font-style: normal; }\n");
        writer.append("div.title a:hover { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.title a:visited { ").append(this.fLinkFGColorCSS).append(" text-decoration: none; font-style: normal; }\n");
        writer.append("div.delete { text-align: right; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("div.subline { margin: 0; padding: 0; clear: left; ").append(this.fSmallFontCSS).append(" }\n");
        writer.append("      div.footer { padding: 3px 5px 3px 5px; line-height: 20px; border-top: dotted 1px silver; border-bottom: 1px solid white; clear: both; }\n");
        writer.append("div.footerSticky { padding: 3px 5px 3px 5px; line-height: 20px; border-top: dotted 1px silver; border-bottom: 1px dotted silver; clear: both; ").append(this.fStickyBGColorCSS).append("}\n");
    }

    private void writesingleNewsCSS(Writer writer) throws IOException {
        writer.write("  div.newsitemRead { margin: 0; }\n");
        writer.write("div.newsitemUnread { margin: 0; }\n");
        writer.append("      div.header { padding: 10px 10px 5px 10px; background-color: rgb(242,242,242); }\n");
        writer.append("div.headerSticky { padding: 10px 10px 5px 10px; ").append(this.fStickyBGColorCSS).append(" }\n");
        writer.write("       div.footer { padding: 3px 5px 3px 5px; line-height: 20px; border-top: dotted 1px silver; border-bottom: dotted 1px silver; clear: both; background-color: rgb(248,248,248); }\n");
        writer.append("div.footerSticky { padding: 3px 5px 3px 5px; line-height: 20px; border-top: dotted 1px silver; border-bottom: dotted 1px silver; clear: both; ").append(this.fStickyBGColorCSS).append("}\n");
    }

    private void writeNewspaperUngroupedCSS(Writer writer) throws IOException {
        writer.write("div.newsitemRead   { margin: 0px 0px 10px 0px; border-bottom: 1px solid white; }\n");
        writer.write("div.newsitemUnread { margin: 0px 0px 10px 0px; border-bottom: 1px solid white; }\n");
        writer.append("      div.header { padding: 10px 10px 5px 10px; border-top: 1px solid white; }\n");
        writer.append("div.headerSticky { padding: 10px 10px 5px 10px; border-top: 1px dotted silver; ").append(this.fStickyBGColorCSS).append("}\n");
    }

    private void writeNewspaperGroupedCSS(Writer writer) throws IOException {
        writer.write("  div.newsitemRead { margin: 0px 0px 10px 10px; border-bottom: 1px solid white; }\n");
        writer.write("div.newsitemUnread { margin: 0px 0px 10px 10px; border-bottom: 1px solid white; }\n");
        writer.append("      div.header { padding: 10px 10px 5px 10px; border-top: 1px solid white; }\n");
        writer.append("div.headerSticky { padding: 10px 10px 5px 10px; border-top: 1px dotted silver; ").append(this.fStickyBGColorCSS).append("}\n");
    }

    private void writeHeadlinesUngroupedCSS(Writer writer) throws IOException {
        writer.write("  div.newsitemRead { margin: 0px 0px 0px 0px; }\n");
        writer.write("div.newsitemUnread { margin: 0px 0px 0px 0px; }\n");
        writer.write("       div.header { padding: 5px 10px 5px 10px; }\n");
        writer.append("div.headerSticky { padding: 5px 10px 5px 10px; ").append(this.fStickyBGColorCSS).append(" }\n");
        writer.append("div.headlinesSeparator { margin: 0; padding: 0; border-bottom: 1px dotted silver; }\n");
    }

    private void writeHeadlinesGroupedCSS(Writer writer) throws IOException {
        writer.write("  div.newsitemRead { margin: 0px 0px 0px 10px; }\n");
        writer.write("div.newsitemUnread { margin: 0px 0px 0px 10px; }\n");
        writer.write("       div.header { padding: 5px 10px 5px 10px; }\n");
        writer.append("div.headerSticky { padding: 5px 10px 5px 10px; ").append(this.fStickyBGColorCSS).append(" }\n");
        writer.append("div.headlinesSeparator { margin: 0px 0px 0px 10px; padding: 0; border-bottom: 1px dotted silver; }\n");
    }

    private String getLabel(EntityGroup group, boolean withInternalLinks) {
        boolean isVisible = this.isVisible(group);
        StringBuilder builder = new StringBuilder();
        String groupName = StringUtils.htmlEscape((String)group.getName());
        String groupColor = null;
        if (group.getColorHint() != null && !group.getColorHint().equals((Object)new RGB(255, 255, 255))) {
            groupColor = OwlUI.toString(group.getColorHint());
        }
        StringBuilder extraCSS = new StringBuilder();
        if (!isVisible) {
            extraCSS.append("display: none; ");
        }
        if (groupColor != null) {
            extraCSS.append("border-bottom-color: rgb(" + groupColor + ");");
        }
        if (extraCSS.length() == 0) {
            this.div(builder, "group", Dynamic.GROUP.getId(group));
        } else {
            this.div(builder, "group", extraCSS.toString(), Dynamic.GROUP.getId(group));
        }
        if (withInternalLinks) {
            String link = "rssowl://org.rssowl.ui.CollapseGroup?" + group.getId();
            this.imageLink(builder, link, null, null, "/icons/elcl16/expanded.gif", "expanded.gif", Dynamic.TOGGLE_GROUP_LINK.getId(group), Dynamic.TOGGLE_GROUP_IMG.getId(group));
            link = "rssowl://org.rssowl.ui.GroupMenu?" + group.getId();
            this.link(builder, link, groupName, null, Dynamic.GROUP_MENU_LINK.getId(group), groupColor);
        } else {
            this.span(builder, groupName, null, groupColor);
        }
        int actualSize = group.getSizeHint();
        int totalSize = group.getEntities().size();
        String groupNote = this.getGroupNote(actualSize, totalSize);
        this.span(builder, groupNote, "groupNote", Dynamic.GROUP_NOTE.getId(group), groupColor);
        this.close(builder, "div");
        return builder.toString();
    }

    String getGroupNote(int actualSize, int totalSize) {
        int sizeDiff = totalSize - actualSize;
        String groupNote = actualSize == 1 ? (sizeDiff == 0 ? Messages.NewsBrowserLabelProvider_ONE_ARTICLE : NLS.bind((String)Messages.NewsBrowserLabelProvider_ONE_ARTICLE_N_FILTERED, (Object)sizeDiff)) : (sizeDiff == 0 ? NLS.bind((String)Messages.NewsBrowserLabelProvider_N_ARTICLES, (Object)actualSize) : NLS.bind((String)Messages.NewsBrowserLabelProvider_N_ARTICLES_M_FILTERED, (Object)actualSize, (Object)sizeDiff));
        return groupNote;
    }

    private StringBuilder getBuilder(INews news, String description) {
        int capacity = 0;
        if (news.getTitle() != null) {
            capacity += news.getTitle().length();
        }
        if (description != null) {
            capacity += description.length();
        }
        return new StringBuilder(capacity);
    }

    String getLabel(INews news, boolean withInternalLinks, boolean withManagedLinks, boolean onlyInnerContent, int index) {
        boolean isUnread;
        boolean isVisible = this.isVisible(news) || this.fForceNoPaging;
        String description = null;
        if (!this.fHeadlinesOnly && isVisible) {
            description = this.stripMediaTagsIfNecessary(news.getDescription());
        }
        StringBuilder builder = this.getBuilder(news, description);
        INews.State state = news.getState();
        boolean bl = isUnread = state == INews.State.NEW || state == INews.State.UPDATED || state == INews.State.UNREAD;
        if (!onlyInnerContent) {
            StringBuilder extraCSS = new StringBuilder();
            if (!isVisible) {
                extraCSS.append("display: none; ");
            }
            if (index != 0 && this.fIsNewsListBGColorDefined && index % 2 != 0) {
                extraCSS.append(this.fNewsListBGColorCSS);
            }
            if (extraCSS.length() != 0) {
                this.div(builder, isUnread ? "newsitemUnread" : "newsitemRead", extraCSS.toString(), Dynamic.NEWS.getId(news));
            } else {
                this.div(builder, isUnread ? "newsitemUnread" : "newsitemRead", Dynamic.NEWS.getId(news));
            }
        }
        if (isVisible) {
            String link;
            String feedName;
            String link2;
            String cssClass;
            String color;
            String newsTitle = CoreUtils.getHeadline((INews)news, (boolean)false);
            String newsLink = CoreUtils.getLink((INews)news);
            boolean hasLink = newsLink != null;
            Set labels = CoreUtils.getSortedLabels((INews)news);
            String string = color = !labels.isEmpty() ? ((ILabel)labels.iterator().next()).getColor() : null;
            if ("0,0,0".equals(color) || "255,255,255".equals(color)) {
                color = null;
            }
            if (index == 0) {
                this.div(builder, news.isFlagged() ? "headerSticky" : "header", "border-top: none;", Dynamic.HEADER.getId(news));
            } else {
                this.div(builder, news.isFlagged() ? "headerSticky" : "header", Dynamic.HEADER.getId(news));
            }
            this.div(builder, "title", Dynamic.TITLE.getId(news));
            String string2 = cssClass = isUnread ? "unread" : "read";
            if (this.fHeadlinesOnly) {
                String link3 = "rssowl://org.rssowl.ui.ToggleSticky?" + news.getId();
                this.imageLink(builder, link3, Messages.NewsBrowserLabelProvider_STICKY, Messages.NewsBrowserLabelProvider_STICKY, "/icons/obj16/news_pin_light_tiny.gif", "news_pin_light_tiny.gif", Dynamic.TINY_TOGGLE_STICKY_LINK.getId(news), null);
                link3 = "rssowl://org.rssowl.ui.ExpandNews?" + news.getId();
                this.link(builder, link3, newsTitle, cssClass, Dynamic.TITLE_LINK.getId(news), color);
                StringBuilder subtitleContent = new StringBuilder();
                this.fillSubtitle(subtitleContent, news, labels, false);
                this.link(builder, link3, subtitleContent.toString(), "subtitle", Dynamic.SUBTITLE_LINK.getId(news), "80, 80, 80");
            } else if (hasLink) {
                this.link(builder, this.fManageLinks && withManagedLinks ? URIUtils.toManaged((String)newsLink) : newsLink, newsTitle, cssClass, Dynamic.TITLE_LINK.getId(news), color);
            } else {
                this.span(builder, newsTitle, cssClass, Dynamic.TITLE_LINK.getId(news), color);
            }
            this.close(builder, "div");
            if (withInternalLinks) {
                if (this.fHeadlinesOnly) {
                    this.div(builder, "delete", "display: none;", Dynamic.DELETE.getId(news));
                } else {
                    this.div(builder, "delete", Dynamic.DELETE.getId(news));
                }
                link2 = "rssowl://org.rssowl.ui.Delete?" + news.getId();
                this.imageLink(builder, link2, Messages.NewsBrowserLabelProvider_DELETE, Messages.NewsBrowserLabelProvider_DELETE, "/icons/elcl16/remove_small.gif", "remove_small.gif", null, null);
                this.close(builder, "div");
            }
            if (this.fHeadlinesOnly) {
                this.div(builder, "subline", "display: none;", Dynamic.SUBLINE.getId(news));
            } else {
                this.div(builder, "subline", Dynamic.SUBLINE.getId(news));
            }
            builder.append("<table class=\"subline\">");
            builder.append("<tr class=\"subline\">");
            if (withInternalLinks) {
                builder.append("<td class=\"firstactionsubline\">");
                link2 = "rssowl://org.rssowl.ui.ToggleRead?" + news.getId();
                String text = news.getState() == INews.State.READ ? Messages.NewsBrowserLabelProvider_MARK_UNREAD : Messages.NewsBrowserLabelProvider_MARK_READ;
                this.imageLink(builder, link2, text, text, "/icons/elcl16/mark_read_light.gif", "mark_read_light.gif", Dynamic.TOGGLE_READ_LINK.getId(news), Dynamic.TOGGLE_READ_IMG.getId(news));
                builder.append("</td>");
                builder.append("<td class=\"otheractionsubline\">");
                link2 = "rssowl://org.rssowl.ui.ToggleSticky?" + news.getId();
                this.imageLink(builder, link2, Messages.NewsBrowserLabelProvider_STICKY, Messages.NewsBrowserLabelProvider_STICKY, news.isFlagged() ? "/icons/obj16/news_pinned_light.gif" : "/icons/obj16/news_pin_light.gif", news.isFlagged() ? "news_pinned_light.gif" : "news_pin_light.gif", Dynamic.TOGGLE_STICKY_LINK.getId(news), Dynamic.TOGGLE_STICKY_IMG.getId(news));
                builder.append("</td>");
                builder.append("<td class=\"otheractionsubline\">");
                link2 = "rssowl://org.rssowl.ui.LabelsMenu?" + news.getId();
                this.imageLink(builder, link2, Messages.NewsBrowserLabelProvider_ASSIGN_LABELS, Messages.NewsBrowserLabelProvider_LABEL, "/icons/elcl16/labels_light.gif", "labels_light.gif", Dynamic.LABELS_MENU_LINK.getId(news), null);
                builder.append("</td>");
                builder.append("<td class=\"otheractionsubline\">");
                link2 = "rssowl://org.rssowl.ui.Archive?" + news.getId();
                this.imageLink(builder, link2, Messages.NewsBrowserLabelProvider_ARCHIVE_NEWS, Messages.NewsBrowserLabelProvider_ARCHIVE, "/icons/etool16/archive_light.gif", "archive_light.gif", Dynamic.ARCHIVE_LINK.getId(news), null);
                builder.append("</td>");
                builder.append("<td class=\"otheractionsubline\">");
                link2 = "rssowl://org.rssowl.ui.ShareNewsMenu?" + news.getId();
                this.imageLink(builder, link2, Messages.NewsBrowserLabelProvider_SHARE_NEWS, Messages.NewsBrowserLabelProvider_SHARE, "/icons/elcl16/share_light.gif", "share_light.gif", Dynamic.SHARE_MENU_LINK.getId(news), null);
                builder.append("</td>");
                builder.append("<td class=\"otheractionsubline\">");
                link2 = "rssowl://org.rssowl.ui.NewsMenu?" + news.getId();
                this.imageLink(builder, link2, Messages.NewsBrowserLabelProvider_MENU, Messages.NewsBrowserLabelProvider_MENU, "/icons/obj16/menu_light.gif", "menu_light.gif", Dynamic.NEWS_MENU_LINK.getId(news), null);
                builder.append("</td>");
                builder.append("<td class=\"actionsublineseparator\">");
                builder.append("|");
                builder.append("</td>");
            }
            builder.append("<td class=\"subline\">");
            this.fillDate(news, builder);
            builder.append("</td>");
            IPerson author = news.getAuthor();
            if (author != null) {
                builder.append("<td class=\"sublineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"subline\">");
                this.fillAuthor(builder, author, true);
                builder.append("</td>");
            }
            if (this.showFeedInformation() && StringUtils.isSet((String)(feedName = this.getFeedName(news)))) {
                builder.append("<td class=\"sublineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"subline\">");
                builder.append(feedName);
                builder.append("</td>");
            }
            if (StringUtils.isSet((String)news.getComments()) && news.getComments().trim().length() > 0 && URIUtils.looksLikeLink((String)news.getComments())) {
                builder.append("<td class=\"sublineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"subline\">");
                String comments = news.getComments();
                this.imageLink(builder, comments, Messages.NewsBrowserLabelProvider_READ_COMMENTS, Messages.NewsBrowserLabelProvider_COMMENTS, "/icons/obj16/comments_light.gif", "comments_light.gif", null, null);
                builder.append("</td>");
            }
            boolean hasAttachments = false;
            List attachments = news.getAttachments();
            for (IAttachment attachment : attachments) {
                if (attachment.getLink() == null) continue;
                hasAttachments = true;
                break;
            }
            if (hasAttachments) {
                builder.append("<td class=\"sublineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"subline\">");
                link = "rssowl://org.rssowl.ui.AttachmentsMenu?" + news.getId();
                this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_ATTACHMENTS, Messages.NewsBrowserLabelProvider_ATTACHMENTS, "/icons/obj16/attachment_light.gif", "attachment_light.gif", Dynamic.ATTACHMENTS_MENU_LINK.getId(news), null);
                builder.append("</td>");
            }
            if (labels.isEmpty()) {
                builder.append("<td id=\"").append(Dynamic.LABELS_SEPARATOR.getId(news)).append("\" class=\"sublineseparator\" style=\"display: none;\">");
            } else {
                builder.append("<td id=\"").append(Dynamic.LABELS_SEPARATOR.getId(news)).append("\" class=\"sublineseparator\">");
            }
            builder.append("|");
            builder.append("</td>");
            builder.append("<td id=\"").append(Dynamic.LABELS.getId(news)).append("\" class=\"subline\">");
            this.fillLabels(builder, labels);
            builder.append("</td>");
            builder.append("</tr>");
            builder.append("</table>");
            this.close(builder, "div");
            this.close(builder, "div");
            StringBuilder extraCSS = new StringBuilder();
            if (this.fHeadlinesOnly) {
                extraCSS.append("display: none; ");
            }
            if (index != 0 && this.fIsNewsListBGColorDefined && index % 2 != 0) {
                extraCSS.append(this.fNewsListBGColorCSS);
            }
            if (extraCSS.length() > 0) {
                this.div(builder, "content", extraCSS.toString(), Dynamic.CONTENT.getId(news));
            } else {
                this.div(builder, "content", Dynamic.CONTENT.getId(news));
            }
            if (!this.fHeadlinesOnly) {
                if (StringUtils.isSet((String)description) && description != null && !description.equals(news.getTitle())) {
                    builder.append(description);
                } else {
                    builder.append(Messages.NewsBrowserLabelProvider_NO_CONTENT);
                    if (withInternalLinks && hasLink) {
                        builder.append(" ");
                        String link4 = "rssowl://org.rssowl.ui.TransformNews?" + news.getId();
                        this.link(builder, link4, Messages.NewsBrowserLabelProvider_ATTEMPT_DOWNLOAD_AND_DISPLAY, null);
                    }
                }
            }
            this.close(builder, "div");
            if (withInternalLinks && this.fShowFooter) {
                ISource source;
                if (this.fHeadlinesOnly) {
                    this.div(builder, news.isFlagged() ? "footerSticky" : "footer", "display: none;", Dynamic.FOOTER.getId(news));
                } else {
                    this.div(builder, news.isFlagged() ? "footerSticky" : "footer", Dynamic.FOOTER.getId(news));
                }
                this.div(builder, "footerline");
                builder.append("<table class=\"footerline\">");
                builder.append("<tr class=\"footerline\">");
                if (this.fHeadlinesOnly) {
                    builder.append("<td class=\"footerline\">");
                    link = "rssowl://org.rssowl.ui.CollapseNews?" + news.getId();
                    this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_COLLAPSE, Messages.NewsBrowserLabelProvider_COLLAPSE_NEWS, null, "/icons/obj16/mono_collapse.gif", "mono_collapse.gif", Dynamic.COLLAPSE_LINK.getId(news), null, null);
                    builder.append("</td>");
                    builder.append("<td class=\"footerlineseparator\">");
                    builder.append("|");
                    builder.append("</td>");
                }
                builder.append("<td class=\"footerline\">");
                link = "rssowl://org.rssowl.ui.ToggleSticky?" + news.getId();
                this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_STICKY, Messages.NewsBrowserLabelProvider_STICKY, null, "/icons/obj16/mono_sticky.gif", "mono_sticky.gif", Dynamic.FOOTER_STICKY_LINK.getId(news), null, null);
                builder.append("</td>");
                builder.append("<td class=\"footerlineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"footerline\">");
                link = "rssowl://org.rssowl.ui.LabelsMenu?" + news.getId();
                this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_LABEL, Messages.NewsBrowserLabelProvider_LABEL, null, "/icons/obj16/mono_label.gif", "mono_label.gif", Dynamic.FOOTER_LABEL_MENU_LINK.getId(news), null, null);
                builder.append("</td>");
                builder.append("<td class=\"footerlineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"footerline\">");
                link = "rssowl://org.rssowl.ui.Archive?" + news.getId();
                this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_ARCHIVE, Messages.NewsBrowserLabelProvider_ARCHIVE_NEWS, null, "/icons/obj16/mono_archive.gif", "mono_archive.gif", Dynamic.FOOTER_ARCHIVE_LINK.getId(news), null, null);
                builder.append("</td>");
                builder.append("<td class=\"footerlineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"footerline\">");
                link = "rssowl://org.rssowl.ui.ShareNewsMenu?" + news.getId();
                this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_SHARE, Messages.NewsBrowserLabelProvider_SHARE_NEWS, null, "/icons/obj16/mono_share.gif", "mono_share.gif", Dynamic.FOOTER_SHARE_MENU_LINK.getId(news), null, null);
                builder.append("</td>");
                builder.append("<td class=\"footerlineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"footerline\">");
                link = "rssowl://org.rssowl.ui.NewsMenu?" + news.getId();
                this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_MENU, Messages.NewsBrowserLabelProvider_NEWS_MENU, null, "/icons/obj16/mono_menu.gif", "mono_menu.gif", Dynamic.FOOTER_NEWS_MENU_LINK.getId(news), null, null);
                builder.append("</td>");
                builder.append("<td class=\"footerlineseparator\">");
                builder.append("|");
                builder.append("</td>");
                builder.append("<td class=\"footerline\">");
                link = "rssowl://org.rssowl.ui.RelatedNewsMenu?" + news.getId();
                this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_RELATED_NEWS, Messages.NewsBrowserLabelProvider_SEARCH_FOR_RELATED_NEWS, null, "/icons/obj16/mono_search.gif", "mono_search.gif", Dynamic.FIND_RELATED_MENU_LINK.getId(news), null, null);
                builder.append("</td>");
                if (hasLink) {
                    builder.append("<td class=\"footerlineseparator\">");
                    builder.append("|");
                    builder.append("</td>");
                    builder.append("<td class=\"footerline\">");
                    link = "rssowl://org.rssowl.ui.TransformNews?" + news.getId();
                    this.imageLink(builder, link, Messages.NewsBrowserLabelProvider_FULL_CONTENT, Messages.NewsBrowserLabelProvider_DISPLAY_FULL_CONTENT, null, "/icons/obj16/mono_transform.gif", "mono_transform.gif", Dynamic.FULL_CONTENT_LINK.getId(news), null, Dynamic.FULL_CONTENT_LINK_TEXT.getId(news));
                    builder.append("</td>");
                }
                if (attachments.size() != 0) {
                    builder.append("<td class=\"footerlineseparator\">");
                    builder.append("|");
                    builder.append("</td>");
                    for (IAttachment attachment : attachments) {
                        String size;
                        if (attachment.getLink() == null) continue;
                        URI attachmentLink = attachment.getLink();
                        String name = URIUtils.getFile((URI)attachmentLink, (String)OwlUI.getExtensionForMime(attachment.getType()));
                        if (!StringUtils.isSet((String)name)) {
                            name = attachmentLink.toASCIIString();
                        }
                        name = (size = OwlUI.getSize(attachment.getLength())) != null ? NLS.bind((String)Messages.NewsBrowserLabelProvider_NAME_SIZE, (Object)StringUtils.htmlEscape((String)name), (Object)size) : StringUtils.htmlEscape((String)name);
                        builder.append("<td class=\"footerline\">");
                        link = "rssowl://org.rssowl.ui.DownloadAttachment?" + news.getId();
                        this.imageLink(builder, link, name, null, null, "/icons/obj16/mono_attachment.gif", "mono_attachment.gif", Dynamic.ATTACHMENT_LINK.getId(news), null, null);
                        builder.append("</td>");
                    }
                }
                if ((source = news.getSource()) != null && source.getLink() != null) {
                    link = source.getLink().toASCIIString();
                    String name = source.getName();
                    if (StringUtils.isSet((String)link)) {
                        builder.append("<td class=\"footerlineseparator\">");
                        builder.append("|");
                        builder.append("</td>");
                        name = StringUtils.isSet((String)name) ? StringUtils.htmlEscape((String)name) : StringUtils.htmlEscape((String)link);
                        builder.append("<td class=\"footerline\">");
                        this.imageLink(builder, link, name, null, null, "/icons/obj16/mono_source.gif", "mono_source.gif", null, null, null);
                        builder.append("</td>");
                    }
                }
                builder.append("</tr>");
                builder.append("</table>");
                this.close(builder, "div");
                this.close(builder, "div");
            } else {
                this.div(builder, "clearingFooter");
                this.close(builder, "div");
            }
        }
        if (!onlyInnerContent) {
            this.close(builder, "div");
            if (this.fHeadlinesOnly) {
                if (isVisible) {
                    this.div(builder, "headlinesSeparator", Dynamic.HEADLINE_SEPARATOR.getId(news));
                } else {
                    this.div(builder, "headlinesSeparator", "display: none;", Dynamic.HEADLINE_SEPARATOR.getId(news));
                }
                this.close(builder, "div");
            }
        }
        return this.highlightSearchTermsIfNecessary(builder.toString());
    }

    private boolean isVisible(EntityGroup group) {
        if (this.fViewer != null) {
            return this.fViewer.getViewModel().isGroupVisible(group.getId());
        }
        return true;
    }

    private boolean isVisible(INews news) {
        if (this.fViewer != null) {
            return this.fViewer.getViewModel().isNewsVisible(news);
        }
        return true;
    }

    private int getTotalNewsCount() {
        if (this.fViewer != null) {
            return this.fViewer.getViewModel().getNewsCount();
        }
        return 0;
    }

    private int getVisibleNewsCount() {
        if (this.fViewer != null) {
            return this.fViewer.getViewModel().getVisibleNewsCount();
        }
        return 0;
    }

    private String getLabel(NewsBrowserViewer.PageLatch latch) {
        StringBuilder builder = new StringBuilder();
        this.div(builder, "pageLatch", Dynamic.PAGE_LATCH.getId());
        String link = "rssowl://org.rssowl.ui.NextPage";
        this.imageLink(builder, link, this.getLatchName(), null, null, "/icons/obj16/mono_transform.gif", "mono_transform.gif", Dynamic.PAGE_LATCH_LINK.getId(), null, Dynamic.PAGE_LATCH_TEXT.getId());
        this.close(builder, "div");
        return builder.toString();
    }

    String getLatchName() {
        return NLS.bind((String)Messages.NewsBrowserLabelProvider_DISPLAY_MORE_ARTICLES, (Object)this.getVisibleNewsCount(), (Object)this.getTotalNewsCount());
    }

    void fillSubtitle(StringBuilder subtitleContent, INews news, Set<ILabel> labels, boolean withLinks) {
        String feedName;
        this.fillDate(news, subtitleContent);
        IPerson author = news.getAuthor();
        if (author != null) {
            subtitleContent.append(" | ");
            this.fillAuthor(subtitleContent, author, withLinks);
        }
        if (this.showFeedInformation() && StringUtils.isSet((String)(feedName = this.getFeedName(news)))) {
            subtitleContent.append(" | ");
            subtitleContent.append(feedName);
        }
        if (!labels.isEmpty()) {
            subtitleContent.append(" | ");
            this.fillLabels(subtitleContent, labels);
        }
    }

    private void fillDate(INews news, StringBuilder builder) {
        Date newsDate = DateUtils.getRecentDate((INews)news);
        if (DateUtils.isAfterIncludingToday((Date)newsDate, (long)this.fTodayInMillies)) {
            builder.append(this.fTimeFormat.format(newsDate));
        } else {
            builder.append(this.fDateFormat.format(newsDate));
        }
    }

    private void fillAuthor(StringBuilder builder, IPerson author, boolean withLinks) {
        String email;
        String name = author.getName();
        String string = email = author.getEmail() != null ? author.getEmail().toASCIIString() : null;
        if (email != null && !email.contains("mail:")) {
            email = "mailto:" + email;
        }
        if (email == null && name != null && name.contains("@") && !name.contains(" ")) {
            email = name;
        }
        if (withLinks && StringUtils.isSet((String)name) && email != null) {
            this.link(builder, email, StringUtils.stripTags((String)name, (boolean)false), "author");
        } else if (StringUtils.isSet((String)name)) {
            builder.append(StringUtils.stripTags((String)name, (boolean)false));
        } else if (withLinks && email != null) {
            this.link(builder, email, StringUtils.stripTags((String)email, (boolean)false), "author");
        } else if (email != null) {
            builder.append(StringUtils.stripTags((String)email, (boolean)false));
        } else {
            builder.append(Messages.NewsBrowserLabelProvider_UNKNOWN);
        }
    }

    private String getFeedName(INews news) {
        IBookMark bm;
        String feedLinkAsText = news.getFeedLinkAsText();
        String feedName = this.fMapFeedLinkToName.get(feedLinkAsText);
        if (feedName == null && (bm = CoreUtils.getBookMark((FeedLinkReference)news.getFeedReference())) != null) {
            feedName = StringUtils.htmlEscape((String)bm.getName());
            this.fMapFeedLinkToName.put(feedLinkAsText, feedName);
        }
        return feedName;
    }

    private void fillLabels(StringBuilder builder, Set<ILabel> labels) {
        if (!labels.isEmpty()) {
            builder.append(Messages.NewsBrowserLabelProvider_LABELS).append(" ");
        }
        int c = 0;
        for (ILabel label : labels) {
            if (++c < labels.size()) {
                this.span(builder, String.valueOf(StringUtils.htmlEscape((String)label.getName())) + ", ", null, label.getColor());
                continue;
            }
            this.span(builder, StringUtils.htmlEscape((String)label.getName()), null, label.getColor());
        }
    }

    private void div(StringBuilder builder, String cssClass) {
        builder.append("<div class=\"").append(cssClass).append("\">\n");
    }

    private void div(StringBuilder builder, String cssClass, String id) {
        builder.append("<div id=\"").append(id).append("\" class=\"").append(cssClass).append("\">\n");
    }

    private void div(StringBuilder builder, String cssClass, String extraCSS, String id) {
        builder.append("<div id=\"").append(id).append("\" class=\"").append(cssClass).append("\" style=\"").append(extraCSS).append("\">\n");
    }

    private void close(StringBuilder builder, String tag) {
        builder.append("</").append(tag).append(">\n");
    }

    private void link(StringBuilder builder, String link, String content, String cssClass) {
        this.link(builder, link, content, cssClass, null);
    }

    private void link(StringBuilder builder, String link, String content, String cssClass, String color) {
        this.link(builder, link, content, cssClass, null, color);
    }

    private void link(StringBuilder builder, String link, String content, String cssClass, String id, String color) {
        builder.append("<a href=\"").append(link).append("\"");
        if (cssClass != null) {
            builder.append(" class=\"").append(cssClass).append("\"");
        }
        if (color != null) {
            builder.append(" style=\"color: rgb(").append(color).append(");\"");
        }
        if (id != null) {
            builder.append(" id=\"").append(id).append("\"");
        }
        builder.append(">").append(content).append("</a>");
    }

    private void imageLink(StringBuilder builder, String link, String tooltip, String alt, String imgPath, String imgName, String linkId, String imageId) {
        this.imageLink(builder, link, null, tooltip, alt, imgPath, imgName, linkId, imageId, null);
    }

    private void imageLink(StringBuilder builder, String link, String text, String tooltip, String alt, String imgPath, String imgName, String linkId, String imageId, String textId) {
        builder.append("<a");
        if (linkId != null) {
            builder.append(" id=\"").append(linkId).append("\"");
        }
        if (tooltip != null) {
            builder.append(" title=\"").append(tooltip).append("\" href=\"").append(link).append("\">");
        } else {
            builder.append(" href=\"").append(link).append("\">");
        }
        builder.append("<img");
        if (imageId != null) {
            builder.append(" id=\"").append(imageId).append("\"");
        }
        String imageUri = this.fIsIE ? OwlUI.getImageUri(imgPath, imgName) : ApplicationServer.getDefault().toResourceUrl(imgPath);
        if (alt == null) {
            alt = text;
        }
        if (alt != null) {
            builder.append(" alt=\"").append(alt).append("\" border=\"0\" src=\"").append(imageUri).append("\" />");
        } else {
            builder.append(" border=\"0\" src=\"").append(imageUri).append("\" />");
        }
        if (text != null) {
            if (textId != null) {
                builder.append("<span id=\"").append(textId).append("\" style=\"padding-left:3px;\">").append(text).append("</span>");
            } else {
                builder.append("<span style=\"padding-left:3px;\">").append(text).append("</span>");
            }
        }
        builder.append("</a>");
    }

    private void span(StringBuilder builder, String content, String cssClass, String color) {
        this.span(builder, content, cssClass, null, color);
    }

    private void span(StringBuilder builder, String content, String cssClass, String id, String color) {
        if (cssClass != null) {
            builder.append("<span class=\"").append(cssClass).append("\"");
        } else {
            builder.append("<span");
        }
        if (color != null) {
            builder.append(" style=\"color: rgb(").append(color).append(");\"");
        }
        if (id != null) {
            builder.append(" id=\"").append(id).append("\"");
        }
        builder.append(">").append(content).append("</span>\n");
    }

    public String render(Object[] elements, URI base, boolean withManagedLinks) {
        boolean stripImagesFromNews = this.fStripImagesFromNews;
        boolean stripMediaFromNews = this.fStripMediaFromNews;
        boolean showFooter = this.fShowFooter;
        boolean headlinesOnly = this.fHeadlinesOnly;
        boolean showFeedInformation = this.fForceShowFeedInformation;
        this.fStripImagesFromNews = false;
        this.fStripMediaFromNews = false;
        this.fShowFooter = false;
        this.fHeadlinesOnly = false;
        this.fForceShowFeedInformation = true;
        this.fForceNoGrouping = true;
        this.fForceNoPaging = true;
        try {
            String string = this.internalRender(elements, base, withManagedLinks);
            return string;
        }
        finally {
            this.fStripImagesFromNews = stripImagesFromNews;
            this.fStripMediaFromNews = stripMediaFromNews;
            this.fShowFooter = showFooter;
            this.fHeadlinesOnly = headlinesOnly;
            this.fForceShowFeedInformation = showFeedInformation;
            this.fForceNoGrouping = false;
            this.fForceNoPaging = false;
        }
    }

    private String internalRender(Object[] elements, URI base, boolean withManagedLinks) {
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        if (Application.IS_WINDOWS) {
            html.append(IE_MOTW);
            html.append("\n");
        }
        html.append("<html>\n  <head>\n");
        if (base != null) {
            html.append("  <base href=\"");
            html.append(base);
            html.append("\">");
        }
        html.append("\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        try {
            StringWriter writer = new StringWriter();
            this.writeCSS(writer, elements.length == 1, false);
            html.append(writer.toString());
        }
        catch (IOException iOException) {}
        html.append("  </head>\n  <body id=\"owlbody\">\n");
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof INews) {
                html.append(this.getText(elements[i], false, withManagedLinks, i));
            }
            ++i;
        }
        html.append("\n  </body>\n</html>");
        return html.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Dynamic {
        NEWS("newsitem"),
        GROUP("group"),
        GROUP_NOTE("groupNote"),
        TITLE("title"),
        TITLE_LINK("titleLink"),
        SUBTITLE_LINK("subtitleLink"),
        SUBLINE("subline"),
        DELETE("delete"),
        TOGGLE_READ_LINK("toggleRead"),
        TOGGLE_READ_IMG("toggleReadImg"),
        TINY_TOGGLE_STICKY_LINK("tinyToggleStickyLink"),
        TOGGLE_STICKY_LINK("toggleStickyLink"),
        TOGGLE_STICKY_IMG("toggleStickyImg"),
        TOGGLE_GROUP_LINK("toggleGroupLink"),
        TOGGLE_GROUP_IMG("toggleGroupImg"),
        LABELS_MENU_LINK("labelsMenuLink"),
        ARCHIVE_LINK("archiveLink"),
        SHARE_MENU_LINK("shareMenuLink"),
        GROUP_MENU_LINK("groupMenuLink"),
        NEWS_MENU_LINK("newsMenuLink"),
        HEADER("header"),
        CONTENT("content"),
        FOOTER("footer"),
        FOOTER_STICKY_LINK("footerStickyLink"),
        FOOTER_ARCHIVE_LINK("footerArchiveLink"),
        FOOTER_LABEL_MENU_LINK("footerLabelMenuLink"),
        FOOTER_SHARE_MENU_LINK("footerShareMenuLink"),
        FIND_RELATED_MENU_LINK("findRelatedMenuLink"),
        FOOTER_NEWS_MENU_LINK("footerNewsMenuLink"),
        ATTACHMENTS_MENU_LINK("attachmentsMenuLink"),
        ATTACHMENT_LINK("attachmentLink"),
        COLLAPSE_LINK("collapseLink"),
        FULL_CONTENT_LINK("fullContentLink"),
        FULL_CONTENT_LINK_TEXT("fullContentLinkText"),
        LABELS("labels"),
        LABELS_SEPARATOR("labelsSeparator"),
        HEADLINE_SEPARATOR("headlineSeparator"),
        PAGE_LATCH("pageLatch"),
        PAGE_LATCH_LINK("pageLatchLink"),
        PAGE_LATCH_TEXT("pageLatchText");

        private String fId;

        private Dynamic(String id) {
            this.fId = id;
        }

        String getId() {
            return this.fId;
        }

        String getId(long id) {
            return String.valueOf(this.fId) + id;
        }

        String getId(EntityGroup group) {
            return String.valueOf(this.fId) + group.getId();
        }

        String getId(INews news) {
            return String.valueOf(this.fId) + news.getId();
        }

        String getId(NewsReference newsRef) {
            return String.valueOf(this.fId) + newsRef.getId();
        }
    }
}

