/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.ILabelDAO;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.SearchHit;
import org.rssowl.core.util.SyncItem;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.ConfirmDialog;
import org.rssowl.ui.internal.dialogs.LabelDialog;
import org.rssowl.ui.internal.dialogs.NewsFiltersListDialog;
import org.rssowl.ui.internal.dialogs.preferences.Messages;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageLabelsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.rssowl.ui.ManageLabels";
    private static final int LABELS_CHUNK_SIZE = 100;
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private TreeViewer fViewer;
    private Button fMoveDownButton;
    private Button fMoveUpButton;

    public ManageLabelsPreferencePage() {
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/labels.gif"));
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite container = this.createContainer(parent);
        Label infoLabel = new Label(container, 0);
        infoLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        infoLabel.setText(Messages.ManageLabelsPreferencePage_LABEL_INFO);
        this.createViewer(container);
        this.createButtons(container);
        Composite infoContainer = new Composite(container, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Link infoText = new Link(infoContainer, 64);
        infoText.setText(Messages.ManageLabelsPreferencePage_LABEL_TIP);
        infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        infoText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewsFiltersListDialog dialog = NewsFiltersListDialog.getVisibleInstance();
                if (dialog == null) {
                    dialog = new NewsFiltersListDialog(ManageLabelsPreferencePage.this.getShell());
                    dialog.setBlockOnOpen(false);
                    dialog.open();
                } else {
                    dialog.getShell().forceActive();
                    if (dialog.getShell().getMinimized()) {
                        dialog.getShell().setMinimized(false);
                    }
                }
            }
        });
        this.applyDialogFont(container);
        return container;
    }

    private void createButtons(Composite container) {
        Composite buttonBox = new Composite(container, 0);
        buttonBox.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        buttonBox.setLayoutData((Object)new GridData(4, 4, false, true));
        Button addButton = new Button(buttonBox, 8);
        addButton.setText(Messages.ManageLabelsPreferencePage_NEW);
        Dialog.applyDialogFont((Control)addButton);
        this.setButtonLayoutData(addButton);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageLabelsPreferencePage.this.onAdd();
            }
        });
        final Button editButton = new Button(buttonBox, 8);
        editButton.setText(Messages.ManageLabelsPreferencePage_EDIT);
        editButton.setEnabled(!this.fViewer.getSelection().isEmpty());
        Dialog.applyDialogFont((Control)editButton);
        this.setButtonLayoutData(editButton);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageLabelsPreferencePage.this.onEdit();
            }
        });
        final Button deleteButton = new Button(buttonBox, 8);
        deleteButton.setText(Messages.ManageLabelsPreferencePage_DELETE);
        deleteButton.setEnabled(!this.fViewer.getSelection().isEmpty());
        Dialog.applyDialogFont((Control)deleteButton);
        this.setButtonLayoutData(deleteButton);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageLabelsPreferencePage.this.onDelete();
            }
        });
        this.fMoveUpButton = new Button(buttonBox, 8);
        this.fMoveUpButton.setText(Messages.ManageLabelsPreferencePage_MOVE_UP);
        this.fMoveUpButton.setEnabled(false);
        Dialog.applyDialogFont((Control)this.fMoveUpButton);
        this.setButtonLayoutData(this.fMoveUpButton);
        ((GridData)this.fMoveUpButton.getLayoutData()).verticalIndent = 10;
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageLabelsPreferencePage.this.onMove(true);
            }
        });
        this.fMoveDownButton = new Button(buttonBox, 8);
        this.fMoveDownButton.setText(Messages.ManageLabelsPreferencePage_MOVE_DOWN);
        this.fMoveDownButton.setEnabled(false);
        Dialog.applyDialogFont((Control)this.fMoveDownButton);
        this.setButtonLayoutData(this.fMoveDownButton);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManageLabelsPreferencePage.this.onMove(false);
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                editButton.setEnabled(!event.getSelection().isEmpty());
                deleteButton.setEnabled(!event.getSelection().isEmpty());
                ManageLabelsPreferencePage.this.updateMoveEnablement();
            }
        });
    }

    private void onMove(boolean up) {
        TreeItem[] items = this.fViewer.getTree().getItems();
        ArrayList<ILabel> sortedLabels = new ArrayList<ILabel>(items.length);
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            sortedLabels.add((ILabel)item.getData());
            ++n2;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        ILabel selectedLabel = (ILabel)selection.getFirstElement();
        int selectedLabelOrder = selectedLabel.getOrder();
        ILabel otherLabel = null;
        int index = sortedLabels.indexOf(selectedLabel);
        if (up && index > 0) {
            otherLabel = (ILabel)sortedLabels.get(index - 1);
            selectedLabel.setOrder(otherLabel.getOrder());
            otherLabel.setOrder(selectedLabelOrder);
        } else if (!up && index < sortedLabels.size() - 1) {
            otherLabel = (ILabel)sortedLabels.get(index + 1);
            selectedLabel.setOrder(otherLabel.getOrder());
            otherLabel.setOrder(selectedLabelOrder);
        }
        ((ILabelDAO)DynamicDAO.getDAO(ILabelDAO.class)).saveAll(Arrays.asList(selectedLabel, otherLabel));
        this.fViewer.refresh();
        this.fViewer.getTree().showSelection();
        this.updateMoveEnablement();
    }

    private void updateMoveEnablement() {
        boolean enableMoveUp = true;
        boolean enableMoveDown = true;
        TreeItem[] selection = this.fViewer.getTree().getSelection();
        int[] selectionIndices = new int[selection.length];
        int i = 0;
        while (i < selection.length) {
            selectionIndices[i] = this.fViewer.getTree().indexOf(selection[i]);
            ++i;
        }
        if (selectionIndices.length == 1) {
            enableMoveUp = selectionIndices[0] != 0;
            enableMoveDown = selectionIndices[0] != this.fViewer.getTree().getItemCount() - 1;
        } else {
            enableMoveUp = false;
            enableMoveDown = false;
        }
        this.fMoveUpButton.setEnabled(enableMoveUp);
        this.fMoveDownButton.setEnabled(enableMoveDown);
    }

    private void onAdd() {
        LabelDialog dialog = new LabelDialog(this.getShell(), LabelDialog.DialogMode.ADD, null);
        if (dialog.open() == 0) {
            String name = dialog.getName();
            RGB color = dialog.getColor();
            ILabel newLabel = Owl.getModelFactory().createLabel(null, name);
            newLabel.setColor(OwlUI.toString(color));
            newLabel.setOrder(this.fViewer.getTree().getItemCount());
            DynamicDAO.save((IPersistable)newLabel);
            this.fViewer.refresh();
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)newLabel));
        }
        this.fViewer.getTree().setFocus();
    }

    private void onEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (!selection.isEmpty()) {
            ILabel label = (ILabel)selection.getFirstElement();
            LabelDialog dialog = new LabelDialog(this.getShell(), LabelDialog.DialogMode.EDIT, label);
            if (dialog.open() == 0) {
                boolean changed = false;
                String name = dialog.getName();
                RGB color = dialog.getColor();
                if (!label.getName().equals(name)) {
                    this.onLabelNameChanged(label, label.getName(), name);
                    label.setName(name);
                    changed = true;
                }
                String colorStr = OwlUI.toString(color);
                if (!label.getColor().equals(colorStr)) {
                    label.setColor(colorStr);
                    changed = true;
                }
                if (changed) {
                    Controller.getDefault().getSavedSearchService().forceQuickUpdate();
                    DynamicDAO.save((IPersistable)label);
                    this.fViewer.update((Object)label, null);
                }
            }
        }
        this.fViewer.getTree().setFocus();
    }

    private void onDelete() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (!selection.isEmpty()) {
            List<ILabel> selectedLabels = ModelUtils.getEntities(selection, ILabel.class);
            String msg = selectedLabels.size() == 1 ? NLS.bind((String)Messages.ManageLabelsPreferencePage_DELETE_LABEL_N, (Object)selectedLabels.get(0).getName()) : NLS.bind((String)Messages.ManageLabelsPreferencePage_DELETE_N_LABELS, (Object)selectedLabels.size());
            ConfirmDialog dialog = new ConfirmDialog(this.getShell(), Messages.ManageLabelsPreferencePage_CONFIRM_DELETE, Messages.ManageLabelsPreferencePage_NO_UNDO, msg, null);
            if (dialog.open() == 0) {
                this.deleteInBackground(selectedLabels);
            }
        }
    }

    private void onLabelNameChanged(final ILabel label, final String oldName, final String newName) {
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.ManageLabelsPreferencePage_WAIT_UPDATE, -1);
                try {
                    ArrayList<SyncItem> syncItems = new ArrayList<SyncItem>();
                    ISearchField labelField = Owl.getModelFactory().createSearchField(15, INews.class.getName());
                    ISearchField feedField = Owl.getModelFactory().createSearchField(17, INews.class.getName());
                    ISearchCondition labelCondition = Owl.getModelFactory().createSearchCondition(labelField, SearchSpecifier.IS, (Object)oldName);
                    ISearchCondition feedCondition = Owl.getModelFactory().createSearchCondition(feedField, SearchSpecifier.BEGINS_WITH, (Object)"reader");
                    List result = Owl.getPersistenceService().getModelSearch().searchNews(Arrays.asList(labelCondition, feedCondition), true);
                    List chunks = CoreUtils.toChunks((List)result, (int)100);
                    for (List chunk : chunks) {
                        for (SearchHit item : chunk) {
                            INews news = ((NewsReference)item.getResult()).resolve();
                            if (news != null && news.isVisible()) {
                                if (!SyncUtils.isSynchronized((INews)news) || !news.getLabels().contains(label)) continue;
                                SyncItem syncItem = SyncItem.toSyncItem((INews)news);
                                syncItem.addLabel(newName);
                                syncItem.removeLabel(oldName);
                                syncItems.add(syncItem);
                                continue;
                            }
                            CoreUtils.reportIndexIssue();
                        }
                    }
                    if (!syncItems.isEmpty()) {
                        Controller.getDefault().getSyncService().synchronize(syncItems);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

            protected void initializeBounds() {
                super.initializeBounds();
                Shell shell = this.getShell();
                int width = this.convertHorizontalDLUsToPixels(320);
                shell.setSize(width, shell.getSize().y);
                Rectangle containerBounds = shell.getParent().getBounds();
                int x = Math.max(0, containerBounds.x + (containerBounds.width - width) / 2);
                shell.setLocation(x, shell.getLocation().y);
            }
        };
        try {
            dialog.run(true, false, runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
    }

    private void deleteInBackground(final List<ILabel> labelsToDelete) {
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.ManageLabelsPreferencePage_WAIT_DELETE, -1);
                try {
                    Controller.getDefault().getSavedSearchService().forceQuickUpdate();
                    List labeledNews = ManageLabelsPreferencePage.this.findLabeledNews(labelsToDelete);
                    if (!labeledNews.isEmpty()) {
                        monitor.subTask(NLS.bind((String)Messages.ManageLabelsPreferencePage_UPDATE_NEWS_REMOVE_LABELS, (Object)labeledNews.size()));
                        List chunks = CoreUtils.toChunks((List)labeledNews, (int)100);
                        for (List chunk : chunks) {
                            ArrayList<INews> newsToSave = new ArrayList<INews>(chunk.size());
                            for (SearchHit hit : chunk) {
                                boolean needsSave = false;
                                INews item = ((NewsReference)hit.getResult()).resolve();
                                if (item != null && item.isVisible()) {
                                    for (ILabel labelToDelete : labelsToDelete) {
                                        if (!item.removeLabel(labelToDelete)) continue;
                                        needsSave = true;
                                    }
                                    if (!needsSave) continue;
                                    newsToSave.add(item);
                                    continue;
                                }
                                CoreUtils.reportIndexIssue();
                            }
                            if (newsToSave.isEmpty()) continue;
                            DynamicDAO.saveAll(newsToSave);
                        }
                    }
                    DynamicDAO.deleteAll((Collection)labelsToDelete);
                    JobRunner.runInUIThread((Widget)ManageLabelsPreferencePage.this.fViewer.getControl(), new Runnable(){

                        public void run() {
                            ManageLabelsPreferencePage.this.fViewer.refresh();
                            ManageLabelsPreferencePage.this.fixOrderAfterDelete();
                            ManageLabelsPreferencePage.this.fViewer.getTree().setFocus();
                        }
                    });
                }
                finally {
                    monitor.done();
                }
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell()){

            protected void initializeBounds() {
                super.initializeBounds();
                Shell shell = this.getShell();
                int width = this.convertHorizontalDLUsToPixels(320);
                shell.setSize(width, shell.getSize().y);
                Rectangle containerBounds = shell.getParent().getBounds();
                int x = Math.max(0, containerBounds.x + (containerBounds.width - width) / 2);
                shell.setLocation(x, shell.getLocation().y);
            }
        };
        try {
            dialog.run(true, false, runnableWithProgress);
        }
        catch (InvocationTargetException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
    }

    private List<SearchHit<NewsReference>> findLabeledNews(List<ILabel> selectedLabels) {
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(selectedLabels.size());
        ISearchField labelField = Owl.getModelFactory().createSearchField(15, INews.class.getName());
        for (ILabel label : selectedLabels) {
            ISearchCondition condition = Owl.getModelFactory().createSearchCondition(labelField, SearchSpecifier.IS, (Object)label.getName());
            conditions.add(condition);
        }
        return Owl.getPersistenceService().getModelSearch().searchNews(conditions, false);
    }

    private void fixOrderAfterDelete() {
        ArrayList<ILabel> labelsToSave = new ArrayList<ILabel>();
        TreeItem[] items = this.fViewer.getTree().getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            ILabel label = (ILabel)item.getData();
            label.setOrder(i);
            labelsToSave.add(label);
            ++i;
        }
        DynamicDAO.saveAll(labelsToSave);
    }

    private void createViewer(Composite container) {
        this.fViewer = new TreeViewer(container, 67586);
        this.fViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.fViewer.getTree().getLayoutData()).heightHint = 190;
        this.fViewer.getTree().setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        this.fViewer.getTree().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        this.fViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return CoreUtils.loadSortedLabels().toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        final RGB listBackground = this.fViewer.getControl().getDisplay().getSystemColor(25).getRGB();
        final RGB listSelectionBackground = this.fViewer.getControl().getDisplay().getSystemColor(26).getRGB();
        this.fViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ILabel label = (ILabel)cell.getElement();
                cell.setText(label.getName());
                if (!OwlUI.isHighContrast()) {
                    RGB labelRGB = OwlUI.getRGB(label);
                    if (!listBackground.equals((Object)labelRGB) && !listSelectionBackground.equals((Object)labelRGB)) {
                        cell.setForeground(OwlUI.getColor((ResourceManager)ManageLabelsPreferencePage.this.fResources, labelRGB));
                    } else {
                        cell.setForeground(null);
                    }
                }
            }
        });
        this.fViewer.setInput(new Object());
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ManageLabelsPreferencePage.this.onEdit();
            }
        });
    }

    private Composite createContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        return composite;
    }

    public void dispose() {
        super.dispose();
        this.fResources.dispose();
    }
}

