/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.exporter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.core.interpreter.ITypeExporter;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.exporter.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportOptionsPage
extends WizardPage {
    private Button fExportSettingsCheck;
    private Button fExportFiltersCheck;
    private Button fExportLabelsCheck;

    protected ExportOptionsPage(String pageName) {
        super(pageName, pageName, OwlUI.getImageDescriptor("icons/wizban/export_wiz.png"));
        this.setMessage(Messages.ExportOptionsPage_EXPORT_OPTIONS);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        StyledText infoText = new StyledText(container, 72);
        infoText.setEnabled(false);
        infoText.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)infoText.getLayoutData()).widthHint = 200;
        infoText.setBackground(container.getDisplay().getSystemColor(22));
        infoText.setText(Messages.ExportOptionsPage_OPTIONS_INFO);
        Collection labels = DynamicDAO.loadAll(ILabel.class);
        this.fExportLabelsCheck = new Button(container, 32);
        this.fExportLabelsCheck.setImage(OwlUI.getImage((Control)this.fExportLabelsCheck, "icons/elcl16/labels.gif"));
        if (!labels.isEmpty()) {
            this.fExportLabelsCheck.setText(NLS.bind((String)Messages.ExportOptionsPage_EXPORT_N_LABELS, (Object)labels.size()));
        } else {
            this.fExportLabelsCheck.setText(Messages.ExportOptionsPage_EXPORT_LABELS);
        }
        this.fExportLabelsCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fExportLabelsCheck.getLayoutData()).verticalIndent = 10;
        this.fExportLabelsCheck.setEnabled(!labels.isEmpty());
        Collection filters = DynamicDAO.loadAll(ISearchFilter.class);
        final boolean filtersUseLabels = this.filtersUseLabels(filters);
        this.fExportFiltersCheck = new Button(container, 32);
        this.fExportFiltersCheck.setImage(OwlUI.getImage((Control)this.fExportFiltersCheck, OwlUI.FILTER));
        if (!filters.isEmpty()) {
            this.fExportFiltersCheck.setText(NLS.bind((String)Messages.ExportOptionsPage_EXPORT_N_FILTERS, (Object)filters.size()));
        } else {
            this.fExportFiltersCheck.setText(Messages.ExportOptionsPage_EXPORT_FILTERS);
        }
        this.fExportFiltersCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fExportFiltersCheck.setEnabled(!filters.isEmpty());
        this.fExportFiltersCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportOptionsPage.this.fExportFiltersCheck.getSelection() && !ExportOptionsPage.this.fExportLabelsCheck.getSelection() && filtersUseLabels) {
                    ExportOptionsPage.this.fExportLabelsCheck.setSelection(true);
                    ExportOptionsPage.this.setMessage(Messages.ExportOptionsPage_EXPORT_LABEL_FILTER_INFO, 1);
                } else if (!ExportOptionsPage.this.fExportFiltersCheck.getSelection()) {
                    ExportOptionsPage.this.setMessage(Messages.ExportOptionsPage_EXPORT_OPTIONS);
                }
            }
        });
        this.fExportSettingsCheck = new Button(container, 32);
        this.fExportSettingsCheck.setImage(OwlUI.getImage((Control)this.fExportSettingsCheck, "icons/elcl16/preferences.gif"));
        this.fExportSettingsCheck.setText(Messages.ExportOptionsPage_EXPORT_PREFERENCES);
        this.fExportSettingsCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private boolean filtersUseLabels(Collection<ISearchFilter> filters) {
        for (ISearchFilter filter : filters) {
            List actions = filter.getActions();
            for (IFilterAction action : actions) {
                if (!"org.rssowl.core.LabelNewsAction".equals(action.getActionId())) continue;
                return true;
            }
        }
        return false;
    }

    Set<ITypeExporter.Options> getExportOptions() {
        HashSet<ITypeExporter.Options> options = new HashSet<ITypeExporter.Options>();
        if (this.fExportLabelsCheck.getSelection()) {
            options.add(ITypeExporter.Options.EXPORT_LABELS);
        }
        if (this.fExportFiltersCheck.getSelection()) {
            options.add(ITypeExporter.Options.EXPORT_FILTERS);
        }
        if (this.fExportSettingsCheck.getSelection()) {
            options.add(ITypeExporter.Options.EXPORT_PREFERENCES);
        }
        return options;
    }

    public boolean isPageComplete() {
        return true;
    }
}

