/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class SplashHandler
extends AbstractSplashHandler {
    private Font fVersionFont;
    private Color fVersionColor;
    private ProgressBar fBar;

    public void init(Shell splash) {
        super.init(splash);
        this.initResources(splash);
        this.initComponents(splash);
    }

    private void initResources(Shell splash) {
        FontData fontData = splash.getDisplay().getSystemFont().getFontData()[0];
        this.fVersionFont = new Font((Device)splash.getDisplay(), fontData.getName(), 8, 1);
        this.fVersionColor = new Color((Device)splash.getDisplay(), new RGB(53, 53, 53));
    }

    private void initComponents(Shell shell) {
        shell.setBackgroundMode(1);
        Composite container = new Composite((Composite)shell, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(1, 30, 12));
        container.setLocation(0, 240);
        container.setSize(400, 60);
        this.fBar = new ProgressBar(container, 256);
        this.fBar.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fBar.getLayoutData()).heightHint = 12;
        this.fBar.setMaximum(100);
        this.fBar.setSelection(25);
        Label versionLabel = new Label(container, 0);
        versionLabel.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        versionLabel.setFont(this.fVersionFont);
        versionLabel.setForeground(this.fVersionColor);
        versionLabel.setText(NLS.bind((String)Messages.SplashHandler_BUILD, (Object)"2.2.1"));
        shell.layout(true, true);
    }

    public void dispose() {
        super.dispose();
        this.fVersionColor.dispose();
        this.fVersionFont.dispose();
    }

    public IProgressMonitor getBundleProgressMonitor() {
        return new NullProgressMonitor(){

            public void beginTask(String name, int totalWork) {
                SplashHandler.this.getSplash().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        SplashHandler.this.fBar.setSelection(50);
                    }
                });
            }

            public void subTask(String name) {
                SplashHandler.this.getSplash().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (SplashHandler.this.fBar.getSelection() < 100) {
                            SplashHandler.this.fBar.setSelection(SplashHandler.this.fBar.getSelection() + 8);
                        }
                    }
                });
            }
        };
    }
}

