/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.Db4oDatabase;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Arrays4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.handlers.LongHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.slots.Slot;

public class UUIDFieldMetadata
extends VirtualFieldMetadata {
    private static final int LINK_LENGTH = 12;

    UUIDFieldMetadata(ObjectContainerBase objectContainerBase) {
        this.i_name = "v4ouuid";
        this.i_handler = new LongHandler(objectContainerBase);
    }

    public void addFieldIndex(MarshallerFamily marshallerFamily, ClassMetadata classMetadata, StatefulBuffer statefulBuffer, Slot slot) {
        boolean bl = slot == null;
        int n = statefulBuffer._offset;
        int n2 = statefulBuffer.readInt();
        long l = statefulBuffer.readLong();
        statefulBuffer._offset = n;
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)statefulBuffer.getStream();
        if (!(l != 0L && n2 != 0 || statefulBuffer.getID() <= 0 || bl)) {
            DatabaseIdentityIDAndUUID databaseIdentityIDAndUUID = this.readDatabaseIdentityIDAndUUID(localObjectContainer, classMetadata, slot, false);
            n2 = databaseIdentityIDAndUUID.databaseIdentityID;
            l = databaseIdentityIDAndUUID.uuid;
        }
        if (n2 == 0) {
            n2 = localObjectContainer.identity().getID(statefulBuffer.getTransaction());
        }
        if (l == 0L) {
            l = localObjectContainer.generateTimeStampId();
        }
        statefulBuffer.writeInt(n2);
        statefulBuffer.writeLong(l);
        if (bl) {
            this.addIndexEntry(statefulBuffer, new Long(l));
        }
    }

    private DatabaseIdentityIDAndUUID readDatabaseIdentityIDAndUUID(ObjectContainerBase objectContainerBase, ClassMetadata classMetadata, Slot slot, boolean bl) {
        ClassMetadata classMetadata2;
        Buffer buffer = objectContainerBase.readReaderByAddress(slot.getAddress(), slot.getLength());
        if (bl && (classMetadata2 = ClassMetadata.readClass(objectContainerBase, buffer)) != classMetadata) {
            return null;
        }
        if (null == classMetadata.findOffset(buffer, this)) {
            return null;
        }
        return new DatabaseIdentityIDAndUUID(buffer.readInt(), buffer.readLong());
    }

    public void delete(MarshallerFamily marshallerFamily, StatefulBuffer statefulBuffer, boolean bl) {
        ObjectContainerBase objectContainerBase;
        if (bl) {
            statefulBuffer.incrementOffset(this.linkLength());
            return;
        }
        statefulBuffer.incrementOffset(4);
        long l = statefulBuffer.readLong();
        if (l > 0L && (objectContainerBase = statefulBuffer.getStream()).maintainsIndices()) {
            this.removeIndexEntry(statefulBuffer.getTransaction(), statefulBuffer.getID(), new Long(l));
        }
    }

    public boolean hasIndex() {
        return true;
    }

    public BTree getIndex(Transaction transaction) {
        this.ensureIndex(transaction);
        return super.getIndex(transaction);
    }

    protected void rebuildIndexForObject(LocalObjectContainer localObjectContainer, ClassMetadata classMetadata, int n) {
        DatabaseIdentityIDAndUUID databaseIdentityIDAndUUID = this.readDatabaseIdentityIDAndUUID(localObjectContainer, classMetadata, ((LocalTransaction)localObjectContainer.getSystemTransaction()).getCurrentSlotOfID(n), true);
        if (null == databaseIdentityIDAndUUID) {
            return;
        }
        this.addIndexEntry(localObjectContainer.getSystemTransaction(), n, new Long(databaseIdentityIDAndUUID.uuid));
    }

    private void ensureIndex(Transaction transaction) {
        if (null == transaction) {
            throw new ArgumentNullException();
        }
        if (null != super.getIndex(transaction)) {
            return;
        }
        LocalObjectContainer localObjectContainer = (LocalObjectContainer)transaction.stream();
        SystemData systemData = localObjectContainer.systemData();
        if (systemData == null) {
            return;
        }
        this.initIndex(transaction, systemData.uuidIndexId());
        if (systemData.uuidIndexId() == 0) {
            systemData.uuidIndexId(super.getIndex(transaction).getID());
            localObjectContainer.getFileHeader().writeVariablePart(localObjectContainer, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void instantiate1(Transaction transaction, ObjectReference objectReference, Buffer buffer) {
        int n = buffer.readInt();
        ObjectContainerBase objectContainerBase = transaction.stream();
        objectContainerBase.showInternalClasses(true);
        try {
            Db4oDatabase db4oDatabase = (Db4oDatabase)objectContainerBase.getByID2(transaction, n);
            if (db4oDatabase != null && db4oDatabase.i_signature == null) {
                objectContainerBase.activate2(transaction, db4oDatabase, 2);
            }
            VirtualAttributes virtualAttributes = objectReference.virtualAttributes();
            virtualAttributes.i_database = db4oDatabase;
            virtualAttributes.i_uuid = buffer.readLong();
        }
        finally {
            objectContainerBase.showInternalClasses(false);
        }
    }

    public int linkLength() {
        return 12;
    }

    void marshall1(ObjectReference objectReference, StatefulBuffer statefulBuffer, boolean bl, boolean bl2) {
        boolean bl3;
        ObjectContainerBase objectContainerBase = statefulBuffer.getStream();
        Transaction transaction = statefulBuffer.getTransaction();
        boolean bl4 = bl2 && objectContainerBase.maintainsIndices();
        int n = 0;
        VirtualAttributes virtualAttributes = objectReference.virtualAttributes();
        boolean bl5 = bl3 = !bl;
        if (virtualAttributes != null && virtualAttributes.i_database == null) {
            bl3 = true;
        }
        if (bl3) {
            Db4oDatabase db4oDatabase = objectContainerBase.identity();
            if (db4oDatabase == null) {
                virtualAttributes = null;
            } else {
                if (virtualAttributes.i_database == null) {
                    virtualAttributes.i_database = db4oDatabase;
                    if (objectContainerBase instanceof LocalObjectContainer) {
                        virtualAttributes.i_uuid = objectContainerBase.generateTimeStampId();
                        bl4 = true;
                    }
                }
                if ((db4oDatabase = virtualAttributes.i_database) != null) {
                    n = db4oDatabase.getID(transaction);
                }
            }
        } else if (virtualAttributes != null) {
            n = virtualAttributes.i_database.getID(transaction);
        }
        statefulBuffer.writeInt(n);
        if (virtualAttributes != null) {
            statefulBuffer.writeLong(virtualAttributes.i_uuid);
            if (bl4) {
                this.addIndexEntry(statefulBuffer, new Long(virtualAttributes.i_uuid));
            }
        } else {
            statefulBuffer.writeLong(0L);
        }
    }

    void marshallIgnore(Buffer buffer) {
        buffer.writeInt(0);
        buffer.writeLong(0L);
    }

    public Object[] objectAndYapObjectBySignature(Transaction transaction, long l, byte[] byArray) {
        BTreeRange bTreeRange = this.search(transaction, new Long(l));
        Iterator4 iterator4 = bTreeRange.keys();
        while (iterator4.moveNext()) {
            FieldIndexKey fieldIndexKey = (FieldIndexKey)iterator4.current();
            Object[] objectArray = this.getObjectAndYapObjectByID(transaction, fieldIndexKey.parentID(), byArray);
            if (null == objectArray) continue;
            return objectArray;
        }
        return new Object[2];
    }

    protected Object[] getObjectAndYapObjectByID(Transaction transaction, int n, byte[] byArray) {
        Object[] objectArray = transaction.stream().getObjectAndYapObjectByID(transaction, n);
        if (objectArray[1] == null) {
            return null;
        }
        ObjectReference objectReference = (ObjectReference)objectArray[1];
        VirtualAttributes virtualAttributes = objectReference.virtualAttributes(transaction);
        if (!Arrays4.areEqual(byArray, virtualAttributes.i_database.i_signature)) {
            return null;
        }
        return objectArray;
    }

    public void defragField(MarshallerFamily marshallerFamily, ReaderPair readerPair) {
        readerPair.copyID();
        readerPair.incrementOffset(8);
    }

    static class DatabaseIdentityIDAndUUID {
        public int databaseIdentityID;
        public long uuid;

        public DatabaseIdentityIDAndUUID(int n, long l) {
            this.databaseIdentityID = n;
            this.uuid = l;
        }
    }
}

