/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.TransactionListener;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.Tree;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.TreeInt;
import com.db4o.internal.ix.IndexTransaction;
import com.db4o.reflect.Reflector;

public abstract class Transaction {
    protected int i_address;
    protected final byte[] _pointerBuffer = new byte[8];
    public Tree i_delete;
    private List4 i_dirtyFieldIndexes;
    public final LocalObjectContainer i_file;
    final Transaction i_parentTransaction;
    protected final StatefulBuffer i_pointerIo;
    private final ObjectContainerBase i_stream;
    private List4 i_transactionListeners;
    protected Tree i_writtenUpdateDeletedMembers;
    private final Collection4 _participants = new Collection4();

    public Transaction(ObjectContainerBase objectContainerBase, Transaction transaction) {
        this.i_stream = objectContainerBase;
        this.i_file = objectContainerBase instanceof LocalObjectContainer ? (LocalObjectContainer)objectContainerBase : null;
        this.i_parentTransaction = transaction;
        this.i_pointerIo = new StatefulBuffer(this, 8);
    }

    public void addDirtyFieldIndex(IndexTransaction indexTransaction) {
        this.i_dirtyFieldIndexes = new List4(this.i_dirtyFieldIndexes, indexTransaction);
    }

    public final void checkSynchronization() {
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        this.i_transactionListeners = new List4(this.i_transactionListeners, transactionListener);
    }

    protected void clearAll() {
        this.i_dirtyFieldIndexes = null;
        this.i_transactionListeners = null;
        this.disposeParticipants();
        this._participants.clear();
    }

    private void disposeParticipants() {
        Iterator4 iterator4 = this._participants.iterator();
        while (iterator4.moveNext()) {
            ((TransactionParticipant)iterator4.current()).dispose(this);
        }
    }

    public void close(boolean bl) {
        try {
            if (this.stream() != null) {
                this.checkSynchronization();
                this.stream().releaseSemaphores(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Object object = this.stream().i_lock;
        synchronized (object) {
            this.i_file.freeSpaceBeginCommit();
            this.commitExceptForFreespace();
            this.i_file.freeSpaceEndCommit();
        }
    }

    private void commitExceptForFreespace() {
        this.commit2Listeners();
        this.commit3Stream();
        this.commit4FieldIndexes();
        this.commit5Participants();
        this.stream().writeDirty();
        this.commit6WriteChanges();
        this.freeOnCommit();
        this.commit7ClearAll();
    }

    protected void freeOnCommit() {
    }

    protected void commit6WriteChanges() {
    }

    private void commit7ClearAll() {
        this.commit7ParentClearAll();
        this.clearAll();
    }

    private void commit7ParentClearAll() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit7ClearAll();
        }
    }

    private void commit2Listeners() {
        this.commit2ParentListeners();
        this.commitTransactionListeners();
    }

    private void commit2ParentListeners() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit2Listeners();
        }
    }

    private void commit3Stream() {
        this.stream().checkNeededUpdates();
        this.stream().writeDirty();
        this.stream().classCollection().write(this.stream().getSystemTransaction());
    }

    private void commit4FieldIndexes() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit4FieldIndexes();
        }
        if (this.i_dirtyFieldIndexes != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_dirtyFieldIndexes);
            while (iterator4Impl.moveNext()) {
                ((IndexTransaction)iterator4Impl.current()).commit();
            }
        }
    }

    private void commit5Participants() {
        if (this.i_parentTransaction != null) {
            this.i_parentTransaction.commit5Participants();
        }
        Iterator4 iterator4 = this._participants.iterator();
        while (iterator4.moveNext()) {
            ((TransactionParticipant)iterator4.current()).commit(this);
        }
    }

    protected void commitTransactionListeners() {
        this.checkSynchronization();
        if (this.i_transactionListeners != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_transactionListeners);
            while (iterator4Impl.moveNext()) {
                ((TransactionListener)iterator4Impl.current()).preCommit();
            }
            this.i_transactionListeners = null;
        }
    }

    public abstract boolean isDeleted(int var1);

    protected boolean isSystemTransaction() {
        return this.i_parentTransaction == null;
    }

    public boolean delete(ObjectReference objectReference, int n, int n2) {
        this.checkSynchronization();
        if (objectReference != null && !this.i_stream.flagForDelete(objectReference)) {
            return false;
        }
        DeleteInfo deleteInfo = (DeleteInfo)TreeInt.find(this.i_delete, n);
        if (deleteInfo == null) {
            deleteInfo = new DeleteInfo(n, objectReference, n2);
            this.i_delete = Tree.add(this.i_delete, deleteInfo);
            return true;
        }
        deleteInfo._reference = objectReference;
        if (n2 > deleteInfo._cascade) {
            deleteInfo._cascade = n2;
        }
        return true;
    }

    public void dontDelete(int n) {
        if (this.i_delete == null) {
            return;
        }
        this.i_delete = TreeInt.removeLike((TreeInt)this.i_delete, n);
    }

    void dontRemoveFromClassIndex(int n, int n2) {
        this.checkSynchronization();
        ClassMetadata classMetadata = this.stream().getYapClass(n);
        classMetadata.index().add(this, n2);
    }

    public Object[] objectAndYapObjectBySignature(long l, byte[] byArray) {
        this.checkSynchronization();
        return this.stream().getUUIDIndex().objectAndYapObjectBySignature(this, l, byArray);
    }

    public abstract void processDeletes();

    public Reflector reflector() {
        return this.stream().reflector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        Object object = this.stream().i_lock;
        synchronized (object) {
            this.rollbackParticipants();
            this.rollbackFieldIndexes();
            this.rollbackSlotChanges();
            this.rollBackTransactionListeners();
            this.clearAll();
        }
    }

    protected void rollbackSlotChanges() {
    }

    private void rollbackFieldIndexes() {
        if (this.i_dirtyFieldIndexes != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_dirtyFieldIndexes);
            while (iterator4Impl.moveNext()) {
                ((IndexTransaction)iterator4Impl.current()).rollback();
            }
        }
    }

    private void rollbackParticipants() {
        Iterator4 iterator4 = this._participants.iterator();
        while (iterator4.moveNext()) {
            ((TransactionParticipant)iterator4.current()).rollback(this);
        }
    }

    protected void rollBackTransactionListeners() {
        this.checkSynchronization();
        if (this.i_transactionListeners != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this.i_transactionListeners);
            while (iterator4Impl.moveNext()) {
                ((TransactionListener)iterator4Impl.current()).postRollback();
            }
            this.i_transactionListeners = null;
        }
    }

    void setAddress(int n) {
        this.i_address = n;
    }

    public abstract void setPointer(int var1, int var2, int var3);

    public void slotDelete(int n, int n2, int n3) {
    }

    public void slotFreeOnCommit(int n, int n2, int n3) {
    }

    public void slotFreeOnRollback(int n, int n2, int n3) {
    }

    void slotFreeOnRollbackCommitSetPointer(int n, int n2, int n3) {
    }

    void slotFreeOnRollbackSetPointer(int n, int n2, int n3) {
    }

    public void slotFreePointerOnCommit(int n) {
    }

    void slotFreePointerOnCommit(int n, int n2, int n3) {
    }

    public void slotFreePointerOnRollback(int n) {
    }

    boolean supportsVirtualFields() {
        return true;
    }

    public Transaction systemTransaction() {
        if (this.i_parentTransaction != null) {
            return this.i_parentTransaction;
        }
        return this;
    }

    public String toString() {
        return this.stream().toString();
    }

    public void writePointer(int n, int n2, int n3) {
        this.checkSynchronization();
        this.i_pointerIo.useSlot(n);
        this.i_pointerIo.writeInt(n2);
        this.i_pointerIo.writeInt(n3);
        this.i_pointerIo.write();
    }

    public abstract void writeUpdateDeleteMembers(int var1, ClassMetadata var2, int var3, int var4);

    public final ObjectContainerBase stream() {
        return this.i_stream;
    }

    public void enlist(TransactionParticipant transactionParticipant) {
        if (null == transactionParticipant) {
            throw new ArgumentNullException("participant");
        }
        this.checkSynchronization();
        if (!this._participants.containsByIdentity(transactionParticipant)) {
            this._participants.add(transactionParticipant);
        }
    }

    public static Transaction readInterruptedTransaction(LocalObjectContainer localObjectContainer, Buffer buffer) {
        int n = buffer.readInt();
        int n2 = buffer.readInt();
        if (n > 0 && n == n2) {
            Transaction transaction = localObjectContainer.newTransaction(null);
            transaction.setAddress(n);
            return transaction;
        }
        return null;
    }

    public Transaction parentTransaction() {
        return this.i_parentTransaction;
    }
}

