/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.event.NewsEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncItem
implements Serializable {
    private static final long serialVersionUID = 4093540431879243015L;
    private static final Set<INews.State> UNREAD_STATES = EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED);
    private final String fId;
    private final String fStreamId;
    private boolean fMarkedRead;
    private boolean fMarkedUnread;
    private boolean fStarred;
    private boolean fUnStarred;
    private List<String> fAddedLabels;
    private List<String> fRemovedLabels;

    public static SyncItem toSyncItem(NewsEvent event) {
        boolean newSticky;
        boolean oldSticky;
        INews.State newState;
        boolean requiresSync = false;
        INews item = event.getEntity();
        SyncItem syncItem = SyncItem.toSyncItem(item);
        INews.State oldState = event.getOldNews().getState();
        if (oldState != (newState = item.getState())) {
            if (newState == INews.State.READ && UNREAD_STATES.contains((Object)oldState)) {
                syncItem.setMarkedRead();
                requiresSync = true;
            } else if (newState == INews.State.UNREAD && oldState == INews.State.READ) {
                syncItem.setMarkedUnread();
                requiresSync = true;
            } else if (newState == INews.State.HIDDEN || newState == INews.State.DELETED) {
                if (UNREAD_STATES.contains((Object)oldState)) {
                    syncItem.setMarkedRead();
                    if (item.isFlagged()) {
                        syncItem.setUnStarred();
                    }
                    requiresSync = true;
                } else if (oldState == INews.State.READ && item.isFlagged()) {
                    syncItem.setUnStarred();
                    requiresSync = true;
                }
            } else if (!event.getOldNews().isVisible() && event.getEntity().isVisible()) {
                if (UNREAD_STATES.contains((Object)newState)) {
                    syncItem.setMarkedUnread();
                    requiresSync = true;
                }
                if (event.getEntity().isFlagged()) {
                    syncItem.setStarred();
                    requiresSync = true;
                }
            }
        }
        if ((oldSticky = event.getOldNews().isFlagged()) != (newSticky = item.isFlagged())) {
            if (oldSticky) {
                syncItem.setUnStarred();
            } else {
                syncItem.setStarred();
            }
            requiresSync = true;
        }
        Set<ILabel> oldLabels = event.getOldNews().getLabels();
        Set<ILabel> newLabels = item.getLabels();
        if (!Arrays.equals(oldLabels.toArray(), newLabels.toArray())) {
            HashSet<String> oldLabelNames = new HashSet<String>(oldLabels.size());
            for (ILabel oldLabel : oldLabels) {
                oldLabelNames.add(oldLabel.getName());
            }
            for (ILabel newLabel : newLabels) {
                if (oldLabelNames.remove(newLabel.getName())) continue;
                syncItem.addLabel(newLabel.getName());
                requiresSync = true;
            }
            for (String oldLabelName : oldLabelNames) {
                syncItem.removeLabel(oldLabelName);
                requiresSync = true;
            }
        }
        return requiresSync ? syncItem : null;
    }

    public static SyncItem toSyncItem(ISearchFilter filter, INews item) {
        boolean requiresSync = false;
        SyncItem syncItem = SyncItem.toSyncItem(item);
        List<IFilterAction> actions = filter.getActions();
        for (IFilterAction action : actions) {
            Long labelId;
            ILabel label;
            Object data;
            String actionId = action.getActionId();
            if ("org.rssowl.core.MarkReadNewsAction".equals(actionId)) {
                syncItem.setMarkedRead();
                requiresSync = true;
            }
            if ("org.rssowl.core.MarkUnreadNewsAction".equals(actionId)) {
                syncItem.setMarkedUnread();
                requiresSync = true;
            }
            if ("org.rssowl.core.DeleteNewsAction".equals(actionId)) {
                syncItem.setMarkedRead();
                requiresSync = true;
            }
            if ("org.rssowl.core.MarkStickyNewsAction".equals(actionId)) {
                syncItem.setStarred();
                requiresSync = true;
            }
            if (!"org.rssowl.core.LabelNewsAction".equals(actionId) || (data = action.getData()) == null || !(data instanceof Long) || (label = DynamicDAO.load(ILabel.class, labelId = (Long)data)) == null) continue;
            syncItem.addLabel(label.getName());
            requiresSync = true;
        }
        return requiresSync ? syncItem : null;
    }

    public static SyncItem toSyncItem(INews news) {
        String itemId = news.getGuid().getValue();
        String streamId = news.getInReplyTo();
        return new SyncItem(itemId, streamId);
    }

    SyncItem(String id, String streamId) {
        this.fId = id;
        this.fStreamId = streamId;
    }

    public String getId() {
        return this.fId;
    }

    public String getStreamId() {
        return this.fStreamId;
    }

    public void setMarkedRead() {
        this.fMarkedRead = true;
        this.fMarkedUnread = false;
    }

    public void setMarkedUnread() {
        this.fMarkedUnread = true;
        this.fMarkedRead = false;
    }

    public void setStarred() {
        this.fStarred = true;
        this.fUnStarred = false;
    }

    public void setUnStarred() {
        this.fUnStarred = true;
        this.fStarred = false;
    }

    public void addLabel(String label) {
        if (this.fAddedLabels == null) {
            this.fAddedLabels = new ArrayList<String>(3);
        }
        if (!this.fAddedLabels.contains(label)) {
            this.fAddedLabels.add(label);
        }
        if (this.fRemovedLabels != null) {
            this.fRemovedLabels.remove(label);
        }
    }

    public void removeLabel(String label) {
        if (this.fRemovedLabels == null) {
            this.fRemovedLabels = new ArrayList<String>(1);
        }
        if (!this.fRemovedLabels.contains(label)) {
            this.fRemovedLabels.add(label);
        }
        if (this.fAddedLabels != null) {
            this.fAddedLabels.remove(label);
        }
    }

    public boolean isMarkedRead() {
        return this.fMarkedRead;
    }

    public boolean isMarkedUnread() {
        return this.fMarkedUnread;
    }

    public boolean isStarred() {
        return this.fStarred;
    }

    public boolean isUnStarred() {
        return this.fUnStarred;
    }

    public List<String> getAddedLabels() {
        return this.fAddedLabels != null ? this.fAddedLabels : Collections.emptyList();
    }

    public List<String> getRemovedLabels() {
        return this.fRemovedLabels != null ? this.fRemovedLabels : Collections.emptyList();
    }

    public void merge(SyncItem item) {
        if (item.fMarkedRead) {
            this.setMarkedRead();
        }
        if (item.fMarkedUnread) {
            this.setMarkedUnread();
        }
        if (item.fStarred) {
            this.setStarred();
        }
        if (item.fUnStarred) {
            this.setUnStarred();
        }
        if (item.fAddedLabels != null) {
            for (String label : item.fAddedLabels) {
                this.addLabel(label);
            }
        }
        if (item.fRemovedLabels != null) {
            for (String label : item.fRemovedLabels) {
                this.removeLabel(label);
            }
        }
    }

    public void applyTo(INews news) {
        if (this.isMarkedRead()) {
            news.setProperty("org.rssowl.pref.GoogleMarkedRead", Boolean.valueOf(true));
            news.removeProperty("org.rssowl.pref.GoogleMarkedUnRead");
        }
        if (this.isMarkedUnread()) {
            news.setProperty("org.rssowl.pref.GoogleMarkedUnRead", Boolean.valueOf(true));
            news.removeProperty("org.rssowl.pref.GoogleMarkedRead");
        }
        if (this.isStarred()) {
            news.setFlagged(true);
        }
        if (this.isUnStarred()) {
            news.setFlagged(false);
        }
        if (this.fAddedLabels != null || this.fRemovedLabels != null) {
            String[] labelsObj = news.getProperty("org.rssowl.pref.GoogleLabels");
            if (labelsObj == null) {
                labelsObj = new String[]{};
            }
            if (labelsObj instanceof String[]) {
                HashSet<String> labels = new HashSet<String>(Arrays.asList(labelsObj));
                if (this.fAddedLabels != null) {
                    labels.addAll(this.fAddedLabels);
                }
                if (this.fRemovedLabels != null) {
                    labels.removeAll(this.fRemovedLabels);
                }
                news.setProperty("org.rssowl.pref.GoogleLabels", (Serializable)labels.toArray(new String[labels.size()]));
            }
        }
    }

    public boolean isEquivalent(SyncItem item) {
        if (this.fMarkedRead != item.fMarkedRead) {
            return false;
        }
        if (this.fMarkedUnread != item.fMarkedUnread) {
            return false;
        }
        if (this.fStarred != item.fStarred) {
            return false;
        }
        if (this.fUnStarred != item.fUnStarred) {
            return false;
        }
        if (!this.isLabelsEquivalent(this.fAddedLabels, item.fAddedLabels)) {
            return false;
        }
        return this.isLabelsEquivalent(this.fRemovedLabels, item.fRemovedLabels);
    }

    private boolean isLabelsEquivalent(List<String> labelsA, List<String> labelsB) {
        if (labelsA == null && labelsB != null) {
            return false;
        }
        if (labelsA != null && labelsB == null) {
            return false;
        }
        if (labelsA == null && labelsB == null) {
            return true;
        }
        return Arrays.equals(labelsA.toArray(), labelsB.toArray());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyncItem other = (SyncItem)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }
}

