/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.persist;

import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.Persistable;

public final class NewsCounterItem
extends Persistable {
    private int fNewCounter;
    private int fUnreadCounter;
    private int fStickyCounter;

    public NewsCounterItem() {
    }

    public NewsCounterItem(int newCounter, int unreadCounter, int stickyCounter) {
        Assert.isLegal((newCounter >= 0 ? 1 : 0) != 0, (String)"newCounter should be >= 0");
        Assert.isLegal((unreadCounter >= 0 ? 1 : 0) != 0, (String)"unreadCounter should be >= 0");
        Assert.isLegal((stickyCounter >= 0 ? 1 : 0) != 0, (String)"stickyCounter should be >= 0");
        this.fNewCounter = newCounter;
        this.fUnreadCounter = unreadCounter;
        this.fStickyCounter = stickyCounter;
    }

    public final int getNewCounter() {
        return this.fNewCounter;
    }

    public final void incrementNewCounter() {
        ++this.fNewCounter;
    }

    public final void decrementNewCounter() {
        Assert.isTrue((this.fNewCounter > 0 ? 1 : 0) != 0, (String)"newCounter must not be negative");
        --this.fNewCounter;
    }

    public final int getUnreadCounter() {
        return this.fUnreadCounter;
    }

    public final void incrementUnreadCounter() {
        ++this.fUnreadCounter;
    }

    public final void decrementUnreadCounter() {
        Assert.isTrue((this.fUnreadCounter > 0 ? 1 : 0) != 0, (String)"unreadCounter must not be negative");
        --this.fUnreadCounter;
    }

    public final int getStickyCounter() {
        return this.fStickyCounter;
    }

    public final void incrementStickyCounter() {
        ++this.fStickyCounter;
    }

    public final void decrementStickyCounter() {
        Assert.isTrue((this.fStickyCounter > 0 ? 1 : 0) != 0, (String)"stickyCounter must not be negative");
        --this.fStickyCounter;
    }
}

