/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Field;
import org.rssowl.core.internal.persist.search.SearchDocument;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsDocument
extends SearchDocument<INews> {
    static final String STATE_ID_TEXT = String.valueOf(14);

    public NewsDocument(INews type) {
        super(type);
    }

    @Override
    public boolean addFields() {
        return this.addFields(true);
    }

    public boolean addFields(boolean indexDescription) {
        String value;
        INews news = (INews)this.getType();
        ArrayList<Field> fields = new ArrayList<Field>();
        this.addField(fields, this.createDocumentIDField());
        this.addField(fields, this.createHTMLField(0, news.getTitle()));
        if (indexDescription) {
            this.addField(fields, this.createHTMLField(2, news.getDescription()));
        }
        this.addField(fields, this.createURIField(1, news.getLinkAsText(), Field.Store.NO, Field.Index.UN_TOKENIZED));
        this.addField(fields, this.createURIField(17, news.getFeedLinkAsText(), Field.Store.NO, Field.Index.UN_TOKENIZED));
        this.addField(fields, this.createDateField(8, news.getReceiveDate(), Field.Store.NO));
        this.addField(fields, this.createDateField(6, news.getPublishDate(), Field.Store.NO));
        this.addField(fields, this.createDateField(7, news.getModifiedDate(), Field.Store.NO));
        this.addField(fields, this.createDateField(18, DateUtils.getRecentDate(news), Field.Store.NO));
        this.addField(fields, this.createDateField(21, DateUtils.getRecentDate(news), Field.Store.NO, DateTools.Resolution.MINUTE));
        this.addField(fields, this.createEnumField(14, news.getState(), Field.Store.YES));
        this.addField(fields, this.createBooleanField(13, news.isFlagged(), Field.Store.NO));
        this.addField(fields, this.createLongField(16, news.getRating(), Field.Store.NO));
        this.addField(fields, this.createLongField(20, news.getParentId(), Field.Store.NO));
        Set<ILabel> labels = news.getLabels();
        for (ILabel label : labels) {
            if (label == null) continue;
            this.addField(fields, this.createStringField(15, label.getName().toLowerCase(), Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
        if (news.getGuid() != null && (value = news.getGuid().getValue()) != null) {
            this.addField(fields, this.createStringField(5, value.toLowerCase(), Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
        if (news.getSource() != null) {
            if (news.getSource().getLink() != null) {
                this.addField(fields, this.createURIField(9, news.getSource().getLink().toString(), Field.Store.NO, Field.Index.UN_TOKENIZED));
            } else if (news.getSource().getName() != null) {
                this.addField(fields, this.createStringField(9, news.getSource().getName(), Field.Store.NO, Field.Index.TOKENIZED));
            }
        }
        this.addField(fields, this.createPersonField(3, news.getAuthor(), Field.Store.NO, Field.Index.TOKENIZED));
        this.addField(fields, this.createCategoriesField(12, news.getCategories(), Field.Store.NO, Field.Index.TOKENIZED));
        List<IAttachment> attachments = news.getAttachments();
        this.addField(fields, this.createBooleanField(10, !attachments.isEmpty(), Field.Store.NO));
        this.addField(fields, this.createAttachmentsField(11, attachments, Field.Store.NO, Field.Index.TOKENIZED));
        return this.addFieldsToDocument(fields);
    }
}

