/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.jidesoft.utils.SystemInfo;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.res.GetIcon;
import mediathek.tool.Duration;
import mediathek.tool.MVMessageDialog;
import msearch.filmlisten.WriteFilmlistJson;

public class PanelExportFilmliste
extends PanelVorlage {
    public String ziel;
    private JButton jButtonExportPfad;
    private JButton jButtonExportieren;
    private JTextField jTextFieldPfad;

    public PanelExportFilmliste(Daten d, JFrame parent) {
        super(d, parent);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.jButtonExportPfad.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jTextFieldPfad.setText(Daten.mVConfig.get("system-export-datei"));
        this.jTextFieldPfad.getDocument().addDocumentListener(new BeobTextFeld());
        this.jButtonExportieren.addActionListener(new BeobExport());
        this.jButtonExportPfad.addActionListener(new BeobPfad());
    }

    private void filmeExportieren() {
        String exporDatei = Daten.mVConfig.get("system-export-datei");
        if (exporDatei.equals("")) {
            MVMessageDialog.showMessageDialog(this.parentComponent, "Keine Datei angegeben", "Pfad", 1);
        } else {
            try {
                int ret = new File(exporDatei).exists() ? JOptionPane.showConfirmDialog(this.parentComponent, "Datei:  \"" + exporDatei + "\"" + "  existiert bereits", "\u00dcberschreiben?", 0) : 0;
                if (ret == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.updateUI();
                    Duration duration = new Duration(PanelExportFilmliste.class.getSimpleName());
                    duration.start("Filmliste schreiben: " + exporDatei);
                    new WriteFilmlistJson().filmlisteSchreibenJson(exporDatei, Daten.listeFilme);
                    duration.stop("fertig");
                    if (!new File(exporDatei).exists()) {
                        MVMessageDialog.showMessageDialog(this.parentComponent, "Datei:  \"" + exporDatei + "\"" + "  Konnte nicht erstellt werden!", "Fehler", 0);
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(0x1BB11191, ex);
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initComponents() {
        JPanel jPanel4 = new JPanel();
        this.jTextFieldPfad = new JTextField();
        this.jButtonExportPfad = new JButton();
        JLabel jLabelDatei = new JLabel();
        this.jButtonExportieren = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        JTextArea jTextArea1 = new JTextArea();
        jPanel4.setBorder(new SoftBevelBorder(0));
        this.jButtonExportPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        jLabelDatei.setText("Datei:");
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(jLabelDatei).addGap(18, 18, 18).addComponent(this.jTextFieldPfad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExportPfad).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldPfad, -2, -1, -2).addComponent(jLabelDatei).addComponent(this.jButtonExportPfad)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jButtonExportPfad, this.jTextFieldPfad);
        this.jButtonExportieren.setText("Exportieren");
        jTextArea1.setEditable(false);
        jTextArea1.setColumns(20);
        jTextArea1.setRows(7);
        jTextArea1.setText("Es kann die programmeigene Liste mit den Filmen exportiert werden.\n\nDateien werden mit der Endung:\n\n\".zip\"\tals Zip-Dateien,\n\".xz\" \tim XZ-Container mit LZMA2 komprimiert.\n\nAlle anderen Dateien werden unkomprimiert gespeichert.\n");
        jTextArea1.setMargin(new Insets(4, 4, 4, 4));
        jScrollPane1.setViewportView(jTextArea1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel4, -1, -1, Short.MAX_VALUE).addComponent(jScrollPane1, -1, 566, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonExportieren))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jScrollPane1, -2, 167, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonExportieren).addContainerGap(66, Short.MAX_VALUE)));
    }

    private class BeobExport
    implements ActionListener {
        private BeobExport() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanelExportFilmliste.this.filmeExportieren();
        }
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                FileDialog chooser = new FileDialog((Frame)PanelExportFilmliste.this.daten.mediathekGui, "Filme exportieren");
                chooser.setMode(1);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        PanelExportFilmliste.this.jTextFieldPfad.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(679890147, ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!PanelExportFilmliste.this.jTextFieldPfad.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(PanelExportFilmliste.this.jTextFieldPfad.getText()));
                }
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        PanelExportFilmliste.this.jTextFieldPfad.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(911025463, ex);
                    }
                }
            }
        }
    }

    private class BeobTextFeld
    implements DocumentListener {
        private BeobTextFeld() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        void tusEinfach(DocumentEvent e) {
            Daten.mVConfig.add("system-export-datei", PanelExportFilmliste.this.jTextFieldPfad.getText());
        }
    }
}

