/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListeBlacklist;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVConfig;
import mediathek.tool.MVReplaceList;
import msearch.filmlisten.DatenFilmlisteUrl;

public class IoXmlLesen {
    public static boolean datenLesen(Path xmlFilePath) {
        boolean ret = false;
        if (Files.exists(xmlFilePath, new LinkOption[0])) {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            DatenPset datenPset = null;
            try (InputStreamReader in = new InputStreamReader(Files.newInputStream(xmlFilePath, new OpenOption[0]), "UTF-8");){
                XMLStreamReader parser = inFactory.createXMLStreamReader(in);
                while (parser.hasNext()) {
                    int event = parser.next();
                    if (event != 1) continue;
                    block15 : switch (parser.getLocalName()) {
                        case "system": {
                            IoXmlLesen.getConfig(parser, "system", Daten.mVConfig, true);
                            break;
                        }
                        case "Programmset": {
                            datenPset = new DatenPset();
                            if (!IoXmlLesen.get(parser, "Programmset", DatenPset.COLUMN_NAMES_, datenPset.arr)) break;
                            Daten.listePset.add(datenPset);
                            break;
                        }
                        case "Programm": {
                            DatenProg datenProg = new DatenProg();
                            if (!IoXmlLesen.get(parser, "Programm", DatenProg.COLUMN_NAMES_, datenProg.arr) || datenPset == null) break;
                            datenPset.addProg(datenProg);
                            break;
                        }
                        case "Ersetzungstabelle": {
                            String[] sa = new String[2];
                            if (!IoXmlLesen.get(parser, "Ersetzungstabelle", MVReplaceList.COLUMN_NAMES, sa)) break;
                            Daten.mVReplaceList.list.add(sa);
                            break;
                        }
                        case "Abonnement": {
                            DatenAbo datenAbo = new DatenAbo();
                            if (!IoXmlLesen.get(parser, "Abonnement", DatenAbo.COLUMN_NAMES, datenAbo.arr)) break;
                            Daten.listeAbo.addAbo(datenAbo);
                            break;
                        }
                        case "Downlad": {
                            DatenDownload d = new DatenDownload();
                            if (!IoXmlLesen.get(parser, "Downlad", DatenDownload.COLUMN_NAMES_, d.arr)) break;
                            d.init();
                            Daten.listeDownloads.add(d);
                            break;
                        }
                        case "Blacklist": {
                            ListeBlacklist blacklist = Daten.listeBlacklist;
                            DatenBlacklist datenBlacklist = new DatenBlacklist();
                            if (!IoXmlLesen.get(parser, "Blacklist", DatenBlacklist.BLACKLIST_COLUMN_NAMES, datenBlacklist.arr)) break;
                            blacklist.add(datenBlacklist);
                            break;
                        }
                        case "film-update-server": {
                            DatenFilmlisteUrl datenFilmlisteUrl = new DatenFilmlisteUrl();
                            if (!IoXmlLesen.get(parser, "film-update-server", DatenFilmlisteUrl.FILM_UPDATE_SERVER_COLUMN_NAMES, datenFilmlisteUrl.arr)) break;
                            switch (datenFilmlisteUrl.arr[5]) {
                                case "akt": {
                                    Daten.filmeLaden.getDownloadUrlsFilmlisten_akt().addWithCheck(datenFilmlisteUrl);
                                    break block15;
                                }
                                case "diff": {
                                    Daten.filmeLaden.getDownloadUrlsFilmlisten_diff().addWithCheck(datenFilmlisteUrl);
                                }
                            }
                        }
                    }
                }
                parser.close();
                ret = true;
            }
            catch (Exception ex) {
                ret = false;
                Log.fehlerMeldung(392840096, ex);
            }
            Daten.listeDownloads.listeNummerieren();
            Daten.filmeLaden.getDownloadUrlsFilmlisten_akt().sort();
            Daten.filmeLaden.getDownloadUrlsFilmlisten_diff().sort();
        }
        return ret;
    }

    public static boolean einstellungenExistieren() {
        Path xmlFilePath = Daten.getMediathekXmlFilePath();
        return Files.exists(xmlFilePath, new LinkOption[0]);
    }

    public static int[] importAboBlacklist(String datei, boolean abo, boolean black, boolean replace) {
        int[] found = new int[]{0, 0, 0};
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
            XMLStreamReader parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                String[] sa;
                int event = parser.next();
                if (event != 1) continue;
                if (abo && parser.getLocalName().equals("Abonnement")) {
                    DatenAbo datenAbo = new DatenAbo();
                    if (!IoXmlLesen.get(parser, "Abonnement", DatenAbo.COLUMN_NAMES, datenAbo.arr)) continue;
                    found[0] = found[0] + 1;
                    Daten.listeAbo.addAbo(datenAbo);
                    continue;
                }
                if (black && parser.getLocalName().equals("Blacklist")) {
                    ListeBlacklist blacklist = Daten.listeBlacklist;
                    DatenBlacklist datenBlacklist = new DatenBlacklist();
                    if (!IoXmlLesen.get(parser, "Blacklist", DatenBlacklist.BLACKLIST_COLUMN_NAMES, datenBlacklist.arr)) continue;
                    found[1] = found[1] + 1;
                    blacklist.add(datenBlacklist);
                    continue;
                }
                if (!replace || !parser.getLocalName().equals("Ersetzungstabelle") || !IoXmlLesen.get(parser, "Ersetzungstabelle", MVReplaceList.COLUMN_NAMES, sa = new String[2])) continue;
                found[2] = found[2] + 1;
                Daten.mVReplaceList.list.add(sa);
            }
            in.close();
        }
        catch (Exception ex) {
            Log.fehlerMeldung(302045698, ex);
        }
        if (found[0] > 0) {
            Daten.listeAbo.aenderungMelden();
        }
        if (found[2] > 0) {
            ListenerMediathekView.notify(38, IoXmlLesen.class.getSimpleName());
        }
        return found;
    }

    private static boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet) {
        return IoXmlLesen.get(parser, xmlElem, xmlNames, strRet, true);
    }

    private static boolean get(XMLStreamReader parser, String xmlElem, String[] xmlNames, String[] strRet, boolean log) {
        boolean ret;
        block5: {
            ret = true;
            int maxElem = strRet.length;
            for (int i = 0; i < maxElem; ++i) {
                if (strRet[i] != null) continue;
                strRet[i] = "";
            }
            try {
                int event;
                block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                    if (event != 1) continue;
                    for (int i = 0; i < maxElem; ++i) {
                        if (!parser.getLocalName().equals(xmlNames[i])) continue;
                        strRet[i] = parser.getElementText();
                        continue block3;
                    }
                }
            }
            catch (Exception ex) {
                ret = false;
                if (!log) break block5;
                Log.fehlerMeldung(739530149, ex);
            }
        }
        return ret;
    }

    private static boolean getConfig(XMLStreamReader parser, String xmlElem, MVConfig mVConfig, boolean log) {
        boolean ret;
        block3: {
            ret = true;
            try {
                int event;
                while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                    if (event != 1) continue;
                    String s = parser.getLocalName();
                    String n = parser.getElementText();
                    mVConfig.add(s, n);
                }
            }
            catch (Exception ex) {
                ret = false;
                if (!log) break block3;
                Log.fehlerMeldung(945120369, ex);
            }
        }
        return ret;
    }
}

