/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.installer.macosx;

import glguerin.authkit.Authorization;
import glguerin.authkit.Privilege;
import glguerin.authkit.imp.macosx.MacOSXAuthorization;
import gnu.io.installer.RXTXInstaller;
import gnu.io.installer.util.InstallUtil;
import java.io.File;

public class MACOSXRXTXInstaller
extends RXTXInstaller {
    private static final String JavaExtensions = "Java/Extensions";

    public MACOSXRXTXInstaller() {
        this.createJarFolder();
        this.createLibFolder();
        this.installAuthKit();
        this.addJarResource("RXTXcomm.jar", "/gnu/io/installer/resources/macosx/jar/RXTXcomm.dat");
        this.addLibResource("librxtxSerial.jnilib", "/gnu/io/installer/resources/macosx/lib/librxtxSerial.jnilib");
    }

    public void runPreProcess() {
        MacOSXAuthorization auth = new MacOSXAuthorization();
        Privilege priv = new Privilege("system.privilege.admin");
        int count = 0;
        boolean succeed = false;
        while (true) {
            try {
                ((Authorization)auth).authorize(priv, true);
                succeed = true;
            }
            catch (Throwable t) {
                System.out.println("Throwable " + t);
                if (++count <= 3) continue;
            }
            break;
        }
        if (succeed) {
            String preinstallPath = this.createTemporaryPreinstallFile();
            if (preinstallPath == null) {
                return;
            }
            String[] progArray = new String[]{preinstallPath, System.getProperty("user.name")};
            try {
                Process p = ((Authorization)auth).execPrivileged(progArray);
                Thread.sleep(1000L);
            }
            catch (Throwable t) {
                System.out.println("Throwable " + t);
                t.printStackTrace();
            }
        }
    }

    public void runPostProcess() {
    }

    protected void createJarFolder() {
        File libFile = new File(InstallUtil.getFolderPath((short)-32765, 1684826466));
        this.jarFolder = new File(libFile, JavaExtensions);
        if (!this.jarFolder.canWrite()) {
            libFile = new File(InstallUtil.getFolderPath((short)-32763, 1684826466));
            this.jarFolder = new File(libFile, JavaExtensions);
            if (!this.jarFolder.exists()) {
                this.jarFolder.mkdirs();
            }
        }
    }

    protected void createLibFolder() {
        File libFile = new File(InstallUtil.getFolderPath((short)-32765, 1684826466));
        this.libFolder = new File(libFile, JavaExtensions);
        if (!this.libFolder.canWrite()) {
            libFile = new File(InstallUtil.getFolderPath((short)-32763, 1684826466));
            this.libFolder = new File(libFile, JavaExtensions);
            if (!this.libFolder.exists()) {
                this.libFolder.mkdirs();
            }
        }
    }

    private String createTemporaryPreinstallFile() {
        try {
            File tempFile = File.createTempFile("preinstall", null);
            tempFile.deleteOnExit();
            InstallUtil.copyResourceToFile("/gnu/io/installer/resources/macosx/preinstall", tempFile);
            String absPath = tempFile.getAbsolutePath();
            Process p = Runtime.getRuntime().exec(new String[]{"chmod", "a+x", absPath});
            p.waitFor();
            return absPath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void installAuthKit() {
        boolean usingJWS = false;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        if (originalClassLoader.toString().toLowerCase().indexOf("jnlp") != -1) {
            usingJWS = true;
        }
        if (usingJWS) {
            return;
        }
        try {
            File tempFile = new File(this.jarFolder, "libAuthKit.jnilib");
            tempFile.deleteOnExit();
            InstallUtil.copyResourceToFile("/gnu/io/installer/resources/macosx/lib/libAuthKit.jnilib", tempFile);
        }
        catch (Throwable t) {
            System.out.println("installAuthKit Throwable " + t);
        }
    }
}

