/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.templates.web.TMain;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Homer
extends WebAction {
    private static final Logger log = Logger.getLogger(Homer.class);

    @Override
    public void handleRequest() throws SQLException, IOException {
        Properties p = this.getProperties();
        int totalRecentTracks = (int)p.get("browse.recentTracks.count", 10L);
        int totalTopArtists = (int)p.get("browse.topArtists.count", 10L);
        Vector<Track> recentlyPlayedTracks = this.getRecentlyPlayedTracks(totalRecentTracks);
        Vector<Artist> topArtists = this.getTopArtists(totalTopArtists);
        Vector<Album> recentlyPlayedAlbums = this.getRecentlyPlayedAlbums(5);
        this.showMain(recentlyPlayedTracks, topArtists, recentlyPlayedAlbums);
    }

    protected void showMain(Vector<Track> recentlyPlayedTracks, Vector<Artist> topArtists, Vector<Album> recentlyPlayedAlbums) throws IOException, SQLException {
        TMain tpl = new TMain();
        tpl.setRecentTracks(recentlyPlayedTracks);
        tpl.setTopArtists(topArtists);
        tpl.setRecentAlbums(recentlyPlayedAlbums);
        this.getResponse().showHtml(tpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Artist> getTopArtists(int total) throws SQLException {
        Vector<Artist> vector;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            Database db = this.getDatabase();
            String sql = " select ar.id as id, ar.name as name, count(t.id) as playCount  from play_log l  inner join tracks t  on t.id = l.track_id  inner join artists ar  on ar.id = t.artist_id  group by ar.id, ar.name  order by playCount desc  limit ? ";
            st = db.prepare(" select ar.id as id, ar.name as name, count(t.id) as playCount  from play_log l  inner join tracks t  on t.id = l.track_id  inner join artists ar  on ar.id = t.artist_id  group by ar.id, ar.name  order by playCount desc  limit ? ");
            st.setInt(1, total);
            rs = st.executeQuery();
            Vector<Artist> topArtists = new Vector<Artist>();
            while (rs.next()) {
                topArtists.addElement(new Artist(rs.getInt("id"), rs.getString("name"), rs.getInt("playCount")));
            }
            vector = topArtists;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Track> getRecentlyPlayedTracks(int total) throws SQLException {
        Vector<Track> vector;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            Database db = this.getDatabase();
            String sql = Track.getSelectSql() + " from ( select l.track_id " + " from play_log l " + " order by l.date_played desc ) r " + " inner join tracks t " + " on r.track_id = t.id " + " inner join artists ar " + " on ar.id = t.artist_id " + " inner join albums al " + " on al.id = t.album_id " + " group by artistId, artistName, albumId, albumName, albumYear, trackId, " + " trackName, trackPath, trackNo, dateAdded " + " limit ? ";
            st = db.prepare(sql);
            st.setInt(1, total);
            rs = st.executeQuery();
            vector = Track.createVectorFromResultSet(rs);
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Album> getRecentlyPlayedAlbums(int total) throws SQLException {
        Vector<Album> vector;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            Database db = this.getDatabase();
            String sql = " select al.id as albumId, al.name as albumName, al.year as albumYear,  ar.id as artistId, ar.name as artistName,  max(l.date_played) as mostRecent  from play_log l  inner join tracks t  on t.id = l.track_id  inner join albums al  on al.id = t.album_id  inner join artists ar  on ar.id = al.artist_id  group by albumId, albumName, albumYear, artistId, artistName  order by mostRecent desc  limit ? ";
            st = db.prepare(" select al.id as albumId, al.name as albumName, al.year as albumYear,  ar.id as artistId, ar.name as artistName,  max(l.date_played) as mostRecent  from play_log l  inner join tracks t  on t.id = l.track_id  inner join albums al  on al.id = t.album_id  inner join artists ar  on ar.id = al.artist_id  group by albumId, albumName, albumYear, artistId, artistName  order by mostRecent desc  limit ? ");
            st.setInt(1, total);
            rs = st.executeQuery();
            Vector<Album> recentAlbums = new Vector<Album>();
            while (rs.next()) {
                recentAlbums.add(new Album(rs.getInt("artistId"), rs.getString("artistName"), rs.getInt("albumId"), rs.getString("albumName"), rs.getString("albumYear")));
            }
            vector = recentAlbums;
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }
}

