/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.scheduling;

import com.pugh.sockso.Properties;
import com.pugh.sockso.music.indexing.Indexer;
import com.pugh.sockso.music.scheduling.CronScheduler;
import com.pugh.sockso.music.scheduling.ManualScheduler;
import com.pugh.sockso.music.scheduling.Scheduler;
import com.pugh.sockso.music.scheduling.SimpleScheduler;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class SchedulerRunner
extends Thread {
    private static final int ONE_MINUTE = 60000;
    private static final Logger log = Logger.getLogger(SchedulerRunner.class);
    private final Indexer indexer;
    private final Properties p;

    public SchedulerRunner(Indexer indexer, Properties p) {
        this.indexer = indexer;
        this.p = p;
    }

    public void run() {
        while (true) {
            Calendar now = Calendar.getInstance();
            Scheduler scheduler = this.getScheduler();
            log.debug((Object)("Checking schedule (" + scheduler.getClass().getSimpleName() + ")"));
            if (scheduler.shouldRunAt(now.getTime())) {
                this.indexer.scan();
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected Scheduler getScheduler() {
        String scheduler = this.p.get("scheduler");
        if (scheduler.equals("cron")) {
            return new CronScheduler(this.p);
        }
        if (scheduler.equals("manual")) {
            return new ManualScheduler();
        }
        return new SimpleScheduler(this.p);
    }
}

