/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.UPNP;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.Server;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import org.apache.log4j.Logger;

public class ForwardPortDialog
extends JDialog {
    private static Logger log = Logger.getLogger(ForwardPortDialog.class);
    private Server sv;
    private Resources r;
    private JButton nextButton = null;
    private JList deviceList = null;
    private DefaultListModel deviceListModel = null;
    private JLabel statusLabel = null;

    public ForwardPortDialog(JFrame parent, Server sv, Resources r) {
        super(parent, " Sockso - Internet Setup", true);
        this.sv = sv;
        this.r = r;
        this.setDefaultCloseOperation(2);
        this.setBounds(30, 30, 400, 300);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
        new Thread(){

            public void run() {
                ForwardPortDialog.this.loadDevices();
            }
        }.start();
        this.setVisible(true);
    }

    private void loadDevices() {
        try {
            this.statusLabel.setText("Probing for routers...");
            InternetGatewayDevice[] devices = UPNP.getRouterDevices();
            if (devices != null) {
                for (InternetGatewayDevice device : devices) {
                    this.deviceListModel.addElement(device);
                }
                this.statusLabel.setText("Select a device");
            } else {
                this.statusLabel.setText("Sorry, no devices found");
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }

    private JPanel getMainPane() {
        this.deviceListModel = new DefaultListModel();
        this.deviceList = new JList(this.deviceListModel);
        this.deviceList.setMinimumSize(new Dimension(400, 300));
        this.statusLabel = new JLabel("Initializing...");
        this.statusLabel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)new JScrollPane(this.deviceList), "Center");
        p.add((Component)this.statusLabel, "South");
        return p;
    }

    private void nextClicked() {
        Object item = this.deviceList.getSelectedValue();
        if (item != null) {
            boolean success = false;
            try {
                InternetGatewayDevice device = (InternetGatewayDevice)item;
                success = UPNP.forwardPort(device, this.sv.getPort());
            }
            catch (Exception exception) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(this, success ? "Port forwarded successfully!" : "Ack... it didn't seem to work...");
            this.close();
        } else {
            JOptionPane.showMessageDialog(this, "You need to select a device first");
        }
    }

    private void cancelClicked() {
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getButtonPane() {
        JButton cancel = new JButton("Cancel", new ImageIcon(this.r.getImage("icons/22x22/cancel.png")));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ForwardPortDialog.this.cancelClicked();
            }
        });
        this.nextButton = new JButton("Next", new ImageIcon(this.r.getImage("icons/22x22/ok.png")));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ForwardPortDialog.this.nextClicked();
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2));
        p.add(cancel);
        p.add(this.nextButton);
        return p;
    }
}

