/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.commands;

import com.pugh.sockso.Validater;
import com.pugh.sockso.ValidationException;
import com.pugh.sockso.commands.BaseCommand;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.web.User;
import java.sql.SQLException;

public class UserAdd
extends BaseCommand {
    private final Database db;
    private final Locale locale;

    public UserAdd(Database db, Locale locale) {
        this.db = db;
        this.locale = locale;
    }

    public String getName() {
        return "useradd";
    }

    public String getDescription() {
        return "Adds a new user";
    }

    public String execute(String[] args) throws SQLException {
        try {
            Validater v = new Validater(this.db);
            String name = args[1];
            String pass = args[2];
            String email = args[3];
            String isAdmin = args[4];
            if (v.usernameExists(name)) {
                throw new ValidationException(this.locale.getString("con.err.usernameExists"));
            }
            if (v.emailExists(email)) {
                throw new ValidationException(this.locale.getString("con.err.emailExists"));
            }
            User newUser = new User(name, pass, email, isAdmin.equals("1"));
            newUser.save(this.db);
            return newUser.getId() != -1 ? this.locale.getString("con.msg.userCreated") : this.locale.getString("con.err.errorCreatingUser");
        }
        catch (ValidationException e) {
            return e.getMessage();
        }
    }

    public int getNumArgs() {
        return 4;
    }

    public String[] getArguments() {
        return new String[]{"NAME", "PASS", "EMAIL", "ISADMIN 1/0"};
    }
}

