/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact.file;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.logging.Logger;
import org.jboss.profileservice.repository.artifact.file.FileArtifact;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.repository.artifact.file.FileRepositoryConfiguration;
import org.jboss.profileservice.repository.artifact.file.LocalFileArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.Artifact;
import org.jboss.profileservice.spi.repository.artifact.ArtifactFilter;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactTransformer;
import org.jboss.profileservice.spi.repository.artifact.MutableArtifactRepository;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class MutableFileArtifactRepository
extends LocalFileArtifactRepository
implements MutableArtifactRepository<FileArtifactId> {
    private static Logger log = Logger.getLogger((String)"org.jboss.profileservice.repository.file");
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public MutableFileArtifactRepository(ArtifactRepositoryId identifier, URI rootURI, FileRepositoryConfiguration configuration) {
        super(identifier, rootURI, configuration);
    }

    @Override
    public void create() throws IOException {
        super.create();
        if (this.getConfiguration().getBackupPolicy() != ArtifactRepositoryConfiguration.VFSBackupPolicy.BACKUP) {
            log.warn((Object)"using a mutable repository without backing up real files will most likely lead to unexpected behavior.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArtifact(FileArtifactId artifactId, InputStream is, ArtifactTransformer<FileArtifactId> transformer) throws IOException {
        if (artifactId == null) {
            throw new IllegalArgumentException("null artifact");
        }
        if (is == null) {
            throw new IllegalArgumentException("null input stream");
        }
        if (transformer == null) {
            throw new IllegalArgumentException("null artifact transformer");
        }
        this.lockWrite();
        try {
            VirtualFile target = this.getArtifactFile(artifactId, false);
            transformer.transform((ArtifactId)artifactId, is, target);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsArtifact(FileArtifactId artifact) {
        this.lockRead();
        try {
            boolean bl = super.containsArtifact(artifact);
            return bl;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileArtifact getArtifact(FileArtifactId artifactId) {
        this.lockRead();
        try {
            FileArtifact fileArtifact = super.getArtifact(artifactId);
            return fileArtifact;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Artifact<FileArtifactId>> getArtifacts() {
        this.lockRead();
        try {
            Collection<Artifact<FileArtifactId>> collection = super.getArtifacts();
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Artifact<FileArtifactId>> getArtifacts(ArtifactFilter<FileArtifactId> filter) {
        this.lockRead();
        try {
            Collection<Artifact<FileArtifactId>> collection = super.getArtifacts(filter);
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualFile getArtifactFile(FileArtifactId artifact) throws IOException {
        this.lockRead();
        try {
            VirtualFile virtualFile = super.getArtifactFile(artifact);
            return virtualFile;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualFile getOriginalFile(FileArtifactId artifactId) throws IOException {
        this.lockRead();
        try {
            VirtualFile virtualFile = super.getOriginalFile(artifactId);
            return virtualFile;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArtifact(FileArtifactId artifactId) throws IOException {
        this.lockWrite();
        try {
            VirtualFile vf = this.getArtifactFile(artifactId, false);
            if (!vf.exists()) {
                return;
            }
            if (!VFSUtils.recursiveDelete((VirtualFile)vf)) {
                throw new IOException("Failed to delete " + vf);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    void lockRead() {
        this.lock.readLock().lock();
    }

    void unlockRead() {
        this.lock.readLock().unlock();
    }

    void lockWrite() {
        this.lock.writeLock().lock();
    }

    void unlockWrite() {
        this.lock.writeLock().unlock();
    }
}

