/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.deployment.hotdeploy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ActionController;
import org.jboss.profileservice.spi.action.ModificationStatus;
import org.jboss.profileservice.spi.action.ProfileModificationAction;
import org.jboss.profileservice.spi.action.ProfileModificationContext;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentInfo;
import org.jboss.profileservice.spi.managed.ManagedProfile;
import org.jboss.profileservice.spi.managed.ManagedProfileDeployer;

class HDScanner
implements Runnable {
    private static final Logger log = Logger.getLogger(HDScanner.class);
    private int scanCount = 0;
    private ProfileKey key;
    private ActionController controller;
    private volatile boolean defunct = false;

    protected HDScanner(ProfileKey key, ActionController controller) {
        this.key = key;
        this.controller = controller;
    }

    protected ProfileKey getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.scan();
        }
        catch (Throwable e) {
            if (!this.defunct) {
                log.warn((Object)"Scan failed", e);
                this.defunct = true;
            }
        }
        finally {
            if (!this.defunct) {
                this.incScanCount();
            }
        }
    }

    protected synchronized int getScanCount() {
        return this.scanCount;
    }

    protected synchronized void resetScanCount() {
        this.scanCount = 0;
    }

    protected synchronized void scan() throws Exception {
        ManagedProfile managedProfile = this.controller.getManagedProfile(this.key);
        if (managedProfile == null) {
            throw new IllegalStateException("Profile not active " + this.key);
        }
        MutableProfile profile = (MutableProfile)MutableProfile.class.cast(managedProfile.getProfile());
        HDScanAction action = new HDScanAction(profile, managedProfile.getManagedDeployer());
        ModificationStatus modificationStatus = this.controller.perform(this.key, ProfileModificationType.UPDATE, Collections.singletonList(action));
        if (modificationStatus.isFailed()) {
            log.warn((Object)"Scan failed", modificationStatus.getFailure());
        }
        if (this.defunct) {
            this.defunct = false;
        }
    }

    protected synchronized void incScanCount() {
        ++this.scanCount;
        this.notifyAll();
    }

    class HDScanAction
    implements ProfileModificationAction<ProfileModificationContext> {
        private boolean complete = false;
        private final MutableProfile profile;
        private final ManagedProfileDeployer deployer;

        public HDScanAction(MutableProfile profile, ManagedProfileDeployer deployer) {
            this.profile = profile;
            this.deployer = deployer;
        }

        public void cancel() {
        }

        public void complete(ProfileModificationResponse response) {
            try {
                this.deploy(response);
                this.complete = true;
            }
            catch (Throwable t) {
                response.setFailure(t);
            }
        }

        public void deploy(ProfileModificationResponse response) throws Exception {
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace((Object)("Begin deployment scan: " + this.profile.getKey()));
            }
            boolean modified = false;
            ArrayList<String> checkCompleteNames = new ArrayList<String>();
            Collection modifiedDeployments = this.profile.getModifiedDeployments();
            for (ModificationInfo info : modifiedDeployments) {
                ProfileDeployment ctx = info.getDeployment();
                ProfileDeploymentInfo deploymentInfo = ctx.getDeploymentInfo();
                try {
                    switch (info.getStatus()) {
                        case ADDED: 
                        case MODIFIED: {
                            this.deployer.addDeployment(ctx);
                            checkCompleteNames.add(ctx.getName());
                            deploymentInfo.setFlag(ProfileDeploymentFlag.DEPLOYED);
                            modified = true;
                            break;
                        }
                        case REMOVED: {
                            this.deployer.removeDeployment(ctx);
                            modified = true;
                        }
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to add deployment: " + ctx.getName()), (Throwable)e);
                }
            }
            if (modified) {
                this.deployer.process();
                response.fireModificationEvent(ProfileModificationEvent.create(ProfileModificationType.UPDATE, HDScanner.this.key));
                if (!checkCompleteNames.isEmpty()) {
                    this.deployer.checkComplete(checkCompleteNames.toArray(new String[checkCompleteNames.size()]));
                }
            }
            if (trace) {
                log.trace((Object)("End deployment scan: " + this.profile.getKey()));
            }
        }

        public ProfileModificationContext getContext() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isComplete() {
            return this.complete;
        }
    }
}

