/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.deployment;

import java.util.Collections;
import java.util.Map;
import org.jboss.profileservice.spi.deployment.DeploymentAttachments;
import org.jboss.util.collection.CollectionsFactory;

public class DefaultAttachments
implements DeploymentAttachments {
    private Map<String, Object> attachments = CollectionsFactory.createLazyMap();

    public Map<String, Object> getAttachments() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public Object getAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        return this.attachments.get(name);
    }

    public <T> T getAttachment(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("null expected type");
        }
        Object attachment = this.getAttachment(name);
        if (attachment == null) {
            return null;
        }
        if (!expectedType.isInstance(attachment)) {
            throw new IllegalStateException("attachment " + name + " with value " + attachment + " is not of the expected type " + expectedType);
        }
        return expectedType.cast(attachment);
    }

    public Object putAttachment(String name, Object attachment) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("Null attachment.");
        }
        return this.attachments.put(name, attachment);
    }

    public Object removeAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        return this.attachments.remove(name);
    }

    public boolean hasAttachment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null attachment name.");
        }
        return this.attachments.containsKey(name);
    }
}

