/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.dependency.plugin;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.LifecycleCallbackItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.profileservice.dependency.ProfileControllerContext;
import org.jboss.profileservice.dependency.plugin.ProfileLifeCycleCallbackAction;
import org.jboss.profileservice.management.AbstractActionController;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.metadata.ProfileFeatureMetaData;
import org.jboss.util.collection.ConcurrentReferenceHashMap;

public class ProfileLifeCycleCallbackActions
implements LifecycleCallbackItem,
KernelControllerContextAware {
    private static final Object value = new Object();
    private Object beanName;
    private final AbstractActionController actionController;
    private Map<ProfileLifeCycleCallbackAction<ProfileFeatureMetaData>, Object> actions = new ConcurrentReferenceHashMap();

    public ProfileLifeCycleCallbackActions(AbstractActionController actionController) {
        if (actionController == null) {
            throw new IllegalArgumentException("null action controller");
        }
        this.actionController = actionController;
    }

    public void addCallback(ProfileLifeCycleCallbackAction<ProfileFeatureMetaData> callback) {
        this.actions.put(callback, value);
    }

    public void removeCallback(ProfileLifeCycleCallbackAction<ProfileFeatureMetaData> callback) {
        this.actions.remove(callback);
    }

    void processCallbacks(Profile profile, ProfileMetaDataContext context, boolean isInstall) {
        Set<ProfileLifeCycleCallbackAction<ProfileFeatureMetaData>> actions;
        Collection<ProfileFeatureMetaData> features = context.getFeatures();
        if (features != null && !features.isEmpty() && (actions = this.actions.keySet()) != null && !actions.isEmpty()) {
            for (ProfileFeatureMetaData feature : context.getFeatures()) {
                for (ProfileLifeCycleCallbackAction profileLifeCycleCallbackAction : actions) {
                    Class featureClass = profileLifeCycleCallbackAction.getFeatureType();
                    if (!featureClass.isAssignableFrom(feature.getClass())) continue;
                    if (isInstall) {
                        profileLifeCycleCallbackAction.install(profile, feature);
                        continue;
                    }
                    profileLifeCycleCallbackAction.uninstall(profile, feature);
                }
            }
        }
    }

    public Object getBean() {
        return this.beanName;
    }

    public ControllerState getDependentState() {
        return ControllerState.INSTALLED;
    }

    public ControllerState getWhenRequired() {
        return ControllerState.INSTALLED;
    }

    public void install(ControllerContext ctx) throws Exception {
        if (ctx instanceof ProfileControllerContext) {
            ProfileControllerContext context = (ProfileControllerContext)((Object)ProfileControllerContext.class.cast(ctx));
            Profile profile = context.getProfile();
            ProfileMetaDataContext metaDataCtx = context.getDependencyContext();
            if (profile != null && metaDataCtx != null) {
                this.processCallbacks(profile, metaDataCtx, true);
                this.actionController.addProfile(context);
            }
        }
    }

    public void uninstall(ControllerContext ctx) {
        if (ctx instanceof ProfileControllerContext) {
            ProfileControllerContext context = (ProfileControllerContext)((Object)ProfileControllerContext.class.cast(ctx));
            Profile profile = context.getProfile();
            ProfileMetaDataContext metaDataCtx = context.getDependencyContext();
            if (profile != null && metaDataCtx != null) {
                this.actionController.removeProfile(context);
                this.processCallbacks(profile, metaDataCtx, false);
            }
        }
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.beanName = context.getName();
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
    }
}

