/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.jms;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hornetq.api.core.management.AddressSettingsInfo;
import org.hornetq.api.core.management.RoleInfo;
import org.hornetq.api.jms.management.TopicControl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.jms.server.config.impl.TopicConfigurationImpl;
import org.jboss.as.integration.hornetq.management.jms.AddressSettingsMapper;
import org.jboss.as.integration.hornetq.management.jms.JMSManageMO;
import org.jboss.as.integration.hornetq.management.jms.MessageListMapper;
import org.jboss.as.integration.hornetq.management.jms.SubscriptionInfoMapper;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.metatype.api.annotations.MetaMapping;

@ManagementObject(componentType=@ManagementComponent(type="JMSDestinationManage", subtype="TopicManage"), properties=ManagementProperties.EXPLICIT, isRuntime=true)
public class TopicManageMO
extends JMSManageMO {
    public TopicManageMO(HornetQServer server) {
        super(server);
    }

    @ManagementOperation(name="deleteTopic", description="delete the topic", params={@ManagementParameter(name="name", description="the queue name")})
    public void deleteTopic(String name) throws Exception {
        this.jmsServerControl.destroyTopic(name.replace("jms.topic.", ""));
        this.hornetQServerControl.removeSecuritySettings(name);
        this.hornetQServerControl.removeAddressSettings(name);
    }

    @ManagementOperation(name="getTopicConfiguration", description="Returns a topics configuration", params={@ManagementParameter(name="name", description="the queue name")})
    @MetaMapping(value=AddressSettingsMapper.class)
    public Object[] getTopicConfiguration(String name) throws Exception {
        RoleInfo[] roles;
        Object[] config = new Object[3];
        TopicControl control = (TopicControl)this.managementService.getResource(name);
        TopicConfigurationImpl topicConfiguration = new TopicConfigurationImpl(control.getName(), control.getJNDIBindings());
        config[0] = topicConfiguration;
        String jsonString = this.hornetQServerControl.getAddressSettingsAsJSON(name);
        config[1] = AddressSettingsInfo.from((String)jsonString);
        String rolesAsJSON = this.hornetQServerControl.getRolesAsJSON(name);
        config[2] = roles = RoleInfo.from((String)rolesAsJSON);
        return config;
    }

    @ManagementOperation(name="createQueue", description="Creates a new Queue", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="jndiName", description="The JNDI Name of the queue"), @ManagementParameter(name="dla", description="Dead Letter Address"), @ManagementParameter(name="expiryAddress", description="Expiry Address"), @ManagementParameter(name="maxSizeBytes", description="Max Size of Address"), @ManagementParameter(name="pageSizeBytes", description="Page Size"), @ManagementParameter(name="deliveryAttempts", description="Max Delivery Attempts"), @ManagementParameter(name="redeliveryDelay", description="Redelivery Delay"), @ManagementParameter(name="lastValueQueue", description="Last Value Queue"), @ManagementParameter(name="redistributionDelay", description="Redistribution Delay"), @ManagementParameter(name="sendToDLAOnNoRoute", description="Send To DLA on no route"), @ManagementParameter(name="addressFullMessagePolicy", description="Address Full Message Policy"), @ManagementParameter(name="sendRoles", description="Send roles for a queue"), @ManagementParameter(name="consumeRoles", description="consume roles for a queue"), @ManagementParameter(name="createDurableQueueRoles", description="Send roles for a queue"), @ManagementParameter(name="deleteDurableQueueRoles", description="consume roles for a queue"), @ManagementParameter(name="createTempQueueRoles", description="Send roles for a queue"), @ManagementParameter(name="deleteTempQueueRoles", description="consume roles for a queue")})
    public void createTopic(String name, String jndiName, String DLA, String expiryAddress, long maxSizeBytes, int pageSizeBytes, int deliveryAttempts, long redeliveryDelay, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createTempQueueRoles, String deleteTempQueueRoles) throws Exception {
        this.hornetQServerControl.addAddressSettings("jms.queue." + name, DLA, expiryAddress, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, redeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy);
        this.jmsServerControl.createTopic(name, jndiName);
        this.hornetQServerControl.addSecuritySettings(name, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createTempQueueRoles, deleteTempQueueRoles, "");
    }

    @ManagementOperation(name="updateQueueConfiguration", description="updates a queues configuration", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="jndiName", description="The JNDI Name of the queue"), @ManagementParameter(name="dla", description="Dead Letter Address"), @ManagementParameter(name="expiryAddress", description="Expiry Address"), @ManagementParameter(name="maxSizeBytes", description="Max Size of Address"), @ManagementParameter(name="pageSizeBytes", description="Page Size"), @ManagementParameter(name="deliveryAttempts", description="Max Delivery Attempts"), @ManagementParameter(name="redeliveryDelay", description="Redelivery Delay"), @ManagementParameter(name="lastValueQueue", description="Last Value Queue"), @ManagementParameter(name="redistributionDelay", description="Redistribution Delay"), @ManagementParameter(name="sendToDLAOnNoRoute", description="Send To DLA on no route"), @ManagementParameter(name="addressFullMessagePolicy", description="Address Full Message Policy"), @ManagementParameter(name="sendRoles", description="Send roles for a queue"), @ManagementParameter(name="consumeRoles", description="consume roles for a queue"), @ManagementParameter(name="createDurableQueueRoles", description="Send roles for a queue"), @ManagementParameter(name="deleteDurableQueueRoles", description="consume roles for a queue"), @ManagementParameter(name="createTempQueueRoles", description="Send roles for a queue"), @ManagementParameter(name="deleteTempQueueRoles", description="consume roles for a queue")})
    public void updateTopicConfiguration(String name, String jndiName, String dla, String expiryAddress, long maxSizeBytes, int pageSizeBytes, int deliveryAttempts, long redeliveryDelay, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createTempQueueRoles, String deleteTempQueueRoles) throws Exception {
        this.hornetQServerControl.addAddressSettings(name, dla, expiryAddress, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, redeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy);
        this.hornetQServerControl.addSecuritySettings(name, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createTempQueueRoles, deleteTempQueueRoles, "");
    }

    @ManagementOperation(name="getTopicMeasurements", description="updates a queues configuration", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="names", description="the measurement names")})
    public String[] getTopicMeasurements(String name, String[] names) throws Exception {
        TopicControl control = (TopicControl)this.managementService.getResource(name);
        String[] val = new String[names.length];
        int valLength = val.length;
        for (int i = 0; i < valLength; ++i) {
            Object o = control.getClass().getMethod(names[i], new Class[0]).invoke((Object)control, new Object[0]);
            val[i] = o instanceof Object[] ? this.coomaSeparatedString((Object[])o) : o.toString();
        }
        return val;
    }

    @ManagementOperation(name="invokeTopicOperation", description="invokes a queues method", params={@ManagementParameter(name="name", description="the topic name"), @ManagementParameter(name="method", description="the method"), @ManagementParameter(name="params", description="the method params")})
    public Object invokeTopicOperation(String name, String method, String[] params, String[] type) throws Exception {
        TopicControl control = (TopicControl)this.managementService.getResource(name);
        Class[] classes = this.getClassTypes(type);
        Method m = control.getClass().getMethod(method, classes);
        return m.invoke((Object)control, this.getParams(params, classes));
    }

    @ManagementOperation(name="invokeTopicOperationMessageType", description="invokes a queues method", params={@ManagementParameter(name="name", description="the topic name"), @ManagementParameter(name="method", description="the method"), @ManagementParameter(name="params", description="the method params")})
    @MetaMapping(value=MessageListMapper.class)
    public List invokeTopicOperationMessageType(String name, String method, String[] params, String[] type) throws Exception {
        TopicControl control = (TopicControl)this.managementService.getResource(name);
        Class[] classes = this.getClassTypes(type);
        Method m = control.getClass().getMethod(method, classes);
        Map[] maps = (Map[])m.invoke((Object)control, this.getParams(params, classes));
        ArrayList<Map> list = new ArrayList<Map>();
        list.addAll(Arrays.asList(maps));
        return list;
    }

    @ManagementOperation(name="invokeTopicOperationSubscriptionType", description="invokes a queues method", params={@ManagementParameter(name="name", description="the topic name"), @ManagementParameter(name="method", description="the method"), @ManagementParameter(name="params", description="the method params")})
    @MetaMapping(value=SubscriptionInfoMapper.class)
    public Object[] invokeTopicOperationSubscriptionType(String name, String method, String[] params, String[] type) throws Exception {
        TopicControl control = (TopicControl)this.managementService.getResource(name);
        Class[] classes = this.getClassTypes(type);
        Method m = control.getClass().getMethod(method, classes);
        Object[] maps = (Object[])m.invoke((Object)control, this.getParams(params, classes));
        return maps;
    }

    @ManagementOperation(name="getJMSTopics", description="returns the JMS Topics")
    public String[] getJMSTopics() {
        return this.jmsServerControl.getTopicNames();
    }
}

